/***************************************************************************/
/*                             T E A M - E D                               */
/***************************************************************************/
/*                                                                         */
/* DIALOG.c                                                                */
/*                                                                         */
/*   DialogBox routines for sample MS-Windows application                  */
/*                                                                         */
/*   Routines - AboutBoxWindowProc                                         */
/*              OpenFileBoxWindowProc                                      */
/*              BtrvOpsListBoxWindowProc                                   */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/
#include <windows.h>
#include "sample.h"
#include "extern.h"


/* Btrieve DLL interface functions */
extern int SHELLINIT (char far *);
extern int BTRVINIT (char far *);
extern int BTRVSTOP (void);
extern unsigned BTRV (int, char far *, char far *, unsigned far *, char far *, int);


BOOL far pascal AboutBoxWindowProc (HWND,unsigned,WORD,LONG);
BOOL far pascal OpenFileBoxWindowProc (HWND,unsigned,WORD,LONG);
BOOL far pascal BtrvOpsListBoxWindowProc (HWND,unsigned,WORD,LONG);


BOOL FAR PASCAL AboutBoxWindowProc (hDlg, message, wParam, lParam)
  HWND hDlg;
  unsigned message;
  WORD wParam;
  LONG lParam;
{
  if (message == WM_COMMAND)
  {
     EndDialog (hDlg,TRUE);
     return (TRUE);
  }
  else
     if (message == WM_INITDIALOG)
        return (TRUE);
     else
        return (FALSE);
}


BOOL FAR PASCAL OpenFileBoxWindowProc (hDlg, message, wParam, lParam)
  HWND hDlg;
  unsigned message;
  WORD wParam;
  LONG lParam;
{
  char msg[255];
  int  bStat;

  switch (message)
  {
     case WM_INITDIALOG :
          return (TRUE);

     case WM_COMMAND :
       switch (wParam)
       {
          case IDOK:          /* retrieve file name and open it            */
             if (GetDlgItemText (hDlg, SAMPLE_FILENAME, keyBuf, 255) == 0)
               break;

             if ((posBlk = GlobalLock (hPosBlk)) == NULL)
             {
                 MessageBox (NULL, "ERROR - Could not lock POSBLK",
                            " ERROR ", MB_OK);
                 break;
             }

             if (fileIsOpen)   /* Close previous file                      */
                BTRV (1, posBlk, dataBuf, &dataLen, keyBuf, 0);

             if (bStat = BTRV (0, posBlk, dataBuf, &dataLen, keyBuf, 0))
             {
                fileIsOpen = FALSE;
                sprintf (msg, "*** Open failed ***\nFile: %s\nStatus = %d",
                         keyBuf, bStat);
                MessageBox (hDlg, msg, " TEAM-ED ", MB_OK);
             }
             else
                fileIsOpen = TRUE;
             GlobalUnlock (hPosBlk);
             EndDialog (hDlg, TRUE);
             return (TRUE);

          case IDCANCEL :
             EndDialog (hDlg, TRUE);
             return (TRUE);

          default :
             return (FALSE);
       }
  }
  return (FALSE);
}


BOOL FAR PASCAL BtrvOpsListBoxWindowProc (hDlg, message, wParam, lParam)
  HWND hDlg;
  unsigned message;
  WORD wParam;
  LONG lParam;
{
  int i;
  switch (message)
  {
     case WM_INITDIALOG :               /* Fill listbox with operations and  */
                                        /* set default position to Get First */
          SendDlgItemMessage (hDlg, SAMPLE_OPLIST, LB_RESETCONTENT, 0, 0L);
          for (i = 0; i < NUMFUN; ++i)
             SendDlgItemMessage (hDlg, SAMPLE_OPLIST, LB_INSERTSTRING, i,
                            (LONG) ((LPSTR) Operations[i]));
          SendDlgItemMessage (hDlg, SAMPLE_OPLIST, LB_SETCURSEL, GET_FIRST, 0L);
          op = OpCodes[GET_FIRST];
          opNdx = GET_FIRST;
          return (TRUE);

     case WM_COMMAND :
       switch (wParam)
       {
          case SAMPLE_OPLIST:                     /* Get new operation code */
             if (HIWORD (lParam) == LBN_SELCHANGE)
             {
                opNdx = (WORD) SendDlgItemMessage (hDlg, SAMPLE_OPLIST, LB_GETCURSEL, 0, 0L);
                op = OpCodes[opNdx];
             }
            return (TRUE);

          case SAMPLE_OPCLOSE:
            DestroyWindow (hDlg);
            hDlgModeless = 0;
            return (TRUE);

          default :
             return (FALSE);
       }
  }
  return (FALSE);
}
