/***************************************************************************/
/*                             T E A M - E D                               */
/***************************************************************************/
/*                                                                         */
/* INIT.c                                                                  */
/*                                                                         */
/*   Initialization routine for sample MS-Windows application              */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/
#include <windows.h>
#include "sample.h"
#include "extern.h"


extern long far pascal WndProc (HWND, unsigned, WORD, LONG);

int initSample (HANDLE, HANDLE, int);
int initSample (HANDLE hInstance, HANDLE hPrevInstance, int nCmdShow)
{
    WNDCLASS    wndclass;
    static char szAppName[] = "SAMPLE";

    if (!hPrevInstance)
    {
       wndclass.style            = CS_HREDRAW | CS_VREDRAW;
       wndclass.lpfnWndProc      = WndProc;
       wndclass.cbClsExtra       = 0;
       wndclass.cbWndExtra       = 0;
       wndclass.hInstance        = hInstance;
       wndclass.hIcon            = LoadIcon (hInstance, "SAMPLEICON");
       wndclass.hCursor          = LoadCursor (NULL, IDC_ARROW);
       wndclass.hbrBackground    = GetStockObject (WHITE_BRUSH);
       wndclass.lpszMenuName     = szAppName;
       wndclass.lpszClassName    = szAppName;

       if (!RegisterClass (&wndclass))
          return (FALSE);
     }

     parentWnd = CreateWindow (szAppName,
                              " Generic Skeleton ",
                              WS_OVERLAPPEDWINDOW | WS_HSCROLL | WS_VSCROLL,
                              CW_USEDEFAULT, 0,
                              CW_USEDEFAULT, 0,
                              NULL, NULL,
                              hInstance,
                              NULL);

     if (!parentWnd)
        return (FALSE);

     parentInst = hInstance;
     ShowWindow (parentWnd, nCmdShow);
     UpdateWindow (parentWnd);

     return (TRUE);
}
