Option Explicit
'rdpj192
'*********************************************************************
'*                                                                   *
'*                                                                   *
'*   Waveform Spectrum Plot Research & Development Project  11-94    *
'*                                                                   *
'*                                                                   *
'*********************************************************************

'For use with Visual Basic for Windows Standard Edition or Pro Edition

'Files needed on system for this program to work
'MMSystem.DLL  (included with Windows 3.1)
'ToolHelp.DLL  (included with Windows 3.1)
'CMDialog.VBX  (comes with VBWIN 3.0 )

'The .mak project is ready to run as is.

'The purpose of this project is allow VBWIN programmers to plot waveform
'files(.wav) in their multimedia applications.

'This small R & D application will load most waveform .wav files and then
'proceed to plot a static representation of the wave in the picture box.
'Press the Full Screen Plot button to plot the wave full screen.

'Included with this download is a wave file Clock.WAV,use this file
'first.This is an excellent example for using the plotter, especially
'the full screen plot.

'Take a look at PlotaWave Function,this is the code that does the plotting.
'currently only 8 bit mono and 16 bit mono 11025 kHz,22050 kHz and 44100 kHz
'are set for plotting,this covers a large majority of wave files out there

'Most of the code to extract the Stereo formats is in PlotaWave Function
'but you need to set up the code that does the actual stereo plotting.

'If you use part of the code from this project in your application,make
'sure you use the CloseWavePlay procedure each time after playing wave file
'this will free up the memory block reserved by Windows to hold wave file
'if you don't eventually you will run out of memory.This project as is
'already does so.

'The code is far from perfect,but with a little tweaking and diligence
'you can customize to your needs.The size of the picture box can be any
'height and width,the PlotaWave Function will adjust automatically to any
'size,the wider the picture box the more detailed the plot will be.

'In your Project
'Use Picture box controls for the time position instead of a label control.
'Label controls used for updating a high speed display will cause lots of
'flickering.The time updates over 60 times a second

'In the PlotaWave function you will notice there are two methods used to
'do the plotting,LINE for the small picturebox and PSET for the full
'screen,the PSet offers more detail but may not be prefered,you can use
'LINE to plot full screen just as well

'The code under the Play wo Timeclock command button is an alternate method
'to play a wavefile(.wav) without any time updates etc.

'Regarding accurracy & Quality of the plotted Waveform file:
'I have compared the wave plot to several commercial applications
'and notice very little difference,some(comm. apps) are actually inferior


'Regarding MS ADPCM wave files
'********************************************************************
'This program will NOT read any MS ADPCM files,these are 16 bit
'compressed files reduced to 4 or 8 bit.they usually have a format tag of 2

'I have made a Function called checkformat that checks for a MS ADPCM
'wave file,they have a format tag of 2,currently having problems trying
'to read these files and then successfully closing the device which is
'neccessary to reopen the next file.

'The program as is will not proceed to OpenWaveFile procedure unless the
'wave file has a format tag of 1.

'you can Rem out the function call to checkformat in the OpenOption_click event
'procedure and try to get it to work.Some sound cards/drivers might allow
'loading,mine does not(SB 2.0)

'*********************************************************************

'if you have already run the program you have noticed that the wave plot
'is a Static plot only.I am currently working on a Dynamic plot,a dynamic
'plotted wave shows while being played(as seen in the Windows 3.1 Sound Recorder)

'Anyone with tips on plotting dynamically in VB please post a
'bulletin,E-Mail or whatever.


Type SMPTE
    hour As String * 1          '  hours
    min As String * 1           '  minutes
    sec As String * 1           '  seconds
    frame As String * 1         '  frames
    fps As String * 1           '  frames per second
    dummy As String * 1         '  pad
End Type

Type MMTIME
    wType As Integer        '  indicates the contents of units
    units As Long           '  (msecs, samples, bytes)
    SMPTEVal As SMPTE
    songptrpos As Long      '  song pointer position
End Type

Type WAVEOUTCAPS
    wMid As Integer
    wPid As Integer
    vDriverVersion As Integer
    szPName As String * 32
    dwFormats As Long
    wChannels As Integer
    dwSupport As Long
End Type

Type WAVEFORMAT
    wFormatTag As Integer
    nChannels As Integer
    nSamplesPerSec As Long
    nAvgBytesPerSec As Long
    nBlockAlign As Integer
End Type

Type PCMWAVEFORMAT
    wf As WAVEFORMAT
    wBitsPerSample As Integer
End Type

Type WAVEHDR
    lpData As Long
    dwBufferLength As Long
    dwBytesRecorded As Long
    dwUser As Long
    dwFlags As Long
    dwLoops As Long
    lpNext As Long
    reserved As Long
End Type

Type FOURCC
    Chars As String * 4
End Type

Type MMIOINFO
    dwFlags As Long
    fccIOProc As FOURCC
    lpIOProc As Long
    wErrorRet As Integer
    wReserved As Integer
    ' Fields maintained by MMIO functions during buffered IO
    cchBuffer As Long
    pchBuffer As Long
    pchNext As Long
    pchEndRead As Long
    pchEndWrite As Long
    lBufOffset As Long
    ' Fields maintained by I/O procedure
    lDiskOffset As Long
    adwInfo As String * 12
    ' Other fields maintained by MMIO
    dwReserved1 As Long
    dwReserved2 As Long
    hMMIO As Integer
End Type

' RIFF chunk information data structure
Type MMCKINFO
    CkId As FOURCC
    CkSize As Long
    fccType As FOURCC
    dwDataOffset As Long
    dwFlags As Long
End Type

Type MonoEightBitSamples
    Char As String * 1
End Type

Type StereoEightBitSamples
    LeftChar As String * 1
    RightChar As String * 1
End Type

Type MonoSixteenBitSamples
    Sample As Integer
End Type

Type StereoSixteenBitSamples
    LeftSample As Integer
    RightSample As Integer
End Type

Declare Function waveOutReset Lib "MMSYSTEM" (ByVal hWaveOut As Integer) As Integer
Declare Function waveOutGetDevCaps Lib "MMSystem" (ByVal wDeviceID As Integer, lpCaps As WAVEOUTCAPS, ByVal wSize As Integer) As Integer
Declare Function waveOutOpen Lib "MMSystem" (lphWaveOut As Integer, ByVal wDeviceID As Integer, lpFormat As Any, ByVal dwCallBack As Long, ByVal dwCallBack As Long, ByVal dwFlags As Long) As Integer
Declare Function waveOutClose Lib "MMSystem" (ByVal hWaveOut As Integer) As Integer
Declare Function waveOutPrepareHeader Lib "MMSystem" (ByVal hWaveOut As Integer, lpWaveOutHdr As Any, ByVal wSize As Integer) As Integer
Declare Function waveOutUnprepareHeader Lib "MMSystem" (ByVal hWaveOut As Integer, lpWaveOutHdr As Any, ByVal wSize As Integer) As Integer
Declare Function waveOutWrite Lib "MMSystem" (ByVal hWaveOut As Integer, lpWaveOutHdr As Any, ByVal wSize As Integer) As Integer
Declare Function waveOutGetPosition Lib "MMSYSTEM" (ByVal hWaveOut As Integer, lpinfo As MMTIME, ByVal uSize As Integer) As Integer


Declare Function mmioOpen Lib "MMSystem" (ByVal szFilename As String, lpMMIOINFO As Any, ByVal dwOpenFlags As Long) As Integer
Declare Function mmioClose Lib "MMSystem" (ByVal hMMIO As Integer, ByVal wFlags As Integer) As Integer
Declare Function mmioDescend Lib "MMSystem" (ByVal hMMIO As Integer, lpCk As Any, lpCkParent As Any, ByVal wFlags As Integer) As Integer
Declare Function mmioAscend Lib "MMSystem" (ByVal hMMIO As Integer, lpCk As Any, ByVal wFlags As Integer) As Integer
Declare Function mmioRead Lib "MMSystem" (ByVal hMMIO As Integer, pCh As Any, ByVal cCh As Long) As Long
Declare Function mmioReadToGlobal Lib "MMSystem" Alias "mmioRead" (ByVal hMMIO As Integer, ByVal lpBuffer As Long, ByVal cCh As Long) As Long

Declare Function lstrcpy Lib "Kernel" (lpString1 As Any, lpString2 As Any) As Long

Declare Function GlobalAlloc Lib "Kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
Declare Function GlobalHandleToSel Lib "ToolHelp.DLL" (ByVal hMem As Integer) As Integer
Declare Function MemoryWrite Lib "ToolHelp.DLL" (ByVal wSel As Integer, ByVal dwOffSet As Long, lpvBuf As Any, ByVal dwcb As Long) As Long
Declare Function MemoryRead Lib "ToolHelp.DLL" (ByVal wSel As Integer, ByVal dwOffSet As Long, lpvBuf As Any, ByVal dwcb As Long) As Long
Declare Function GlobalFree Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function AnsiNext Lib "User" (ByVal lpString As String) As Long
Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Sub hmemcpy Lib "Kernel" (ByVal lpDest As Long, ByVal lpSrc As Long, ByVal BytesToCopy As Long)


Declare Function mmsystemGetVersion Lib "MMSYSTEM" () As Integer
Declare Function mciexecute Lib "mmsystem" (ByVal lpstrCommand As String) As Integer
Declare Function mciSendCommand Lib "mmsystem" (ByVal udeviceid As Integer, ByVal uMessage As Integer, ByVal dwParam1 As Long, ByVal dwParam2 As Long) As Long
Declare Function mcisendstring Lib "mmsystem" (ByVal lpstrCommand As String, ByVal lpstrReturnString As String, ByVal uReturnLength As Integer, ByVal hWndCallback As Integer) As Long
Declare Function mciGetErrorString Lib "mmsystem" (ByVal wError As Long, ByVal lpstrBuffer As String, ByVal uLength As Integer) As Integer

Declare Function sndPlaySound Lib "MMSYSTEM" (ByVal lpszSoundName As String, ByVal uFlags As Integer) As Integer



Global wavepath As String

Global PCMWaveFmtRecord As PCMWAVEFORMAT
Global hWaveSampleData As Integer
Dim hWaveOut As Integer
Dim WaveHeader As WAVEHDR
Global plotpos As Integer
Global plottime As Single

'used for sndPlaySound
Global Const SND_SYNC = &H0                 '  play synchronously (default)
Global Const SND_ASYNC = &H1                '  play asynchronously
Global Const SND_NODEFAULT = &H2            '  don't use default sound
Global Const SND_MEMORY = &H4               '  lpszSoundName points to a memory file
Global Const SND_LOOP = &H8                 '  loop the sound until next sndPlaySound
Global Const SND_NOSTOP = &H10              '  don't stop any currently playing sound


Global Const GMEM_MOVEABLE = &H2
Global Const GMEM_ZEROINIT = &H40

Global Const WAVE_MAPPER = -1        ' Device ID for Wave Mapper
Global Const MMIO_READ = &H0&
Global Const MMIO_WRITE = &H1&
Global Const MMIO_READWRITE = &H2&
Global Const MMIO_FINDCHUNK = &H10   ' mmioDescend: find a chunk by ID
Global Const MMIO_FINDRIFF = &H20    ' mmioDescend: find a LIST chunk

Global Const WHDR_DONE = &H1         ' done bit

' flags for dwFlags parameter in waveOutOpen() and waveInOpen()
Global Const WAVE_FORMAT_QUERY = &H1
Global Const TWIPS = 1
Global Const WAVECAPS_PITCH = &H1           ' Supports pitch control
Global Const WAVECAPS_PLAYBACKRATE = &H2    ' Supports playback rate control
Global Const WAVECAPS_VOLUME = &H4          ' Supports volume control
Global Const WAVECAPS_LRVOLUME = &H8        ' Supports separate left-right volume control
Global Const WAVECAPS_SYNC = &H10

'  types for wType field in MMTIME struct
Global Const TIME_MS = &H1              '  time in milliseconds
Global Const TIME_SAMPLES = &H2         '  number of wave samples
Global Const TIME_BYTES = &H4           '  current byte offset
Global Const TIME_SMPTE = &H8           '  SMPTE time
Global Const TIME_MIDI = &H10           '  MIDI time

' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed


Global Const WAVE_INVALIDFORMAT = &H0 ' Invalid Format
Global Const WAVE_FORMAT_1M08 = &H1   ' 11.025 kHz, Mono,   8 bit
Global Const WAVE_FORMAT_1S08 = &H2   ' 11.025 kHz, Stereo, 8 bit
Global Const WAVE_FORMAT_1M16 = &H4   ' 11.025 kHz, Mono,   16 bit
Global Const WAVE_FORMAT_1S16 = &H8   ' 11.025 kHz, Stereo, 16 bit
Global Const WAVE_FORMAT_2M08 = &H10  ' 22.05  kHz, Mono,   8 bit
Global Const WAVE_FORMAT_2S08 = &H20  ' 22.05  kHz, Stereo, 8 bit
Global Const WAVE_FORMAT_2M16 = &H40  ' 22.05  kHz, Mono,   16 bit
Global Const WAVE_FORMAT_2S16 = &H80  ' 22.05  kHz, Stereo, 16 bit
Global Const WAVE_FORMAT_4M08 = &H100 ' 44.1   kHz, Mono,   8 bit
Global Const WAVE_FORMAT_4S08 = &H200 ' 44.1   kHz, Stereo, 8 bit
Global Const WAVE_FORMAT_4M16 = &H400 ' 44.1   kHz, Mono,   16 bit
Global Const WAVE_FORMAT_4S16 = &H800 ' 44.1   kHz, Stereo, 16 bit

Function checkformat (wavepath As String) As Integer
'check for the proper format tag

'THIS will go into the RIFF wave file and grab the format tag
'any format tag of 16777728(actually 2) will not load.
'A format tag of 2 is a 16 bit compressed file,converted down to 4 or 8 bit files
'having trouble opening and then Closing these files.
'without this procedure there will be problems with format 2 files on
'some sound cards/drivers

'It is a jerry rig at best but it Does work to prevent crashes

Dim fmt As Long, f As Integer
Const UNCOMPRESSED = 16777472
Const COMPRESSED = 16777728

f = FreeFile

Open wavepath For Binary As #f

'go to the 20th byte,this is the format tag
Get #f, 20, fmt

Close #f

Select Case fmt
       Case UNCOMPRESSED
         checkformat = True
       Case COMPRESSED
         checkformat = False
End Select


End Function

Sub CloseWavePlay ()
    Dim dummy As Integer

    If hWaveSampleData <> 0 Then
        dummy = GlobalFree(hWaveSampleData)
    End If

End Sub

Function ExtendGlobalMemBlock (hMemoryBlock As Integer, OldLength As Long, NewLength As Long) As Integer
    Dim hNewMemoryBlock As Integer
    Dim lpNewMemoryBlock As Long
    Dim lpMemoryBlock As Long
    Dim dummy As Integer

    hNewMemoryBlock = GlobalAlloc(GMEM_MOVEABLE Or GMEM_ZEROINIT, NewLength)
    lpMemoryBlock = GlobalLock(hMemoryBlock)
    lpNewMemoryBlock = GlobalLock(hNewMemoryBlock)
    hmemcpy lpNewMemoryBlock, lpMemoryBlock, OldLength
    dummy = GlobalUnlock(hMemoryBlock)
    hMemoryBlock = GlobalFree(hMemoryBlock)
    dummy = GlobalUnlock(hNewMemoryBlock)
    ExtendGlobalMemBlock = hNewMemoryBlock
End Function

Function MaxInt (A As Integer, B As Integer) As Integer
    If A > B Then
        MaxInt = A
      Else
        MaxInt = B
      End If
End Function

Function MaxLong (A As Long, B As Long) As Long
    If A > B Then
        MaxLong = A
      Else
        MaxLong = B
      End If
End Function

Function MaxSingle (A As Single, B As Single) As Single
    If A > B Then
        MaxSingle = A
      Else
        MaxSingle = B
      End If
End Function

Function MinInt (A As Integer, B As Integer) As Integer
    If A < B Then
        MinInt = A
      Else
        MinInt = B
      End If
End Function

Function MinLong (A As Long, B As Long) As Long
    If A < B Then
        MinLong = A
      Else
        MinLong = B
      End If
End Function

Function MinSingle (A As Single, B As Single) As Single
    If A < B Then
        MinSingle = A
      Else
        MinSingle = B
      End If
End Function

Function OpenWaveFile (ByVal FileNameAndPath As String) As Integer
    Dim dummy As Integer
    Dim MMCKInfoParent As MMCKINFO
    Dim MMCkInfoChild As MMCKINFO
    Dim hMMIO As Integer
    Dim ErrorCode As Integer
    Dim BytesRead As Long
    Dim Index As Integer
    Dim lpWaveSampleData As Long
    hMMIO = mmioOpen(FileNameAndPath, ByVal 0&, MMIO_READ)

    If hMMIO <> 0 Then
        ' Find WAVE Parent Chunk
        MMCKInfoParent.fccType.Chars = "WAVE"
        
        ErrorCode = mmioDescend(hMMIO, MMCKInfoParent, ByVal 0&, MMIO_FINDRIFF)
       
        If ErrorCode = 0 Then
            ' Find fmt Chunk
            MMCkInfoChild.CkId.Chars = "fmt "
            ErrorCode = mmioDescend(hMMIO, MMCkInfoChild, MMCKInfoParent, MMIO_FINDCHUNK)
           
            If ErrorCode = 0 Then
                ' Read PCM Wave Format Record
                BytesRead = mmioRead(hMMIO, PCMWaveFmtRecord, MMCkInfoChild.CkSize)
                 
                If BytesRead > 0 Then

          ErrorCode = waveOutOpen(hWaveOut, WAVE_MAPPER, PCMWaveFmtRecord, 0&, 0&, WAVE_FORMAT_QUERY)
                  If ErrorCode <> 0 Then
                       dummy = waveOutReset(hWaveOut)
                       dummy = waveOutClose(hWaveOut)
                   End If
                    
                    If ErrorCode = 0 Then
                        ' Ascend back one level in the RIFF file.
                          ErrorCode = mmioAscend(hMMIO, MMCkInfoChild, 0)
                       If ErrorCode = 0 Then
                            ' Read data chunk.
                            MMCkInfoChild.CkId.Chars = "data"
                            ErrorCode = mmioDescend(hMMIO, MMCkInfoChild, MMCKInfoParent, MMIO_FINDCHUNK)
                            
                            If ErrorCode = 0 Then
                                hWaveSampleData = GlobalAlloc(GMEM_MOVEABLE Or GMEM_ZEROINIT, MMCkInfoChild.CkSize)
                                
                                
                                If hWaveSampleData <> 0 Then
                                    lpWaveSampleData = GlobalLock(hWaveSampleData)
                                    
                                    BytesRead = mmioReadToGlobal(hMMIO, lpWaveSampleData, MMCkInfoChild.CkSize)
                                    lpWaveSampleData = GlobalUnlock(hWaveSampleData)
                                    
                                    If BytesRead > 0 Then
                                        WaveHeader.lpData = 0
                                        WaveHeader.dwBufferLength = BytesRead
                                        WaveHeader.dwFlags = 0&
                                        WaveHeader.dwLoops = 0&
                                        OpenWaveFile = True
                                    Else
                                        MsgBox "Couldn't read wave data.", MB_ICONSTOP, "RIFF File Error"
                                    End If
                                Else
                                    MsgBox "Unable to Allocate Global Memory.", MB_ICONSTOP, "Memory Error"
                                End If
                              Else
                                MsgBox "Couldn't find data chunk.", MB_ICONSTOP, "RIFF File Error"
                              End If
                          Else
                            MsgBox "Couldn't ascend from fmt chunk.", MB_ICONSTOP, "RIFF File Error"
                          End If
                      Else
                        MsgBox "Format not supported by Wave device.", MB_ICONSTOP, "Wave Data Error"
                        
                      End If
                  Else
                    MsgBox "Couldn't read wave format record.", MB_ICONSTOP, "RIFF File Error"
                  End If
              Else
                MsgBox "Couldn't find fmt chunk.", MB_ICONSTOP, "RIFF File Error"
              End If
          Else
            MsgBox "Couldn't find WAVE parent chunk.", MB_ICONSTOP, "RIFF File Error"
          End If
          ' Close WAVE file.
          ErrorCode = mmioClose(hMMIO, 0&)
      Else
       
        MsgBox "Couldn't open file.", MB_ICONSTOP, "RIFF File Error"
    End If

'place wave files stats into picbox
wavestats PCMWaveFmtRecord, waveplot, BytesRead, FileNameAndPath

End Function

Sub playwave ()
'play the wavefile
Dim result As Integer
Dim returnstring As String * 512
Dim success As Integer
Dim mcierrorstring As String * 256
Dim commandstring As String

commandstring = "play " & wavepath

result = mcisendstring(commandstring, ByVal returnstring, Len(returnstring) - 1, 0)

success = mciGetErrorString(result, mcierrorstring, 255)

If success <> 1 Then
   MsgBox mcierrorstring
End If


End Sub

Function PlotaWave (hTheWaveSampleData As Integer, f As Form, choice As Integer)
Dim plot As Integer, curx As Single, cury As Single, filesize As Long, thestep As Integer
Dim preplot  As Single
Dim thecolor As Integer
Dim sixteenplot As Integer
Dim sixteenplot2 As Integer
    
Dim hNewWaveSampleData As Integer
Dim lpTheWaveSampleData As Long
Dim lpNewWaveSampleData As Long
Dim SelWaveSampleData As Integer
Dim LastSamplePosition As Long
Dim Position As Long
Dim BytesRead As Long
'Dim BytesWritten As Long
Dim dummy As Integer

Dim MonoEightBitSample As MonoEightBitSamples
Dim PrevMonoEightBitSample As MonoEightBitSamples
'Dim StereoEightBitSample As StereoEightBitSamples
'Dim PrevStereoEightBitSample As StereoEightBitSamples
Dim MonoSixteenBitSample As MonoSixteenBitSamples
Dim PrevMonoSixteenBitSample As MonoSixteenBitSamples
'Dim StereoSixteenBitSample As StereoSixteenBitSamples
'Dim PrevStereoSixteenBitSample As StereoSixteenBitSamples
Const THELINE = 1
Const THEPOINT = 2
Const INCREMENT = 1
    

curx = 0
thecolor = 1
f!Picture1.ScaleHeight = 700
'set the center line
f!Picture1.CurrentY = f!Picture1.ScaleHeight / 2
cury = f!Picture1.CurrentY
         
f!Picture1.DrawWidth = 1
f!Picture1.CurrentX = 0
f!Picture1.BackColor = QBColor(0)
        
'Red center line(base line)
f!Picture1.Line (curx, cury)-(f!Picture1.ScaleWidth, cury), QBColor(4)

Select Case WaveFormatConstantFromFormat(PCMWaveFmtRecord)
       'Mono 8 bit  11025,22050,44100 kHz
       Case WAVE_FORMAT_1M08, WAVE_FORMAT_2M08, WAVE_FORMAT_4M08
       
        hTheWaveSampleData = ExtendGlobalMemBlock(hTheWaveSampleData, WaveHeader.dwBufferLength, WaveHeader.dwBufferLength)
        SelWaveSampleData = GlobalHandleToSel(hTheWaveSampleData)
        LastSamplePosition = WaveHeader.dwBufferLength
        'PrevMonoEightBitSample.Char = Chr$(128)
  
'Since it is not possible to plot every single wave value on large
'wave files we must divide size of file by picture box width at time of plot
'this will give us a Step which will jump over some values,since
'there are so many values(11025 or so in a 11025 kHz per second)IN WAVE FILEs
'jumping over a few will not degrade the plotted wave display
'Remember that the wider your picturebox the more values(higher detail)
'will be displayed.

        'divide the file size by picturebox width
        preplot = Abs(LastSamplePosition / f!Picture1.ScaleWidth)
        thestep = CInt(preplot)
   
    '8 bit values above 128 are positive,values below are negative
    
   For Position = 0 To LastSamplePosition - 1 Step thestep
     BytesRead = MemoryRead(SelWaveSampleData, Position, MonoEightBitSample, 1)
    
     'grab each sample and convert
     plot = Asc(MonoEightBitSample.Char)
     'convert to a 0 baseline (for 8 bit only)
     plot = plot - 128
        
    'This is the STATIC plotting of the wave values
     Select Case choice
            Case THELINE    'small picture box
               f!Picture1.Line (curx, cury)-(curx, cury + (plot * 4))
            Case THEPOINT   'full screen picture box
               f!Picture1.PSet (curx, cury + plot)
    End Select
   
   'move CurrentX over 1
   curx = curx + INCREMENT
  
  Next Position

Case WAVE_FORMAT_1S08, WAVE_FORMAT_2S08, WAVE_FORMAT_4S08
        
         Exit Function
        
        'Stereo 8-bit   'Need to add plotting code only
        
        'hTheWaveSampleData = ExtendGlobalMemBlock(hTheWaveSampleData, WaveHeader.dwBufferLength, WaveHeader.dwBufferLength)
        'SelWaveSampleData = GlobalHandleToSel(hTheWaveSampleData)
        'LastSamplePosition = WaveHeader.dwBufferLength
        'PrevStereoEightBitSample.LeftChar = Chr$(128)
        'PrevStereoEightBitSample.RightChar = Chr$(128)
        
        ' Initialize new bytes to midpoint value.
       ' For Position = WaveHeader.dwBufferLength To LastSamplePosition Step 2
        '    BytesWritten = MemoryWrite(SelWaveSampleData, Position, PrevStereoEightBitSample, 2)
         '   Next Position
        ' Mix in echo.
       ' For Position = 0 To LastSamplePosition
        '    BytesRead = MemoryRead(SelWaveSampleData, Position, StereoEightBitSample, 2)
            ' Retrieve contents of byte at (Position-Period).
         '   BytesRead = MemoryRead(SelWaveSampleData, Position, PrevStereoEightBitSample, 2)
          '  StereoEightBitSample.LeftChar = Chr$(((Asc(StereoEightBitSample.LeftChar) - 128) + (Asc(PrevStereoEightBitSample.LeftChar) - 128) * GainFactor) \ 2 + 128)
           ' StereoEightBitSample.RightChar = Chr$(((Asc(StereoEightBitSample.RightChar) - 128) + (Asc(PrevStereoEightBitSample.RightChar) - 128) * GainFactor) \ 2 + 128)
           ' BytesWritten = MemoryWrite(SelWaveSampleData, Position, StereoEightBitSample, 2)
           ' Next Position
        
      Case WAVE_FORMAT_1M16, WAVE_FORMAT_2M16, WAVE_FORMAT_4M16
           'Mono 16-bit  11025,22050,44100 kHz
        
        hTheWaveSampleData = ExtendGlobalMemBlock(hTheWaveSampleData, WaveHeader.dwBufferLength, WaveHeader.dwBufferLength)
        SelWaveSampleData = GlobalHandleToSel(hTheWaveSampleData)
        LastSamplePosition = WaveHeader.dwBufferLength'
        
        preplot = Abs(LastSamplePosition / f!Picture1.ScaleWidth)
        thestep = CInt(preplot)
        
       'thestep for 16 bit must be divisible by 2
       'since we will go stepping through 2 samples at a time
       Do While Not thestep Mod 2 = 0
         thestep = thestep + 1
       Loop
       
        For Position = 0 To LastSamplePosition - 1 Step thestep
          ' Retrieve contents of byte
          BytesRead = MemoryRead(SelWaveSampleData, Position, MonoSixteenBitSample, 2)
          sixteenplot = MonoSixteenBitSample.Sample
         
         ' Retrieve contents of byte
           BytesRead = MemoryRead(SelWaveSampleData, Position, PrevMonoSixteenBitSample, 2)
           sixteenplot2 = PrevMonoSixteenBitSample.Sample
           
          '16 bit values are large so we will have to
          'divide 16 bit values by 100  so they will fit into picbox
          sixteenplot = sixteenplot \ 100
          sixteenplot2 = sixteenplot2 \ 100
         
         'This is the plotting of the 16 bit wave values
         'Select Case choice
                'Case THELINE    'small picture box
                   f!Picture1.Line (curx, cury)-(curx, cury + sixteenplot)
                   f!Picture1.Line (curx, cury)-(curx, cury + sixteenplot2)
                'Case THEPOINT   'full screen picture box
                  ' f!Picture1.PSet (curX, curY + sixteenplot)
                  ' f!Picture1.PSet (curX, curY + sixteenplot2)
        'End Select
   
       'move CurrentX over 1
       curx = curx + INCREMENT
       
     Next Position
   
   Case WAVE_FORMAT_1S16, WAVE_FORMAT_2S16, WAVE_FORMAT_4S16
          
        'Stereo 16-bit  'Need to add plotting code only
          
         
        'hTheWaveSampleData = ExtendGlobalMemBlock(hTheWaveSampleData, WaveHeader.dwBufferLength, WaveHeader.dwBufferLength)
        'SelWaveSampleData = GlobalHandleToSel(hTheWaveSampleData)
        'LastSamplePosition = WaveHeader.dwBufferLength
        '
        'For Position = 0 To LastSamplePosition-1 Step 4
         '   BytesRead = MemoryRead(SelWaveSampleData, Position, StereoSixteenBitSample, 4)
            ' Retrieve contents of byte at (Position-Period).
          '  BytesRead = MemoryRead(SelWaveSampleData, Position, PrevStereoSixteenBitSample, 4)
           ' StereoSixteenBitSample.LeftSample = (StereoSixteenBitSample.LeftSample + PrevStereoSixteenBitSample.LeftSample
           ' StereoSixteenBitSample.RightSample = (StereoSixteenBitSample.RightSample + PrevStereoSixteenBitSample.RightSample
           ' BytesWritten = MemoryWrite(SelWaveSampleData, Position, StereoSixteenBitSample, 4)
           ' Next Position
        'WaveHeader.dwBufferLength = WaveHeader.dwBufferLength
      End Select


End Function

Function WaveFormatConstantFromFormat (ThePCMWaveFormatRecord As PCMWAVEFORMAT) As Long
    Dim SampleRateFactor As Long
    Dim ResolutionFactor As Long
    Dim ChannelsFactor As Long
    
    SampleRateFactor = (Log(ThePCMWaveFormatRecord.wf.nSamplesPerSec \ 11025) / Log(2)) * 4
    ResolutionFactor = (ThePCMWaveFormatRecord.wBitsPerSample \ 8 - 1) * 2
    ChannelsFactor = ThePCMWaveFormatRecord.wf.nChannels - 1
    WaveFormatConstantFromFormat = 2 ^ (SampleRateFactor + ResolutionFactor + ChannelsFactor)
End Function

Function WaveFormatStringFromConstant (FormatNumber As Long)
    Dim result As String

    Select Case FormatNumber
      Case WAVE_FORMAT_1M08
          result = "11.025 kHz, Mono,   8 bit"
      Case WAVE_FORMAT_1S08
          result = "11.025 kHz, Stereo,  8 bit"
      Case WAVE_FORMAT_1M16
          result = "11.025 kHz, Mono,   16 bit"
      Case WAVE_FORMAT_1S16
          result = "11.025 kHz, Stereo,  16 bit"
      Case WAVE_FORMAT_2M08
          result = "22.05  kHz, Mono,   8 bit"
      Case WAVE_FORMAT_2S08
          result = "22.05  kHz, Stereo, 8 bit"
      Case WAVE_FORMAT_2M16
          result = "22.05  kHz, Mono,   16 bit"
      Case WAVE_FORMAT_2S16
          result = "22.05  kHz, Stereo, 16 bit"
      Case WAVE_FORMAT_4M08
          result = "44.1   kHz, Mono,   8 bit"
      Case WAVE_FORMAT_4S08
          result = "44.1   kHz, Stereo, 8 bit"
      Case WAVE_FORMAT_4M16
          result = "44.1   kHz, Mono,   16 bit"
      Case WAVE_FORMAT_4S16
          result = "44.1   kHz, Stereo, 16 bit"
      Case Else
          result = "Invalid Wave Format"
      End Select
    WaveFormatStringFromConstant = result
    End Function

Function WaveFunctionStringFromConstant (FunctionNumber As Long)
    Dim result As String

    Select Case FunctionNumber
      Case WAVECAPS_PITCH
          result = "Pitch Control"
      Case WAVECAPS_PLAYBACKRATE
          result = "Playback Rate Control"
      Case WAVECAPS_VOLUME
          result = "Volume Control"
      Case WAVECAPS_LRVOLUME
          result = "Separate Left-Right Volume Control"
      Case WAVECAPS_SYNC
          result = "Synchronization"
      Case Else
          result = "Invalid Function"
      End Select
    WaveFunctionStringFromConstant = result
End Function

Function WaveOut () As Integer
    Dim hWaveOut As Integer
    Dim ReturnCode As Integer
    Dim wavepos As Integer
    Dim wavetime As MMTIME
    Dim wvtm As Single
    Dim curx As Single
    Dim wavepoint As Single
    Dim oldwidth As Single
    Const EIGHT = 8
    Const SIXTEEN = 16
    
    WaveHeader.lpData = GlobalLock(hWaveSampleData)'lstrcpy(WaveBuffer(1), WaveBuffer(1))
    ' Open the wave device.
    ReturnCode = waveOutOpen(hWaveOut, WAVE_MAPPER, PCMWaveFmtRecord, 0&, 0&, 0&)

    If ReturnCode = 0 Then
        ' Prepare the wave output header.
        
        ReturnCode = waveOutPrepareHeader(hWaveOut, WaveHeader, Len(WaveHeader))
        
        If ReturnCode = 0 Then
            ' Write the wave data to the output device.
            ReturnCode = waveOutWrite(hWaveOut, WaveHeader, Len(WaveHeader))
            
            'get the increment for pointer to keep track of wave position
            'on the plotted display
            
             oldwidth = waveplot!Picture1.ScaleWidth
             
              Select Case PCMWaveFmtRecord.wBitsPerSample
                     Case Is = EIGHT
                         wavepoint = (plottime * 106)   '8 bit
                     Case Is = SIXTEEN
                         wavepoint = (plottime * 115)   '16 bit
              End Select

             waveplot!Picture1.ScaleWidth = wavepoint
           
            If ReturnCode = 0 Then
                
                'display the time in a picture box,if you use a label control
                'you will get severe flicker
               
                Do Until (WaveHeader.dwFlags And WHDR_DONE)
                  DoEvents
                   'display the time position of playback
                   wavepos = waveOutGetPosition(hWaveOut, wavetime, Len(wavetime))
                   wvtm = wavetime.units / PCMWaveFmtRecord.wf.nAvgBytesPerSec
                   
                   waveplot!picwavetime.Cls
                   waveplot!picwavetime.CurrentX = 0
                   waveplot!picwavetime.CurrentY = 0
                   waveplot!picwavetime.Print Format$(wvtm, "00:00.#0")
                   waveplot!Shape1.Left = waveplot!Shape1.Left + 2 'red pointer
                  
                Loop
              
            End If
            'reset
            waveplot!Shape1.Left = 0
            waveplot!Picture1.ScaleMode = 1
            waveplot!Picture1.ScaleWidth = oldwidth

            WaveOut = True
            ' Unprepare the wave output header.
            ReturnCode = waveOutUnprepareHeader(hWaveOut, WaveHeader, Len(WaveHeader))
            If ReturnCode <> 0 Then
                MsgBox "Unable to Unprepare Wave Header", MB_ICONSTOP, "Wave Error"
              End If
            WaveHeader.dwFlags = 0
            ' Close the wave device.
            ReturnCode = waveOutClose(hWaveOut)
            If ReturnCode <> 0 Then
                MsgBox "Unable to Close Wave Device", MB_ICONSTOP, "Wave Error"
              End If
          Else
            ' Couldn't prepare the header, so close the device.
            MsgBox "Unable to Prepare Wave Header", 0, "Wave Error"
            ReturnCode = waveOutClose(hWaveOut)
            If ReturnCode <> 0 Then
                MsgBox "Unable to Close Wave Device", MB_ICONSTOP, "Wave Error"
              End If
          End If
      Else
        ' Couldn't open the device so do nothing.
        MsgBox "Unable to Open Wave Device", MB_ICONSTOP, "Wave Error"
      End If
    WaveHeader.lpData = GlobalUnlock(hWaveSampleData)
End Function

Sub wavestats (stats As PCMWAVEFORMAT, f As Form, bytes As Long, thepath As String)
'place the wave file stats into picbox
Const MONO = 1
Const STEREO = 2
On Error Resume Next

f!pic_stats.Cls
f!pic_stats.CurrentX = 0: f!pic_stats.CurrentY = 0
f!pic_stats.Print "Sampling " & stats.wf.nSamplesPerSec & " Hz"

'get the time length of data samples
plottime = bytes / stats.wf.nAvgBytesPerSec
f!pic_stats.Print "Length    " & Format$(plottime, "##.#0"); " Seconds"

Select Case stats.wf.nChannels
       Case MONO
         f!pic_stats.Print "Channels " & "Mono " & stats.wBitsPerSample; " Bit"
       Case STEREO
        f!pic_stats.Print "Channels " & "Stereo " & stats.wBitsPerSample; " Bit"
End Select

f!pic_stats.Print thepath

End Sub

