
LONG _export FAR PASCAL WaveWndProc( HCTL, HWND, WORD, WORD, LONG );
LONG _export FAR PASCAL PopupWndProc( HWND, WORD, WORD, LONG );
void ReverseData( HANDLE );
BOOL OpenWaveFile( HCTL );
BOOL CloseWaveFile( HCTL );
BOOL PlayWaveFile( HCTL );

typedef struct {
   HSZ WaveFile;
   int Enable, Loops, Reverse;
   HWAVEOUT hWave;
   WORD Device;
   HANDLE hWaveHeader;
   HANDLE hWaveData;
   DWORD dwStart;
   DWORD dwEnd;
   DWORD dwSize;
   DWORD dwVolume;
   DWORD dwPlayback;
   DWORD dwPitch;
   int nSampPerSec;
   int nBytesPerSec;
   int nSamplesPerSec;
} WAVESTRUCT;


#define DEREF(hctl) ((WAVESTRUCT far *)VBDerefControl(hctl))


char *CLASSPOPUP = "CPopup";

char *WaveMask = "Wave Files  (*.WAV)\0"\
                 "*.WAV\0"\
                 "All Files   (*.*)\0"\
                 "*.*\0"\
                 "";

char SampType[] = "0 - 11025 Samples Per Second\0"\
                  "1 - 22050 Samples Per Second\0"\
                  "2 - 44100 Samples Per Second\0"\
                  "\0";

char *WaveWild = "*.WAV";
char *WaveTitle = "Attach Wave File...";


PROPINFO Prop_Filename =
{
   "Filename",
   DT_HSZ | PF_fSetData | PF_fSetMsg | PF_fGetData | PF_fSaveData | PF_fEditable,
   0, 0, NULL, 0
};

PROPINFO Prop_Enable =
{
   "Enable",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Start =
{
   "Start",
   DT_LONG | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_End =
{
   "End",
   DT_LONG | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Loop =
{
   "Loop",
   DT_SHORT | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Channels =
{
   "Channels",
   DT_SHORT | PF_fGetMsg,
   0, 0, NULL, 0
};

PROPINFO Prop_Size =
{
   "Size",
   DT_LONG | PF_fGetMsg,
   0, 0, NULL, 0
};

PROPINFO Prop_Version =
{
   "Version",
   DT_SHORT | PF_fGetMsg,
   0, 0, NULL, 0
};

PROPINFO Prop_LVol =
{
   "LVolume",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_RVol =
{
   "RVolume",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Vol =
{
   "Volume",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Play =
{
   "Play",
   DT_BOOL | PF_fGetMsg | PF_fNoShow,
   0, 0, NULL, 0
};

PROPINFO Prop_Device =
{
   "DeviceNum",
   DT_SHORT | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Playback =
{
   "PlayRate",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Pitch =
{
   "Pitch",
   DT_SHORT | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_VolOK =
{
   "VolumeOK",
   DT_BOOL | PF_fGetMsg,
   0, 0, NULL, 0
};

PROPINFO Prop_PitchOK =
{
   "PitchOK",
   DT_BOOL | PF_fGetMsg,
   0, 0, NULL, 0
};

PROPINFO Prop_PlayrateOK =
{
   "PlayrateOK",
   DT_BOOL | PF_fGetMsg,
   0, 0, NULL, 0
};

PROPINFO Prop_LRVolumeOK =
{
   "LRVolumeOK",
   DT_BOOL | PF_fGetMsg,
   0, 0, NULL, 0
};

PROPINFO Prop_IsSync =
{
   "Synchronous",
   DT_BOOL | PF_fGetMsg,
   0, 0, NULL, 0
};

PROPINFO Prop_SampPerSec =
{
   "SampPerSec",
   DT_ENUM | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, 0, SampType, 2
};

PROPINFO Prop_Reverse =
{
   "Reverse",
   DT_BOOL | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PPROPINFO proplistWave[] =
{
   PPROPINFO_STD_LEFT,
   PPROPINFO_STD_TOP,
   &Prop_Channels,
   &Prop_Device,
   &Prop_Enable,
   &Prop_End,
   &Prop_Filename,
   &Prop_Loop,
   &Prop_Play,
   &Prop_Size,
   &Prop_Start,
   &Prop_Version,
   &Prop_Vol,
   &Prop_LVol,
   &Prop_RVol,
   &Prop_Playback,
   &Prop_Pitch,
   &Prop_VolOK,
   &Prop_PitchOK,
   &Prop_PlayrateOK,
   &Prop_LRVolumeOK,
   &Prop_IsSync,
   &Prop_SampPerSec,
   &Prop_Reverse,
   NULL
};

#define PROP_CHANNELS    2
#define PROP_DEVICE      3
#define PROP_ENABLE      4
#define PROP_END         5
#define PROP_FILENAME    6
#define PROP_LOOP        7
#define PROP_PLAY        8
#define PROP_SIZE        9
#define PROP_START       10
#define PROP_VERSION     11
#define PROP_VOL         12
#define PROP_LVOL        13
#define PROP_RVOL        14
#define PROP_PLAYBACK    15
#define PROP_PITCH       16
#define PROP_VOLOK       17
#define PROP_PITCHOK     18
#define PROP_PLAYRATEOK  19
#define PROP_LRVOLUMEOK  20
#define PROP_ISSYNC      21
#define PROP_SAMPPERSEC  22
#define PROP_REVERSE     23

MODEL modelWave =
{
   VB_VERSION,
   MODEL_fLoadMsg,
   (PCTLPROC)WaveWndProc,
   NULL,
   WS_CHILD,
   sizeof(WAVESTRUCT),
   8000,
   "Wave",
   "Wave",
   NULL,
   proplistWave,
   NULL
};



HANDLE hmodDLL;
HCTL DlgCtl;
HWND DlgWnd;
WORD DlgID;

BOOL FAR PASCAL LibMain( HANDLE hmod, HANDLE segDS, USHORT cbHeapSize )
{
   hmodDLL = hmod;

   UnlockData( 0 );
   return( TRUE );
}


BOOL _export FAR PASCAL VBINITCC( USHORT usVersion, BOOL fRunTime )
{
   if( ! fRunTime )
   {
      WNDCLASS wc;

      wc.style = 0;
      wc.lpfnWndProc = (WNDPROC)PopupWndProc;
      wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;
      wc.hInstance = hmodDLL;
      wc.hIcon = NULL;
      wc.hCursor = NULL;
      wc.hbrBackground = NULL;
      wc.lpszMenuName = NULL;
      wc.lpszClassName = CLASSPOPUP;

      if( ! RegisterClass( &wc ) )
         return( FALSE );
   }
   return( VBRegisterModel( hmodDLL, &modelWave ) );
}


