Option Explicit

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

Global Const KEY_TAB = &H9
Global Const KEY_ALT = &H12

Global Const SC_TASKLIST = &HF130

Global Const WM_COMMAND = &H111
Global Const WM_SYSCOMMAND = &H112
Global Const WM_SYSKEYDOWN = &H104
Global Const WM_SYSKEYUP = &H105
Global Const WM_LBUTTONDBLCLK = &H203

Global Const MF_BYCOMMAND = &H0
Global Const MF_APPEND = &H100
Global Const MF_SEPARATOR = &H800
Global Const MF_ENABLED = &H0
Global Const MF_STRING = &H0

Global Const MB_ICONINFORMATION = 64

Global Const IDM_ABOUT = 108

Global gnDesktopHwnd        As Integer

Declare Function APIGetDesktopHwnd Lib "User" Alias "GetDesktopHwnd" () As Integer
Declare Function APIGetDesktopWindow Lib "User" Alias "GetDesktopWindow" () As Integer
Declare Function APIGetSystemMenu Lib "User" Alias "GetSystemMenu" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer
Declare Function APIDeleteMenu Lib "User" Alias "DeleteMenu" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
Declare Function APIAppendMenu Lib "User" Alias "AppendMenu" (ByVal hMenu As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpNewItem As Any) As Integer
Declare Function APIShowWindow Lib "User" Alias "ShowWindow" (ByVal hWnd As Integer, ByVal nCmdShow As Integer) As Integer
Declare Function APIFindWindow Lib "User" Alias "FindWindow" (ByVal lpClassName As Any, ByVal lpWindowName As Any) As Integer
Declare Function APIArrangeIconicWindows Lib "User" Alias "ArrangeIconicWindows" (ByVal hWnd As Integer) As Integer
Declare Function APIGetPrivateProfileString Lib "Kernel" Alias "GetPrivateProfileString" (ByVal lpAppName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer

Sub APP_About ()

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.
    
    Dim tTempStr            As String
    Dim tCRLF               As String
		
    tCRLF = Chr$(13) & Chr$(10)
    tTempStr = "Copyright  1994 by Computer Technologies, Inc." & tCRLF & "All rights reserved."
    tTempStr = tTempStr & tCRLF & tCRLF & "Version 1.0 - Released October 11, 1994."
    tTempStr = tTempStr & tCRLF & tCRLF & "This demo program and all associated code is the property of Computer Technologies, Inc. It is provided as a service for the personal use of the members of the MS-BASIC forum on CompuServe, and other interested Visual Basic developers."
    tTempStr = tTempStr & tCRLF & tCRLF & "Author:" & Chr$(9) & "Eric Brierley"
    tTempStr = tTempStr & tCRLF & "CIS:" & Chr$(9) & "71163,2657"
    tTempStr = tTempStr & tCRLF & "Phone:" & Chr$(9) & "1-704-634-1766"
    MsgBox tTempStr, MB_ICONINFORMATION, "About VB-Switch"

End Sub

Function APP_IniRead (tSectionName As String, tItemName As String, tItemType As String, tFileName As String) As Variant

' Copyright  1993, 1994 by Computer Technologies, Inc. All rights reserved.

    Dim tReturnStr          As String * 256
    Dim lReturnSize         As Long
    Dim nBufferSize         As Integer
    Dim tTempStr            As String

    nBufferSize = 255

    lReturnSize = APIGetPrivateProfileString(tSectionName, tItemName, "", tReturnStr, nBufferSize, tFileName)
    tTempStr = Trim$(Left$(tReturnStr, lReturnSize))

    Select Case Left$(UCase$(tItemType), 2)
    Case "ST"            ' String
	APP_IniRead = tTempStr
    Case "IN"            ' Integer
	If tTempStr <> "" Then APP_IniRead = CVar(tTempStr) Else APP_IniRead = 0
    Case "BO"            ' Boolean (True/False)
	If Left$(UCase$(tTempStr), 1) = "T" Then
	    APP_IniRead = True
	  Else
	    APP_IniRead = False
	End If
    Case "TI"            ' Time
    Case "LO"            ' Long
	APP_IniRead = CVar(tTempStr)
    Case "SI"            ' Single
	APP_IniRead = CVar(tTempStr)
    Case "CU"            ' Currency
	APP_IniRead = CVar(tTempStr)
    Case "DO"            ' Double
	APP_IniRead = CVar(tTempStr)
    End Select

End Function

Sub Main ()

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

    Dim hMenu               As Integer
    Dim nHandle             As Integer
    Dim nResult             As Integer
    Dim tCommand            As String
    Dim bHide               As Integer
    Dim tCaption            As String

    Const SW_HIDE = 0
    Const SW_SHOW = 5
    Const GWL_STYLE = (-16)

' Get the handle of the desktop window so we can trap for
' double clicks used to bring up the task manager.
    gnDesktopHwnd = APIGetDesktopHwnd()

    Load frmNoSwitch
    frmNoSwitch.WindowState = 1                      ' Minimized

' Check the INI file for the 'Hide' option. Then check the command
' line for a /HIDE switch. The INI file overrides the command line
' if 'Hide' is set to 'True'.
    bHide = False
    nResult = APP_IniRead("Options", "Hide", "Boolean", App.Path & "\VBSWITCH.INI")
    If nResult = True Then
	bHide = True
      Else
	tCommand = UCase$(Trim$(Command$))          ' Get the command line
	If InStr(1, tCommand, "/HI") <> 0 Then bHide = True
    End If
    
    If bHide = True Then
	nHandle = APIFindWindow(0&, (frmNoSwitch.Caption))
	nResult = APIShowWindow(nHandle, SW_HIDE)
	nResult = APIArrangeIconicWindows((APIGetDesktopWindow()))
	Exit Sub
    End If

' We are not hidden, so show the about box and configure the application
    Call APP_About
    tCaption = APP_IniRead("Captions", "Form", "String", App.Path & "\VBSWITCH.INI")
    frmNoSwitch.Caption = tCaption

' Now we get a copy of the system menu, delete the "switch to"
' item, and remove the seperator bars.
    hMenu = APIGetSystemMenu((frmNoSwitch.hWnd), False)
    nResult = APIDeleteMenu(hMenu, SC_TASKLIST, MF_BYCOMMAND)
    nResult = APIDeleteMenu(hMenu, 0, MF_BYCOMMAND)
    nResult = APIDeleteMenu(hMenu, 0, MF_BYCOMMAND)

' Add our own 'About...' item to the menu
    tCaption = APP_IniRead("Captions", "About", "String", App.Path & "\VBSWITCH.INI")
    nResult = APIAppendMenu(hMenu, MF_SEPARATOR, 0, "")
    nResult = APIAppendMenu(hMenu, MF_ENABLED Or MF_STRING, IDM_ABOUT, tCaption)

    frmNoSwitch.Show             ' Let the user know we are here

End Sub

