//---------------------------------------------------------------------------
// ccInit.c
//---------------------------------------------------------------------------
// Custom Control DLL Initialization
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>

#define CTL_DATA	// cause the control structures to be declared

#include "vbapi.h"
#include "slider.h"

HANDLE	hmodDLL;

//---------------------------------------------------------------------------
// Register custom control.
//	This routine is called by VB when the custom control DLL is
//	loaded for use.
//---------------------------------------------------------------------------

BOOL FAR PASCAL _export VBINITCC
(
    USHORT usVersion,
    BOOL fRuntime
)
{
    // avoid warnings on unused (but required) formal parameters

    fRuntime = fRuntime;
    usVersion = usVersion;

    // Register control(s)

    if (!VBRegisterModel(hmodDLL, &modelSlider))
	return FALSE;

    return TRUE;
}

//---------------------------------------------------------------------------
// Initialize library.
//	This routine is called from the DLL entry point in LIBINIT.ASM
//	which is called when the first client loads the DLL.
//---------------------------------------------------------------------------

BOOL FAR LibMain
(
    HANDLE	hmod,
    HANDLE	segDS,
    USHORT	cbHeapSize
)
{
    BITMAP	bmp;

    // avoid warnings on unused (but required) formal parameters

    cbHeapSize = cbHeapSize;
    segDS = segDS;

    hmodDLL = hmod;

    hbmpSlide  = LoadBitmap(hmodDLL, MAKEINTRESOURCE(IDBMP_SLIDE));
    hbmpButton = LoadBitmap(hmodDLL, MAKEINTRESOURCE(IDBMP_BUTTON));
    hbmpMask   = LoadBitmap(hmodDLL, MAKEINTRESOURCE(IDBMP_MASK));

    if (!hbmpSlide || !hbmpButton || !hbmpMask) {
	MessageBox(NULL, "cannot load bitmaps", "SLIDER",
		   MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL);
	return FALSE;
	}

    GetObject(hbmpSlide, sizeof(BITMAP), (LPSTR)&bmp);
    sSlideWidth  = bmp.bmWidth;
    sSlideHeight = bmp.bmHeight;

    GetObject(hbmpButton, sizeof(BITMAP), (LPSTR)&bmp);
    sButtonWidth  = bmp.bmWidth;
    sButtonHeight = bmp.bmHeight;

    return TRUE;
}

//---------------------------------------------------------------------------
// Handle exit notification from Windows
//	This routine is called by Windows when the library is freed
//	by its last client.
//---------------------------------------------------------------------------

VOID FAR _export WEP
(
    BOOL	fSystemExit
)
{
    // avoid warnings on unused (but required) formal parameters

    fSystemExit = fSystemExit;
}

//---------------------------------------------------------------------------
