//---------------------------------------------------------------------------
// Slider.h
//---------------------------------------------------------------------------
// Copyright (C) 1990-91,  Microsoft Corp.
//                 All Rights Reserved
// Information Contained Herein Is Proprietary and Confidential.
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Helpful Macros
//---------------------------------------------------------------------------
#define OFFSETIN( struc, field )  ( (USHORT)&( ((struc *)0)->field ) )


//---------------------------------------------------------------------------
// Resource ID's
//---------------------------------------------------------------------------
// Toolbox bitmap resource IDs numbers must be consecutive from N to N+5
//---------------------------------------------------------------------------
#define IDBMP_SLIDER		8000
#define IDBMP_SLIDERDOWN	8001
#define IDBMP_SLIDERMONO	8003
#define IDBMP_SLIDERMONODOWN	8004
#define IDBMP_SLIDEREGA 	8006
#define IDBMP_SLIDEREGADOWN	8007

#define IDBMP_SLIDE		9000
#define IDBMP_BUTTON		9001
#define IDBMP_MASK		9002


#ifndef RC_INVOKED
//---------------------------------------------------------------------------
// SLIDER global data
//---------------------------------------------------------------------------
SHORT	sButtonWidth;
SHORT	sButtonHeight;
SHORT	sSlideWidth;
SHORT	sSlideHeight;

HBITMAP hbmpSlide;
HBITMAP hbmpButton;
HBITMAP hbmpMask;


//---------------------------------------------------------------------------
// Slider control struct
//---------------------------------------------------------------------------
typedef struct tagSLIDER
{
    USHORT	fCapture:1;	// mouse down and captured
    RECT	rectButton;	// button extent
    SHORT	sHeight;	// pixel height of slider
    SHORT	sYoff;		// relative mouse position at capture
}
SLIDER;

typedef SLIDER FAR * PSLIDER;

#define SLIDERDEREF( hctl )   CONTROLDEREF( SLIDER, hctl )


//---------------------------------------------------------------------------
// Control Procudure
//---------------------------------------------------------------------------
LONG _export SliderCtlProc( HCTL, HWND, USHORT, USHORT, LONG );


//---------------------------------------------------------------------------
// Property info
//---------------------------------------------------------------------------
#ifdef CTL_DATA
PROPINFO CTL_DATA propinfoSliderValue =
{
    "Value",
    DT_SHORT | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
    0, 0
};
#endif	// CTL_DATA


//---------------------------------------------------------------------------
// Property list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the properties
//---------------------------------------------------------------------------
#define IPROP_SLIDER_CTLNAME	    0x0000
#define IPROP_SLIDER_INDEX	    0x0001
#define IPROP_SLIDER_PARENT	    0x0002
#define IPROP_SLIDER_BACKCOLOR	    0x0003
#define IPROP_SLIDER_FORECOLOR	    0x0004
#define IPROP_SLIDER_LEFT	    0x0005
#define IPROP_SLIDER_TOP	    0x0006
#define IPROP_SLIDER_WIDTH	    0x0007
#define IPROP_SLIDER_HEIGHT	    0x0008
#define IPROP_SLIDER_ENABLED	    0x0009
#define IPROP_SLIDER_VISIBLE	    0x000A
#define IPROP_SLIDER_MOUSEPOINTER   0x000B
#define IPROP_SLIDER_VALUE	    0x000C
#define IPROP_SLIDER_DRAGMODE	    0x000D
#define IPROP_SLIDER_DRAGICON	    0x000E
#define IPROP_SLIDER_TABINDEX	    0x000F
#define IPROP_SLIDER_TABSTOP	    0x0010
#define IPROP_SLIDER_TAG	    0x0011

#ifdef CTL_DATA
PPROPINFO CTL_DATA proplistSlider[] =
{
    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_BACKCOLOR,
    PPROPINFO_STD_FORECOLOR,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_ENABLED,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_MOUSEPOINTER,
    &propinfoSliderValue,
    PPROPINFO_STD_DRAGMODE,
    PPROPINFO_STD_DRAGICON,
    PPROPINFO_STD_TABINDEX,
    PPROPINFO_STD_TABSTOP,
    PPROPINFO_STD_TAG,
    NULL
};
#endif	// CTL_DATA


//---------------------------------------------------------------------------
// Event procedure parameter prototypes
//---------------------------------------------------------------------------
#ifdef CTL_DATA
EVENTINFO CTL_DATA eventinfoChange =
{
    "Change"
};
#endif	// CTL_DATA


//---------------------------------------------------------------------------
// Event list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the events
//---------------------------------------------------------------------------
#define EVENT_SLIDER_CHANGE	    0
#define EVENT_SLIDER_DRAGDROP	    1
#define EVENT_SLIDER_DRAGOVER	    2
#define EVENT_SLIDER_GOTFOCUS	    3
#define EVENT_SLIDER_LOSTFOCUS	    4

#ifdef CTL_DATA
PEVENTINFO CTL_DATA eventlistSlider[] =
{
    &eventinfoChange,
    PEVENTINFO_STD_DRAGDROP,
    PEVENTINFO_STD_DRAGOVER,
    PEVENTINFO_STD_GOTFOCUS,
    PEVENTINFO_STD_LOSTFOCUS,
    NULL
};
#endif	// CTL_DATA


//---------------------------------------------------------------------------
// Model struct
//---------------------------------------------------------------------------
// Define the control model (using the event and property structures).
//---------------------------------------------------------------------------
#ifdef CTL_DATA
MODEL CTL_DATA modelSlider =
{
    VB_VERSION, 			// VB version being used
    MODEL_fFocusOk | MODEL_fWantArrows, // MODEL flags
    (PCTLPROC)SliderCtlProc,		// Control procedure
    CS_DBLCLKS | CS_HREDRAW
     | CS_VREDRAW,                      // Class style
    WS_CHILD,				// default Window style
    sizeof(SLIDER),			// cbCtlExtra for SLIDER structure
    IDBMP_SLIDER,			// palette bitmap ID
    "Slider",				// default control name
    "Slider",				// Visual Basic class name
    NULL,				// parent class name
    proplistSlider,			// Properties list
    eventlistSlider			// Events list
};
#endif	// CTL_DATA

#endif  // RC_INVOKED

//---------------------------------------------------------------------------
