//---------------------------------------------------------------------------
// Slider.c
//---------------------------------------------------------------------------
// Slider Control
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>

#include "vbapi.h"
#include "slider.h"

#define EBER_NONE 0

SHORT	sButtonWidth = 0;
SHORT	sButtonHeight = 0;
SHORT	sSlideWidth = 0;
SHORT	sSlideHeight = 0;

HBITMAP hbmpSlide = 0;
HBITMAP hbmpButton = 0;
HBITMAP hbmpMask = 0;


typedef union tagPARAMS // event procedure parameter profiles
{
    struct {
	LPVOID	Index;	// reserve space for index parameter to array ctl
    } Void;		// NO PARAMS: Change, GotFocus, LostFocus events
}
PARAMS;

void	PaintSlider(HCTL hctl, HWND hwnd, HDC hdc);
SHORT	GetButtonPos(HCTL hctl);
void	SetButtonPos(HCTL hctl, SHORT sPos);
void	MoveButton(HCTL hctl, HWND hwnd, SHORT sPos);

//---------------------------------------------------------------------------
// Slider control function
//---------------------------------------------------------------------------
LONG _export SliderCtlProc
(
    HCTL	hctl,
    HWND        hwnd,
    USHORT      msg,
    USHORT      wp,
    LONG        lp
)
{
    LONG        lResult;

    // Message pre-processing
    switch( msg )
    {
	case WM_PAINT:
	    if (wp)
		PaintSlider(hctl, hwnd, (HDC)wp);
	    else {
		PAINTSTRUCT ps;

		BeginPaint(hwnd, &ps);
		PaintSlider(hctl, hwnd, ps.hdc);
		EndPaint(hwnd, &ps);
		}
	    break;

	case WM_SIZE:
	    {
	    PSLIDER pSlider;

	    pSlider = SLIDERDEREF(hctl);

	    pSlider->sHeight = ((HIWORD(lp) - sButtonHeight) / sSlideHeight)
				* sSlideHeight + sButtonHeight;
	    }
	    break;

	case WM_LBUTTONDOWN:
	    {
	    PSLIDER pSlider;

	    pSlider = SLIDERDEREF(hctl);

	    if (PtInRect(&pSlider->rectButton, MAKEPOINT(lp))) {
		pSlider->fCapture = TRUE;
		pSlider->sYoff = HIWORD(lp) - pSlider->rectButton.top;
		SetCapture(hwnd);
		}
	    }
	    break;

	case WM_LBUTTONUP:
	case WM_MOUSEMOVE:
	    {
	    PSLIDER pSlider;

	    pSlider = SLIDERDEREF(hctl);

	    if (pSlider->fCapture) {
		MoveButton(hctl, hwnd, HIWORD(lp) - pSlider->sYoff);
		if (msg == WM_LBUTTONUP) {
		    ReleaseCapture();
		    pSlider->fCapture = FALSE;
		    }
		}
	    }
	    break;

	case WM_NCCREATE:
	    {
	    PSLIDER pSlider;

	    pSlider = SLIDERDEREF(hctl);

	    pSlider->rectButton.top    = 0;
	    pSlider->rectButton.bottom = sButtonHeight;
	    pSlider->rectButton.left   = (sSlideWidth - sButtonWidth) / 2;
	    pSlider->rectButton.right  = pSlider->rectButton.left + sButtonWidth;
	    }
	    break;

	case VBM_GETPROPERTY:
	    switch ( wp ) {
		case IPROP_SLIDER_VALUE:
		    (*(SHORT FAR *)lp) = GetButtonPos(hctl);
		    return EBER_NONE;
		}
	    break;

	case VBM_SETPROPERTY:
	    switch ( wp ) {
		case IPROP_SLIDER_VALUE:
		    MoveButton(hctl, hwnd, (SHORT)lp);
		    return EBER_NONE;
		}
	    break;

	case WM_KEYDOWN:
	    switch (wp) {
		case VK_UP:
		    MoveButton(hctl, hwnd, GetButtonPos(hctl)-1);
		    break;

		case VK_DOWN:
		    MoveButton(hctl, hwnd, GetButtonPos(hctl)+1);
		    break;

		case VK_PRIOR:
		    MoveButton(hctl, hwnd, GetButtonPos(hctl)-40);
		    break;

		case VK_NEXT:
		    MoveButton(hctl, hwnd, GetButtonPos(hctl)+40);
		    break;
		}
	    break;

	case VBM_CREATED:
	    MoveButton(hctl, hwnd, 0);
	    break;
    }

    // Default processing:
    lResult = VBDefControlProc( hctl, hwnd, msg, wp, lp );

    // Message post-processing:
    switch( msg )
    {

	// none!

    }

    return lResult;
}

//---------------------------------------------------------------------------

void	SetButtonPos
(
    HCTL    hctl,
    SHORT   sPos
)
{
    PSLIDER pSlider;
    PARAMS  params;

    pSlider = SLIDERDEREF(hctl);
    if (sPos < 0)
	sPos = 0;
    if (sPos + sButtonHeight >= pSlider->sHeight)
	sPos = pSlider->sHeight - sButtonHeight;
    if (pSlider->rectButton.top != sPos) {
	pSlider->rectButton.top    = sPos;
	pSlider->rectButton.bottom = sPos + sButtonHeight;
	pSlider->rectButton.left   = (sSlideWidth - sButtonWidth) / 2;
	pSlider->rectButton.right  = pSlider->rectButton.left + sButtonWidth;
	VBFireEvent(hctl, EVENT_SLIDER_CHANGE, &params);
	}
}

SHORT	GetButtonPos
(
    HCTL    hctl
)
{
    return SLIDERDEREF(hctl)->rectButton.top;
}

void	PaintSlider
(
    HCTL    hctl,
    HWND    hwnd,
    HDC     hdc
)
{
    HDC     hMemDC;
    RECT    rectSlide;
    PSLIDER pSlider;
    HBITMAP hbmpSave;
    HBRUSH  hbrSlide;
    HBRUSH  hbrSave;

    pSlider = SLIDERDEREF(hctl);

    hMemDC = CreateCompatibleDC(hdc);
    hbmpSave = SelectObject(hMemDC, hbmpSlide);

    rectSlide.top    = sButtonHeight / 2;
    rectSlide.left   = 0;
    rectSlide.bottom = rectSlide.top + sSlideHeight;
    rectSlide.right  = sSlideWidth;

    SendMessage(GetParent(hwnd), WM_CTLCOLOR, hdc, MAKELONG(hwnd, 0));
    hbrSlide = CreateSolidBrush(GetTextColor(hdc));
    if (hbrSlide)
	hbrSave = SelectObject(hdc, hbrSlide);
    while (rectSlide.top <= pSlider->sHeight) {
	if (RectVisible(hdc, &rectSlide))
	    BitBlt(hdc,
		   rectSlide.left,
		   rectSlide.top,
		   sSlideWidth,
		   (pSlider->sHeight >= rectSlide.bottom) ? sSlideHeight : 1,
		   hMemDC,
		   0, 0,
		   0x00B8074AL);    // PSDPxax
	OffsetRect(&rectSlide, 0, sSlideHeight);
	}
    if (hbrSlide)
	SelectObject(hdc, hbrSave);
    DeleteObject(hbrSlide);

    if (RectVisible(hdc, &pSlider->rectButton)) {
	SelectObject(hMemDC, hbmpMask);
	BitBlt(hdc,
	       pSlider->rectButton.left,
	       pSlider->rectButton.top,
	       sButtonWidth,
	       sButtonHeight,
	       hMemDC,
	       0, 0,
	       SRCAND);
	SelectObject(hMemDC, hbmpButton);
	BitBlt(hdc,
	       pSlider->rectButton.left,
	       pSlider->rectButton.top,
	       sButtonWidth,
	       sButtonHeight,
	       hMemDC,
	       0, 0,
	       SRCPAINT);
	}

    // ExcludeClipRect(hdc, 0, 0, sSlideWidth, sSlideHeight);

    rectSlide.top    = 0;
    rectSlide.right  = 9999;

    // FillRect(hdc, &rectSlide, COLOR_WINDOW+1);
    SelectObject(hMemDC, hbmpSave);
    DeleteDC(hMemDC);
}

//--------------------------------------------------------------------------
// MoveButton
//--------------------------------------------------------------------------
void MoveButton
(
    HCTL    hctl,
    HWND    hwnd,
    SHORT   sPos
)
{
    RECT    rectOld;
    RECT    rectUnion;
    PSLIDER pSlider;
    HDC     hdcMove;
    HDC     hdcMain;
    HBITMAP hbmpMove;
    HBITMAP hbmpSave;

    pSlider = SLIDERDEREF(hctl);

    rectOld = pSlider->rectButton;
    SetButtonPos(hctl, sPos);
    UnionRect(&rectUnion, &rectOld, &pSlider->rectButton);
    hdcMain = GetDC(hwnd);
    hdcMove = CreateCompatibleDC(hdcMain);
    hbmpMove = CreateCompatibleBitmap(hdcMain,
	    rectUnion.right -  rectUnion.left,
	    rectUnion.bottom - rectUnion.top);
    hbmpSave = SelectObject(hdcMove, hbmpMove);
    SetWindowOrg(hdcMove, rectUnion.left, rectUnion.top);
    VBSendControlMsg(hctl, WM_ERASEBKGND, hdcMove, 0L);
    PaintSlider(hctl, hwnd, hdcMove);
    SetWindowOrg(hdcMove, 0, 0);
    BitBlt(hdcMain,
	    rectUnion.left,
	    rectUnion.top,
	    rectUnion.right -  rectUnion.left,
	    rectUnion.bottom - rectUnion.top,
	    hdcMove,
	    0,
	    0,
	    SRCCOPY);
    SelectObject(hdcMove, hbmpSave);
    DeleteObject(hbmpMove);
    DeleteDC(hdcMove);
    ReleaseDC(hwnd, hdcMain);
}
