#include "windows.h"
#include "vbapi.h"


#define PAINTTEXT    1
#define PAINTPIC     2
#define PAINTALL     3

void PaintControl( HCTL, HWND, WORD );
LONG FAR PASCAL _export PicWndProc( HCTL, HWND, WORD, WORD, LONG );

#define OFFSETIN( struc, field )  ( (USHORT)&( ((struc *)0)->field ) )

typedef struct {
   HPIC hPicUp;
   HPIC hPicDown;
   HSZ hszWaveFile;
   int Width, Height;
   int MouseX, MouseY, WaveOn;
   int Selected, ButtonDown;
   int Stretch, BorderWidth, WaveLoop;
   int Shadow, Border, WaveStyle;
   HFONT hFont;
   LONG Hilite;
   LONG Lolite;
   long ShadowColor;
   char Caption[ 128 ];
} PICSTRUCT;

#define DEREF(hctl) ((PICSTRUCT far *)VBDerefControl(hctl))

char MMSystem[] = "MMSYSTEM.DLL";

EVENTINFO Event_Click =
{
   "Click",
   0, 0, NULL, NULL
};

PEVENTINFO eventlistPicBttn[] =
{

   &Event_Click,
   PEVENTINFO_STD_DBLCLICK,
   PEVENTINFO_STD_GOTFOCUS,
   PEVENTINFO_STD_LOSTFOCUS,
   PEVENTINFO_STD_MOUSEDOWN,
   PEVENTINFO_STD_MOUSEMOVE,
   PEVENTINFO_STD_MOUSEUP,
   NULL
};

PROPINFO propinfoPictureUp =
{
    "PicUp",
    DT_PICTURE | PF_fGetData | PF_fSetCheck | PF_fSetData | PF_fSaveData,
    0, 0, NULL, 0
};

PROPINFO propinfoPictureDown =
{
    "PicDown",
    DT_PICTURE | PF_fGetData | PF_fSetCheck | PF_fSetData | PF_fSaveData,
    sizeof(HPIC), 0, NULL, 0
};

PROPINFO prop_Stretch =
{
   "Stretch",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO prop_BorderWidth =
{
   "BorderWidth",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO prop_TextShadow =
{
   "TextShadow",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO prop_ShColor =
{
   "TextShadowCol",
   DT_COLOR | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO prop_Hilite =
{
   "HiliteColor",
   DT_COLOR | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO prop_Shadow =
{
   "ShadowColor",
   DT_COLOR | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO prop_Border =
{
   "Border",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO prop_WaveFile =
{
   "WaveFile",
   DT_HSZ | PF_fSetData | PF_fGetData | PF_fSaveData,
   sizeof(HPIC) * 2, 0, NULL, 0
};

char WaveStyles[] = "0 - Synchronous\0"\
                  "1 - Asynchrounous\0"\
                  "";

PROPINFO prop_WaveStyle =
{
   "WaveStyle",
   DT_ENUM | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, 0, WaveStyles, 1
};

PROPINFO prop_WaveLoop =
{
   "WaveLoop",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO prop_WaveEnabled =
{
   "WaveEnabled",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PPROPINFO proplistPicBttn[] =
{
    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_BACKCOLOR,
    PPROPINFO_STD_FORECOLOR,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_ENABLED,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_MOUSEPOINTER,
    PPROPINFO_STD_CAPTION,
    PPROPINFO_STD_FONTNAME,
    PPROPINFO_STD_FONTSIZE,
    PPROPINFO_STD_FONTBOLD,
    PPROPINFO_STD_FONTITALIC,
    PPROPINFO_STD_FONTSTRIKE,
    PPROPINFO_STD_FONTUNDER,
    PPROPINFO_STD_DRAGMODE,
    PPROPINFO_STD_DRAGICON,
    PPROPINFO_STD_TABINDEX,
    PPROPINFO_STD_TABSTOP,
    PPROPINFO_STD_TAG,
    &propinfoPictureUp,
    &propinfoPictureDown,
    &prop_Stretch,
    &prop_BorderWidth,
    &prop_TextShadow,
    &prop_ShColor,
    &prop_Shadow,
    &prop_Hilite,
    &prop_Border,
    &prop_WaveFile,
    &prop_WaveStyle,
    &prop_WaveLoop,
    &prop_WaveEnabled,
   NULL
};

#define PROP_PICUP       24
#define PROP_PICDOWN     25
#define PROP_STRETCH     26
#define PROP_BORDERWIDTH 27
#define PROP_TEXTSHADOW  28
#define PROP_SHCOLOR     29
#define PROP_SHADOW      30
#define PROP_HILITE      31
#define PROP_BORDER      32
#define PROP_WAVEFILE    33
#define PROP_WAVESTYLE   34
#define PROP_WAVELOOP    35
#define PROP_WAVEENABLED 36

MODEL modelPicBttn =
{
   VB_VERSION,
   MODEL_fFocusOk | MODEL_fMnemonic,
   (PCTLPROC)PicWndProc,
   NULL,
   WS_CHILD | BS_PUSHBUTTON | BS_OWNERDRAW,
   sizeof(PICSTRUCT),
   8000,
   "Pic3D",
   "Pic3D",
   "button",
   proplistPicBttn,
   eventlistPicBttn
};

HANDLE hmodDLL;

BOOL FAR PASCAL LibMain( HANDLE hmod, HANDLE segDS, USHORT cbHeapSize )
{
   hmodDLL = hmod;
   UnlockData( 0 );
   return( TRUE );
}


BOOL FAR PASCAL _export VBINITCC( USHORT usVersion, BOOL fRunTime )
{
   return( VBRegisterModel( hmodDLL, &modelPicBttn ) );
}


LONG FAR PASCAL _export PicWndProc( HCTL hCtl, HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_CREATE:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );

         if( ! lstrlen( Pi->Caption ) )
            lstrcpy( (LPSTR)Pi->Caption, "&Text" );

         Pi->Shadow = 0;
         Pi->ShadowColor = 0L;
         Pi->Hilite = RGB( 255, 255, 255 );
         Pi->Lolite = RGB( 128, 128, 128 );
         Pi->Border = 1;
         break;
      }

      case WM_SIZE:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );

         Pi->Width = LOWORD( lParam );
         Pi->Height = HIWORD( lParam );
         break;
      }

      case VBM_MNEMONIC:
         PostMessage( hWnd, WM_LBUTTONDOWN, 0, 0L );
         PostMessage( hWnd, WM_LBUTTONUP, 0, 0L );
         break;

      case WM_MOUSEMOVE:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );

         Pi->MouseX = LOWORD( lParam );
         Pi->MouseY = HIWORD( lParam );

         if( LOWORD( lParam ) > Pi->Width || LOWORD( lParam ) < 0 ||
             HIWORD( lParam ) > Pi->Height || HIWORD( lParam ) < 0 )
         {
            if( Pi->Selected && Pi->ButtonDown )
            {
               Pi->ButtonDown = 0;
               InvalidateRect( hWnd, NULL, FALSE );
            }
         }
         else
         {
            if( Pi->Selected && ! Pi->ButtonDown )
            {
               Pi->ButtonDown = 1;
               InvalidateRect( hWnd, NULL, FALSE );
            }
         }
         break;
      }


      case WM_LBUTTONDOWN:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );
         WORD winVer;
         HANDLE hMM;
         FARPROC lpfnSndPlaySound;
         LPSTR lpWave;

         Pi->ButtonDown = 1;
         Pi->Selected = 1;
         SetCapture( hWnd );
         InvalidateRect( hWnd, NULL, FALSE );
         break;
      }

      case WM_LBUTTONUP:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );
         WORD winVer;
         LPSTR lpWave;
         HANDLE hMM;
         FARPROC lpfnSndPlaySound;

         Pi->ButtonDown = 0;
         Pi->Selected = 0;

         InvalidateRect( hWnd, NULL, FALSE );

         ReleaseCapture();

         if( LOWORD( lParam ) < 0 || LOWORD( lParam ) > Pi->Width ||
             HIWORD(lParam ) < 0 || HIWORD( lParam ) > Pi->Height )
            return( TRUE );

         if( Pi->WaveOn != 0 )
         {
            winVer = GetVersion();
            if( HIBYTE( winVer ) >= 10 && LOBYTE( winVer ) >= 3 )
            {
               lpWave = VBDerefHsz( Pi->hszWaveFile );
               if( lstrlen( lpWave ) )
               {
                  hMM = LoadLibrary( MMSystem );
                  if( hMM )
                  {
                     lpfnSndPlaySound = GetProcAddress( hMM, (LPSTR)(long)2 );
                     if( lpfnSndPlaySound )
                        ( *lpfnSndPlaySound )( (LPSTR)lpWave,
                                       (int)8 * ( Pi->WaveLoop != 0 ) );

                     FreeLibrary( hMM );
                  }
               }
            }
         }
         VBFireEvent( hCtl, 0, NULL );
         return( TRUE );
      }

      case WM_SETTEXT:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );

         lstrcpy( Pi->Caption, (LPSTR)lParam );
         InvalidateRect( hWnd, NULL, TRUE );
         break;
      }

      case WM_SETFONT:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );

         Pi->hFont = wParam;
         if( lParam )
            PaintControl( hCtl, hWnd, PAINTALL );

         return( FALSE );
      }

      case WM_GETFONT:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );

         return( Pi->hFont );
      }

      case VBM_CHECKPROPERTY:
      {
         if( wParam == PROP_PICUP || wParam == PROP_PICDOWN )
         {
            PIC pic;

            VBGetPic( (HPIC)lParam, &pic );

            if( pic.picType == PICTYPE_NONE ||
                pic.picType == PICTYPE_BITMAP ||
                pic.picType == PICTYPE_ICON )
            {
               InvalidateRect( hWnd, NULL, TRUE );
               return( FALSE );
            }
            return( 380 );
         }
         break;
      }

      case VBN_DRAWITEM:
      {
         LPDRAWITEMSTRUCT Ds = (LPDRAWITEMSTRUCT)lParam;

         if( ! ( Ds->itemAction & ODA_SELECT ) && ! ( Ds->itemAction & ODA_DRAWENTIRE ) )
            return( FALSE );

         if( ( Ds->itemAction & ODA_FOCUS ) == ODA_FOCUS )
            return( FALSE );

         PaintControl( hCtl, hWnd, PAINTALL );

         return( FALSE );
      }

      case VBM_SETPROPERTY:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );

         switch( wParam )
         {
            case PROP_BORDERWIDTH:
               Pi->BorderWidth = LOWORD( lParam ) - 1;
               if( Pi->BorderWidth < 0 )
                  Pi->BorderWidth = 0;

               PaintControl( hCtl, hWnd, PAINTALL );
               return( FALSE );

            case PROP_STRETCH:
               Pi->Stretch = (BOOL)lParam;
               PaintControl( hCtl, hWnd, PAINTALL );
               return( FALSE );

            case PROP_TEXTSHADOW:
               Pi->Shadow = (BOOL)lParam;
               PaintControl( hCtl, hWnd, PAINTALL );
               return( FALSE );

            case PROP_SHCOLOR:
               Pi->ShadowColor = lParam;
               PaintControl( hCtl, hWnd, PAINTALL );
               return( FALSE );

            case PROP_SHADOW:
               Pi->Lolite = lParam;
               PaintControl( hCtl, hWnd, PAINTALL );
               return( FALSE );

            case PROP_HILITE:
               Pi->Hilite = lParam;
               PaintControl( hCtl, hWnd, PAINTALL );
               return( FALSE );

            case PROP_BORDER:
               Pi->Border = (BOOL)lParam;
               PaintControl( hCtl, hWnd, PAINTALL );
               return( FALSE );

            case PROP_WAVESTYLE:
               Pi->WaveStyle = LOWORD( lParam );
               return( FALSE );

            case PROP_WAVELOOP:
               Pi->WaveLoop = LOWORD( lParam );
               return( FALSE );

            case PROP_WAVEENABLED:
               Pi->WaveOn = LOWORD( lParam );
               return( FALSE );
         }
         break;
      }

      case VBM_GETPROPERTY:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );

         switch( wParam )
         {
            case PROP_BORDERWIDTH:
               *(WORD far *)lParam = Pi->BorderWidth + 1;
               return( FALSE );

            case PROP_STRETCH:
               *(WORD far *)lParam = Pi->Stretch;
               return( FALSE );

            case PROP_TEXTSHADOW:
               *(BOOL far *)lParam = Pi->Shadow;
               return( FALSE );

            case PROP_SHCOLOR:
               *(LONG far *)lParam = Pi->ShadowColor;
               return( FALSE );

            case PROP_SHADOW:
               *(LONG far *)lParam = Pi->Lolite;
               return( FALSE );

            case PROP_HILITE:
               *(LONG far *)lParam = Pi->Hilite;
               return( FALSE );

            case PROP_BORDER:
               *(BOOL far *)lParam = Pi->Border;
               return( FALSE );

            case PROP_WAVESTYLE:
               *(WORD far *)lParam = Pi->WaveStyle;
               return( FALSE );

            case PROP_WAVELOOP:
               *(WORD far *)lParam = Pi->WaveLoop;
               return( FALSE );

            case PROP_WAVEENABLED:
               *(WORD far *)lParam = Pi->WaveOn;
               return( FALSE );
         }
         break;
      }

      case WM_DESTROY:
      {
         PICSTRUCT far *Pi = DEREF( hCtl );
         LONG lResult;

         lResult = VBDefControlProc( hCtl, hWnd, msg, wParam, lParam );
         VBFreePic( Pi->hPicUp );
         VBFreePic( Pi->hPicDown );
         return( lResult );
      }
      break;
   }
   return( VBDefControlProc( hCtl, hWnd, msg, wParam, lParam ) );
}


void PaintControl( HCTL hCtl, HWND hWnd, WORD Control )
{
   PICSTRUCT far *Pi = DEREF( hCtl );
   HDC hDC;
   HDC mDC;
   TEXTMETRIC tm;
   HPEN hBlackPen;
   HPEN hDkGrayPen;
   HPEN hWhitePen;
   HPIC hPic;
   RECT Rect;
   PIC Pic;
   BITMAP bmp;
   HBRUSH hBrush;
   int len, bWidth, Xpos, Ypos;
   long OldTextColor;

   hWhitePen = CreatePen( PS_SOLID, 1, RGB( 255, 255, 255 ) );
   hDkGrayPen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) );
   hBlackPen = CreatePen( PS_SOLID, 1, RGB( 0, 0, 0 ) );

   hDC = GetDC( hWnd );
   SelectObject( hDC, Pi->hFont );

   if( lstrlen( Pi->Caption ) )
      GetTextMetrics( hDC, &tm );
   else
      tm.tmHeight = 0;


   hBrush = SendMessage( GetParent( hWnd ), WM_CTLCOLOR, hDC, MAKELONG( hWnd, 0 ) );
   SelectObject( hDC, hBrush );

   len = Pi->Height - tm.tmHeight - 1;

   if( Pi->Border )
      SelectObject( hDC, hBlackPen );
   else
      SelectObject( hDC, CreatePen( PS_SOLID, 1, GetBkColor( hDC ) ) );

   Rectangle( hDC, 0, 0, Pi->Width, len );

   MoveTo( hDC, 0, 0 );
   LineTo( hDC, 0, len - 1 );
   LineTo( hDC, Pi->Width - 1, len - 1 );
   LineTo( hDC, Pi->Width - 1, 0 );
   LineTo( hDC, 0, 0 );

   if( ! Pi->Border )
      DeleteObject( SelectObject( hDC, GetStockObject( NULL_PEN ) ) );

   bWidth = Pi->BorderWidth;

   while( bWidth != -1 )
   {
      if( Pi->ButtonDown )
         SelectObject( hDC, CreatePen( PS_SOLID, 1, Pi->Lolite ) );
      else
         SelectObject( hDC, CreatePen( PS_SOLID, 1, Pi->Hilite ) );

      MoveTo( hDC, Pi->Width - 2 - bWidth, 1 + bWidth );
      LineTo( hDC, 1 + bWidth, 1 + bWidth );
      LineTo( hDC, 1 + bWidth, len - 1 - bWidth );

      if( ! Pi->ButtonDown )
      {
         DeleteObject( SelectObject( hDC, CreatePen( PS_SOLID, 1, Pi->Lolite ) ) );

         MoveTo( hDC, 2 + bWidth, len - 2 - bWidth );
         LineTo( hDC, Pi->Width - 2 - bWidth, len - 2 - bWidth );
         LineTo( hDC, Pi->Width - 2 - bWidth, 1 + bWidth );
      }
      DeleteObject( SelectObject( hDC, GetStockObject( NULL_PEN ) ) );

      --bWidth;
   }

   if( lstrlen( Pi->Caption ) )
   {
      if( Pi->Shadow )
      {
         Rect.left = 0;
         Rect.right = Pi->Width - 1;
         Rect.top = Pi->Height - tm.tmHeight - 1;
         Rect.bottom = Pi->Height;

         OldTextColor = GetTextColor( hDC );
         SetTextColor( hDC, Pi->ShadowColor );
         DrawText( hDC, Pi->Caption, lstrlen( Pi->Caption ), &Rect, DT_CENTER | DT_VCENTER );
         SetTextColor( hDC, OldTextColor );
         SetBkMode( hDC, TRANSPARENT );
      }

      Rect.left = 1;
      Rect.right = Pi->Width;
      Rect.top = Pi->Height - tm.tmHeight - 1 + ( Pi->Shadow != 0 );
      Rect.bottom = Pi->Height + ( Pi->Shadow != 0 );

      DrawText( hDC, Pi->Caption, lstrlen( Pi->Caption ), &Rect, DT_CENTER | DT_VCENTER );
   }

   len = 0;

   if( Pi->ButtonDown )
   {
      if( ! Pi->hPicDown )
         hPic = Pi->hPicUp;
      else
         hPic = Pi->hPicDown;
   }
   else
      hPic = Pi->hPicUp;

   VBGetPic( hPic, &Pic );

   if( Pic.picType == PICTYPE_BITMAP )
   {
      GetObject( Pic.picData.bmp.hbitmap, sizeof(BITMAP), (LPSTR)&bmp );

      mDC = CreateCompatibleDC( hDC );

      SelectObject( mDC, Pic.picData.bmp.hbitmap );

      Xpos = ( Pi->Width - bmp.bmWidth ) / 2;
      Ypos = ( Pi->Height - bmp.bmHeight - tm.tmHeight ) / 2;
      if( Pi->ButtonDown )
      {
         Xpos += Pi->BorderWidth + 1;
         Ypos += Pi->BorderWidth + 1;
      }

      if( Pi->Stretch == -1 )
         StretchBlt( hDC, Pi->BorderWidth + 2 + ( Pi->BorderWidth * Pi->ButtonDown ),
                          Pi->BorderWidth + 2 + ( Pi->BorderWidth * Pi->ButtonDown ),
                     Pi->Width - ( 2 * Pi->BorderWidth ) - 4,
                     Pi->Height - tm.tmHeight - ( 2 * Pi->BorderWidth ) - 5,
                     mDC, 0, 0, bmp.bmWidth, bmp.bmHeight, SRCCOPY );
      else
         BitBlt( hDC, Xpos, Ypos, bmp.bmWidth, bmp.bmHeight, mDC, 0, 0, SRCCOPY );

      DeleteDC( mDC );
   }

   if( Pic.picType == PICTYPE_ICON )
   {
      Xpos = ( Pi->Width - 32 ) / 2;
      Ypos = ( Pi->Height - tm.tmHeight - 32 ) / 2;

      if( Pi->ButtonDown )
      {
         Xpos += Pi->BorderWidth + 1;
         Ypos += Pi->BorderWidth + 1;
      }

      DrawIcon( hDC, Xpos, Ypos, Pic.picData.icon.hicon );
   }

   ReleaseDC( hWnd, hDC );
   DeleteObject( hBlackPen );
   DeleteObject( hDkGrayPen );
   DeleteObject( hWhitePen );
}


