//---------------------------------------------------------------------------
// Grid.h
//---------------------------------------------------------------------------
// Copyright (C) 1990-91,  Microsoft Corp.
//                 All Rights Reserved
// Information Contained Herein Is Proprietary and Confidential.
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Helpful Macros
//---------------------------------------------------------------------------
#define OFFSETIN( struc, field )  ( (USHORT)&( ((struc *)0)->field ) )


//---------------------------------------------------------------------------
// Resource ID's
//---------------------------------------------------------------------------
// Toolbox bitmap resource IDs numbers must be consecutive from N to N+5
//---------------------------------------------------------------------------
#define IDBMP_GRID		8000
#define IDBMP_GRIDDOWN		8001
#define IDBMP_GRIDMONO		8003
#define IDBMP_GRIDMONODOWN	8004
#define IDBMP_GRIDEGA		8006
#define IDBMP_GRIDEGADOWN	8007

#define IDCUR_HSEP		9000
#define IDCUR_VSEP		9001


#ifndef RC_INVOKED
//---------------------------------------------------------------------------
// Grid control data and structs
//---------------------------------------------------------------------------
HCURSOR hcurHSep;
HCURSOR hcurVSep;
HCURSOR hcurArrow;

_segment segGrid;   // segment where the Grid HCTL is stored
_segment segData;   // segment where the Grid data is stored

#define GBP _based(segGrid) *	// Grid based pointer
#define DBP _based(segData) *	// Data based pointer

#define GBH GBP GBP		// Grid based handle
#define DBH DBP DBP		// Data based handle

typedef VOID DBH BHVOID;	// void handle

typedef CHAR DBH BHSTR; 	// handle to a string

typedef struct tagROWDATA {
    SHORT	Height; 	// row height in pixels
    SHORT	Cols;		// allocated columns for THIS row
    SHORT	fDefHeight:1;	// height was set by default
    BHSTR	bhStr[1];	// array of handles to column text data
    } ROWDATA;

typedef struct tagROWARRAY {
    ROWDATA	DBH bhRowData[1];// array of handles to each row's data
    } ROWARRAY;

typedef struct tagCOLDATA {
    SHORT	Width;		// width in pixels
    SHORT	Alignment;	// left/center/right
    SHORT	fDefWidth:1;	// width was set by default
    } COLDATA;

typedef struct tagCOLARRAY {
    COLDATA	ColData[1];	// array of handles to each col's data
    } COLARRAY;

typedef struct tagGRID
{
    FSHORT	fl;		// flags (unused)
    FSHORT	SelType:2;
    FSHORT	fFocus:1;
    FSHORT	fSelection:1;
    FSHORT	fMouseCapture:1;
    FSHORT	fScrollVert:1;
    FSHORT	fScrollHorz:1;
    SHORT	Row;
    SHORT	Col;
    SHORT	Rows;
    SHORT	Cols;
    SHORT	FixedRows;
    SHORT	FixedCols;
    SHORT	TopRow;
    SHORT	BottomRow;
    SHORT	TopRowMax;
    SHORT	WholeBottomRow;
    SHORT	LeftCol;
    SHORT	RightCol;
    SHORT	LeftColMax;
    SHORT	WholeRightCol;
    SHORT	OrgY;
    SHORT	OrgX;
    SHORT	SelTopRow;
    SHORT	SelBottomRow;
    SHORT	SelLeftCol;
    SHORT	SelRightCol;
    SHORT	KeySelRow;
    SHORT	KeySelCol;
    HFONT	hFont;
    SHORT	Width;
    SHORT	Height;
    SHORT	DefWidth;
    SHORT	DefHeight;
    ROWARRAY	DBH bhRowArray; // handle to array of row data
    COLARRAY	DBH bhColArray; // handle to array of col data
    _segment	segData;	// segment where the Grid data is stored
    _segment	segClip;	// segment where the Clip data is constructed
}
GRID;

typedef GRID GBP PGRID;

#define GRIDDEREF( hctl )   ((PGRID)(VOID *)(SHORT)(LONG)VBControlDeRef(hctl))


//---------------------------------------------------------------------------
// Control Procudure
//---------------------------------------------------------------------------
LONG _export GridCtlProc( HCTL, HWND, USHORT, USHORT, LONG );


//---------------------------------------------------------------------------
// Property info
//---------------------------------------------------------------------------
#ifdef CTL_DATA
PROPINFO CTL_DATA propinfoGridText =
{
    "Text",
    DT_HSZ | PF_fGetMsg | PF_fSetMsg | PF_fNoShow,
    0, 0
};

PROPINFO CTL_DATA propinfoGridRows =
{
    "Rows",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(GRID,Rows), 0
};

PROPINFO CTL_DATA propinfoGridCols =
{
    "Cols",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(GRID,Cols), 0
};

PROPINFO CTL_DATA propinfoGridFixedRows =
{
    "FixedRows",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(GRID,FixedRows), 0
};

PROPINFO CTL_DATA propinfoGridFixedCols =
{
    "FixedCols",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(GRID,FixedCols), 0
};

PROPINFO CTL_DATA propinfoGridRow =
{
    "Row",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fNoShow,
    OFFSETIN(GRID,Row), 0
};

PROPINFO CTL_DATA propinfoGridCol =
{
    "Col",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fNoShow,
    OFFSETIN(GRID,Col), 0
};

CHAR CTL_DATA szScrollbarTypes[] = "0 - None\0"\
				   "1 - Horizontal\0"\
				   "2 - Vertical\0"\
				   "3 - Both\0"\
				   "";
PROPINFO CTL_DATA propinfoGridScrollBars =
{
    "ScrollBars",
    DT_ENUM | PF_fGetMsg | PF_fSetMsg | PF_fSaveData,
    0, 0,
    0,				// 0 - None
    szScrollbarTypes, 3
};

PROPINFO CTL_DATA propinfoGridRowHeight =
{
    "RowHeight",
    DT_LONG | PF_fGetMsg | PF_fSetMsg | PF_fNoShow,
    0, 0
};

PROPINFO CTL_DATA propinfoGridColWidth =
{
    "ColWidth",
    DT_LONG | PF_fGetMsg | PF_fSetMsg | PF_fNoShow,
    0, 0
};

PROPINFO CTL_DATA propinfoGridColAlignment =
{
    "ColAlignment",
    DT_SHORT | PF_fGetMsg | PF_fSetMsg | PF_fNoShow,
    0, 0
};

PROPINFO CTL_DATA propinfoGridCellSelected =
{
    "CellSelected",
    DT_BOOL | PF_fGetMsg | PF_fSetMsg | PF_fNoShow | PF_fNoRuntimeW,
    0, 0
};

PROPINFO CTL_DATA propinfoGridClip =
{
    "Clip",
    DT_HSZ | PF_fGetMsg | PF_fSetMsg,
    0, 0
};

PROPINFO CTL_DATA propinfoGridSelStartRow =
{
    "SelStartRow",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fNoShow,
    OFFSETIN(GRID,SelTopRow), 0
};

PROPINFO CTL_DATA propinfoGridSelEndRow =
{
    "SelEndRow",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fNoShow,
    OFFSETIN(GRID,SelBottomRow), 0
};

PROPINFO CTL_DATA propinfoGridSelStartCol =
{
    "SelStartCol",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fNoShow,
    OFFSETIN(GRID,SelLeftCol), 0
};

PROPINFO CTL_DATA propinfoGridSelEndCol =
{
    "SelEndCol",
    DT_SHORT | PF_fGetData | PF_fSetMsg | PF_fNoShow,
    OFFSETIN(GRID,SelRightCol), 0
};
#endif	// CTL_DATA


//---------------------------------------------------------------------------
// Property list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the properties
//---------------------------------------------------------------------------
#define IPROP_GRID_CTLNAME	0x0000
#define IPROP_GRID_INDEX	0x0001
#define IPROP_GRID_BACKCOLOR	0x0002
#define IPROP_GRID_FORECOLOR	0x0003
#define IPROP_GRID_LEFT 	0x0004
#define IPROP_GRID_TOP		0x0005
#define IPROP_GRID_WIDTH	0x0006
#define IPROP_GRID_HEIGHT	0x0007
#define IPROP_GRID_ENABLED	0x0008
#define IPROP_GRID_VISIBLE	0x0009
#define IPROP_GRID_FONTNAME	0x000A
#define IPROP_GRID_FONTSIZE	0x000B
#define IPROP_GRID_FONTBOLD	0x000C
#define IPROP_GRID_FONTITALIC	0x000D
#define IPROP_GRID_FONTSTRIKE	0x000E
#define IPROP_GRID_FONTUNDER	0x000F
#define IPROP_GRID_TABINDEX	0x0010
#define IPROP_GRID_TABSTOP	0x0011
#define IPROP_GRID_PARENT	0x0012
#define IPROP_GRID_DRAGMODE	0x0013
#define IPROP_GRID_DRAGICON	0x0014
#define IPROP_GRID_TAG		0x0015
#define IPROP_GRID_TEXT 	0x0016
#define IPROP_GRID_ROWS 	0x0017
#define IPROP_GRID_COLS 	0x0018
#define IPROP_GRID_FIXEDROWS	0x0019
#define IPROP_GRID_FIXEDCOLS	0x001A
#define IPROP_GRID_ROW		0x001B
#define IPROP_GRID_COL		0x001C
#define IPROP_GRID_SCROLLBARS	0x001D
#define IPROP_GRID_ROWHEIGHT	0x001E
#define IPROP_GRID_COLWIDTH	0x001F
#define IPROP_GRID_COLALIGN	0x0020
#define IPROP_GRID_CELLSEL	0x0021
#define IPROP_GRID_CLIP 	0x0022
#define IPROP_GRID_SELSTARTROW	0x0023
#define IPROP_GRID_SELENDROW	0x0024
#define IPROP_GRID_SELSTARTCOL	0x0025
#define IPROP_GRID_SELENDCOL	0x0026

#ifdef CTL_DATA
PPROPINFO CTL_DATA proplistGrid[] =
{
    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_BACKCOLOR,
    PPROPINFO_STD_FORECOLOR,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_ENABLED,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_FONTNAME,
    PPROPINFO_STD_FONTSIZE,
    PPROPINFO_STD_FONTBOLD,
    PPROPINFO_STD_FONTITALIC,
    PPROPINFO_STD_FONTSTRIKE,
    PPROPINFO_STD_FONTUNDER,
    PPROPINFO_STD_TABINDEX,
    PPROPINFO_STD_TABSTOP,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_DRAGMODE,
    PPROPINFO_STD_DRAGICON,
    PPROPINFO_STD_TAG,
    &propinfoGridText,
    &propinfoGridRows,
    &propinfoGridCols,
    &propinfoGridFixedRows,
    &propinfoGridFixedCols,
    &propinfoGridRow,
    &propinfoGridCol,
    &propinfoGridScrollBars,
    &propinfoGridRowHeight,
    &propinfoGridColWidth,
    &propinfoGridColAlignment,
    &propinfoGridCellSelected,
    &propinfoGridClip,
    &propinfoGridSelStartRow,
    &propinfoGridSelEndRow,
    &propinfoGridSelStartCol,
    &propinfoGridSelEndCol,
    NULL
};
#endif	// CTL_DATA


//---------------------------------------------------------------------------
// Event procedure parameter prototypes
//---------------------------------------------------------------------------
#ifdef CTL_DATA
EVENTINFO CTL_DATA eventinfoClick =
{
    "Click",
    0,
    0,
    NULL,
    NULL
};

EVENTINFO CTL_DATA eventinfoDblClick =
{
    "DblClick",
    0,
    0,
    NULL,
    NULL
};

EVENTINFO CTL_DATA eventinfoSelChange =
{
    "SelChange",
    0,
    0,
    NULL,
    NULL
};
#endif	// CTL_DATA


//---------------------------------------------------------------------------
// Event list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the events
//---------------------------------------------------------------------------
#define EVENT_GRID_CLICK	0
#define EVENT_GRID_DBLCLICK	1
#define EVENT_GRID_DRAGDROP	2
#define EVENT_GRID_DRAGOVER	3
#define EVENT_GRID_GOTFOCUS	4
#define EVENT_GRID_KEYDOWN	5
#define EVENT_GRID_KEYPRESS	6
#define EVENT_GRID_KEYUP	7
#define EVENT_GRID_LOSTFOCUS	8
#define EVENT_GRID_SELCHANGE	9

#ifdef CTL_DATA
PEVENTINFO CTL_DATA eventlistGrid[] =
{
    &eventinfoClick,
    &eventinfoDblClick,
    PEVENTINFO_STD_DRAGDROP,
    PEVENTINFO_STD_DRAGOVER,
    PEVENTINFO_STD_GOTFOCUS,
    PEVENTINFO_STD_KEYDOWN,
    PEVENTINFO_STD_KEYPRESS,
    PEVENTINFO_STD_KEYUP,
    PEVENTINFO_STD_LOSTFOCUS,
    &eventinfoSelChange,
    NULL
};
#endif	// CTL_DATA


//---------------------------------------------------------------------------
// Model struct
//---------------------------------------------------------------------------
// Define the control model (using the event and property structures).
//---------------------------------------------------------------------------
#ifdef CTL_DATA
MODEL CTL_DATA modelGrid =
{
    VB_VERSION, 			// VB version being used
    MODEL_fFocusOk | MODEL_fWantArrows, // MODEL flags
    (PCTLPROC)GridCtlProc,		// Control procedure
    CS_VREDRAW | CS_HREDRAW		// Class style
	       | CS_DBLCLKS,
    WS_CHILD | WS_VSCROLL | WS_HSCROLL	// Default Window style
	     | WS_BORDER,
    sizeof(GRID),			// cbCtlExtra for GRID structure
    IDBMP_GRID, 			// Palette bitmap ID
    "Grid",				// Default control name
    "Grid",				// Visual Basic class name
    NULL,				// Parent class name
    proplistGrid,			// Properties list
    eventlistGrid			// Events list
};
#endif	// CTL_DATA

#endif	// RC_INVOKED

//---------------------------------------------------------------------------
