//---------------------------------------------------------------------------
// ccInit.c
//---------------------------------------------------------------------------
// Custom Control DLL Initialization
//---------------------------------------------------------------------------

#define NOCOMM

#include <windows.h>

#define CTL_DATA	// cause the control structures to be declared

#include "vbapi.h"
#include "grid.h"

HANDLE	hmodDLL;

//---------------------------------------------------------------------------
// Register custom control.
//	This routine is called by VB when the custom control DLL is
//	loaded for use.
//---------------------------------------------------------------------------

BOOL FAR PASCAL _export VBINITCC
(
    USHORT usVersion,
    BOOL fRuntime
)
{
    // avoid warnings on unused (but required) formal parameters

    fRuntime = fRuntime;
    usVersion = usVersion;

    // Register control(s)

    if (!VBRegisterModel(hmodDLL, &modelGrid))
	return FALSE;

    return TRUE;
}

//---------------------------------------------------------------------------
// Initialize library.
//	This routine is called from the DLL entry point in LIBINIT.ASM
//	which is called when the first client loads the DLL.
//---------------------------------------------------------------------------

BOOL FAR LibMain
(
    HANDLE	hmod,
    HANDLE	segDS,
    USHORT	cbHeapSize
)
{
    // avoid warnings on unused (but required) formal parameters

    cbHeapSize = cbHeapSize;
    segDS = segDS;

    hmodDLL = hmod;

    hcurHSep  = LoadCursor(hmodDLL, MAKEINTRESOURCE(IDCUR_HSEP));
    hcurVSep  = LoadCursor(hmodDLL, MAKEINTRESOURCE(IDCUR_VSEP));
    hcurArrow = LoadCursor(NULL, IDC_ARROW);

    // Leave our DS unlocked when we're not running

    UnlockData( 0 );

    return TRUE;
}

//---------------------------------------------------------------------------
// Handle exit notification from Windows
//	This routine is called by Windows when the library is freed
//	by its last client.
//---------------------------------------------------------------------------

VOID FAR _export WEP
(
    BOOL	fSystemExit
)
{
    // avoid warnings on unused (but required) formal parameters

    fSystemExit = fSystemExit;
}

//---------------------------------------------------------------------------
