'----------------------------------------------------------------
'Copyright 1994   Unger Business Systems  All Rights Reserved
'This code is distributed as shareware.  If you use it, you
'are required by law to register it.  Please contact Unger
'Business Systems at 11926 Barrett Brae, Houston, TX 77072-4004
'or call (713) 498-8517.  Registration fee is $20.00 US
'See the README.TXT file for more information
'
'All code, forms, modules, controls, etc. are provided without
'warranty or liability
'----------------------------------------------------------------

Option Explicit
   
Global CRLF$

Dim di%, lf As LOGFONT, lp As LOGPEN
Dim dev$, DevName$, DevOutput$, DeviceDriver$
Dim dm As DEVMODE, dmout As DEVMODE
Dim libhnd%
Dim bufsize%
Dim dminstring$, dmoutstring$
Dim dminaddr&, dmoutaddr&
Dim dinfo As DOCINFO
Dim docname$, CurrX%, CurrY%
Dim oldcursor%, CurrentFont%, oldfont%, Oldpen%
Dim lpRect As RECT
Global GenPaperWidth#, GenPaperLength#, GenPaperSize%
Global AbortPrinting%
Global DoShowDevMode%, DoShowDevCaps%
Global DoShowPaperSize%

Global Const MaxLinesArray = 30
Global LinesArray(MaxLinesArray)  As String
Global RemainStr$

Global NumberOfLines%

Const DefPtSize = 10

Global CurrentPen%

Global PrtXRes%, PrtYRes%, FontIsBold%, OriginalFontWeight%

Global Const DT_TOP = &H0
Global Const DT_LEFT = &H0
Global Const DT_CENTER = &H1
Global Const DT_RIGHT = &H2
Global Const DT_VCENTER = &H4
Global Const DT_BOTTOM = &H8
Global Const DT_WORDBREAK = &H10
Global Const DT_SINGLELINE = &H20
Global Const DT_EXPANDTABS = &H40
Global Const DT_TABSTOP = &H80
Global Const DT_NOCLIP = &H100
Global Const DT_EXTERNALLEADING = &H200
Global Const DT_CALCRECT = &H400
Global Const DT_NOPREFIX = &H800
Global Const DT_INTERNAL = &H1000
Global Const SYSTEM_FONT = 13

' color enable/disable for color printers
Global Const DMCOLOR_MONOCHROME = 1
Global Const DMCOLOR_COLOR = 2

' paper selections
' Warning: The PostScript driver mistakingly uses DMPAPER_ values between
' 50 and 56.  Don't use this range when defining new paper sizes.

Global Const DMPAPER_LETTER = 1         'Letter 8 1/2 x 11 in
Global Const DMPAPER_LETTERSMALL = 2    'Letter Small 8 1/2 x 11 in
Global Const DMPAPER_TABLOID = 3        'Tabloid 11 x 17 in
Global Const DMPAPER_LEDGER = 4         'Ledger 17 x 11 in
Global Const DMPAPER_LEGAL = 5          'Legal 8 1/2 x 14 in
Global Const DMPAPER_STATEMENT = 6      'Statement 5 1/2 x 8 1/2 in
Global Const DMPAPER_EXECUTIVE = 7     'Executive 7 1/4 x 10 1/2 in
Global Const DMPAPER_A3 = 8             'A3 297 x 420 mm
Global Const DMPAPER_A4 = 9             'A4 210 x 297 mm
Global Const DMPAPER_A4SMALL = 10       'A4 Small 210 x 297 mm
Global Const DMPAPER_A5 = 11            'A5 148 x 210 mm
Global Const DMPAPER_B4 = 12            'B4 250 x 354
Global Const DMPAPER_B5 = 13            'B5 182 x 257 mm
Global Const DMPAPER_FOLIO = 14         'Folio 8 1/2 x 13 in
Global Const DMPAPER_QUARTO = 15        'Quarto 215 x 275 mm
Global Const DMPAPER_10X14 = 16         '10x14 in
Global Const DMPAPER_11X17 = 17         '11x17 in
Global Const DMPAPER_NOTE = 18          'Note 8 1/2 x 11 in
Global Const DMPAPER_ENV_9 = 19         'Envelope #9 3 7/8 x 8 7/8
Global Const DMPAPER_ENV_10 = 20        'Envelope #10 4 1/8 x 9 1/2
Global Const DMPAPER_ENV_11 = 21        'Envelope #11 4 1/2 x 10 3/8
Global Const DMPAPER_ENV_12 = 22        'Envelope #12 4 \276 x 11
Global Const DMPAPER_ENV_14 = 23        'Envelope #14 5 x 11 1/2
Global Const DMPAPER_CSHEET = 24        'C size sheet
Global Const DMPAPER_DSHEET = 25        'D size sheet
Global Const DMPAPER_ESHEET = 26        'E size sheet
Global Const DMPAPER_ENV_DL = 27        'Envelope DL 110 x 220mm
Global Const DMPAPER_ENV_C5 = 28        'Envelope C5 162 x 229 mm
Global Const DMPAPER_ENV_C3 = 29        'Envelope C3  324 x 458 mm
Global Const DMPAPER_ENV_C4 = 30        'Envelope C4  229 x 324 mm
Global Const DMPAPER_ENV_C6 = 31        'Envelope C6  114 x 162 mm
Global Const DMPAPER_ENV_C65 = 32       'Envelope C65 114 x 229 mm
Global Const DMPAPER_ENV_B4 = 33        'Envelope B4  250 x 353 mm
Global Const DMPAPER_ENV_B5 = 34        'Envelope B5  176 x 250 mm
Global Const DMPAPER_ENV_B6 = 35        'Envelope B6  176 x 125 mm
Global Const DMPAPER_ENV_ITALY = 36     'Envelope 110 x 230 mm
Global Const DMPAPER_ENV_MONARCH = 37   'Envelope Monarch 3.875 x 7.5 in
Global Const DMPAPER_ENV_PERSONAL = 38  '6 3/4 Envelope 3 5/8 x 6 1/2 in
Global Const DMPAPER_FANFOLD_US = 39    'US Std Fanfold 14 7/8 x 11 in
Global Const DMPAPER_FANFOLD_STD_GERMAN = 40  'German Std Fanfold 8 1/2 x 12 in
Global Const DMPAPER_FANFOLD_LGL_GERMAN = 41  'German Legal Fanfold 8 1/2 x 13 in

Global Const DMPAPER_USER = 256

' printer bin selections
Global Const DMBIN_UPPER = 1
Global Const DMBIN_ONLYONE = 1
Global Const DMBIN_LOWER = 2
Global Const DMBIN_MIDDLE = 3
Global Const DMBIN_MANUAL = 4
Global Const DMBIN_ENVELOPE = 5
Global Const DMBIN_ENVMANUAL = 6
Global Const DMBIN_AUTO = 7
Global Const DMBIN_TRACTOR = 8
Global Const DMBIN_SMALLFMT = 9
Global Const DMBIN_LARGEFMT = 10
Global Const DMBIN_LARGECAPACITY = 11
Global Const DMBIN_CASSETTE = 14

Global Const DMBIN_USER = 256  'device specific bins start here

' print qualities
Global Const DMRES_DRAFT = -1
Global Const DMRES_LOW = -2
Global Const DMRES_MEDIUM = -3
Global Const DMRES_HIGH = -4

' Printer duplex enable
Global Const DMDUP_SIMPLEX = 1
Global Const DMDUP_VERTICAL = 2
Global Const DMDUP_HORIZONTAL = 3

' TrueType options
Global Const DMTT_BITMAP = 1    'print TT fonts as graphics
Global Const DMTT_DOWNLOAD = 2  'download TT fonts as soft fonts
Global Const DMTT_SUBDEV = 3    'substitute device fonts for TT fonts

'  Pen Styles
Global Const PS_SOLID = 0
Global Const PS_DASH = 1        '  -------
Global Const PS_DOT = 2 '  .......
Global Const PS_DASHDOT = 3     '  _._._._
Global Const PS_DASHDOTDOT = 4  '  _.._.._
Global Const PS_NULL = 5
Global Const PS_INSIDEFRAME = 6

Global Const TMPF_FIXED_PITCH = 1
Global Const TMPF_VECTOR = 2
Global Const TMPF_DEVICE = 8
Global Const TMPF_TRUETYPE = 4

Global Const DM_IN_BUFFER = 8
Global Const DM_IN_PROMPT = 4
Global Const DM_OUT_BUFFER = 2
Global Const DMORIENT_PORTRAIT = 1
Global Const DMORIENT_LANDSCAPE = 2
Global Const SP_OUTOFDISK = (-4)

' field selection bits
Global Const DM_ORIENTATION = &H1&
Global Const DM_PAPERSIZE = &H2&
Global Const DM_PAPERLENGTH = &H4&
Global Const DM_PAPERWIDTH = &H8&
Global Const DM_SCALE = &H10&
Global Const DM_COPIES = &H100&
Global Const DM_DEFAULTSOURCE = &H200&
Global Const DM_PRINTQUALITY = &H400&
Global Const DM_COLOR = &H800&
Global Const DM_DUPLEX = &H1000&
Global Const DM_YRESOLUTION = &H2000&
Global Const DM_TTOPTION = &H4000&

' device capabilities indices
Global Const DC_FIELDS = 1
Global Const DC_PAPERS = 2
Global Const DC_PAPERSIZE = 3
Global Const DC_MINEXTENT = 4
Global Const DC_MAXEXTENT = 5
Global Const DC_BINS = 6
Global Const DC_DUPLEX = 7
Global Const DC_SIZE = 8
Global Const DC_EXTRA = 9
Global Const DC_VERSION = 10
Global Const DC_DRIVER = 11
Global Const DC_BINNAMES = 12
Global Const DC_ENUMRESOLUTIONS = 13
Global Const DC_FILEDEPENDENCIES = 14
Global Const DC_TRUETYPE = 15
Global Const DC_PAPERNAMES = 16
Global Const DC_ORIENTATION = 17
Global Const DC_COPIES = 18

' DC_TRUETYPE bit fields
Global Const DCTT_BITMAP = &H1&
Global Const DCTT_DOWNLOAD = &H2&
Global Const DCTT_SUBDEV = &H4&

Global Const PD_RETURNDC = &H100&

Declare Function GetTextExtentPoint% Lib "GDI" (ByVal hDC%, ByVal lpszString$, ByVal cbString%, lpSize As SIZEAPI)
Declare Function GetStockObject% Lib "GDI" (ByVal nIndex%)
Declare Function SelectObject% Lib "GDI" (ByVal hDC%, ByVal hObject%)
Declare Function GetObject2% Lib "GDI" Alias "GetObject" (ByVal hObject%, ByVal nCount%, ByVal lpObject&)
Declare Function CreateFontIndirect% Lib "GDI" (lpLogFont As LOGFONT)
Declare Function DeleteObject% Lib "GDI" (ByVal hObject%)
Declare Function MoveTo& Lib "GDI" (ByVal hDC%, ByVal x%, ByVal y%)
Declare Function LineTo% Lib "GDI" (ByVal hDC%, ByVal x%, ByVal y%)
Declare Function Rectangle% Lib "GDI" (ByVal hDC%, ByVal X1%, ByVal Y1%, ByVal X2%, ByVal Y2%)
Declare Function EndPage% Lib "GDI" (ByVal hDC%)
Declare Function EndDocAPI% Lib "GDI" Alias "EndDoc" (ByVal hDC%)
Declare Function DeleteDC% Lib "GDI" (ByVal hDC%)
Declare Function DrawText% Lib "User" (ByVal hDC%, ByVal lpStr$, ByVal nCount%, lpRect As RECT, ByVal wFormat%)
Declare Function SetAbortProc% Lib "GDI" (ByVal hDC%, ByVal abrtprc&)
Declare Function CreatePen% Lib "GDI" (ByVal nPenStyle%, ByVal nWidth%, ByVal crColor&)
Declare Function GetTextMetrics% Lib "GDI" (ByVal hDC%, lpMetrics As TEXTMETRIC)
Declare Function GetTextFace% Lib "GDI" (ByVal hDC%, ByVal nCount%, ByVal lpFacename$)
Declare Function StartPage% Lib "GDI" (ByVal hDC%)
Declare Function StartDoc% Lib "GDI" (ByVal hDC%, lpdi As DOCINFO)
Declare Function LoadLibrary% Lib "Kernel" (ByVal lpLibFileName$)
Declare Function CreateDC% Lib "GDI" (ByVal lpDriverName$, ByVal lpDeviceName$, ByVal lpOutput$, ByVal lpInitData&)
Declare Function SetSysModalWindow% Lib "User" (ByVal hWnd%)

Function ClipString$ (ByVal prhdc%, ByVal TString$, ByVal MaxLength#)
   'returns maximum number of characters from TString which will
   'fit in a space which is MaxLength inches wide
   'uses current font to determine text size

   Dim TLen#, I%, TStr$
	    
   I = 0
   Do While 1
      I = I + 1
      If I > Len(TString) Then
	 ClipString = TString
	 Exit Do
      End If
      TStr = Left$(TString, I)
      TLen = GetTextWidth(prhdc, TStr) / PrtYRes
      If TLen > MaxLength Then
	 ClipString = Left$(TString, I - 1)
	 Exit Do
      End If
   Loop
End Function

Sub DefaultFontSetup (ByVal prhdc%)
   'called by GenPrinterSetup

   Dim di%, CurrLogFont%, Result%

   'temporarily select in a stock font to return current logical font
   CurrLogFont = SelectObject%(GeneralPrinter.hDC, GetStockObject(SYSTEM_FONT))
   DoEvents

   'stuff info on current logical font into lf (LOGFONT structure)
   di% = GetObject2%(CurrLogFont%, 50, agGetAddressForObject&(lf))
   DoEvents
   
   'restore the current logical font
   di% = SelectObject%(GeneralPrinter.hDC, CurrLogFont)
   DoEvents

   'set font to Arial with default pt size and weight
   lf.lfFaceName = "Arial"
   lf.lfHeight = -(DefPtSize / 72) * PrtYRes
   lf.lfWidth = .45 * lf.lfHeight
   lf.lfWeight = 400

   'create "OldFont" from current lf
   oldfont = CreateFontIndirect(lf)
   DoEvents
   
   'select "OldFont" into printer
   di = SelectObject(prhdc, oldfont)
   DoEvents
   'delete previously existing font
   If di <> 0 Then Result = DeleteObject(di)
   DoEvents
End Sub

Sub DrawLine (ByVal prhdc%, ByVal X1!, ByVal Y1!, ByVal X2!, ByVal Y2!)
   'draws a line from X1,Y1 to X2,Y2  (in inches)
   Dim di%, dl&

   dl = MoveTo(prhdc, X1 * PrtXRes, Y1 * PrtYRes)

   di = LineTo(prhdc, X2 * PrtXRes, Y2 * PrtYRes)
   If di = 0 Then
      MsgBox "Error occurred in LineTo call in DrawLine." & CRLF & "This should not happen."
   End If
End Sub

Sub DrawRectangle (ByVal prhdc%, ByVal X1!, ByVal Y1!, ByVal X2!, ByVal Y2!)
   'draws a rectangle with corners at X1,Y1 and X2,Y2 (in inches)
   
   Dim di%

   di = Rectangle(prhdc, X1 * PrtXRes, Y1 * PrtYRes, X2 * PrtXRes, Y2 * PrtYRes)
End Sub

Function EndAPage% (ByVal prhdc%)
    ' The system will spend a long time in the EndPage
    ' function, but it will periodically call the Abort
    ' procedure which in turn triggers the Callback1
    ' AbortProc event.
    EndAPage = EndPage(prhdc%)
End Function

Function EndDocument% (ByVal prhdc%)
   'called at the end of the print job

    EndDocument = EndDocAPI(prhdc%)
End Function

Sub GenPrinterClose (ByVal prhdc%)
   'cleans up printer

    If prhdc% <> 0 Then di% = DeleteDC%(prhdc%)
    If libhnd% <> 0 Then FreeLibrary libhnd%
End Sub

Function GenPrinterSetup% (ByVal TPrinterStr$, ByVal TOrientationStr$)
   'This routine accepts a printer string and returns a device context

   Dim TStr$, CleanupStr$
   Dim prhdc%  ' handle to printer device context

   GenPrinterSetup = 0   'if fails
   dev$ = TPrinterStr
   If dev$ = "" Then Exit Function
   'strip out name, output, and driver
   DevName$ = GetDeviceName$(dev$)
   DevOutput$ = GetDeviceOutput$(dev$)
   DeviceDriver$ = GetDeviceDriver$(dev$)
   DoEvents

   ' Load the device driver library - exit if unavailable
   libhnd% = LoadLibrary(DeviceDriver & ".drv")
   DoEvents
   CleanupStr = "Unable to load library: " & DeviceDriver & ".drv"
   If libhnd% = 0 Then GoTo SetupCleanup

   'Find out how big the DEVMODE structure is for this printer
   bufsize% = agExtDeviceMode%(GeneralPrinter.hWnd, libhnd%, 0, DevName$, DevOutput$, agGetAddressForObject(dm), 0, 0)
   DoEvents
   'Allocate two buffers of that size and get pointers to them
   dminstring$ = String$(bufsize%, 0)
   dmoutstring$ = String$(bufsize%, 0)
   dminaddr& = agGetAddressForVBString&(dminstring$)
   dmoutaddr& = agGetAddressForVBString&(dmoutstring$)
   
   'Copy DEVMODE info into dmoutstring
   di% = agExtDeviceMode(GeneralPrinter.hWnd, libhnd%, dmoutaddr&, DevName$, DevOutput$, dminaddr&, 0, DM_OUT_BUFFER)
   If di <> IDOK Then
      Beep
      MsgBox "Error returned by agExtDeviceMode: " & Str(di) & CRLF & "Printer not initialized.", MB_ICONSTOP
      GoTo SetupCleanup
   End If
   DoEvents

   'Copy the data buffer (dmoutstring) into the DEVMODE structure
   dmoutaddr& = agGetAddressForVBString&(dmoutstring$)
   agCopyDataBynum dmoutaddr&, agGetAddressForObject&(dm), 68
   DoEvents

   If DoShowDevMode Then ShowDevMode "Direct From Driver", dm
   If DoShowDevCaps Then ShowDeviceCapabilities libhnd, DevName, DevOutput
   ' Set the orientation, and set the dmField flag so that
   ' the function will know that it is valid.
   If TOrientationStr = "LANDSCAPE" Then
      dm.dmOrientation = DMORIENT_LANDSCAPE
   Else
      dm.dmOrientation = DMORIENT_PORTRAIT
   End If
   dm.dmFields = dm.dmFields Or DM_ORIENTATION
   dm.dmDriverExtra = 0   'required for PostScript printers
   If DoShowDevMode Then ShowDevMode "After Changes", dm

   'create new DevMode with any changes we made
   agCopyDataBynum agGetAddressForObject&(dm), agGetAddressForVBString&(dminstring$), 68
   dminaddr& = agGetAddressForVBString&(dminstring$)
   dmoutaddr& = agGetAddressForVBString&(dmoutstring$)
   di% = agExtDeviceMode(GeneralPrinter.hWnd, libhnd%, dmoutaddr&, DevName$, DevOutput$, dminaddr&, 0, DM_IN_BUFFER Or DM_OUT_BUFFER)
   If di <> IDOK Then
      Beep
      MsgBox "Error returned by agExtDeviceMode: " & Str(di) & CRLF & "Printer not initialized.", MB_ICONSTOP
      GoTo SetupCleanup
   End If
   DoEvents
   agCopyDataBynum agGetAddressForVBString&(dmoutstring$), agGetAddressForObject&(dmout), 68
   If DoShowDevMode Then ShowDevMode "From Driver After Changes", dmout

   'Now create a DC (device context) to the  printer
   prhdc = CreateDC%(DeviceDriver, DevName$, DevOutput$, agGetAddressForObject&(dmout))
   DoEvents
   CleanupStr = "Unable to create device context: " & CRLF & DeviceDriver & ".drv" & CRLF & DevName & CRLF & DevOutput
   If prhdc% = 0 Then GoTo SetupCleanup
   'ShowPrinterMetrics dmout
   If dmout.dmPrintQuality > 0 Then
      PrtXRes = dmout.dmPrintQuality
      If dmout.dmYResolution > 0 Then
	 PrtYRes = dmout.dmYResolution
      Else
	 PrtYRes = PrtXRes
      End If
   Else
      PrtXRes = 300 'assume laser
      PrtYRes = 300
   End If
   If PrtXRes <> 300 Then
      TStr = "Printer X Resolution = " & Format(PrtXRes, "###0") & ", not 300!"
      MsgBox TStr
   End If
   GenPaperSize = dmout.dmPaperSize
   If GenPaperSize = 0 Then
      GenPaperWidth = (dmout.dmPaperWidth / 100) / 2.54     'inches
      GenPaperLength = (dmout.dmPaperLength / 100) / 2.54   'inches
   Else
      Select Case GenPaperSize
	 Case DMPAPER_LETTER: GenPaperWidth = 8.5
	 Case DMPAPER_LEGAL: GenPaperWidth = 8.5
	 Case DMPAPER_TABLOID: GenPaperWidth = 11#
	 Case DMPAPER_LEDGER: GenPaperWidth = 17#
	 Case Else: GenPaperWidth = 8.5   'default
      End Select
      Select Case GenPaperSize
	 Case DMPAPER_LETTER: GenPaperLength = 11#
	 Case DMPAPER_LEGAL: GenPaperLength = 14#
	 Case DMPAPER_TABLOID: GenPaperLength = 17#
	 Case DMPAPER_LEDGER: GenPaperLength = 11#
	 Case Else: GenPaperLength = 11#    'default
      End Select
   End If
   If DoShowPaperSize Then MsgBox "Paper size is " & Str(GenPaperWidth) & " by " & Str(GenPaperLength) & CRLF & "dmout.dmPaperSize = " & Str$(dmout.dmPaperSize) & CRLF & "dmout.dmPaperWidth = " & Str$(dmout.dmPaperWidth) & CRLF & "dmout.dmPaperLength = " & Str(dmout.dmPaperLength)
   
   DefaultFontSetup prhdc
   GenPrinterSetup = prhdc
   DoEvents
   SetTextX 0
   SetTextY 0
   Exit Function

SetupCleanup:
   DoEvents
   Beep
   MsgBox CleanupStr, MB_ICONSTOP
   If prhdc% <> 0 Then di% = DeleteDC%(prhdc%)
   If libhnd% <> 0 Then FreeLibrary libhnd%
   Exit Function

End Function

Function GetDeviceDriver$ (ByVal dev$)
'
'   This function returns the driver module name
'   D. Appleman
'
   Dim FirstPos%, NextPos%
   FirstPos% = InStr(dev$, ",")
   NextPos% = InStr(FirstPos% + 1, dev$, ",")
   If NextPos > 0 Then
      GetDeviceDriver$ = Mid$(dev$, FirstPos% + 1, NextPos% - FirstPos% - 1)
   Else
      GetDeviceDriver = ""
   End If
End Function

Function GetDeviceName$ (ByVal dev$)
'
'   Retrieves the name portion of a device string
'   D. Appleman
'
    Dim npos%
    npos% = InStr(dev$, ",")
    If npos > 0 Then
       GetDeviceName$ = Left$(dev$, npos% - 1)
    Else
       GetDeviceName = ""
    End If
End Function

Function GetDeviceOutput$ (ByVal dev$)
'
'   Returns the output destination for the specified device
'   D. Appleman
'
    Dim FirstPos%, NextPos%
    FirstPos% = InStr(dev$, ",")
    NextPos% = InStr(FirstPos% + 1, dev$, ",")
    If NextPos > 0 Then
       GetDeviceOutput = Mid$(dev$, NextPos% + 1)
    Else
       GetDeviceOutput = ""
    End If
End Function

Function GetNumberedDeviceOutput (ByVal TDevOutput$, ByVal Num%)
'returns Numth output destination from string returned by
'GetDeviceOutput
   Dim FirstPos%, NextPos%, Count%, TStr$

   FirstPos = InStr(1, TDevOutput, ",")
   If FirstPos = 0 Then
      GetNumberedDeviceOutput = TDevOutput
      Exit Function
   End If
   Count = 1
   FirstPos = 0
   Do While 1
      NextPos = InStr(FirstPos + 1, TDevOutput, ",")
      If Count = Num Then
	 If NextPos = 0 Then
	    TStr = Right$(TDevOutput, Len(TDevOutput) - FirstPos)
	 Else
	    TStr = Mid$(TDevOutput, FirstPos + 1, NextPos - FirstPos - 1)
	 End If
	 GetNumberedDeviceOutput = TStr
	 Exit Function
      ElseIf NextPos = 0 Then
	 GetNumberedDeviceOutput = ""
	 'this should not occur
	 Exit Function
      Else
	 Count = Count + 1
	 FirstPos = NextPos
      End If
   Loop
End Function

Function GetNumDeviceOutputs% (ByVal TDevOutput)
'Takes output from GetDeviceOutput and returns number of
'output devices
'(GetDeviceOutput returns output destinations separated by
'commas if more than one)

   Dim FirstPos%, NextPos%, Count%

   FirstPos = InStr(1, TDevOutput, ",")
   If FirstPos = 0 Then
      GetNumDeviceOutputs = 1
      Exit Function
   End If
   Count = 2
   Do While 1
      NextPos = InStr(FirstPos + 1, TDevOutput, ",")
      If NextPos = 0 Then Exit Do
      Count = Count + 1
      FirstPos = NextPos
   Loop
   GetNumDeviceOutputs = Count
End Function

Function GetOnlyFontName$ (ByVal LongFontName$)
    'returns only part of font name before first BOLD,
    'ITALIC, or (

    Dim TStr$, Pos%, UTStr$

    TStr = LongFontName
    UTStr = UCase$(LongFontName)
    
    Pos = InStr(1, UTStr, "BOLD")
    If Pos > 0 Then
       TStr = Trim$(Left$(LongFontName, Pos - 1))
       GetOnlyFontName = TStr
       Exit Function
    End If

    Pos = InStr(1, UTStr, "ITALIC")
    If Pos > 0 Then
       TStr = Trim$(Left$(LongFontName, Pos - 1))
       GetOnlyFontName = TStr
       Exit Function
    End If

    Pos = InStr(1, LongFontName, "(")
    If Pos > 0 Then TStr = Trim$(Left$(LongFontName, Pos - 1))
    GetOnlyFontName = TStr
End Function

Function GetTextHeight (ByVal prhdc%, ByVal TString$)
   'returns text height in logical units of device context prhdc

   Dim Result%, TPoint As SIZEAPI

   Result = GetTextExtentPoint(prhdc, TString, Len(TString), TPoint)
   If Result = False Then
      GetTextHeight = -1
      Exit Function
   End If
   GetTextHeight = TPoint.y
End Function

Function GetTextWidth (ByVal prhdc%, ByVal TString$)
   'returns text width in logical units of device context prhdc

   Dim Result%, TPoint As SIZEAPI

   Result = GetTextExtentPoint(prhdc, TString, Len(TString), TPoint)
   If Result = False Then
      GetTextWidth = -1
      Exit Function
   End If
   GetTextWidth = TPoint.x
End Function

Function GetWindowsDefaultPrinter ()
   Dim I%, DefPrinter$

   DefPrinter = Space$(255)
   I% = GetProfileString("WINDOWS", "device", "", DefPrinter, Len(DefPrinter))
   GetWindowsDefaultPrinter = Left$(DefPrinter, I)
End Function

Function GetWindowsPrinterOrientation$ (TPrinterStr$)
    'NOTE:  This routine may not work for every printer driver.
    'It depends on whether it follows the standard convention in
    'storing its state in WIN.INI

    'returns "PORTRAIT" or "LANDSCAPE"
    Dim I%, PrtOrient$, TStr$, OrntStr$

    PrtOrient = Space$(255)
    TStr = GetDeviceName(TPrinterStr) & "," & GetDeviceOutput(TPrinterStr)
    If Mid$(TStr, Len(TStr)) = ":" Then TStr = Left$(TStr, Len(TStr) - 1)  'strip :
    I% = GetProfileString(TStr, "Orientation", "1", PrtOrient, Len(PrtOrient))
    OrntStr = Left$(PrtOrient, I)
    If OrntStr = "1" Then
	GetWindowsPrinterOrientation = "PORTRAIT"
    Else
	GetWindowsPrinterOrientation = "LANDSCAPE"
    End If
End Function

Function HiWord% (ByVal TVal&)
   'used in ShowDeviceCapabilities
   Const SignBit = &H80000000
   
   Dim SignWasSet As Integer
   Dim TLong&

   SignWasSet = ((TVal And SignBit) <> 0&)
   TLong = TVal And (Not SignBit)                  ' chop off sign so we can shift by dividing
   TLong = (TLong \ &H10000) And &HFFFF&           ' Make sure this says (TVal \ &H10000) And &HFFFF& (needs to be long)
   If SignWasSet Then TLong = TLong Or &H8000&
   If TLong >= &H8000& Then TLong = TLong - &H10000' make sure it's in range acceptable to signed integer
   HiWord = TLong
End Function

Sub LineFeed (ByVal prhdc%)
   'moves print point down by height of current font and
   'to left margin

   lpRect.top = lpRect.top + GetTextHeight(prhdc, "S")   'any letter
   lpRect.bottom = lpRect.top + 11 * PrtYRes
   lpRect.left = 0
End Sub

Function LoWord% (ByVal TVal&)
   'used in ShowDeviceCapabilties
   Dim TLong&

   TLong = (TVal And &HFFFF&)  'Make sure this says TVal And &HFFFF& (needs to be long)
   If TLong > &H3FFF& Then TLong = TLong - &H10000
   LoWord = TLong
End Function

Sub PrintText (ByVal prhdc%, ByVal TString$)
   'prints TString at current print point in current font

   di = DrawText(prhdc, TString, Len(TString), lpRect, DT_LEFT)
End Sub

Sub PrintTextCenter (ByVal prhdc%, ByVal TString$, ByVal LeftMargin!, ByVal RightMargin!)
   'centers text on page

   Dim TWidth!, TPos!

   TWidth = GetTextWidth(prhdc, TString) / PrtYRes
   TPos = ((GenPaperWidth - .3 - LeftMargin - RightMargin) - TWidth) / 2
   SetTextX TPos
   di = DrawText(prhdc, TString, Len(TString), lpRect, DT_LEFT)
End Sub

Sub SelectPrinter (ThisPrinter$, ThisOrientation$, TCaption$)
   'this is a routine which encapsulates the functions of
   'the PrtSetupForm
   Dim OldPrinter$, OldOrientation$

   OldPrinter = ThisPrinter
   OldOrientation = ThisOrientation
   Load PrtSetupForm
   PrtSetupForm.Caption = TCaption
   PrtSetupForm!Frame1.Visible = True
   PrtSetupForm!cmdSetup.Visible = False
   PrtSetupForm!txtTempPrinter = GetDeviceName(ThisPrinter) & " on " & GetDeviceOutput(ThisPrinter)
   PrtSetupForm!txtTempOrientation = ThisOrientation
   PrtSetupForm.Show 1 'modal
   If PrtSetupForm!txtTempPrinter = "" Then
      ThisPrinter = OldPrinter
      ThisOrientation = OldOrientation
   Else
      ThisPrinter = PrtSetupForm!txtTempPrinter
      ThisOrientation = PrtSetupForm!txtTempOrientation
   End If
   Unload PrtSetupForm
End Sub

Sub SetAbortCallback (ByVal prhdc%)
   Dim di%
    AbortPrinting% = False
    di% = SetAbortProc(prhdc%, GeneralPrinter!Callback1.ProcAddress)
End Sub

Sub SetPrtFontBold (ByVal prhdc%, ByVal TBold%)
   'sets weight to bold if TBold is true, otherwise not bold;
   'weights determined by constants below

   Const BoldWeight = 700
   Const NormalWeight = 0

   Dim Result%

   If CurrentFont <> 0 Then
      Result = SelectObject(prhdc, oldfont)
      Result = DeleteObject(CurrentFont)
      CurrentFont = 0
   End If
   If (TBold = True) Then
      lf.lfWeight = BoldWeight
   Else
      lf.lfWeight = NormalWeight
   End If
   CurrentFont = CreateFontIndirect(lf)
   oldfont = SelectObject(prhdc, CurrentFont)
   'ShowFontMetrics prhdc, CurrentFont
End Sub

Sub SetPrtFontItalic (ByVal prhdc%, ByVal TItalic%)
   'sets font to italic if TItalic is true, otherwise not italic;

   Dim Result%

   If CurrentFont <> 0 Then
      Result = SelectObject(prhdc, oldfont)
      Result = DeleteObject(CurrentFont)
      CurrentFont = 0
   End If
   If (TItalic = True) Then
      lf.lfItalic = "1"
   Else
      lf.lfItalic = "0"
   End If
   CurrentFont = CreateFontIndirect(lf)
   oldfont = SelectObject(prhdc, CurrentFont)
   'ShowFontMetrics prhdc, CurrentFont
End Sub

Sub SetPrtFontName (ByVal prhdc%, ByVal TFontName$)
   'Must pass installed font name to this routine

   Dim Result%, OldHeight%

   If CurrentFont <> 0 Then
      Result = SelectObject(prhdc, oldfont)
      Result = DeleteObject(CurrentFont)
      CurrentFont = 0
   End If
   lf.lfFaceName = TFontName & Chr$(0)
   OldHeight = lf.lfHeight
   lf.lfHeight = -(DefPtSize / 72) * PrtYRes
   lf.lfWeight = 400
   FontIsBold = False
   CurrentFont = CreateFontIndirect(lf)
   If CurrentFont = 0 Then
      MsgBox "Unable to set printer font to " & TFontName
      Exit Sub
   End If
   oldfont = SelectObject(prhdc, CurrentFont)
   'ShowFontMetrics prhdc, CurrentFont
End Sub

Sub SetPrtFontSize (ByVal prhdc%, ByVal TFontSize!)
   'sets font size in points
   'note that width is set to 0 which chooses default width
   'this could be changed if desired

   Dim Result%, OldHeight%, TName$

   If CurrentFont <> 0 Then
      Result = SelectObject(prhdc, oldfont)
      Result = DeleteObject(CurrentFont)
      CurrentFont = 0
   End If
   OldHeight = lf.lfHeight
   lf.lfHeight = -(TFontSize / 72) * PrtYRes
   TName = agGetSTringFromLPSTR$(lf.lfFaceName)
   lf.lfWidth = 0
   CurrentFont = CreateFontIndirect(lf)
   oldfont = SelectObject(prhdc, CurrentFont)
   'ShowFontMetrics prhdc, CurrentFont
End Sub

Sub SetPrtFontUnderline (ByVal prhdc%, ByVal Underline%)
   'underline font

   Dim Result%

   If CurrentFont <> 0 Then
      Result = SelectObject(prhdc, oldfont)
      Result = DeleteObject(CurrentFont)
      CurrentFont = 0
   End If
   If (Underline = True) Then
      lf.lfUnderline = "1"    'any non-blank value
   Else
      lf.lfUnderline = Chr(0)
   End If
   CurrentFont = CreateFontIndirect(lf)
   oldfont = SelectObject(prhdc, CurrentFont)
   'ShowFontMetrics prhdc, CurrentFont
End Sub

Sub SetPrtPenWidth (ByVal prhdc%, ByVal PWidth%)
   'sets printer pen in logical units

   Const Black = 0
   Dim Result%

   If CurrentPen <> 0 Then
      Result = SelectObject(prhdc, Oldpen)
      Result = DeleteObject(CurrentPen)
      CurrentPen = 0
   End If
   CurrentPen = CreatePen%(PS_SOLID, PWidth, Black)
   Oldpen = SelectObject(prhdc, CurrentPen)
End Sub

Sub SetTextPos (ByVal dx As Single, ByVal dy As Single)
   'set print position in inches

   lpRect.left = dx * PrtXRes
   lpRect.top = dy * PrtYRes
   lpRect.right = lpRect.left + 11 * PrtXRes
   lpRect.bottom = lpRect.top + 11 * PrtYRes
End Sub

Sub SetTextX (ByVal dx As Single)
   'set X print position while leaving Y position alone

   lpRect.left = dx * PrtXRes
   lpRect.right = lpRect.left + 11 * PrtXRes
End Sub

Sub SetTextY (ByVal dy As Single)
   'set Y print position while leaving X alone

   lpRect.top = dy * PrtYRes
   lpRect.bottom = lpRect.top + 11 * PrtYRes
End Sub

Sub SetupDocInfo (ByVal AppName$)
    ' The DOCINFO structure is the information that the
    ' print manager will show.
    docname$ = AppName
    dinfo.cbSize = 10
    dinfo.lpszDocName = agGetAddressForLPSTR&(docname$)
    dinfo.lpszOutput = 0
End Sub

Sub ShowAbortForm (ByVal ShowSystemModal%)
    AbortForm.Label1 = "Press button to abort..."
    AbortForm.Show
    AbortForm.Refresh
    If ShowSystemModal Then
       di% = SetSysModalWindow(AbortForm.hWnd)
    End If
End Sub

Sub ShowDeviceCapabilities (ByVal hlib%, ByVal DevName$, ByVal DevPort$)
   'for information purposes
   Dim Result%, TBuf$, TStr$, BufLen&, TName$, TCnt&, I%
   Dim LongArray&(), TabChar$

   TabChar = Chr(9)

   TBuf$ = Space(255)
   TCnt = agDeviceCapabilities(hlib, DevName, DevPort, DC_BINS, agGetAddressForVBString&(TBuf), 0&)
   TStr = "Bins = " & Str(TCnt) & CRLF
   If TCnt > 0 Then
      BufLen = 24 * TCnt
      TBuf = Space(BufLen)
      Result = agDeviceCapabilities(hlib, DevName, DevPort, DC_BINNAMES, agGetAddressForVBString&(TBuf), 0&)
      For I = 1 To TCnt
	 TName = Mid$(TBuf, (I - 1) * 24 + 1, 24)
	 TStr = TStr & TabChar & agGetSTringFromLPSTR(TName) & CRLF
      Next I
   End If
   Result = agDeviceCapabilities(hlib, DevName, DevPort, DC_COPIES, agGetAddressForVBString&(TBuf), 0&)
   TStr = TStr & "Max copies = " & Str(Result) & CRLF
   Result = agDeviceCapabilities(hlib, DevName, DevPort, DC_DRIVER, agGetAddressForVBString&(TBuf), 0&)
   TStr = TStr & "Driver Version = " & Str(Result) & CRLF
   Result = agDeviceCapabilities(hlib, DevName, DevPort, DC_DUPLEX, agGetAddressForVBString&(TBuf), 0&)
   If Result = 1 Then
      TStr = TStr & "Duplex = NO" & CRLF
   Else
      TStr = TStr & "Duplex = YES" & CRLF
   End If
   TCnt = agDeviceCapabilities(hlib, DevName, DevPort, DC_ENUMRESOLUTIONS, 0&, 0&)
   If TCnt = -1 Then
      TStr = TStr & "Resolutions = CAPABILITY NOT SUPPORTED" & CRLF
   Else
      TStr = TStr & "Resolutions = " & Str(TCnt) & CRLF
      If TCnt > 0 Then
	 ReDim LongArray(1 To 2 * TCnt)
	 Result = agDeviceCapabilities(hlib, DevName, DevPort, DC_ENUMRESOLUTIONS, agGetAddressForObject(LongArray(1)), 0&)
	 For I = 1 To TCnt
	    TStr = TStr & TabChar & Str(LongArray(2 * I - 1)) & " x " & Str(LongArray(2 * I)) & CRLF
	 Next I
      End If
   End If
   TCnt = agDeviceCapabilities(hlib, DevName, DevPort, DC_MAXEXTENT, 0&, 0&)
   If TCnt = -1 Then
      TStr = TStr & "Max Extent: CAPABILITY NOT SUPPORTED" & CRLF
   Else
      TStr = TStr & "Max Extent: " & Hex(HiWord(TCnt)) & "  " & Hex(LoWord(TCnt)) & CRLF
   End If
   TCnt = agDeviceCapabilities(hlib, DevName, DevPort, DC_MINEXTENT, 0&, 0&)
   If TCnt = -1 Then
      TStr = TStr & "Min Extent: CAPABILITY NOT SUPPORTED" & CRLF
   Else
      TStr = TStr & "Min Extent: " & Hex(HiWord(TCnt)) & "  " & Hex(LoWord(TCnt)) & CRLF
   End If
   TCnt = agDeviceCapabilities(hlib, DevName, DevPort, DC_PAPERNAMES, 0&, 0&)
   TStr = TStr & "Paper Sizes: " & Str(TCnt) & CRLF
   If TCnt > 0 Then
      BufLen = 64 * TCnt
      TBuf = Space(BufLen)
      Result = agDeviceCapabilities(hlib, DevName, DevPort, DC_PAPERNAMES, agGetAddressForVBString&(TBuf), 0&)
      For I = 1 To TCnt
	 TName = Mid$(TBuf, (I - 1) * 64 + 1, 64)
	 TStr = TStr & TabChar & agGetSTringFromLPSTR(TName) & CRLF
      Next I
   End If
   TCnt = agDeviceCapabilities(hlib, DevName, DevPort, DC_TRUETYPE, 0&, 0&)
   Select Case TCnt
      Case DCTT_BITMAP: TStr = TStr & "TRUETYPE: Can print TrueType as graphics." & CRLF
      Case DCTT_DOWNLOAD: TStr = TStr & "TRUETYPE: Can download TrueType fonts." & CRLF
      Case DCTT_SUBDEV: TStr = TStr & "TRUETYPE: Can substitute built-in fonts." & CRLF
      Case Else: TStr = TStr & "TRUETYPE: INVALID VALUE." & CRLF
   End Select
   MsgBox TStr
End Sub

Sub ShowDevMode (ByVal HeaderStr$, dm As DEVMODE)
   'for information purposes
   Dim TStr$, TStr2$

   TStr = HeaderStr & CRLF & CRLF
   TStr = TStr & "dmDeviceName:  " & agGetSTringFromLPSTR(dm.dmDeviceName) & CRLF
   TStr = TStr & "dmSpecVersion:  "
   If dm.dmSpecVersion = &H30A Then
      TStr = TStr & "Windows 3.1" & CRLF
   Else
      TStr = TStr & Hex$(dm.dmSpecVersion) & " (Hex)" & CRLF
   End If
   TStr = TStr & "dmDriverVersion:  " & Hex$(dm.dmDriverVersion) & " (Hex) " & CRLF
   TStr = TStr & "dmSize:  " & dm.dmSize & CRLF
   TStr = TStr & "dmDriverExtra:  " & dm.dmDriverExtra & CRLF
   TStr = TStr & "dmFields:  " & Hex$(dm.dmFields) & " (Hex)" & CRLF

   TStr = TStr & "dmOrientation:  "
   If dm.dmFields And DM_ORIENTATION Then
      Select Case dm.dmOrientation
	 Case DMORIENT_PORTRAIT: TStr2 = "Portrait Mode"
	 Case DMORIENT_LANDSCAPE: TStr2 = "Landscape Mode"
	 Case Else: TStr2 = Str(dm.dmOrientation)
      End Select
      TStr = TStr & TStr2 & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmPaperSize:  "
   If dm.dmFields And DM_PAPERSIZE Then
      Select Case dm.dmPaperSize
	 Case DMPAPER_LETTER: TStr2 = "Letter 8 1/2 x 11 in"
	 Case DMPAPER_LETTERSMALL: TStr2 = "Letter Small 8 1/2 x 11 in"
	 Case DMPAPER_TABLOID: TStr2 = "Tabloid 11 x 17 in"
	 Case DMPAPER_LEDGER: TStr2 = "Ledger 17 x 11 in"
	 Case DMPAPER_LEGAL: TStr2 = "Legal 8 1/2 x 14 in"
	 Case DMPAPER_STATEMENT: TStr2 = "Statement 5 1/2 x 8 1/2 in"
	 Case DMPAPER_EXECUTIVE: TStr2 = "Executive 7 1/4 x 10 1/2 in"
	 Case DMPAPER_A3: TStr2 = "A3 297 x 420 mm"
	 Case DMPAPER_A4: TStr2 = "A4 210 x 297 mm"
	 Case DMPAPER_A4SMALL: TStr2 = "A4 Small 210 x 297 mm"
	 Case DMPAPER_A5: TStr2 = "A5 148 x 210 mm"
	 Case DMPAPER_B4: TStr2 = "B4 250 x 354"
	 Case DMPAPER_B5: TStr2 = "B5 182 x 257 mm"
	 Case DMPAPER_FOLIO: TStr2 = "Folio 8 1/2 x 13 in"
	 Case DMPAPER_QUARTO: TStr2 = "Quarto 215 x 275 mm"
	 Case DMPAPER_10X14: TStr2 = "10x14 in"
	 Case DMPAPER_11X17: TStr2 = "11x17 in"
	 Case DMPAPER_NOTE: TStr2 = "Note 8 1/2 x 11 in"
	 Case DMPAPER_ENV_9: TStr2 = "Envelope #9 3 7/8 x 8 7/8"
	 Case DMPAPER_ENV_10: TStr2 = "Envelope #10 4 1/8 x 9 1/2"
	 Case DMPAPER_ENV_11: TStr2 = "Envelope #11 4 1/2 x 10 3/8"
	 Case DMPAPER_ENV_12: TStr2 = "Envelope #12 4 \276 x 11"
	 Case DMPAPER_ENV_14: TStr2 = "Envelope #14 5 x 11 1/2"
	 Case DMPAPER_CSHEET: TStr2 = "C size sheet"
	 Case DMPAPER_DSHEET: TStr2 = "D size sheet"
	 Case DMPAPER_ESHEET: TStr2 = "E size sheet"
	 Case DMPAPER_ENV_DL: TStr2 = "Envelope DL 110 x 220mm"
	 Case DMPAPER_ENV_C5: TStr2 = "Envelope C5 162 x 229 mm"
	 Case DMPAPER_ENV_C3: TStr2 = "Envelope C3  324 x 458 mm"
	 Case DMPAPER_ENV_C4: TStr2 = "Envelope C4  229 x 324 mm"
	 Case DMPAPER_ENV_C6: TStr2 = "Envelope C6  114 x 162 mm"
	 Case DMPAPER_ENV_C65: TStr2 = "Envelope C65 114 x 229 mm"
	 Case DMPAPER_ENV_B4: TStr2 = "Envelope B4  250 x 353 mm"
	 Case DMPAPER_ENV_B5: TStr2 = "Envelope B5  176 x 250 mm"
	 Case DMPAPER_ENV_B6: TStr2 = "Envelope B6  176 x 125 mm"
	 Case DMPAPER_ENV_ITALY: TStr2 = "Envelope 110 x 230 mm"
	 Case DMPAPER_ENV_MONARCH: TStr2 = "Envelope Monarch 3.875 x 7.5 in"
	 Case DMPAPER_ENV_PERSONAL: TStr2 = "6 3/4 Envelope 3 5/8 x 6 1/2 in"
	 Case DMPAPER_FANFOLD_US: TStr2 = "US Std Fanfold 14 7/8 x 11 in"
	 Case DMPAPER_FANFOLD_STD_GERMAN: TStr2 = "German Std Fanfold 8 1/2 x 12 in"
	 Case DMPAPER_FANFOLD_LGL_GERMAN: TStr2 = "German Legal Fanfold 8 1/2 x 13 in"
	 Case Else: TStr2 = Str(dm.dmPaperSize)
      End Select
      TStr = TStr & TStr2 & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmPaperLength:  "
   If dm.dmFields And DM_PAPERLENGTH Then
      TStr = TStr & dm.dmPaperLength / 254 & " in" & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmPaperWidth:  "
   If dm.dmFields And DM_PAPERWIDTH Then
      TStr = TStr & dm.dmPaperWidth / 254 & " in " & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmScale:  "
   If dm.dmFields And DM_SCALE Then
      TStr = TStr & dm.dmScale & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmCopies:  "
   If dm.dmFields And DM_COPIES Then
      TStr = TStr & dm.dmCopies & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmDefaultSource:  "
   If dm.dmFields And DM_DEFAULTSOURCE Then
      Select Case dm.dmDefaultSource
	 Case DMBIN_ONLYONE: TStr2 = "UPPER"
	 Case DMBIN_LOWER: TStr2 = "LOWER"
	 Case DMBIN_MIDDLE: TStr2 = "MIDDLE"
	 Case DMBIN_MANUAL: TStr2 = "MANUAL"
	 Case DMBIN_ENVELOPE: TStr2 = "ENVELOPE"
	 Case DMBIN_ENVMANUAL: TStr2 = "ENVMANUAL"
	 Case DMBIN_AUTO: TStr2 = "AUTO"
	 Case DMBIN_TRACTOR: TStr2 = "TRACTOR"
	 Case DMBIN_SMALLFMT: TStr2 = "SMALLFMT"
	 Case DMBIN_LARGEFMT: TStr2 = "LARGEFMT"
	 Case DMBIN_LARGECAPACITY: TStr2 = "LARGECAPACITY"
	 Case DMBIN_CASSETTE: TStr2 = "CASSETTE"
	 Case Else: TStr2 = Str(dm.dmDefaultSource)
      End Select
      TStr = TStr & TStr2 & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmPrintQuality:  "
   If dm.dmFields And DM_PRINTQUALITY Then
      Select Case dm.dmPrintQuality
	 Case DMRES_DRAFT: TStr2 = "DRAFT"
	 Case DMRES_LOW: TStr2 = "LOW"
	 Case DMRES_MEDIUM: TStr2 = "MEDIUM"
	 Case DMRES_HIGH: TStr2 = "HIGH"
	 Case Else: TStr2 = Str(dm.dmPrintQuality)
      End Select
      TStr = TStr & TStr2 & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmColor:  "
   If dm.dmFields And DM_COLOR Then
      Select Case dm.dmColor
	 Case DMCOLOR_MONOCHROME: TStr2 = "MONOCHROME"
	 Case DMCOLOR_COLOR: TStr2 = "COLOR"
	 Case Else: TStr2 = Str(dm.dmColor)
      End Select
      TStr = TStr & TStr2 & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmDuplex:  "
   If dm.dmFields And DM_DUPLEX Then
      Select Case dm.dmDuplex
	 Case DMDUP_SIMPLEX: TStr2 = "SIMPLEX"
	 Case DMDUP_VERTICAL: TStr2 = "VERTICAL"
	 Case DMDUP_HORIZONTAL: TStr2 = "HORIZONTAL"
	 Case Else: TStr2 = Str(dm.dmDuplex)
      End Select
      TStr = TStr & dm.dmDuplex & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmYResolution:  "
   If dm.dmFields And DM_YRESOLUTION Then
      Select Case dm.dmYResolution
	 Case DMRES_DRAFT: TStr2 = "DRAFT"
	 Case DMRES_LOW: TStr2 = "LOW"
	 Case DMRES_MEDIUM: TStr2 = "MEDIUM"
	 Case DMRES_HIGH: TStr2 = "HIGH"
	 Case Else: TStr2 = Str(dm.dmYResolution)
      End Select
      TStr = TStr & TStr2 & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   TStr = TStr & "dmTTOption:  "
   If dm.dmFields And DM_TTOPTION Then
      Select Case dm.dmTTOption
	 Case DMTT_BITMAP: TStr2 = "print TT fonts as graphics"
	 Case DMTT_DOWNLOAD: TStr2 = "download TT fonts as soft fonts"
	 Case DMTT_SUBDEV: TStr2 = "substitute device fonts for TT fonts"
	 Case Else: TStr2 = Str(dm.dmTTOption)
      End Select
      TStr = TStr & TStr2 & CRLF
   Else
      TStr = TStr & "INVALID" & CRLF
   End If

   MsgBox TStr, 0, "DEVMODE STRUCTURE"
End Sub

Sub ShowFontMetrics (ByVal prhdc%, ByVal FontToUse%)
   'useful for seeing what font characteristics are in use

    Dim tm As TEXTMETRIC
    Dim r$
    Dim CRLF$
    Dim oldfont%
    Dim TBuf As String * 80

    CRLF$ = Chr$(13) & Chr$(10)
    If FontToUse% = 0 Then
	MsgBox "Font not yet selected"
	Exit Sub
    End If
    'oldfont% = SelectObject(prhdc, FontToUse%)
    di% = GetTextMetrics(prhdc, tm)
    di% = GetTextFace(prhdc, 79, TBuf)
    ' Add to r$ only the part up to the null terminator
    r$ = "Facename = " & agGetSTringFromLPSTR$(TBuf) & CRLF$
    If (Asc(tm.tmPitchAndFamily) And TMPF_TRUETYPE) <> 0 Then r$ = r$ & "... is a TrueType font" & CRLF$
    If (Asc(tm.tmPitchAndFamily) And TMPF_DEVICE) <> 0 Then r$ = r$ & "... is a Device font" & CRLF$
    ' Curiously enough, this bit is set for variable width fonts.
    If (Asc(tm.tmPitchAndFamily) And TMPF_FIXED_PITCH) = 0 Then r$ = r$ & "... is a fixed pitch font" & CRLF$
    r$ = r$ & "Height=" & Str$(tm.tmHeight) & ", Ascent=" & Str$(tm.tmAscent) & ", Descent=" & Str$(tm.tmDescent) & CRLF$
    r$ = r$ & "Internal Leading=" & Str$(tm.tmInternalLeading) & ", External Leading=" & Str$(tm.tmExternalLeading) & CRLF$
    r$ = r$ & "Average char width=" & Str$(tm.tmAveCharWidth) & ", Max char width=" & Str$(tm.tmMaxCharWidth) & CRLF$
    r$ = r$ & "Weight=" & Str$(tm.tmWeight) & ", First char=" & Str$(Asc(tm.tmFirstChar)) & ", Last char=" & Str$(Asc(tm.tmLastChar)) & CRLF$
    r$ = r$ & "AspectX=" & Str$(tm.tmDigitizedAspectX) & ", AspectY=" & Str$(tm.tmDigitizedAspectY) & CRLF$
    
    MsgBox r$, 0, "Physical Font Metrics"
    'di% = SelectObject(prhdc, oldfont%)
End Sub

Sub ShowPrinterMetrics (dm As DEVMODE)
   'useful for displaying printer metrics

   Dim a$, CRLF$

   CRLF = Chr$(13) & Chr$(10)
   a$ = "Device Name: " & agGetSTringFromLPSTR$(dm.dmDeviceName) & CRLF
   a$ = a$ & "Devmode Version: " & Hex$(dm.dmSpecVersion) & CRLF
   a$ = a$ & "Horizontal Resolution: " & Str$(dm.dmPrintQuality) & CRLF
   a$ = a$ & "Vertical Resolution: " & Str$(dm.dmYResolution)
   MsgBox a
End Sub

Function SplitLines% (ByVal prhdc%, ByVal TString$, ByVal MaxLength!)
   '---------------------------------------------------------------------
   'This routine takes the string TString$ and splits it up into lines
   'which are <= MaxLength long for the printer whose device context
   'is prhdc
   '
   'This is useful when one wishes to print the contents of a text box
   'or some other long string which is not naturally broken into segments
   '
   'Remember that the length is dependent on the printer, the current
   'font, etc.
   '
   'The individual lines are stored in the array "LinesArray" which is
   'defined in the declarations section.  The maximum number of lines is
   'set by the constant MaxLinesArray.  This value may be set to
   'whatever value is needed.  Any remainder of TString$ which does not
   'fit into LinesArray is returned in RemainStr$ so that you may make
   'iterative calls if you wish.
   '
   'Carriage returns which are embedded in TString$ cause the line to
   'be split at that point.
   '---------------------------------------------------------------------

   Dim TStr1$, TStr2, ArrayCount, TPos%, TLen!, OldTPos%, I%
   Dim CRPos%, LoopCounter%

   TStr1 = TString
   TStr2 = TString
   TPos = 1
   CRPos = 1
   ArrayCount = 1
   LoopCounter = 0  'testing purposes only

   For I = 1 To MaxLinesArray
      LinesArray(I) = ""
   Next I
   RemainStr = ""
   Do While 1
      LoopCounter = LoopCounter + 1
      If LoopCounter >= 25 Then
	 LoopCounter = LoopCounter
      End If
      If ArrayCount > MaxLinesArray Then Exit Do
      TPos = InStr(TPos, TStr1, " ")
      CRPos = InStr(1, TStr1, Chr(13))
      If CRPos > 0 And CRPos < TPos Then
	 LinesArray(ArrayCount) = Left(TStr1, CRPos - 1)
	 TPos = 1
	 TStr1 = Right$(TStr1, Len(TStr1) - (Len(LinesArray(ArrayCount)) + 2))
	 ArrayCount = ArrayCount + 1
	 If ArrayCount > MaxLinesArray Then
	    RemainStr = TStr1
	    Exit Do
	 End If
      Else
	 If TPos > 0 Then
	    TStr2 = Left(TStr1, TPos - 1)
	    TLen = GetTextWidth(prhdc, TStr2) / PrtYRes
	    If TLen < MaxLength Then
	       LinesArray(ArrayCount) = TStr2
	       OldTPos = TPos
	       TPos = TPos + 1
	    Else
	       TPos = 1
	       TStr1 = Right$(TStr1, Len(TStr1) - (Len(LinesArray(ArrayCount)) + 1))
	       ArrayCount = ArrayCount + 1
	       If ArrayCount > MaxLinesArray Then
		  RemainStr = TStr1
		  Exit Do
	       End If
	    End If
	 Else
	    LinesArray(ArrayCount) = TStr2
	    TLen = GetTextWidth(prhdc, TStr1) / PrtYRes
	    If TLen < MaxLength Then
	       LinesArray(ArrayCount) = TStr1
	       TStr1 = ""
	    Else
	       TStr1 = Right(TStr1, Len(TStr1) - OldTPos)
	    End If
	    ArrayCount = ArrayCount + 1
	    If ArrayCount > MaxLinesArray Then
	       RemainStr = TStr1
	       Exit Do
	    End If
	    LinesArray(ArrayCount) = TStr1
	    TPos = 1
	    Exit Do
	 End If
      End If
   Loop
   SplitLines = ArrayCount
End Function

Function StartAPage% (ByVal prhdc%)
   'must be called at the beginning of each page

    StartAPage = StartPage(prhdc%)
End Function

Function StartDocument% (ByVal prhdc%)
    'called at the beginning of a document

    StartDocument = StartDoc(prhdc%, dinfo)
End Function

Sub UnloadAbortForm ()
    Unload AbortForm
End Sub

