DefInt A-Z

Type RECT
    Left As Integer
    Top As Integer
    right As Integer
    Bottom As Integer
End Type

Declare Function GetSystemMetrics Lib "User" (ByVal nIndex%) As Integer
Declare Function SetParent Lib "User" (ByVal hwndChild%, ByVal hWndNewParent%) As Integer

Declare Sub GetWindowRect Lib "User" (ByVal hWnd%, lpRect As RECT)
Declare Sub SetActiveWindow Lib "User" (ByVal hWnd)
Declare Sub SetWindowPos Lib "User" (ByVal hWnd%, ByVal hWndInsertAfter%, ByVal X%, ByVal Y%, ByVal Cx%, ByVal Cy%, ByVal wFlags%)

Global Const SM_CXBORDER = 5
Global Const SM_CYBORDER = 6
Global Const SM_CXFRAME = 32
Global Const SM_CYFRAME = 33
Global Const SM_CYCAPTION = 4

Global mnuembed As Integer
Global lpRect  As RECT

'These are for managing the 3D look.
Global Const CTLRAISED = -1    ' Frame is raised.
Global Const CTLRECESSED = 0   ' Frame is recessed
Global Const BKGNDGRAY = 192   ' Background Gray.
Global Const DARKGRAY = 64     ' Dark Gray
Global Const LIGHTGRAY = 255   ' Light Gray (white).
Global Const DEFAULTWIDTH = 1  ' Default Frame Width
Global FrameWidth As Integer   ' Width of 3d frame (in pixels).

Sub Highlight (C As Control, InOut%)
'Part of my 3D look.
C.Parent.ScaleMode = 3
TLShade& = RGB(LIGHTGRAY, LIGHTGRAY, LIGHTGRAY)
BRShade& = RGB(DARKGRAY, DARKGRAY, DARKGRAY)
' Now draw the Frame Around the Control, on the Parent Form.
For i% = 1 To FrameWidth
T% = C.Top - i%
L% = C.Left - i%
H% = C.Height + 2 * i%
W% = C.Width + 2 * i%
C.Parent.Line (L%, T%)-Step(0, H%), TLShade&   ' left side
C.Parent.Line (L%, T%)-Step(W%, 0), TLShade&   ' top
C.Parent.Line (L% + W%, T%)-Step(0, H%), BRShade& ' right side
C.Parent.Line (L%, T% + H%)-Step(W%, 0), BRShade&  ' bottom
Next i%
End Sub

Sub HotKey (KeyCode As Integer, Shift As Integer)
End Sub

Sub LowLight (D As Control, OutIn%)
'Part of my 3D look.
D.Parent.ScaleMode = 3
TLShade& = RGB(DARKGRAY, DARKGRAY, DARKGRAY)
BRShade& = RGB(LIGHTGRAY, LIGHTGRAY, LIGHTGRAY)
' Now draw the Frame Around the Control, on the Parent Form.
For i% = 1 To FrameWidth
T% = D.Top - i%
L% = D.Left - i%
H% = D.Height + 2 * i%
W% = D.Width + 2 * i%
D.Parent.Line (L%, T%)-Step(0, H%), TLShade&   ' left side
D.Parent.Line (L%, T%)-Step(W%, 0), TLShade&   ' top
D.Parent.Line (L% + W%, T%)-Step(0, H%), BRShade& ' right side
D.Parent.Line (L%, T% + H%)-Step(W%, 0), BRShade&  ' bottom
Next i%
End Sub


