#include "windows.h"
#include "commdlg.h"
#include "vbapi.h"

LONG FAR PASCAL _export DragDropWndProc( HCTL, HWND, WORD, WORD, LONG );
LONG _export FAR PASCAL PopupWndProc( HWND, WORD, WORD, LONG );

typedef struct {
   HSZ hszWaveFile;
   BOOL Enabled;
   HANDLE hFiles;
   int Width, Height;
   int WaveStyle, WaveLoop, WaveOn;
} DDSTRUCT;

#define DEREF(hctl) ((DDSTRUCT far *)VBDerefControl(hctl))


char SHELL[] = "SHELL.DLL";
char *CLASSPOPUP = "CPopup";
HANDLE hmodDLL;
HCTL ColorHctl;
WORD szDropType[] = { ET_I2 };
char MMSystem[] = "MMSYSTEM.DLL";

PROPINFO Prop_Enabled =
{
   "Enabled",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Files =
{
   "Files",
   DT_SHORT | PF_fGetMsg | PF_fNoShow,
   0, 0, NULL, 0
};

PROPINFO Prop_Filename =
{
   "Filename",
   DT_HSZ | PF_fGetMsg | PF_fNoShow | PF_fPropArray,
   0, 0, NULL, 0
};

PROPINFO prop_WaveFile =
{
   "WaveFile",
   DT_HSZ | PF_fSetData | PF_fGetData | PF_fSaveData,
   0, 0, NULL, 0
};

char WaveStyles[] = "0 - Synchronous\0"\
                  "1 - Asynchrounous\0"\
                  "";

PROPINFO prop_WaveStyle =
{
   "WaveStyle",
   DT_ENUM | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, 0, WaveStyles, 1
};

PROPINFO prop_WaveLoop =
{
   "WaveLoop",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO prop_WaveEnabled =
{
   "WaveEnabled",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO prop_Version =
{
   "Version",
   DT_SHORT | PF_fGetMsg,
   0, 0, NULL, 0
};

PPROPINFO proplistDD[] =
{
   &Prop_Enabled,
   &Prop_Files,
   &Prop_Filename,
   &prop_WaveFile,
   &prop_WaveStyle,
   &prop_WaveLoop,
   &prop_WaveEnabled,
   &prop_Version,
   PPROPINFO_STD_BACKCOLOR,
   NULL
};

#define PROP_ENABLED     0
#define PROP_FILES       1
#define PROP_FILENAME    2
#define PROP_WAVEFILE    3
#define PROP_WAVESTYLE   4
#define PROP_WAVELOOP    5
#define PROP_WAVEENABLED 6
#define PROP_VERSION     7

typedef struct {
   WORD far *Files;
   LPVOID Index;
} DROPPARAM;

EVENTINFO Event_Dropped =
{
   "Dropped", 1, 2, szDropType, "Files as Integer"
};

PEVENTINFO eventlistDD[] =
{
   &Event_Dropped,
   NULL
};

MODEL modelDD =
{
   VB_VERSION,
   MODEL_fLoadMsg | MODEL_fChildrenOk,
   (PCTLPROC)DragDropWndProc,
   NULL,
   WS_CHILD | WS_CLIPSIBLINGS | WS_CLIPCHILDREN,
   sizeof(DDSTRUCT),
   8000,
   "DragDrop",
   "DragDrop",
   NULL,
   proplistDD,
   eventlistDD
};

BOOL FAR PASCAL LibMain( HANDLE hmod, HANDLE segDS, USHORT cbHeapSize )
{
   hmodDLL = hmod;
   UnlockData( 0 );
   return( TRUE );
}


BOOL FAR PASCAL _export VBINITCC( USHORT usVersion, BOOL fRunTime )
{
   if( ! fRunTime )
   {
      WNDCLASS wc;

      wc.style = 0;
      wc.lpfnWndProc = (WNDPROC)PopupWndProc;
      wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;
      wc.hInstance = hmodDLL;
      wc.hIcon = NULL;
      wc.hCursor = NULL;
      wc.hbrBackground = NULL;
      wc.lpszMenuName = NULL;
      wc.lpszClassName = CLASSPOPUP;

      if( ! RegisterClass( &wc ) )
         return( FALSE );
   }
   return( VBRegisterModel( hmodDLL, &modelDD ) );
}

void FireDropEvent( HCTL hCtl, HANDLE hShell )
{
   DDSTRUCT far *Dd = DEREF( hCtl );
   DROPPARAM Dp;
   FARPROC lpfnDragQueryFile;
   char str[ 1 ];
   WORD i;

   i = 0;

   lpfnDragQueryFile = GetProcAddress( hShell, (LPSTR)(LONG)11 );
   if( lpfnDragQueryFile )
      i = (WORD)( *lpfnDragQueryFile )( (HANDLE)Dd->hFiles, (WORD)-1, (LPSTR)str, (WORD)1 );

   Dp.Files = (WORD far *)&i;

   VBFireEvent( hCtl, 0, &Dp );
}


LONG FAR PASCAL _export DragDropWndProc( HCTL hCtl, HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case 0x0233:                                                              /*  Drop event...  */
      {
         DDSTRUCT far *Dd = DEREF( hCtl );
         HANDLE hShell;
         FARPROC lpfnDragFinish;
         WORD winVer;
         LPSTR lpWave;
         HANDLE hMM;
         FARPROC lpfnSndPlaySound;

         Dd->hFiles = (HANDLE)wParam;                                      /*  Save memory handle  */
         hShell = LoadLibrary( SHELL );                         /*  Load SHELL.DLL if not already  */

         if( hShell )
         {
            if( Dd->WaveOn != 0 )
            {
               winVer = GetVersion();
               if( HIBYTE( winVer ) >= 10 && LOBYTE( winVer ) >= 3 )
               {
                  lpWave = VBDerefHsz( Dd->hszWaveFile );
                  if( lstrlen( lpWave ) )
                  {
                     hMM = LoadLibrary( MMSystem );
                     if( hMM )
                     {
                        lpfnSndPlaySound = GetProcAddress( hMM, (LPSTR)(long)2 );
                        if( lpfnSndPlaySound )
                           ( *lpfnSndPlaySound )( (LPSTR)lpWave,
                                          (int)8 * ( Dd->WaveLoop != 0 ) );

                        FreeLibrary( hMM );
                        InvalidateRect( hWnd, NULL, FALSE );
                     }
                  }
               }
            }
            FireDropEvent( hCtl, hShell );                                      /*  Fire VB event  */

            lpfnDragFinish = GetProcAddress( hShell, (LPSTR)(LONG)12 );

            if( lpfnDragFinish )                               /*  If all done, kill memory block  */
               ( *lpfnDragFinish )( (WORD)wParam );

            FreeLibrary( hShell );                                  /*  Reduce library lock count  */
         }
         Dd->hFiles = NULL;
         InvalidateRect( GetParent( hWnd ), NULL, TRUE );

         return( TRUE );
      }

      case VBM_LOADED:                                        /*  If control has been created...  */
      {
         DDSTRUCT far *Dd = DEREF( hCtl );
         RECT Rect;
         WORD Mode;
         HANDLE hShell;
         FARPROC lpfnDragAcceptFiles;

         Mode = VBGetMode();
         if( Mode == MODE_RUN || Mode == MODE_BREAK )                   /*  If in runtime mode...  */
         {
            hShell = LoadLibrary( SHELL );
            if( hShell )
            {
               lpfnDragAcceptFiles = GetProcAddress( hShell, (LPSTR)(LONG)9 );
               if( lpfnDragAcceptFiles )
                  ( *lpfnDragAcceptFiles )( (HWND)hWnd, (BOOL)TRUE );
            }
            GetWindowRect( GetParent( hWnd ), &Rect );               /*  Set size to cover parent  */

            SetWindowPos( hWnd, NULL, 0, 0, Rect.right - Rect.left,
                          Rect.bottom - Rect.top, SWP_NOZORDER );

            SetClassWord( hWnd, GCW_STYLE, GetClassWord( hWnd, GCW_STYLE ) | CS_PARENTDC );
            Dd->Width = Rect.right;
            Dd->Height = Rect.bottom;

            FreeLibrary( hShell );
            break;
         }
         break;
      }

      case WM_NCHITTEST:
         if( VBGetMode() != MODE_DESIGN )
            return( HTTRANSPARENT );
         break;

      case VBM_CREATED:
        if( VBGetMode() != MODE_DESIGN )
           SetWindowPos( hWnd, 0, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE );
        else
           SetWindowPos( hWnd, 0, 0, 0, 32, 32, SWP_NOMOVE );
        break;

      case WM_PAINT:
      {
         PAINTSTRUCT ps;
         HICON hIcon;
         HDC hDC;
         HPEN hPen;
         HBRUSH hBrush;
         RECT Rect;
         DDSTRUCT far *Dd = DEREF( hCtl );

         hDC = BeginPaint( hWnd, &ps ); /*  Standard "BeginPaint" beginning  */

         if( VBGetMode() != MODE_DESIGN )      /*  If not in design mode...  */
         {
            hBrush = SendMessage( GetParent( hWnd ), WM_CTLCOLOR, hDC, MAKELONG( hWnd, 0 ) );

            SetWindowPos( hWnd, 1, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE );

            Rect.top = Rect.left = 0;
            Rect.right = Dd->Width;
            Rect.bottom = Dd->Height;

            FillRect( hDC, &Rect, hBrush );

            EndPaint( hWnd, &ps );              /*  End now...nothing to do  */
            return( FALSE );
         }

         hIcon = LoadIcon( hmodDLL, "Icon" );
         if( hIcon )
         {
            DrawIcon( hDC, 0, 0, hIcon );
            DestroyIcon( hIcon );
         }
         EndPaint( hWnd, &ps );
         break;
      }

      case VBM_GETPROPERTY:
      {
         DDSTRUCT far *Dd = DEREF( hCtl );

         if( wParam == PROP_WAVESTYLE )
         {
            *(WORD far *)lParam = Dd->WaveStyle;
            return( FALSE );
         }

         if( wParam == PROP_WAVELOOP )
         {
            *(WORD far *)lParam = Dd->WaveLoop;
            return( FALSE );
         }

         if( wParam == PROP_WAVEENABLED )
         {
            *(WORD far *)lParam = Dd->WaveOn;
            return( FALSE );
         }

         if( wParam == PROP_ENABLED )
         {
            *(WORD far *)lParam = Dd->Enabled;
            return( FALSE );
         }

         if( wParam == PROP_FILES )
         {
            WORD Files;
            HANDLE hShell;
            FARPROC lpfnDragQueryFile;
            char str[ 1 ];

            *(WORD far *)lParam = 0;
            hShell = LoadLibrary( SHELL );

            if( hShell )
            {
               lpfnDragQueryFile = GetProcAddress( hShell, (LPSTR)(LONG)11 );
               if( lpfnDragQueryFile )
               {

                  Files = (WORD)( *lpfnDragQueryFile )( Dd->hFiles, -1,
                                                               (LPSTR)str, 1 );
                  FreeLibrary( hShell );
               }
            }

            *(WORD far *)lParam = Files;
            return( FALSE );
         }

         if( wParam == PROP_FILENAME )
         {
            char str[ 256 ];
            WORD i;
            LPDATASTRUCT lpDs = (LPDATASTRUCT)lParam;
            HANDLE hShell;
            FARPROC lpfnDragQueryFile;

            i = lpDs->index[ 0 ].data;
            hShell = LoadLibrary( SHELL );
            str[ 0 ] = '\0';

            if( hShell )
            {
               lpfnDragQueryFile = GetProcAddress( hShell, (LPSTR)(LONG)11 );
               if( lpfnDragQueryFile )
               {
                  ( *lpfnDragQueryFile )( (HANDLE)Dd->hFiles, (WORD)i, (LPSTR)str,
                                          (WORD)256 );
                  lpDs->data = (LONG)VBCreateHsz( (_segment)hCtl, str );
                  FreeLibrary( hShell );
               }
               else
                  lpDs->data = (LONG)VBCreateHsz( (_segment)hCtl, str );
            }
            else
               lpDs->data = (LONG)VBCreateHsz( (_segment)hCtl, str );

            return( FALSE );
         }

         if( wParam == PROP_VERSION )
         {
            *(WORD far *)lParam = 100;
            return( FALSE );
         }
         break;
      }

      case VBM_SETPROPERTY:
      {
         DDSTRUCT far *Dd = DEREF( hCtl );

         if( wParam == PROP_ENABLED )
         {
            Dd->Enabled = LOWORD( lParam );
            if( ! Dd->Enabled )
               SetWindowPos( hWnd, NULL, 0, 0, 0, 0, SWP_NOZORDER );
            else
               SetWindowPos( hWnd, NULL, 0, 0, Dd->Width, Dd->Height, SWP_NOZORDER );

            return( FALSE );
         }

         if( wParam == PROP_WAVESTYLE )
         {
            Dd->WaveStyle = LOWORD( lParam );
            return( FALSE );
         }

         if( wParam == PROP_WAVELOOP )
         {
            Dd->WaveLoop = LOWORD( lParam );
            return( FALSE );
         }

         if( wParam == PROP_WAVEENABLED )
         {
            Dd->WaveOn = LOWORD( lParam );
            return( FALSE );
         }
         break;
      }

      case VBM_INITPROPPOPUP:
      {
         switch( wParam )
         {
            case PROP_WAVEFILE:
            {
               FARPROC DlgProc;

               if( VBGetMode() == MODE_DESIGN )
               {
                  ColorHctl = hCtl;

                  return( CreateWindow( CLASSPOPUP, NULL, WS_POPUP, 0, 0, 0, 0,
                                        NULL, NULL, hmodDLL, NULL ) );
               }
               return( NULL );
            }
         }
         break;
      }
   }
   return( VBDefControlProc( hCtl, hWnd, msg, wParam, lParam ) );
}



LONG _export FAR PASCAL PopupWndProc( HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_SHOWWINDOW:
         if( wParam )
         {
            PostMessage( hWnd, WM_USER, 0, 0L );
            return( 0L );
         }
         break;

      case WM_USER:
      {
         OPENFILENAME Of;
         HSZ hsz;
         char str[ 128 ];

         lstrcpy( str, "*.WAV" );
         Of.lStructSize = sizeof(OPENFILENAME);
         Of.hwndOwner = hWnd;
         Of.hInstance = (HANDLE)NULL;
         Of.lpstrFilter = "Wave Files  (*.WAV)\0*.WAV\0All Files   (*.*)\0*.*\0\0";
         Of.lpstrCustomFilter = (LPSTR)NULL;
         Of.nMaxCustFilter = (DWORD)0;
         Of.nFilterIndex = (DWORD)0;
         Of.lpstrFile = str;
         Of.nMaxFile = (DWORD)128;
         Of.lpstrFileTitle = (LPSTR)NULL;
         Of.nMaxFileTitle = (DWORD)NULL;
         Of.lpstrInitialDir = (LPSTR)NULL;
         Of.lpstrTitle = "Attach Wave File...";
         Of.Flags = (DWORD)NULL;
         Of.nFileOffset = 0;
         Of.nFileExtension = 0;
         Of.lpstrDefExt = (LPSTR)NULL;
         Of.lCustData = NULL;
         Of.lpfnHook = NULL;
         Of.lpTemplateName = (LPSTR)NULL;

         if( GetOpenFileName( &Of ) )
            VBSetControlProperty( ColorHctl, PROP_WAVEFILE, (LONG)(LPSTR)str );
         return( 0L );
      }
   }
   return( DefWindowProc( hWnd, msg, wParam, lParam ) );
}




