// Code for converting BMPs to strings and strings to BMPs.
//     (C) 1993, Balboa Technical Services.
//
//
//


// Type definitions ( compiler specific)
#define DLL_LONG extern "C" DWORD FAR PASCAL _export
#define DLL_INT extern "C" WORD FAR PASCAL _export
typedef char far * STRINGPTR;
typedef WORD PIXELS;
 
// Constants
const BLACK = 0x00;   // Logic 0.  (Foreground color)
const WHITE = -1;     // Logic 1.  (Background color)

                                             // String Bmp header structure. This information is stored at the beginning
//    of string to store info on size of bitmap stored in the string.
const StringBmpIdentifier =  0x5342;  // = "SB"
struct SB {
   WORD identifier;  // Must be 'SB' = 0x5342
   WORD width;
   WORD height;
   WORD widthbytes;
 };

union StringBmpType
 { struct SB FAR *stringbmp;
   STRINGPTR vbstring;
 }; 

// Function prototypes:
DLL_LONG Bmp_GetSize( HBITMAP hImage);
DLL_LONG BmpToString( HDC hdc, HBITMAP hImage, LPSTR string);
DLL_LONG StringToBmp( LPSTR string, HDC hdcSrc, HBITMAP hbmpSrc);
DLL_LONG StringBmp_OR( STRINGPTR A, STRINGPTR B, STRINGPTR RESULT);
DLL_LONG StringBmp_AND( STRINGPTR A, STRINGPTR B, STRINGPTR RESULT);
DLL_LONG StringBmp_INVERT( STRINGPTR A, STRINGPTR RESULT);
DLL_LONG StringBmp_COMPARE( STRINGPTR A, STRINGPTR B);



// Local functions for use INTERNALLY to the DLL ONLY!!!
DLL_LONG StringBmp_ValidateStringBmp( STRINGPTR A);
DLL_LONG StringBmp_CheckSameSize( STRINGPTR A, STRINGPTR B);
DLL_INT StringBmp_SetDimensions( STRINGPTR A, int w, int h, int wb);
DLL_INT StringBmp_GetWidthBytes( STRINGPTR A);
DLL_INT StringBmp_GetWidth( STRINGPTR A);
DLL_INT StringBmp_GetHeight( STRINGPTR A);
DLL_INT StringBmp_GetIdentifier( STRINGPTR A);
DLL_LONG Bmp_GetHeight( HBITMAP hImage);
DLL_LONG Bmp_GetWidth( HBITMAP hImage);
 
 
