
//////////////////////////////////////////////////////////////////////////////
//
// Filename:     skelabt.cpp
//
// Description:  Skeleton Visual Basic Custom Control.
//
//               This module displays the control's about box.
//
// Date Created: <Date>
//
// Author:       <Your Name>
//
// Copyright (c) <Your Company Name> 1994
//
//               Portions of this product are based on original
//                  source code from Anton Software Limited.
//
//////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <vbapi.h>

#include "skeleton.hpp"
#include "skelexp.hpp"
#include "skelext.hpp"

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: AboutDlgProc
//
// Description:   The about box's window (dialog) procedure.
//
// Parameters:    hwnd - Window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   0 for processed messages, the result from the default window
//                procedure otherwise.
//
//////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK _export AboutDlgProc
(
    HWND   hwndDlg, // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    static HBRUSH hbr;  // brush handle (must be static)

    // Process the message...
    switch (msg)
    {
        case WM_INITDIALOG:
        {
            RECT rect;       // rectangle
            int  left;       // new x
            int  top;        // new y
            int  width;      // width
            int  height;     // height

            // Position the about box centrally.
            GetWindowRect(hwndDlg, &rect);

            width  = rect.right - rect.left;
            height = rect.bottom - rect.top;
            left   = (GetSystemMetrics(SM_CXSCREEN) - width)  / 2;
            top    = (GetSystemMetrics(SM_CYSCREEN) - height) / 2;

            MoveWindow(hwndDlg, left, top, width, height, FALSE);

            //Create the background colour brush (light grey).
            hbr = CreateSolidBrush(0x00C0C0C0);

            // Set the input focus.
            return TRUE;

        } // end case WM_INITDIALOG

        case WM_CTLCOLOR:

            // Switch on the control type...
            switch (HIWORD(lp))
            {
                case CTLCOLOR_DLG:
                    SetBkColor((HDC)wp, hbr);
                    return (BOOL)hbr;

                case CTLCOLOR_BTN:
                case CTLCOLOR_STATIC:
                    SetBkMode((HDC)wp, TRANSPARENT);
                    return (BOOL)hbr;

            } // end switch on the control type

            break;

        case WM_COMMAND:

            // Switch on the control...
            switch (wp)
            {
                // OK button clicked on About box
                case IDOK:

                    // FALSE returned from AboutDlgProc.
                    EndDialog(hwndDlg, FALSE);
                    return 0L;

            } // end switch on the control

            break;

        case WM_CLOSE:
        case WM_DESTROY:

            // Get rid of the brush.
            DeleteObject(hbr);
            EndDialog(hwndDlg, FALSE);

     } // end switch on the message

     // Return FALSE.
     return FALSE;

} // AboutDlgProc

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: AboutWndProc
//
// Description:   Window procedure of the about box's invisible controlling
//                parent window.
//
// Parameters:    hwnd - Window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   0 for processed messages, the result from the default window
//                procedure otherwise.
//
//////////////////////////////////////////////////////////////////////////////

LONG CALLBACK _export AboutWndProc
(
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Process the message...
    switch (msg)
    {
        case WM_SHOWWINDOW:

            // Don't show the window, just post a message to open the dialog
            // box.
            if (wp)
            {
                PostMessage(hwnd, WM_USER, 0, 0L);
                return 0L;
            }

            break;

        case WM_USER:

            // Can now show the about box window.
            VBDialogBoxParam(hmodDLL, "ABOUTBOX", (FARPROC)AboutDlgProc, 0L);
            return 0L;

    } // end switch on the message

    // Return the result from the default window procedure.
    return DefWindowProc(hwnd, msg, wp, lp);

} // AboutWndProc

