
//////////////////////////////////////////////////////////////////////////////
//
// Filename:     skeleton.cpp
//
// Description:  Skeleton Visual Basic Custom Control.
//
//               Main module. Contains the control procedure and all message
//               processing routines.
//
// Date Created: <Date>
//
// Author:       <Your Name>
//
// Copyright (c) <Your Company Name> 1994
//
//               Portions of this product are based on original
//                  source code from Anton Software Limited.
//
//////////////////////////////////////////////////////////////////////////////

#include <string.h>
#include <windows.h>
#include <vbapi.h>

#include "skeleton.hpp"
#include "skelexp.hpp"
#include "skelext.hpp"

//////////////////////////////////////////////////////////////////////////////
//
// Local function forward declarations
//
//////////////////////////////////////////////////////////////////////////////
static LONG VBM_CheckProperty(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_CheckProperty_MyProp1(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_Created(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_GetProperty(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_GetProperty_MyProp2(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_Help(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_HelpControl(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_HelpEvent(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_HelpProperty(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_InitPropPopup(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_InitPropPopup_About(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_Initialize(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_Loaded(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_SetProperty(HCTL, HWND, USHORT, USHORT, LONG);
static LONG VBM_SetProperty_MyProp2(HCTL, HWND, USHORT, USHORT, LONG);
static LONG WM_NCDestroy(HCTL, HWND, USHORT, USHORT, LONG);

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: SkeletonCtlProc
//
// Description:   Skeleton control procedure. Called by Visual Basic.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - Window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from the appropriate message function, or from
//                the default control procedure if the message is not
//                processed.
//
//////////////////////////////////////////////////////////////////////////////

LONG CALLBACK _export SkeletonCtlProc
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // Window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Process the message appropriately.

    switch (msg)
    {
        case VBM_CHECKPROPERTY:
            return VBM_CheckProperty(hctl, hwnd, msg, wp, lp);

        case VBM_CREATED:
            return VBM_Created(hctl, hwnd, msg, wp, lp);

        case VBM_GETPROPERTY:
            return VBM_GetProperty(hctl, hwnd, msg, wp, lp);

        case VBM_HELP:
            return VBM_Help(hctl, hwnd, msg, wp, lp);

        case VBM_INITIALIZE:
            return VBM_Initialize(hctl, hwnd, msg, wp, lp);

        case VBM_INITPROPPOPUP:
            return VBM_InitPropPopup(hctl, hwnd, msg, wp, lp);

        case VBM_LOADED:
            return VBM_Loaded(hctl, hwnd, msg, wp, lp);

        case VBM_SETPROPERTY:
            return VBM_SetProperty(hctl, hwnd, msg, wp, lp);

        case WM_NCDESTROY:
            return WM_NCDestroy(hctl, hwnd, msg, wp, lp);

        default:
            return VBDefControlProc(hctl, hwnd, msg, wp, lp);

    } // end switch message

} // SkeletonCtlProc

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_CheckProperty
//
// DESCRIPTION:   Processes the VBM_CHECKPROPERTY message. Sent by VB when a
//                property needs to be checked for validity.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from the appropriate message function, or from
//                the default control procedure if the message is not
//                processed.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_CheckProperty
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Switch on the property whose value is being checked...
    switch (wp)
    {
        case IPROP_MYPROP1:
            return VBM_CheckProperty_MyProp1(hctl, hwnd, msg, wp, lp);

    } // end switch on the property being checked

    // Return the result from the default control procedure.
    return VBDefControlProc(hctl, hwnd, msg, wp, lp);

} // VBM_CheckProperty

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_CheckProperty_MyProp1
//
// Description:   Processes the VBM_CHECKPROPERTY message for the MyProp1
//                property.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   An error code if the property assignment should not proceed,
//                or 0 otherwise.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_CheckProperty_MyProp1
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // TO DO: call VBSetErrorMessage if the property is being set to an
    //        invalid value and return its result.

    // All OK, so return 0.
    return 0L;

} // VBM_CheckProperty_MyProp1

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_Created
//
// Description:   Processes the VBM_CREATED message. Sent by VB when the
//                control has just been created.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from the default control procedure.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_Created
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Flag the control as being "created".
    LP_SKELETON_DEREF(hctl)->fCreated = TRUE;

    // Return the result from the default control procedure.
    return VBDefControlProc(hctl, hwnd, msg, wp, lp);

} // VBM_Created

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_GetProperty
//
// Description:   Processes the VBM_GETPROPERTY message. Sent by VB when it
//                requires the value of a property.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from the appropriate message function, or from
//                the default control procedure if the message is not
//                processed.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_GetProperty
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Process the property whose value is being obtained...
    switch (wp)
    {
        case IPROP_MYPROP2:
            return VBM_GetProperty_MyProp2(hctl, hwnd, msg, wp, lp);

        default:
            return VBDefControlProc(hctl, hwnd, msg, wp, lp);

    } // end switch on the property being obtained

} // VBM_GetProperty

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_GetProperty_MyProp2
//
// Description:   Processes the VBM_GETPROPERTY message for the MyProp2
//                property.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   0 to indicate success.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_GetProperty_MyProp2
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // TO DO: cast lp to a long pointer to the appropriate type, and use it to
    //        return the property's value. Then return 0L. The default control
    //        procedure is just called for the purposes of the skeleton code.

    return VBDefControlProc(hctl, hwnd, msg, wp, lp);

} // VBM_GetProperty_MyProp2

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_Help
//
// Description:   Processes the VBM_HELP message. Sent by VB when help (F1)
//                is requested for the current property, event or control.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from the appropriate help function, or from the
//                default control procedure if the message is not processed.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_Help
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Process the type of help being requested...
    switch (LOBYTE(wp))
    {
        case VBHELP_CTL:
            return VBM_HelpControl(hctl, hwnd, msg, wp, lp);

        case VBHELP_EVT:
            return VBM_HelpEvent(hctl, hwnd, msg, wp, lp);

        case VBHELP_PROP:
            return VBM_HelpProperty(hctl, hwnd, msg, wp, lp);

        default:
            return VBDefControlProc(hctl, hwnd, msg, wp, lp);

    } // end switch on the type of help being requested

} // VBM_Help

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_HelpControl
//
// Description:   Processes the VBM_HELP message for help on the control.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   0 to indicate success.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_HelpControl
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // TO DO: call WinHelp to display help for the control. This should result
    //        in the control's help contents page being displayed. (The
    //        message box below is simply used for the skeleton code.)

    MessageBox(0, "Help: contents", lpstrMsgBoxTitle, MB_OK);

    // Return 0 to indicate success.
    return 0L;

} // VBM_HelpControl

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_HelpEvent
//
// Description:   Processes the VBM_HELP message for help on the current
//                event.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   0 if processed (i.e. a custom event); the result from the
//                default control procedure otherwise.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_HelpEvent
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // TO DO: call WinHelp to display help for the current event. HIBYTE(wp)
    //        will contain the event's index. Normally, let standard events
    //        drop through for default processing. (The message box below is
    //        simply used for the skeleton code.)

    // Process the event help is being obtained for...
    switch (HIBYTE(wp))
    {
        case IEVENT_MYEVENT:
            MessageBox(0, "Help: MyEvent", lpstrMsgBoxTitle, MB_OK);
            return 0L;

        default:
            return VBDefControlProc(hctl, hwnd, msg, wp, lp);

    } // end switch on the event help is being obtained for

} // VBM_HelpEvent

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_HelpProperty
//
// Description:   Processes the VBM_HELP message for help on the current
//                event.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   0 if processed (i.e. a custom event); the result from the
//                default control procedure otherwise.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_HelpProperty
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // TO DO: call WinHelp to display help for the current property.
    //        HIBYTE(wp) will contain the property's index. Normally, let
    //        standard properties drop through for default processing. (The
    //        message boxes below are simply used for the skeleton code.) Note
    //        that help on the About property should result in the control's
    //        help contents page being displayed.

    // Process the property help is being obtained for...
    switch (HIBYTE(wp))
    {
        case IPROP_ABOUT:
            MessageBox(0, "Help: contents", lpstrMsgBoxTitle, MB_OK);
            return 0L;

        case IPROP_MYPROP1:
            MessageBox(0, "Help: MyProp1", lpstrMsgBoxTitle, MB_OK);
            return 0L;

        case IPROP_MYPROP2:
            MessageBox(0, "Help: MyProp2", lpstrMsgBoxTitle, MB_OK);
            return 0L;

        default:
            return VBDefControlProc(hctl, hwnd, msg, wp, lp);

    } // end switch on the property help is being obtained for

} // VBM_HelpProperty

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_Initialize
//
// Description:   Processes the VBM_INITIALIZE message. Called after the
//                control structure has been allocated (nothing else will have
//                been loaded or allocated).
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from the default control procedure.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_Initialize
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Zero out the control structure.
    _fmemset(LP_SKELETON_DEREF(hctl), 0, sizeof(SKELETON));

    // Flag the control as being "initialised".
    LP_SKELETON_DEREF(hctl)->fInitialised = TRUE;

    // Return the result from the default control procedure.
    return VBDefControlProc(hctl, hwnd, msg, wp, lp);

} // VBM_Initialize

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_InitPropPopup
//
// Description:   Processes the VBM_INITPROPPOPUP message. Sent by VB after a
//                property has been selected in the property window.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from the appropriate message function, or from
//                the default control procedure if the message is not
//                processed.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_InitPropPopup
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Process the property that has been selected...
    switch (wp)
    {
        case IPROP_ABOUT:
            return VBM_InitPropPopup_About(hctl, hwnd, msg, wp, lp);

        default:
            return VBDefControlProc(hctl, hwnd, msg, wp, lp);

    } // end switch on the property that has been selected

}  // VBM_InitPropPopup

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_InitPropPopup_About
//
// Description:   Processes the VBM_INITPROPPOPUP message for the About
//                property.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from CreateWindow().
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_InitPropPopup_About
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Create the about box's invisible controlling parent window, causing
    // the about box to be displayed.
    return CreateWindow(lpstrAboutBoxParent,    // class name
                        NULL,                   // window text
                        WS_POPUP,               // window style
                        0,                      // horizontal position
                        0,                      // vertical position
                        0,                      // width
                        0,                      // height
                        NULL,                   // parent
                        NULL,                   // child identifier
                        hmodDLL,                // application instance handle
                        NULL);                  // window creation data

} // VBM_InitPropPopup_About

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_Loaded
//
// Description:   Processes the VBM_LOADED message. Sent by VB after ALL the
//                controls on a form have been loaded.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from the default control procedure.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_Loaded
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Flag the control as being "loaded".
    LP_SKELETON_DEREF(hctl)->fLoaded = TRUE;

    // Return the result from the default control procedure.
    return VBDefControlProc(hctl, hwnd, msg, wp, lp);

} // VBM_Loaded

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_SetProperty
//
// DESCRIPTION:   Processes the VBM_SETPROPERTY message. Sent by VB to request
//                that a property be set to the specified value.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from the appropriate message function, or from
//                the default control procedure if the message is not
//                processed.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_SetProperty
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // Switch on the property whose value is being set...
    switch (wp)
    {
        case IPROP_MYPROP2:
            return VBM_SetProperty_MyProp2(hctl, hwnd, msg, wp, lp);

    } // end switch on the property being checked

    // Return the result from the default control procedure.
    return VBDefControlProc(hctl, hwnd, msg, wp, lp);

} // VBM_SetProperty

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: VBM_SetProperty_MyProp2
//
// Description:   Processes the VBM_SETPROPERTY message for the MyProp2
//                property.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   The result from the default control procedure.
//
//////////////////////////////////////////////////////////////////////////////

static LONG VBM_SetProperty_MyProp2
(
    HCTL   hctl,    // Visual Basic control handle
    HWND   hwnd,    // window handle
    USHORT msg,     // message
    USHORT wp,      // word parameter
    LONG   lp       // long parameter
)
{
    // TO DO: cast lp to a long pointer to the appropriate type, and use it to
    //        set the property's value. Then return 0L. The default control
    //        procedure is just called for the purposes of the skeleton code.

    return VBDefControlProc(hctl, hwnd, msg, wp, lp);

} // VBM_SetProperty_MyProp2

//////////////////////////////////////////////////////////////////////////////
//
// Function Name: WM_NCDestroy
//
// Description:   Processes the WM_NCDESTROY message. Sent by Windows when the
//                control (i.e. its window) is being destroyed.
//
// Parameters:    hctl - Visual Basic control handle
//                hwnd - window handle
//                msg  - message
//                wp   - word parameter
//                lp   - long parameter
//
// Return Code:   0 to indicate that the message was processed.
//
//////////////////////////////////////////////////////////////////////////////

static LONG WM_NCDestroy
(
    HCTL       hctl,    // Visual Basic control handle
    HWND       hwnd,    // window handle
    USHORT, // msg,     // message
    USHORT, // wp,      // word parameter
    LONG    // lp       // long parameter
)
{
    // Destroy the HSZ property(ies).
    if (LP_SKELETON_DEREF(hctl)->hszMyProp1 != (HSZ)NULL)
        VBDestroyHsz(LP_SKELETON_DEREF(hctl)->hszMyProp1);

    // Return 0 to indicate that the message has been processed.
    return 0L;

} // WM_NCDestroy

