
//////////////////////////////////////////////////////////////////////////////
//
// Filename:     skeldat.cpp
//
// Description:  Skeleton Visual Basic Custom Control.
//
//               Control global data.
//
// Date Created: <Date>
//
// Author:       <Your Name>
//
// Copyright (c) <Your Company Name> 1994
//
//               Portions of this product are based on original
//                  source code from Anton Software Limited.
//
//////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <vbapi.h>

#include "skeleton.hpp"
#include "skelexp.hpp"
#include "skelext.hpp"

//////////////////////////////////////////////////////////////////////////////
//
// DLL (VBX) module handle
//
//////////////////////////////////////////////////////////////////////////////
HANDLE hmodDLL = (HANDLE)NULL;

//////////////////////////////////////////////////////////////////////////////
//
// Message Box title
//
//////////////////////////////////////////////////////////////////////////////
LPSTR lpstrMsgBoxTitle = "Skeleton Custom Control";

//////////////////////////////////////////////////////////////////////////////
//
// About box parent window's class name
//
//////////////////////////////////////////////////////////////////////////////
LPSTR lpstrAboutBoxParent = "SkeletonAboutParent";

//////////////////////////////////////////////////////////////////////////////
//
// Property information
//
//////////////////////////////////////////////////////////////////////////////

static PROPINFO NEAR propinfoAbout =
{
    "(About)",              // property name
                            // property flags:
    DT_ENUM        |        //   ENUM - about box popup
    PF_fNoRuntimeR |        //   data cannot be read at run-time
    PF_fNoRuntimeW,         //   data cannot be changed at run-time

    OFFSETIN(SKELETON,
             enumAbout),    // offset in SKELETON structure
    0,                      // infodata - for packing (not used)
    0,                      // default value (not used)
    "Click on \"...\""
    " for About Box\0",     // property box string
    0                       // maximum value (not used)

}; // propinfoAbout

// TO DO: Use propinfoMyProp1 as a template for your custom HSZ properties.

static PROPINFO NEAR propinfoMyProp1 =
{
    "MyProp1",              // property name
                            // property flags:
    DT_HSZ       |          //   property type (string)
    PF_fGetData  |          //   VB gets value directly
    PF_fSaveData |          //   VB saves value to disk directly
    PF_fSetData  |          //   VB sets value directly
    PF_fSetCheck |          //   VB sends a message before setting value
    PF_fSetMsg,             //   VB sends msg when setting prop. is attempted

    OFFSETIN(SKELETON,
             hszMyProp1),   // offset in control structure
    0,                      // infodata - for packing (not used)
    0,                      // default value (not used)
    NULL,                   // property box strings (not used)
    0                       // maximum value (not used)

}; // propinfoMyProp1

// TO DO: Use propinfoMyProp2 as a template for your other custom properties.

static PROPINFO NEAR propinfoMyProp2 =
{
    "MyProp2",              // property name
                            // property flags:
    DT_ENUM      |          //   property type (enumerated integer)
    PF_fGetData  |          //   VB gets value directly
    PF_fGetMsg   |          //   VB sends msg when getting prop. is attempted
    PF_fSaveData |          //   VB saves value to disk directly
    PF_fSetData  |          //   VB sets value directly
    PF_fSetMsg,             //   VB sends msg when setting prop. is attempted

    OFFSETIN(SKELETON,
             enumMyProp2),  // offset in control structure
    0,                      // infodata - for packing (not used)
    0,                      // default value

      "0 - First Value\0"   // property box strings
      "1 - Second Value\0"
      "2 - Third Value\0"

    "",
    0                       // maximum value (not used)

}; // propinfoMyProp2

//////////////////////////////////////////////////////////////////////////////
//
// Property list
//
//////////////////////////////////////////////////////////////////////////////

static PPROPINFO NEAR proplistSkeleton[] =
{
    // TO DO: choose the standard properties you want your control to have,
    //        and delete the unwanted properties from the list below. (You
    //        will have to make a similar change in the skeleton.hpp file.)

    // Standard properties.
    PPROPINFO_STD_NAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_ALIGN,
    PPROPINFO_STD_BACKCOLOR,
    PPROPINFO_STD_BORDERSTYLEON,
    PPROPINFO_STD_CLIPCONTROLS,
    PPROPINFO_STD_DATACHANGED,
    PPROPINFO_STD_DATAFIELD,
    PPROPINFO_STD_DATASOURCE,
    PPROPINFO_STD_DRAGICON,
    PPROPINFO_STD_DRAGMODE,
    PPROPINFO_STD_ENABLED,
    PPROPINFO_STD_FONTBOLD,
    PPROPINFO_STD_FONTITALIC,
    PPROPINFO_STD_FONTNAME,
    PPROPINFO_STD_FONTSIZE,
    PPROPINFO_STD_FONTSTRIKE,
    PPROPINFO_STD_FONTUNDER,
    PPROPINFO_STD_FORECOLOR,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_HELPCONTEXTID,
    PPROPINFO_STD_HWND,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_LINKITEM,
    PPROPINFO_STD_LINKMODE,
    PPROPINFO_STD_LINKTIMEOUT,
    PPROPINFO_STD_LINKTOPIC,
    PPROPINFO_STD_MOUSEPOINTER,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_TABINDEX,
    PPROPINFO_STD_TABSTOP,
    PPROPINFO_STD_TAG,
    PPROPINFO_STD_TEXT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_WIDTH,

    // TO DO: choose the custom properties you want your control to have. Use
    //        MyProp1 and MyProp2 as templates for these new properties. (You
    //        will have to make a similar change in the skeleton.hpp file.)

    // Custom properties.
    &propinfoAbout,
    &propinfoMyProp1,
    &propinfoMyProp2,
    NULL

}; // proplistSkeleton

//////////////////////////////////////////////////////////////////////////////
//
// Event information
//
//////////////////////////////////////////////////////////////////////////////

// TO DO: Use ParamTypesMyEvent as a template for the event parameter
//        structures of your custom events.

static WORD NEAR ParamTypesMyEvent[] =
{
    ET_I4, // Param1
    ET_I2  // Param2

}; // ParamTypesMyEvent

// TO DO: Use eventinfoMyEvent as a template for your custom events.

static EVENTINFO NEAR eventinfoMyEvent =
{
    "MyEvent",                  // event name
    2,                          // number of arguments
    4,                          // number of words in argument list
    ParamTypesMyEvent,          // argument type array

      "Param1 As Long, "        // argument string
      "Param2 As Integer"

}; // eventinfoMyEvent

//////////////////////////////////////////////////////////////////////////////
//
// Event list
//
//////////////////////////////////////////////////////////////////////////////

static PEVENTINFO NEAR eventlistSkeleton[] =
{
    // TO DO: choose the standard events you want your control to have, and
    //        delete the unwanted events from the list below. (You will have
    //        to make a similar change in the skeleton.hpp file.)

    // Standard events.
    PEVENTINFO_STD_CLICK,
    PEVENTINFO_STD_DBLCLICK,
    PEVENTINFO_STD_DRAGDROP,
    PEVENTINFO_STD_DRAGOVER,
    PEVENTINFO_STD_GOTFOCUS,
    PEVENTINFO_STD_KEYDOWN,
    PEVENTINFO_STD_KEYPRESS,
    PEVENTINFO_STD_KEYUP,
    PEVENTINFO_STD_LOSTFOCUS,
    PEVENTINFO_STD_MOUSEDOWN,
    PEVENTINFO_STD_MOUSEMOVE,
    PEVENTINFO_STD_MOUSEUP,
    PEVENTINFO_STD_LINKERROR,
    PEVENTINFO_STD_LINKOPEN,
    PEVENTINFO_STD_LINKCLOSE,
    PEVENTINFO_STD_LINKNOTIFY,
    PEVENTINFO_STD_LINKCHANGE,

    // TO DO: choose the custom events you want your control to have. Use
    //        MyEvent as a template for these new events. (You will have
    //        to make a similar change in the skeleton.hpp file.)

    // Custom events.
    &eventinfoMyEvent,
    NULL

}; // eventlistSkeleton

//////////////////////////////////////////////////////////////////////////////
//
// Model list
//
//////////////////////////////////////////////////////////////////////////////

static LPMODEL NEAR modellistSkeleton[] =
{
    &modelSkeleton,
    NULL
};

//////////////////////////////////////////////////////////////////////////////
//
// Model information
//
//////////////////////////////////////////////////////////////////////////////

MODELINFO NEAR modelinfoSkeleton =
{
    VB200_VERSION,          // Visual Basic version being used (minimum)
    modellistSkeleton       // MODEL list
};

//////////////////////////////////////////////////////////////////////////////
//
// Model structure
//
//////////////////////////////////////////////////////////////////////////////

MODEL NEAR modelSkeleton =
{
    VB200_VERSION,              // Visual Basic version (minimum)

                                // MODEL flags:

    // TO DO: choose the model flags appropriate for your control from the
    //        list below. Do not remove the fLoadMsg and fInitMsg flags.

/*    MODEL_fArrows      |      //   gets messages for arrow keys     */
/*    MODEL_fChildrenOk  |      //   may contain child controls       */
/*    MODEL_fDesInteract |      //   gets right mouse button messages */
/*    MODEL_fFocusOk     |      //   can get focus at run time        */
/*    MODEL_fGraphical   |      //   graphical control (no hWnd)      */
/*    MODEL_fInvisAtRun  |      //   only displayed at design time    */
/*    MODEL_fMnemonic    |      //   gets mnemonic messages           */

      MODEL_fLoadMsg     |      //   gets created and load messages
      MODEL_fInitMsg,           //   gets initialisation messages

    (PCTLPROC)SkeletonCtlProc,  // control procedure
    0,                          // class style (not used)
    0L,                         // default Window style (not used)
    sizeof(SKELETON),           // cbCtlExtra for Skeleton structure
    IDBMP_SKELETON,             // palette bitmap ID
    "Skeleton",                 // default control name
    "Skeleton",                 // Visual Basic class name

    // TO DO: choose the parent class name for your control from the list
    //        below. Use NULL if your control is not a subclassed standard
    //        control.

    NULL,                       // parent class name (not used)

/*  "BUTTON",                   // parent class name */
/*  "COMBOBOX",                 // parent class name */
/*  "EDIT",                     // parent class name */
/*  "LISTBOX",                  // parent class name */
/*  "SCROLLBAR",                // parent class name */
/*  "STATIC",                   // parent class name */

    proplistSkeleton,           // properties list
    eventlistSkeleton,          // events list
    IPROP_NAME,                 // default property
    IEVENT_MYEVENT,             // default event
    IPROP_MYPROP1               // property representing value of control

}; // modelSkeleton

