VERSION 2.00
Begin Form frmComp 
   Caption         =   "Composite Shapes"
   ClientHeight    =   5790
   ClientLeft      =   2445
   ClientTop       =   1485
   ClientWidth     =   7365
   ControlBox      =   0   'False
   FillColor       =   &H00FFFF00&
   Height          =   6195
   Left            =   2385
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5790
   ScaleWidth      =   7365
   Top             =   1140
   Width           =   7485
   Begin VScrollBar vsbValue 
      Height          =   4815
      LargeChange     =   10
      Left            =   6720
      Max             =   0
      Min             =   100
      TabIndex        =   0
      Top             =   480
      Value           =   70
      Width           =   255
   End
   Begin Label txtMin 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Times New Roman"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   4440
      TabIndex        =   2
      Top             =   2040
      Width           =   375
   End
   Begin Label txtMax 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "100"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Times New Roman"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   255
      Left            =   5640
      TabIndex        =   1
      Top             =   2040
      Width           =   375
   End
   Begin SCGraphic scgGaugeArrow 
      AngleEnd        =   45
      AngleStart      =   -90
      ArrowSize       =   4  '4
      ArrowType       =   1  'Forward
      FillColor       =   &H00808080&
      FillColor2      =   &H00000000&
      FillPattern     =   0  'Solid
      Height          =   2055
      Left            =   4200
      LineColor       =   &H0000FFFF&
      LinePattern     =   0  'Solid
      LineWidth       =   30
      MouseEvents     =   -1  'True
      NumPoints       =   2
      PaletteSteps    =   20
      RoundRadius     =   0
      SelectByInk     =   0   'False
      ShadowColor     =   &H00000000&
      ShadowDepthX    =   0
      ShadowDepthY    =   0
      Shape           =   2  'Polyline
      ShowOutlineOnly =   0   'False
      Top             =   480
      Use256Palette   =   -1  'True
      Width           =   2055
   End
   Begin SCGraphic scgGaugeBack 
      AngleEnd        =   45
      AngleStart      =   -90
      ArrowSize       =   2  'Small
      ArrowType       =   0  'None
      FillColor       =   &H00404000&
      FillColor2      =   &H00C0C000&
      FillPattern     =   16  'Graduated Vertical
      Height          =   2055
      Left            =   4200
      LineColor       =   &H00FF80FF&
      LinePattern     =   0  'Solid
      LineWidth       =   30
      MouseEvents     =   -1  'True
      NumPoints       =   0
      PaletteSteps    =   40
      RoundRadius     =   0
      SelectByInk     =   0   'False
      ShadowColor     =   &H00000000&
      ShadowDepthX    =   100
      ShadowDepthY    =   100
      Shape           =   1  'Ellipse
      ShowOutlineOnly =   0   'False
      Top             =   480
      Use256Palette   =   -1  'True
      Width           =   2055
   End
   Begin SCGraphic scgCastFront 
      AngleEnd        =   45
      AngleStart      =   -90
      ArrowSize       =   2  'Small
      ArrowType       =   0  'None
      FillColor       =   &H0000FFFF&
      FillColor2      =   &H00008080&
      FillPattern     =   17  'Graduated Horizontal
      Height          =   3255
      Left            =   2760
      LineColor       =   &H00C000C0&
      LinePattern     =   5  'Transparent
      LineWidth       =   15
      MouseEvents     =   -1  'True
      NumPoints       =   0
      PaletteSteps    =   20
      RoundRadius     =   0
      SelectByInk     =   0   'False
      ShadowColor     =   &H00000000&
      ShadowDepthX    =   0
      ShadowDepthY    =   0
      Shape           =   0  'Rectangle
      ShowOutlineOnly =   0   'False
      Top             =   2040
      Use256Palette   =   -1  'True
      Width           =   735
   End
   Begin SCGraphic scgCastShad 
      AngleEnd        =   45
      AngleStart      =   -90
      ArrowSize       =   2  'Small
      ArrowType       =   0  'None
      FillColor       =   &H00800000&
      FillColor2      =   &H00000000&
      FillPattern     =   16  'Graduated Vertical
      Height          =   2535
      Left            =   2760
      LineColor       =   &H00FF0000&
      LinePattern     =   5  'Transparent
      LineWidth       =   15
      MouseEvents     =   -1  'True
      NumPoints       =   4
      PaletteSteps    =   20
      RoundRadius     =   0
      SelectByInk     =   0   'False
      ShadowColor     =   &H00000000&
      ShadowDepthX    =   0
      ShadowDepthY    =   0
      Shape           =   3  'Polygon
      ShowOutlineOnly =   0   'False
      Top             =   2760
      Use256Palette   =   -1  'True
      Width           =   1935
   End
   Begin SCGraphic scgCylTop 
      AngleEnd        =   45
      AngleStart      =   -90
      ArrowSize       =   2  'Small
      ArrowType       =   0  'None
      FillColor       =   &H00FF00FF&
      FillColor2      =   &H00000000&
      FillPattern     =   0  'Solid
      Height          =   255
      Left            =   960
      LineColor       =   &H00FF00FF&
      LinePattern     =   5  'Transparent
      LineWidth       =   15
      MouseEvents     =   -1  'True
      NumPoints       =   0
      PaletteSteps    =   20
      RoundRadius     =   0
      SelectByInk     =   0   'False
      ShadowColor     =   &H00000000&
      ShadowDepthX    =   0
      ShadowDepthY    =   0
      Shape           =   1  'Ellipse
      ShowOutlineOnly =   0   'False
      Top             =   1680
      Use256Palette   =   -1  'True
      Width           =   975
   End
   Begin SCGraphic scgCylLeft 
      AngleEnd        =   45
      AngleStart      =   -90
      ArrowSize       =   2  'Small
      ArrowType       =   0  'None
      FillColor       =   &H00808080&
      FillColor2      =   &H00000000&
      FillPattern     =   17  'Graduated Horizontal
      Height          =   3495
      Left            =   960
      LineColor       =   &H00FF0000&
      LinePattern     =   5  'Transparent
      LineWidth       =   15
      MouseEvents     =   -1  'True
      NumPoints       =   4
      PaletteSteps    =   20
      RoundRadius     =   0
      SelectByInk     =   0   'False
      ShadowColor     =   &H00000000&
      ShadowDepthX    =   0
      ShadowDepthY    =   0
      Shape           =   3  'Polygon
      ShowOutlineOnly =   0   'False
      Top             =   1800
      Use256Palette   =   -1  'True
      Width           =   495
   End
   Begin SCGraphic scgCylRight 
      AngleEnd        =   45
      AngleStart      =   -90
      ArrowSize       =   2  'Small
      ArrowType       =   0  'None
      FillColor       =   &H00808080&
      FillColor2      =   &H00000000&
      FillPattern     =   17  'Graduated Horizontal
      Height          =   3495
      Left            =   1440
      LineColor       =   &H00FF0000&
      LinePattern     =   5  'Transparent
      LineWidth       =   15
      MouseEvents     =   -1  'True
      NumPoints       =   4
      PaletteSteps    =   20
      RoundRadius     =   0
      SelectByInk     =   0   'False
      ShadowColor     =   &H00000000&
      ShadowDepthX    =   0
      ShadowDepthY    =   0
      Shape           =   3  'Polygon
      ShowOutlineOnly =   0   'False
      Top             =   1800
      Use256Palette   =   -1  'True
      Width           =   495
   End
   Begin SCGraphic scgCompBkg 
      AngleEnd        =   45
      AngleStart      =   -90
      ArrowSize       =   2  'Small
      ArrowType       =   0  'None
      FillColor       =   &H00800000&
      FillColor2      =   &H00000000&
      FillPattern     =   0  'Solid
      Height          =   6000
      Left            =   0
      LineColor       =   &H00FF0000&
      LinePattern     =   5  'Transparent
      LineWidth       =   15
      MouseEvents     =   -1  'True
      NumPoints       =   0
      PaletteSteps    =   80
      RoundRadius     =   0
      SelectByInk     =   0   'False
      ShadowColor     =   &H00000000&
      ShadowDepthX    =   0
      ShadowDepthY    =   0
      Shape           =   0  'Rectangle
      ShowOutlineOnly =   0   'False
      Top             =   0
      Use256Palette   =   -1  'True
      Width           =   7500
   End
End
Option Explicit
' Statically record the bottom and top positions of the
' composite shapes.  They are tied to the location of the
' scroll bar in the Load event.
Dim iCylBottom As Integer, iCylMaxLoc As Integer

' Draw the Cast Shadow component shape.  scgCastFont is the
' front (rectangular) shape.  scgCastShad is the shadow
' shape, which is a polyline.  iValue is a number between
' 0 and 100 indicating how high to draw the shape.
' The two shapes need to be positioned at design-time so
' their lower-left corners are congruent.
Sub DrawCastShad (scgCastFront As SCGraphic, scgCastShad As SCGraphic, ByVal iValue As Integer)
    Const ANGLE = 50 * PI / 180  ' angle of the cast shadow (in radians)
    Dim iTop As Integer, iHeight As Integer, iWidth As Integer, iLeft As Integer
    Dim fWidthRatio As Single
    ' make the shapes invisible while we change various
    ' properties to avoid flashing
    scgCastFront.Visible = False
    scgCastShad.Visible = False
    ' stretch the front rect into its new position
    ' where iValue is the percentage of its maximum height
    iTop = iCylBottom - iValue / 100# * (iCylBottom - iCylMaxLoc)
    iWidth = scgCastFront.Width
    iLeft = scgCastFront.Left
    iHeight = iCylBottom - iTop
    ' we don't really need iLeft and iWidth, but using Move
    ' is better than setting Top and Height properties individually
    scgCastFront.Move iLeft, iTop, iWidth, iHeight
    ' compute the containing rectangle for the cast shadow
    iWidth = scgCastFront.Width + iHeight * Cos(ANGLE)
    iHeight = iHeight * Sin(ANGLE)
    scgCastShad.Move iLeft, iCylBottom - iHeight, iWidth, iHeight
    ' calculate the ratio of the width of the rectangle
    ' to the shadow to position the polygon points
    fWidthRatio = scgCastFront.Width / iWidth
    scgCastShad.PointX(0) = 0
    scgCastShad.PointY(0) = 1000
    scgCastShad.PointX(1) = 1000 * fWidthRatio
    scgCastShad.PointY(1) = 1000
    scgCastShad.PointX(2) = 1000
    scgCastShad.PointY(2) = 0
    scgCastShad.PointX(3) = 1000 * (1 - fWidthRatio)
    scgCastShad.PointY(3) = 0
    ' make the shapes visible agaon
    scgCastFront.Visible = True
    scgCastShad.Visible = True
End Sub

' Draw the Cylinder composite shape.  scgCylTop is the ellipse
' at the top of the cylinder.  scgCylLeft/Right are the two
' polylines that make up the two shaded halves of the cylinder.
' iValue is a number between 0 and 100 indicating how high
' to draw the cylinder.
' The three shapes must be positioned at design-time as
' shown in the sample form.
Sub DrawCylinder (scgCylTop As SCGraphic, scgCylLeft As SCGraphic, scgCylRight As SCGraphic, ByVal iValue As Integer)
Dim iTop As Integer, iDepth As Integer, iHeight As Integer, fHeightPercent As Single
Dim lColor As Long
    ' Make the cylinder invisible while we change various
    ' properties to avoid flashing.  See the VB manual on
    ' p. 329 regarding the Move method and jerky motion.
    scgCylTop.Visible = False
    scgCylLeft.Visible = False
    scgCylRight.Visible = False
    ' move the ellipse at the top of the cylinder into its new position
    ' where iValue is the percentage of its maximum height
    iTop = iCylBottom - iValue / 100# * (iCylBottom - iCylMaxLoc)
    iDepth = scgCylTop.Height
    lColor = scgCylTop.FillColor
    ' because of the perspective, we lose a little of the value range, so adjust
    If iTop > iCylBottom - iDepth * 1.1 Then iTop = iCylBottom - iDepth * 1.1
    scgCylTop.Top = iTop
    ' adjust the top and height of the sides of the cylinder to match
    ' the new position of the ellipse at the top (attach at the center)
    iTop = iTop + iDepth / 2
    iHeight = iCylBottom - iTop  ' iCylBottom is a global, fixed position
    ' using Move is better than setting Top and Height properties individually
    scgCylLeft.Move scgCylLeft.Left, iTop, scgCylLeft.Width, iHeight
    scgCylRight.Move scgCylRight.Left, iTop, scgCylRight.Width, iHeight
    ' find the percentage of the height of the ellipse to the side
    fHeightPercent = iDepth / iHeight / 2#
    ' position the left side with correct Bezier handles
    scgCylLeft.PointX(0) = 0
    scgCylLeft.PointY(0) = 0
    scgCylLeft.PointX(1) = 1000
    scgCylLeft.PointY(1) = 0
    scgCylLeft.PointX(2) = 1000
    scgCylLeft.PointY(2) = 1000
    scgCylLeft.PointXOffsetOut(2) = -BEZCONIC
    scgCylLeft.PointX(3) = 0
    scgCylLeft.PointY(3) = 1000 * (1 - fHeightPercent)
    scgCylLeft.PointYOffsetIn(3) = BEZCONIC * fHeightPercent
    scgCylLeft.FillColor2 = BetweenColor(lColor, BLACK, 10)
    scgCylLeft.FillColor = BetweenColor(lColor, BLACK, 50)
    ' now do the right side
    scgCylRight.PointX(0) = 1000
    scgCylRight.PointY(0) = 0
    scgCylRight.PointX(1) = 0
    scgCylRight.PointY(1) = 0
    scgCylRight.PointX(2) = 0
    scgCylRight.PointY(2) = 1000
    scgCylRight.PointXOffsetOut(2) = BEZCONIC
    scgCylRight.PointX(3) = 1000
    scgCylRight.PointY(3) = 1000 * (1 - fHeightPercent)
    scgCylRight.PointYOffsetIn(3) = BEZCONIC * fHeightPercent
    scgCylRight.FillColor = BetweenColor(lColor, BLACK, 10)
    scgCylRight.FillColor2 = BetweenColor(lColor, BLACK, 50)
    ' make the cylinder visible again
    scgCylTop.Visible = True
    scgCylLeft.Visible = True
    scgCylRight.Visible = True
End Sub

' Draw the analog gauge.  scgGaugeBack is the background
' circle of the gauge.  scgGaugeArrow is the arrow pointer
' indicating the current value.  iValue is a number between
' 0 and 100 indicating the location of the arrow pointer.
' The two shapes must be positioned at design time.  The
' arrow shape should be the identical location and size of
' the background circle.
Sub DrawGauge (scgGaugeBack As SCGraphic, scgGaugeArrow As SCGraphic, ByVal iValue As Integer)
    Const MINANGLE = 225 * PI / 180  ' arrow angle corresponding to the 0 value
    Const MAXANGLE = -45 * PI / 180  ' arrow angle corresponding to the 100 value
    Const SPREAD = MAXANGLE - MINANGLE
    ' make the shapes invisible while we change various
    ' properties to avoid flashing
    scgGaugeBack.Visible = False
    scgGaugeArrow.Visible = False
    ' set the arrow angle according to the value
    scgGaugeArrow.PointX(0) = 500    ' the base of the arrow is at the center
    scgGaugeArrow.PointY(0) = 500
    scgGaugeArrow.PointX(1) = 500 + 450 * Cos(MINANGLE + SPREAD * (iValue / 100#))
    scgGaugeArrow.PointY(1) = 500 - 450 * Sin(MINANGLE + SPREAD * (iValue / 100#))
    ' make the shapes visible agaon
    scgGaugeBack.Visible = True
    scgGaugeArrow.Visible = True
End Sub

Sub Form_Load ()
    ' keep the bottom of the cylinder fixed at the bottom of the scroll bar
    iCylBottom = vsbValue.Top + vsbValue.Height
    ' let the cylinder grow to the height of the scroll bar
    iCylMaxLoc = vsbValue.Top
    ' simulate a scroll bar change to draw the initial screen
    vsbValue_Change
End Sub

Sub vsbValue_Change ()
    DrawCylinder scgCylTop, scgCylLeft, scgCylRight, vsbValue.Value
    DrawCastShad scgCastFront, scgCastShad, vsbValue.Value
    DrawGauge scgGaugeBack, scgGaugeArrow, vsbValue.Value
End Sub

