Option Explicit
' Colors from CONSTANT.TXT
Global Const BLACK = &H0&
Global Const RED = &HFF&
Global Const GREEN = &HFF00&
Global Const YELLOW = &HFFFF&
Global Const BLUE = &HFF0000
Global Const MAGENTA = &HFF00FF
Global Const CYAN = &HFFFF00
Global Const WHITE = &HFFFFFF

' Bezier Constant for approximating conic sections
Global Const BEZCONIC = 551.92
Global Const BEZAUTO = 32760

Global Const PI = 3.14159265

' Declaration of the exported function (like a method) for high-quality printing of SCGraphic controls
Declare Sub PrintSCG Lib "scgrphic.vbx" (hCtl As Control, ByVal hDC As Integer, ByVal xOrg As Integer, ByVal yOrg As Integer)

' Compute a color that is an interpolation of two other
' colors.  The return value is a color that is percent
' of the way between col1 and col2.
Function BetweenColor (col1 As Long, col2 As Long, percent As Integer)
    Dim R1, G1, B1, R2, G2, B2
    R1 = col1 Mod 256
    G1 = col1 \ 256 Mod 256
    B1 = col1 \ 65536 Mod 256
    R2 = col2 Mod 256
    G2 = col2 \ 256 Mod 256
    B2 = col2 \ 65536 Mod 256
    R1 = R1 + (R2 - R1) * percent / 100
    G1 = G1 + (G2 - G1) * percent / 100
    B1 = B1 + (B2 - B1) * percent / 100
    BetweenColor = RGB(R1, G1, B1)
End Function

' Print a form outline in the center of the page and then
' print all of the SCGraphic controls on the form
Sub PrintFrm (frm As Form)
    Dim nCtl As Integer
    ' center the form on the page
    Printer.ScaleLeft = -(Printer.Width - frm.Width) / 2
    Printer.ScaleTop = -(Printer.Height - frm.Height) / 2
    Printer.Line (0, 0)-Step(frm.Width - 120, frm.Height - 420), , B  ' adjust Height and Width for title bar and borders if desired
    ' At least one Printer method (such as Line above) must
    ' be used before calling PrintSCG to ensure a valid hDC.
    For nCtl = frm.Controls.Count - 1 To 0 Step -1
        ' Kludge:  Can't figure out how to get the Zorder to
        ' sort overlapping controls, but this reverse control order works for the demo
        If TypeOf frm.Controls(nCtl) Is SCGraphic Then
            PrintSCG frm.Controls(nCtl), Printer.hDC, Printer.ScaleLeft, Printer.ScaleTop
        End If
    Next nCtl
    Printer.EndDoc
End Sub

