' -----------------------------------------------------------------------------------------
' Application Profile Routines for Microsoft Visual Basic
' -----------------------------------------------------------------------------------------
'
' The routines contained in this module permit simple manipulation of the application
' profile entries maintained by Windows in the WIN.INI file.  See each routine for usage
' information.
'
' The code contained in these routines is hereby released to the public domain.  It may
' be freely used, modified, and/or distributed.  The author accepts no responsibility for
' the use/misue of these routines.
'
' Author  :  Rob Vance  (CIS: 70003,5674)
' Version :  1.00
' Created :  July 16, 1991
' Released:  July 19, 1991
'------------------------------------------------------------------------------------------
'

'
'  User Profile Routines (provided by the Microsoft Windows Kernel DLL)
'
Declare Function GetProfileInt Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal nDefault As Integer) As Integer
Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer
Declare Function WriteProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String) As Integer
Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lplFileName As String) As Integer
Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function GetSystemDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer

Const MAX_STRING_LEN = 255

Function Get_Profile_String (AppName$, KeyName$, KeyDefault$, KeyValue$) As Integer
    '
    ' -- Get the profile entry specified, returning the string in KeyValue$ and the length
    '    of the string in the function name.  If the profile entry is not found, then the
    '    default string is returned.
    '
    '    Profile entries are generally stored in the WIN.INI file in the \WINDOWS directory
    '    and have the following format:
    '
    '    [application name]
    '    ProfileEntry=Stringval
    '        :
    '        :
    '
    '    Parameters:
    '        AppName$       Corresponds to the [application name]
    '        KeyName$       Name of the profile entry to retrieve (ProfileEntry)
    '        KeyDefault$    Value to be returned if profile entry cannot be retreived
    '        KeyValue$      Return value; stringval if located, KeyDefault$ if not found.
    '
    '    Note:
    '        The maximum string length retreivable by this routine is set to MAX_STRING_LEN
    '        (see module declarations).
    '
    KeyValue$ = Space$(MAX_STRING_LEN)
    Get_Profile_String = GetProfileString(AppName$, KeyName$, KeyDefault$, KeyValue$, Len(KeyValue$))
    KeyValue$ = LTrim$(RTrim$(KeyValue$))

    ' -- Strip the trailing NULL character from the string (it tends to make string comparisons
    '    more difficult when it is left on)
    '
    KeyValue$ = Mid$(KeyValue$, 1, Len(KeyValue$) - 1)
End Function

Function Put_Profile_String (AppName$, KeyName$, KeyValue$)
    '
    ' -- Store the profile entry specified.  If the profile entry is found, its corresponding
    '    value is updated, otherwise the profile entry is created.  This function returns
    '    TRUE if the update was successful, otherwise FALSE.
    '
    '    Profile entries are generally stored in the WIN.INI file in the \WINDOWS directory
    '    and have the following format:
    '
    '    [application name]
    '    ProfileEntry=Stringval
    '        :
    '        :
    '
    '    Parameters:
    '        AppName$       Corresponds to the [application name]
    '        KeyName$       Name of the profile entry to write (ProfileEntry)
    '        KeyValue$      New value for the profile entry (Stringval)
    '
    '
    status% = WriteProfileString(AppName$, KeyName$, KeyValue$)

    If (status% <> 0) Then
        Put_Profile_String = TRUE
    Else
        Put_Profile_String = FALSE
    End If
End Function

