Global Const ProgTitle = "Steve's ProgMan Info"

Type GroupHeader
  Name As String
  NumItems As Integer
End Type

Type GroupInfo
  Parent As Integer
  Name As String
  CommandLine As String
  DefaultDir As String
  IconPath As String
  MinFlag As Integer
End Type

Type MasterGroup
  Name As String
  Level As Integer
End Type

Global GroupList() As GroupHeader
Global GroupInfoList() As GroupInfo
Global MasterList() As MasterGroup

'Word 6 document name
Global Const DOC_NAME = "PMINFO.DOC"

'Word 6 document object
Global OhMyWord As Object

'window state
Global Const WINDOW_MINIMIZED = 1

'dde link
Global Const COLD_LINK = 2

'dialog box stuff
Global Const YES_NO_QUESTION = 36
Global Const NO = 7


Sub CenterForm (SForm As Form)

SForm.Top = (Screen.Height - SForm.Height) / 2
SForm.Left = (Screen.Width - SForm.Width) / 2

End Sub

Function FillGroupInfoList (GroupNum As Integer) As Integer

Dim FirstPos As Integer
Dim NextPos As Integer
Dim Looper As Integer
Dim MyText As String
Dim Minimized As Integer

On Error GoTo FillGroupInfoError

'set initial value
FillGroupInfoList = False

'get the text from the text box
MyText = PMMainForm.DDEText.Text

'find the first comma (chr$(44) is a comma)
FirstPos = InStr(1, MyText, Chr$(44))

'find the next comma
FirstPos = InStr(FirstPos + 1, MyText, Chr$(44))
'find the third comma
NextPos = InStr(FirstPos + 1, MyText, Chr$(44))

'get the number of group items; start from the character after the 2nd comma, and
'take the number of characters up to but not including the third comma
GroupList(GroupNum).NumItems = Val(Mid$(MyText, FirstPos + 1, NextPos - FirstPos - 1))

'find the start of the second line, after the first set of quote marks
FirstPos = InStr(1, MyText, Chr$(10)) + 2

'iterate through the number of items for this group
For Looper = 1 To GroupList(GroupNum).NumItems
  'bump our group info array by one
  ReDim Preserve GroupInfoList(UBound(GroupInfoList) + 1)
  
  'set the group parent
  GroupInfoList(UBound(GroupInfoList)).Parent = GroupNum

  'find the trailing quote of the icon name
  NextPos = InStr(FirstPos, MyText, Chr$(34))

  'add the icon name to the group info array
  GroupInfoList(UBound(GroupInfoList)).Name = Mid$(MyText, FirstPos, NextPos - FirstPos)

  'set the new starting position - the last quote, plus the comma, plus the next quote
  FirstPos = NextPos + 3

  'find the trailing quote of the command line
  NextPos = InStr(FirstPos, MyText, Chr$(34))

  'add the command line info to the array
  GroupInfoList(UBound(GroupInfoList)).CommandLine = Mid$(MyText, FirstPos, NextPos - FirstPos)

  'set the new starting postion - the last quote, plus the comma
  FirstPos = NextPos + 2

  'find the next comma
  NextPos = InStr(FirstPos, MyText, Chr$(44))

  'add the default directory information to the array
  GroupInfoList(UBound(GroupInfoList)).DefaultDir = Mid$(MyText, FirstPos, NextPos - FirstPos)

  'set the new starting position - the last comma, plus one
  FirstPos = NextPos + 1

  'find the next comma
  NextPos = InStr(FirstPos, MyText, Chr$(44))
  
  'add the icon path to the array
  GroupInfoList(UBound(GroupInfoList)).IconPath = Mid$(MyText, FirstPos, NextPos - FirstPos)

  'find the end of the line
  FirstPos = InStr(NextPos, MyText, Chr$(13))

  'set the minimize flag
  Minimized = Val(Mid$(MyText, FirstPos - 1, 1))

  If Minimized = 0 Then
    GroupInfoList(UBound(GroupInfoList)).MinFlag = False
  Else
    GroupInfoList(UBound(GroupInfoList)).MinFlag = True
  End If

  'set the starting position to the beginning of the next line
  FirstPos = FirstPos + 3

Next Looper

'return success!
FillGroupInfoList = True

FillGroupInfoResume:
Exit Function

FillGroupInfoError:
Resume FillGroupInfoResume

End Function

Function FillGroupList () As Integer

On Error GoTo FillGroupListError

Dim Looper As Integer
Dim MyString As String
Dim TempStr As String

'set initial value
FillGroupList = False

'reset our array
ReDim GroupList(0)

'get text
MyString = PMMainForm.DDEText.Text

'for each character in the  string
For Looper = 1 To Len(MyString)
  
  If Asc(Mid$(MyString, Looper, 1)) > 31 Then  'if we don't have a non-printable character
    TempStr = TempStr + Mid$(MyString, Looper, 1)  'concatenate string
  Else
    
    If TempStr <> "" Then  'we've formed a group name
      ReDim Preserve GroupList(UBound(GroupList) + 1)  'bump our array by one
      GroupList(UBound(GroupList)).Name = TempStr  'add the group name to the array
      TempStr = ""                            'clear out our list
    End If

  End If

Next Looper

'return success!
FillGroupList = True

FillGroupListResume:
Exit Function

FillGroupListError:
Resume FillGroupListResume

End Function

Function FillMasterList () As Integer

Dim Looper As Integer
Dim Loop2 As Integer
Dim CurItem As Integer

On Error GoTo FillMasterListError

'initialize variables
FillMasterList = False
ReDim MasterList(0)
CurItem = 1

For Looper = 1 To UBound(GroupList)

  ReDim Preserve MasterList(UBound(MasterList) + 1)  'increment our array
  MasterList(UBound(MasterList)).Name = GroupList(Looper).Name 'add the group name
  MasterList(UBound(MasterList)).Level = 1  'add the level

  'loop through each group's individual items
  For Loop2 = CurItem To GroupList(Looper).NumItems + CurItem - 1

      ReDim Preserve MasterList(UBound(MasterList) + 1)  'increment our array
      MasterList(UBound(MasterList)).Name = GroupInfoList(Loop2).Name  'add the icon name
      MasterList(UBound(MasterList)).Level = 2  'add the level
      
      ReDim Preserve MasterList(UBound(MasterList) + 1)  'increment our array
      MasterList(UBound(MasterList)).Name = "Command Line:  " + GroupInfoList(Loop2).CommandLine'add the command line
      MasterList(UBound(MasterList)).Level = 3  'add the level

      ReDim Preserve MasterList(UBound(MasterList) + 1)  'increment our array
      MasterList(UBound(MasterList)).Name = "Default Directory:  " + GroupInfoList(Loop2).DefaultDir'add the default directory
      MasterList(UBound(MasterList)).Level = 3  'add the level

      ReDim Preserve MasterList(UBound(MasterList) + 1)  'increment our array
      MasterList(UBound(MasterList)).Name = "Icon Path:  " + GroupInfoList(Loop2).IconPath'add the icon path
      MasterList(UBound(MasterList)).Level = 3  'add the level

      ReDim Preserve MasterList(UBound(MasterList) + 1)  'increment our array
      
      If GroupInfoList(Loop2).MinFlag Then
        MasterList(UBound(MasterList)).Name = "Minimize Flag:  True"
      Else
        MasterList(UBound(MasterList)).Name = "Minimize Flag:  False"
      End If

      MasterList(UBound(MasterList)).Level = 3  'add the level

  Next Loop2

'increment the number of items we've worked with
CurItem = CurItem + GroupList(Looper).NumItems

Next Looper

'clear out our other arrays to clean up some memory
ReDim GroupList(0)
ReDim GroupInfoList(0)

'return success!
FillMasterList = True

FillMasterListResume:
Exit Function

FillMasterListError:
Resume FillMasterListResume

End Function

Sub FillPMOutline ()

Dim MyOutline As Control

'set our object to the outline to make it easier (and quicker) to reference
Set MyOutline = PMMainForm.PMOutline

'go through each item in the master list and add it to the outline
For Looper = 1 To UBound(MasterList)
  MyOutline.AddItem MasterList(Looper).Name, Looper + 1
  MyOutline.Indent(Looper + 1) = MasterList(Looper).Level
Next Looper

Set MyOutline = Nothing

End Sub

