Option Explicit
'
' Common Subs/Functions
'
  '
  ' Related Global Constants for this Module
  '
    '
    '  Global Constants for PlaceDialog
    '
      Global Const DLG_STANDARD = 0
      Global Const DLG_CENTERED = 1

Sub CenterForm (frm As Form)
  '
  ' Centers specified form on the screen
  '
  frm.Move (screen.Width / 2) - (frm.Width / 2), (screen.Height / 2) - (frm.Height / 2)
End Sub

Sub PlaceDialog (frmSource As Form, frmDialog As Form, iPos As Integer)
  '
  ' Places a dialog form in relation to the source form
  '
  Select Case iPos
    Case DLG_STANDARD
      frmDialog.Move frmSource.Left + 300, frmSource.Top + 300
    Case DLG_CENTERED
      frmDialog.Move frmSource.Left + ((frmSource.Width / 2) - (frmDialog.Width / 2)), frmSource.Top + ((frmSource.Height / 2) - (frmDialog.Height / 2))
    Case Else
      Debug.Print "Invalid Parameter sent to PlaceDialog"
  End Select
End Sub

