' MIDI API Functions for Windows 3.1
Declare Function midiOutOpen Lib "mmsystem.dll" (hMidiOut As Integer, ByVal DeviceId As Integer, ByVal C As Long, ByVal I As Long, ByVal F As Long) As Integer
Declare Function midiOutShortMsg Lib "mmsystem.dll" (ByVal hMidiOut As Integer, ByVal MidiMessage As Long) As Integer
Declare Function MidiOutClose Lib "mmsystem.dll" (ByVal hMidiOut As Integer) As Integer

Global midiMessageOut As Long
Global midiData1 As Long
Global midiData2 As Long

Global hMidiOut As Integer

' The Volume array (velocity) used for each MIDI channel
Global midiVolume(16) As Integer

' The current Midi Channel out set on Piano form
Global midiChannelOut As Integer

' MIDI status messages
Global Const NOTE_OFF = &H80
Global Const NOTE_ON = &H90
Global Const POLY_KEY_PRESS = &HA0
Global Const CONTROLLER_CHANGE = &HB0
Global Const PROGRAM_CHANGE = &HC0
Global Const CHANNEL_PRESSURE = &HD0
Global Const PITCH_BEND = &HE0

' MIDI Controller Numbers Constants
Global Const MOD_WHEEL = 1
Global Const BREATH_CONTROLLER = 2
Global Const FOOT_CONTROLLER = 4
Global Const PORTAMENTO_TIME = 5
Global Const MAIN_VOLUME = 7
Global Const BALANCE = 8
Global Const PAN = 10
Global Const EXPRESS_CONTROLLER = 11
Global Const DAMPER_PEDAL = 64
Global Const PORTAMENTO = 65
Global Const SOSTENUTO = 66
Global Const SOFT_PEDAL = 67
Global Const HOLD_2 = 69
Global Const EXTERNAL_FX_DEPTH = 91
Global Const TREMELO_DEPTH = 92
Global Const CHORUS_DEPTH = 93
Global Const DETUNE_DEPTH = 94
Global Const PHASER_DEPTH = 95
Global Const DATA_INCREMENT = 96
Global Const DATA_DECREMENT = 97

'MIDI Mapper
Global Const MIDI_MAPPER = -1

' MousePointer
Global Const DEFAULT = 0
Global Const HOURGLASS = 11

' Show parameters
Global Const MODAL = 1
Global Const MODELESS = 0

Sub MidiOutOpenPort ()
    Dim MidiOpenError As Integer
    Dim Msg, Response

    ' Open MIDIOut using MIDI Mapper
    MidiOpenError = midiOutOpen(hMidiOut, MIDI_MAPPER, 0, 0, 0)

    If MidiOpenError <> 0 Then
	' Put together a error message box
	Msg = "The MIDI Mapper would not open.  It is either already"
	Msg = Msg & " in use or not installed correctly."

	Response = MsgBox(Msg, 48, "MIDI Open Error")
    End If

End Sub

Sub SendMidiOut ()
    Dim MidiMessage As Long
    Dim lowint As Long
    Dim highint As Long
    Dim x As Integer
    
    lowint = (midiData1 * 256) + midiMessageOut
    highint = (midiData2 * 256) * 256

    MidiMessage = lowint + highint

    'Windows MIDI API function
    x = midiOutShortMsg(hMidiOut, MidiMessage)
End Sub

