VERSION 2.00
Begin Form NameSpaceInfoForm 
   Caption         =   "Name Space Information"
   Height          =   5385
   Left            =   810
   LinkTopic       =   "Form2"
   ScaleHeight     =   4980
   ScaleWidth      =   4680
   Top             =   1185
   Width           =   4800
   Begin ListBox DataStreamList 
      Height          =   615
      Left            =   1560
      TabIndex        =   11
      Top             =   2640
      Width           =   3015
   End
   Begin ListBox NameSpaceList 
      Height          =   1200
      Left            =   1560
      TabIndex        =   9
      Top             =   1320
      Width           =   3015
   End
   Begin CommandButton OKButton 
      Caption         =   "&OK"
      Height          =   372
      Left            =   1800
      TabIndex        =   0
      Top             =   4560
      Width           =   1092
   End
   Begin Label Label8 
      Caption         =   "Name spaces marked by a tilde (~) are not supported by the operating system on the selected server."
      Height          =   612
      Left            =   360
      TabIndex        =   14
      Top             =   3840
      Width           =   3972
   End
   Begin Label Label7 
      Caption         =   "Name spaces or data streams marked by an asterisk (*) are not supported by the volume."
      Height          =   372
      Left            =   360
      TabIndex        =   13
      Top             =   3360
      Width           =   3852
   End
   Begin Label Label6 
      Alignment       =   1  'Right Justify
      Caption         =   "Data streams supported:"
      Height          =   372
      Left            =   240
      TabIndex        =   12
      Top             =   2520
      Width           =   1212
   End
   Begin Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Name spaces supported:"
      Height          =   372
      Left            =   120
      TabIndex        =   10
      Top             =   1200
      Width           =   1332
   End
   Begin Label NumDataStreamLabel 
      Height          =   252
      Left            =   2400
      TabIndex        =   8
      Top             =   840
      Width           =   2052
   End
   Begin Label NumNameSpaceLabel 
      Height          =   252
      Left            =   2400
      TabIndex        =   7
      Top             =   600
      Width           =   2052
   End
   Begin Label VolumeLabel 
      Height          =   252
      Left            =   2400
      TabIndex        =   6
      Top             =   360
      Width           =   2052
   End
   Begin Label ServerLabel 
      Height          =   252
      Left            =   2400
      TabIndex        =   5
      Top             =   120
      Width           =   2172
   End
   Begin Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Number of Data Streams:"
      Height          =   252
      Left            =   120
      TabIndex        =   4
      Top             =   840
      Width           =   2172
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Number of Name Spaces:"
      Height          =   252
      Left            =   120
      TabIndex        =   3
      Top             =   600
      Width           =   2172
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Volume:"
      Height          =   252
      Left            =   720
      TabIndex        =   2
      Top             =   360
      Width           =   1572
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Server:"
      Height          =   252
      Left            =   840
      TabIndex        =   1
      Top             =   120
      Width           =   1452
   End
End

Sub Form_Load ()
    Dim buffer As NWBUFFER
    Dim nameSpaceName As String * 16
    Dim dataStreamName As String * 48

    ccode% = GetConnectionID(serverName$, connID%)
    If (ccode% <> SUCCESSFUL) Then
        MsgBox "Unable to get connection ID of server " + serverName$, MB_OK, "Error"
    Else
        Unload NameSpaceForm
        SetPreferredConnectionID (connID%)
        ccode% = GetVolumeNumber(volumeName$, volume%)
        ccode% = FillNameSpaceBuffer(connID%, volume%, buffer)

        If (ccode% <> SUCCESSFUL) Then
            MsgBox "Unable to get name space information", MB_OK, "Error"
        Else
            ccode% = GetNumNameSpaceAndDataStreams(buffer, numNameSpaces%, numDataStreams%)

            ns = 0
            nsFound = 1
            Do
                ccode% = GetNameSpaceInfo(buffer, ns, nameSpaceName, osReady%, volSupports%)
                nsName = Left$(nameSpaceName, InStr(nameSpaceName, Chr$(0)) - 1)
                If (ccode% = SUCCESSFUL) Then
                    nsFound = nsFound + 1
                    If (volSupports% = 0) Then nsName = nsName + "*"
                    If (osReady% = 0) Then nsName = nsName + "~"
                    NameSpaceList.AddItem nsName
                End If
                ns = ns + 1
            Loop While ((ns < 10) And (nsFound < numNameSpaces%))

            ds = 0
            dsFound = 1
            Do
                ccode% = GetDataStreamInfo(buffer, ds, dataStreamName, volSupports%)
                dsName = Left$(dataStreamName, InStr(dataStreamName, Chr$(0)) - 1)
                If (ccode% = SUCCESSFUL) Then
                    dsFound = dsFound + 1
                    If (volSupports% = 0) Then dsName = dsName + "*"
                    DataStreamList.AddItem dsName
                End If
                ds = ds + 1
            Loop While ((ds < 10) And (dsFound < numDataStreams%))

            ServerLabel = serverName$
            VolumeLabel = volumeName$
            NumNameSpaceLabel = Format$(numNameSpaces%)
            NumDataStreamLabel = Format$(numDataStreams%)
        End If
    End If
End Sub

Sub Form_Unload (Cancel As Integer)
    SetPreferredConnectionID (originalPrefConnID%)
End Sub

Sub OKButton_Click ()
    Unload NameSpaceInfoForm
End Sub

