VERSION 2.00
Begin Form DiagForm 
   Caption         =   "Diagnostics Services Test"
   Height          =   2190
   Left            =   2100
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   ScaleHeight     =   1785
   ScaleWidth      =   4680
   Top             =   1230
   Width           =   4800
   Begin CommandButton OKButton 
      Caption         =   "&OK"
      Height          =   372
      Left            =   1920
      TabIndex        =   0
      Top             =   1320
      Width           =   852
   End
   Begin Label shellVerLabel 
      Height          =   255
      Left            =   3600
      TabIndex        =   3
      Top             =   960
      Width           =   855
   End
   Begin Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "You are running NetWare shell version:"
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   960
      Width           =   3375
   End
   Begin Label SPXVerLabel 
      Height          =   255
      Left            =   3600
      TabIndex        =   8
      Top             =   720
      Width           =   855
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "You are running SPX version:"
      Height          =   255
      Left            =   840
      TabIndex        =   6
      Top             =   720
      Width           =   2655
   End
   Begin Label IPXVerLabel 
      Height          =   255
      Left            =   3600
      TabIndex        =   2
      Top             =   480
      Width           =   855
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "You are running IPX version:"
      Height          =   255
      Left            =   840
      TabIndex        =   5
      Top             =   480
      Width           =   2655
   End
   Begin Label connNumLabel 
      Height          =   255
      Left            =   3600
      TabIndex        =   1
      Top             =   240
      Width           =   855
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "You are at connection:"
      Height          =   255
      Left            =   1440
      TabIndex        =   4
      Top             =   240
      Width           =   2055
   End
End

Sub Form_Load ()
    Dim physNodeAddress As NodeAddress
    Dim socketNum As Integer
    Dim destination As BeginDiagnosticStruct
    Dim compList As ComponentList
    Dim response As AllResponseData
    Dim ipxResponse As IPXSPXVersion
    Dim shellResponse As ShellVersionStruct

    connNum& = GetConnectionNumber()
    connNumLabel.Caption = Str$(connNum&)

    ccode% = GetInternetAddress(connNum&, networkNum&, physNodeAddress, socketNum)
    If (ccode% <> SUCCESSFUL) Then
        MsgBox "Unable to get your workstation's internetwork address", MB_OK, "Error"
    Else
        destination.network = networkNum&
        'destination.nodeAddr = physNodeAddress
        destination.nodeAddr.nodeHi = physNodeAddress.nodeHi
        destination.nodeAddr.nodeLo = physNodeAddress.nodeLo
        destination.socket = socketNum
        ccode% = BeginDiagnostics(destination, connID%, compList)
        
        If (ccode% <> SUCCESSFUL) Then
            MsgBox "Your workstation is not responding to diagnostics request", MB_OK, "Error"
        Else
            offset% = FindComponentOffset(compList, IPX_SPX_COMPONENT)
            ccode% = GetIPXSPXVersion(connID%, offset%, response, ipxResponse)
            If (ccode% = SUCCESSFUL) Then
                IPXVerLabel.Caption = Format$(Asc(ipxResponse.IPXMajorVersion)) + "." + Format$(Asc(ipxResponse.IPXMinorVersion))
                SPXVerLabel.Caption = Format$(Asc(ipxResponse.SPXMajorVersion)) + "." + Format$(Asc(ipxResponse.SPXMinorVersion))
            
                offset% = FindComponentOffset(compList, SHELL_COMPONENT)
                ccode% = GetShellVersionInfo(connID%, offset%, response, shellResponse)
                If (ccode% = SUCCESSFUL) Then
                    shellVerLabel.Caption = Format$(Asc(shellResponse.major)) + "." + Format$(Asc(shellResponse.minor)) + Chr$(Asc(shellResponse.rev) + 97)
                Else
                    shellVerLabel.Caption = "Unknown"
                End If
            
                ccode% = EndDiagnostics(connID%)
                If (ccode% <> SUCCESSFUL) Then
                    MsgBox "Your workstation is not responding to diagnostics request", MB_OK, "Error"
                End If
            Else
                MsgBox "Your workstation is not responding to diagnostics request", MB_OK, "Error"
                IPXVerLabel.Caption = "Unknown"
                SPXVerLabel.Caption = "Unknown"
                shellVerLabel.Caption = "Unknown"
            End If
        End If
    End If
End Sub

Sub OKButton_Click ()
    Unload DiagForm
End Sub

