VERSION 2.00
Begin Form PSInfoForm 
   Caption         =   "Print Server Information"
   Height          =   4305
   Left            =   1605
   LinkTopic       =   "Form2"
   ScaleHeight     =   3900
   ScaleWidth      =   6495
   Top             =   1200
   Width           =   6615
   Begin ListBox ServerList 
      Height          =   1005
      Left            =   1680
      TabIndex        =   7
      Top             =   2160
      Width           =   4695
   End
   Begin CommandButton OKButton 
      Caption         =   "&OK"
      Height          =   375
      Left            =   2760
      TabIndex        =   0
      Top             =   3360
      Width           =   975
   End
   Begin Label PSType 
      Height          =   255
      Left            =   2520
      TabIndex        =   11
      Top             =   1440
      Width           =   2775
   End
   Begin Label PSVersion 
      Height          =   255
      Left            =   2520
      TabIndex        =   10
      Top             =   1200
      Width           =   1455
   End
   Begin Label PSPrinters 
      Height          =   255
      Left            =   2520
      TabIndex        =   9
      Top             =   960
      Width           =   1455
   End
   Begin Label PSStatus 
      Height          =   255
      Left            =   2520
      TabIndex        =   8
      Top             =   720
      Width           =   3015
   End
   Begin Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Attached servers:"
      Height          =   255
      Left            =   720
      TabIndex        =   6
      Top             =   1800
      Width           =   1575
   End
   Begin Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Server type:"
      Height          =   255
      Left            =   960
      TabIndex        =   5
      Top             =   1440
      Width           =   1335
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Version:"
      Height          =   255
      Left            =   960
      TabIndex        =   4
      Top             =   1200
      Width           =   1335
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Attached printers:"
      Height          =   255
      Left            =   720
      TabIndex        =   3
      Top             =   960
      Width           =   1575
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Status:"
      Height          =   255
      Left            =   1200
      TabIndex        =   2
      Top             =   720
      Width           =   1095
   End
   Begin Label Title 
      Height          =   495
      Left            =   480
      TabIndex        =   1
      Top             =   240
      Width           =   5535
   End
End

Sub Form_Load ()
    Dim info As PS_INFO

    Title.Caption = "Information on print server :  " + PrintServerName$ + " :"
    ServerList.Clear
    
    ccode% = PSAttachToPrintServer(PrintServerName$, connID%)
    If (ccode% <> SUCCESSFUL) Then
        PSStatus.Caption = "Unable to attach to print server"
    Else
        ccode% = PSGetPrintServerInfo(connID%, info, Len(info))
        If (ccode% <> SUCCESSFUL) Then
            MsgBox "Unable to get print server information", MB_OK, "Error"
        Else
            Select Case Asc(info.status)
                Case RUNNING
                    PSStatus.Caption = "Running"
                Case GOING_DOWN
                    PSStatus.Caption = "Going down"
                Case DOWN
                    PSStatus.Caption = "Down"
                Case INITIALIZING
                    PSStatus.Caption = "Initializing"
                Case Else
                    PSStatus.Caption = "Unknown"
            End Select

            PSPrinters.Caption = Asc(info.numPrinters)
            PSVersion.Caption = Format$(Asc(info.majorVersion)) + "." + Format$(Asc(info.minorVersion)) + Chr$(Asc(info.revision) + 97)
            
            Select Case Asc(info.serverType)
                Case 1
                    PSType.Caption = "Dedicated DOS"
                Case 2
                    PSType.Caption = "NLM"
                Case 3
                    PSType.Caption = "File Server VAP"
                Case 4
                    PSType.Caption = "Bridge VAP"
                Case Else
                    PSType.Caption = "Unknown"
            End Select

            sequence% = 0
            Do
                serverName$ = String$(48, 0)
                ccode% = PSGetAttachedServers(connID%, sequence%, serverName$)
                ServerList.AddItem serverName$
            Loop While (ccode% = SUCCESSFUL)
        End If
        
        ccode% = PSDetachFromPrintServer(connID%)
    End If
End Sub

Sub OKButton_Click ()
    Unload PSInfoForm
End Sub

Sub PSInfoForm_Click ()
    Unload PSInfoForm
End Sub

