VERSION 2.00
Begin Form NameSpaceForm 
   Caption         =   "Name Space Services Test"
   Height          =   2055
   Left            =   1245
   LinkTopic       =   "Form1"
   ScaleHeight     =   1650
   ScaleWidth      =   4965
   Top             =   1230
   Width           =   5085
   Begin ComboBox VolumeBox 
      Height          =   300
      Left            =   1320
      TabIndex        =   6
      Top             =   1200
      Width           =   2415
   End
   Begin ComboBox ServerNameBox 
      Height          =   300
      Left            =   1320
      TabIndex        =   4
      Top             =   720
      Width           =   2415
   End
   Begin CommandButton OkButton 
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   3840
      TabIndex        =   3
      Top             =   240
      Width           =   975
   End
   Begin CommandButton CancelButton 
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   3840
      TabIndex        =   0
      Top             =   720
      Width           =   975
   End
   Begin Label Label3 
      Caption         =   "Select a file server and volume to scan for name space information."
      Height          =   495
      Left            =   360
      TabIndex        =   5
      Top             =   120
      Width           =   3255
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Volume:"
      Height          =   255
      Left            =   360
      TabIndex        =   2
      Top             =   1200
      Width           =   855
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "File Server:"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   720
      Width           =   1095
   End
End

Sub CancelButton_Click ()
    Unload NameSpaceForm
End Sub

Sub Form_Load ()
    Dim volName As String * 16

    fileServerName$ = String$(48, 0)
    For connID% = 1 To 8
        If (ISConnectionIDInUse(connID%)) Then
            GetFileServerName connID%, fileServerName$
            ServerNameBox.AddItem fileServerName$
        End If
    Next connID%

    connID% = GetDefaultConnectionID()
    SetPreferredConnectionID (connID%)
    fileServerName$ = String$(48, 0)
    GetFileServerName connID%, fileServerName$
    fileServerName$ = Left$(fileServerName$, InStr(fileServerName$, Chr$(0)) - 1)
    ServerNameBox.Text = fileServerName$
    GetVolumeList
End Sub

Sub Form_Unload (Cancel As Integer)
    SetPreferredConnectionID (originalPrefConnID%)
End Sub

Sub GetVolumeList ()
    Dim usage As NWVOL_USAGE

    VolumeBox.Clear

    connID% = GetPreferredConnectionID()
    For volNum% = 0 To 31
        ccode% = GetVolUsage(connID%, volNum%, usage)
        If ((ccode% = SUCCESSFUL) And (Len(usage.volName) > 0)) Then
            VolumeBox.AddItem usage.volName
        End If
    Next volNum%
    VolumeBox.Text = VolumeBox.List(0)
End Sub

Sub OKButton_Click ()
    serverName$ = ServerNameBox.Text
    volumeName$ = VolumeBox.Text
    NameSpaceInfoForm.Show
End Sub

Sub ServerNameBox_Click ()
    prefServer$ = ServerNameBox.Text
    
    ccode% = GetConnectionID(prefServer$, connID%)
    If (ccode% = SUCCESSFUL) Then
        SetPreferredConnectionID (connID%)  'tell which file server to send
                                            '   requests to
        GetVolumeList
    Else
        MsgBox "Unable to get connection ID of server " + prefServer$, MB_OK, "Error"
        connID% = GetDefaultConnectionID()
        prefServer$ = String$(48, 0)
        GetFileServerName connID%, prefServer$
        prefServer$ = Left$(prefServer$, InStr(prefServer$, Chr$(0)) - 1)
        ServerNameBox.Text = prefServer$
    End If
End Sub

