Option Explicit

Global Frame_Mode As Integer   '24,25,29,30
Global TC_Type As Integer      '0,  1, 2, 3
Global MTC_Time As Long        'External Time in ms.
Global Ms_per_QF As Single     'Ms. per Quarter Frame (1000/Frame_Mode)
Global QF_Counter As Integer   '0...7  (Quarter Frame Message Counter)

Global hhh As Integer          'Actual Hours
Global mmm As Integer          'Minutes
Global sss As Integer          'Seconds
Global fff As Integer          'Frames

Global disp_hhh As Integer     'Display Hours
Global disp_mmm As Integer     'Minutes
Global disp_sss As Integer     'Seconds
Global disp_fff As Integer     'Frames

Global flgStop As Integer
Global flgDown As Integer
Global flgReadStop As Integer

'Midi Device Handles
Global hMidiIn As Integer               'usually 966 or 986
Global hMidiOut As Integer              '   "        "   "
Global Const NO_HANDLE = -1000          'Device closed
     
'InBuffer parameters (circular buffer)
Global ReadIndex As Integer               'Where to read from buffer
Global WriteIndex As Integer              'where to write into buffer
Global BuffCounter As Integer           'N. of messages in buffer
Global InBuffer(1023) As Long           'Buffer (0...1023)
Global Const BUFFSIZE = 1024            'max. 1024 messages

'If InBuffer is full and a message arrives, increment NumErrors
Global NumErrors As Long

'Wait for this flag to be active before change InBuffer Parameters
Global flgChangeIt As Integer        'True=changes allowed, False=not allowed
 
'Device ID
Global InDevice As Integer          'Midi In Device
Global OutDevice As Integer         'Midi Out Device

Global flgGoodbye As Integer        'If true exit polling loop
                                    'For API Functions Calls
Global ret As Integer


''''''''''  General Constants '''''''''''''''

' Booleans
Global Const YES = True
Global Const NO = False

' DragOver
Global Const ENTER = 0
Global Const LEAVE = 1

' Colors
Global Const BLACK = &H0&
Global Const RED = &HFF&
Global Const GREEN = &HFF00&
Global Const YELLOW = &HFFFF&
Global Const BLUE = &HFF0000
Global Const MAGENTA = &HFF00FF
Global Const CYAN = &HFFFF00
Global Const WHITE = &HFFFFFF
Global Const GRAY = &HC0C0C0
Global Const BURDEOS = &H80
Global Const DARKGRREN = &H8000
Global Const DARKBLUE = &H800000
Global Const MIDLEGREEN = &H8080
Global Const LILA = &H800080
Global Const VERDFOSC = &H808000
Global Const DARKGREY = &H808080

'MousePointer
Global Const DEFAULT = 0        ' 0 - Default
Global Const ARROW = 1          ' 1 - Arrow
Global Const CROSSHAIR = 2      ' 2 - Cross
Global Const IBEAM = 3          ' 3 - I-Beam
Global Const ICON_POINTER = 4   ' 4 - Icon
Global Const SIZE_POINTER = 5   ' 5 - Size
Global Const SIZE_NE_SW = 6     ' 6 - Size NE SW
Global Const SIZE_N_S = 7       ' 7 - Size N S
Global Const SIZE_NW_SE = 8     ' 8 - Size NW SE
Global Const SIZE_W_E = 9       ' 9 - Size W E
Global Const UP_ARROW = 10      ' 10 - Up Arrow
Global Const HOURGLASS = 11     ' 11 - Hourglass
Global Const NO_DROP = 12       ' 12 - No drop

' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_APPLMODAL = 0          ' Application Modal Message Box
Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default
Global Const MB_SYSTEMMODAL = 4096      'System Modal
 
' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed

' Key Codes
Global Const KEY_LBUTTON = &H1
Global Const KEY_RBUTTON = &H2
Global Const KEY_CANCEL = &H3
Global Const KEY_MBUTTON = &H4    ' NOT contiguous with L & R BUTTON
Global Const KEY_BACK = &H8
Global Const KEY_TAB = &H9
Global Const KEY_CLEAR = &HC
Global Const KEY_RETURN = &HD
Global Const KEY_SHIFT = &H10
Global Const KEY_CONTROL = &H11
Global Const KEY_MENU = &H12
Global Const KEY_PAUSE = &H13
Global Const KEY_CAPITAL = &H14
Global Const KEY_ESCAPE = &H1B
Global Const KEY_SPACE = &H20
Global Const KEY_PRIOR = &H21
Global Const KEY_NEXT = &H22
Global Const KEY_END = &H23
Global Const KEY_HOME = &H24
Global Const KEY_LEFT = &H25
Global Const KEY_UP = &H26
Global Const KEY_RIGHT = &H27
Global Const KEY_DOWN = &H28
Global Const KEY_SELECT = &H29
Global Const KEY_PRINT = &H2A
Global Const KEY_EXECUTE = &H2B
Global Const KEY_SNAPSHOT = &H2C
Global Const KEY_INSERT = &H2D
Global Const KEY_DELETE = &H2E
Global Const KEY_HELP = &H2F

' KEY_A thru KEY_Z are the same as their ASCII equivalents: 'A' thru 'Z'
' KEY_0 thru KEY_9 are the same as their ASCII equivalents: '0' thru '9'

Global Const KEY_NUMPAD0 = &H60
Global Const KEY_NUMPAD1 = &H61
Global Const KEY_NUMPAD2 = &H62
Global Const KEY_NUMPAD3 = &H63
Global Const KEY_NUMPAD4 = &H64
Global Const KEY_NUMPAD5 = &H65
Global Const KEY_NUMPAD6 = &H66
Global Const KEY_NUMPAD7 = &H67
Global Const KEY_NUMPAD8 = &H68
Global Const KEY_NUMPAD9 = &H69
Global Const KEY_MULTIPLY = &H6A
Global Const KEY_ADD = &H6B
Global Const KEY_SEPARATOR = &H6C
Global Const KEY_SUBTRACT = &H6D
Global Const KEY_DECIMAL = &H6E
Global Const KEY_DIVIDE = &H6F
Global Const KEY_F1 = &H70
Global Const KEY_F2 = &H71
Global Const KEY_F3 = &H72
Global Const KEY_F4 = &H73
Global Const KEY_F5 = &H74
Global Const KEY_F6 = &H75
Global Const KEY_F7 = &H76
Global Const KEY_F8 = &H77
Global Const KEY_F9 = &H78
Global Const KEY_F10 = &H79
Global Const KEY_F11 = &H7A
Global Const KEY_F12 = &H7B
Global Const KEY_F13 = &H7C
Global Const KEY_F14 = &H7D
Global Const KEY_F15 = &H7E
Global Const KEY_F16 = &H7F

Global Const KEY_NUMLOCK = &H90

Global Const SHIFT_MASK = 1
Global Const CTRL_MASK = 2
Global Const ALT_MASK = 4

Global Const LEFT_BUTTON = 1
Global Const RIGHT_BUTTON = 2
Global Const MIDDLE_BUTTON = 4

'SYSTEM Errors
Global Const MMSYSERR_BASE = 0
Global Const MMSYSERR_NOERROR = 0                        ' cap error
Global Const MMSYSERR_ERROR = (MMSYSERR_BASE + 1)        ' error sense especificar
Global Const MMSYSERR_BADDEVICEID = (MMSYSERR_BASE + 2)  ' ID de dispositiu errnia
Global Const MMSYSERR_NOTENABLED = (MMSYSERR_BASE + 3)   ' no es pot activar el dispositiu
Global Const MMSYSERR_ALLOCATED = (MMSYSERR_BASE + 4)    ' el dispositiu ja est activat
Global Const MMSYSERR_INVALHANDLE = (MMSYSERR_BASE + 5)  ' Handle de dispositiu incorrecte
Global Const MMSYSERR_NODRIVER = (MMSYSERR_BASE + 6)     ' no existeix el driver del dispositiu
Global Const MMSYSERR_NOMEM = (MMSYSERR_BASE + 7)        ' no hi ha prou memria
Global Const MMSYSERR_NOTSUPPORTED = (MMSYSERR_BASE + 8) ' funci no suportada
Global Const MMSYSERR_BADERRNUM = (MMSYSERR_BASE + 9)    ' error fora de marge
Global Const MMSYSERR_INVALFLAG = (MMSYSERR_BASE + 10)   ' flag passat incorrecte
Global Const MMSYSERR_INVALPARAM = (MMSYSERR_BASE + 11)  ' parmetre passat incorrecte
Global Const MMSYSERR_LASTERROR = (MMSYSERR_BASE + 11)   ' ltim error del marge


'MIDI Errors
Global Const MIDIERR_BASE = 64
Global Const MIDIERR_UNPREPARED = (MIDIERR_BASE + 0)     ' capalera no preparada (SYSEX)
Global Const MIDIERR_STILLPLAYING = (MIDIERR_BASE + 1)   ' play no ha acabat
Global Const MIDIERR_NOMAP = (MIDIERR_BASE + 2)          ' no hi ha el mapa MIDI
Global Const MIDIERR_NOTREADY = (MIDIERR_BASE + 3)       ' el hardware est ocupat
Global Const MIDIERR_NODEVICE = (MIDIERR_BASE + 4)       ' el port est desconectat
Global Const MIDIERR_INVALIDSETUP = (MIDIERR_BASE + 5)   ' setup incorrecte
Global Const MIDIERR_LASTERROR = (MIDIERR_BASE + 5)      ' ltim error del marge

'tipus de data de MIDI audio
Global Const MIDIPATCHSIZE = 128


'MISSATGES

'missatges de MIDI Input
Global Const MM_MIM_OPEN = &H3C1
Global Const MM_MIM_CLOSE = &H3C2
Global Const MM_MIM_DATA = &H3C3
Global Const MM_MIM_LONGDATA = &H3C4
Global Const MM_MIM_ERROR = &H3C5
Global Const MM_MIM_LONGERROR = &H3C6

'missatges de MIDI Output
Global Const MM_MOM_OPEN = &H3C7
Global Const MM_MOM_CLOSE = &H3C8
Global Const MM_MOM_DONE = &H3C9


'missatges de MIDI callback
Global Const MIM_OPEN = MM_MIM_OPEN
Global Const MIM_CLOSE = MM_MIM_CLOSE
Global Const MIM_DATA = MM_MIM_DATA
Global Const MIM_LONGDATA = MM_MIM_LONGDATA
Global Const MIM_ERROR = MM_MIM_ERROR
Global Const MIM_LONGERROR = MM_MIM_LONGERROR
Global Const MOM_OPEN = MM_MOM_OPEN
Global Const MOM_CLOSE = MM_MOM_CLOSE
Global Const MOM_DONE = MM_MOM_DONE

' device ID del mapa MIDI
Global Const MIDIMAPPER = (-1)
Global Const MIDI_MAPPER = (-1)

' flags per wFlags a midiOutCachePatches(), midiOutCacheDrumPatches()
Global Const MIDI_CACHE_ALL = 1
Global Const MIDI_CACHE_BESTFIT = 2
Global Const MIDI_CACHE_QUERY = 3
Global Const MIDI_UNCACHE = 4


' flags usats a waveOutOpen(), waveInOpen(), midiInOpen(), and
' midiOutOpen() per especificar el tipus de parmetre dwCallback.

Global Const CALLBACK_TYPEMASK = &H70000         ' callback de tipus mask
Global Const CALLBACK_NULL = &H0&                ' cap callback
Global Const CALLBACK_WINDOW = &H10000           ' dwCallback s HWND (finestra)
Global Const CALLBACK_TASK = &H20000             ' dwCallback s HTASK (tasca)
Global Const CALLBACK_FUNCTION = &H30000         ' dwCallback s FARPROC (funci)


'    IDs de fabricants i productes
'    Usat com wMid i wPid a WAVEOUTCAPS, WAVEINCAPS,
'    MIDIOUTCAPS, MIDIINCAPS, AUXCAPS, JOYCAPS

' IDs de fabricants
Global Const MM_MICROSOFT = 1                 ' Microsoft Corp.

' IDs de productes
Global Const MM_MIDI_MAPPER = 1               ' MIDI Mapper
Global Const MM_WAVE_MAPPER = 2               ' Wave Mapper
Global Const MM_SNDBLST_MIDIOUT = 3           ' Sound Blaster MIDI output port
Global Const MM_SNDBLST_MIDIIN = 4            ' Sound Blaster MIDI input port
Global Const MM_SNDBLST_SYNTH = 5             ' Sound Blaster internal synthesizer
Global Const MM_SNDBLST_WAVEOUT = 6           ' Sound Blaster waveform output
Global Const MM_SNDBLST_WAVEIN = 7            ' Sound Blaster waveform input
Global Const MM_ADLIB = 9                     ' Ad Lib-compatible synthesizer
Global Const MM_MPU401_MIDIOUT = 10           ' MPU401-compatible MIDI output port
Global Const MM_MPU401_MIDIIN = 11            ' MPU401-compatible MIDI input port
Global Const MM_PC_JOYSTICK = 12              ' Joystick adapter

' flags per wTechnology a MIDIOUTCAPS
Global Const MOD_MIDIPORT = 1    ' port hardware
Global Const MOD_SYNTH = 2       ' sintetitzador intern genric
Global Const MOD_SQSYNTH = 3     ' sintet. intern d'ona quadrada
Global Const MOD_FMSYNTH = 4     ' sintet. intern FM
Global Const MOD_MAPPER = 5      ' mapa MIDI

' flags per dwSupport a MIDIOUTCAPS
Global Const MIDICAPS_VOLUME = &H1             ' suporta control de volum
Global Const MIDICAPS_LRVOLUME = &H2           ' suporta control independent esquerra/dreta
Global Const MIDICAPS_CACHE = &H4              ' suporta cache de patch


' estructura de les capacitats del dispositiu MIDI output
Type MidiOutCaps
    wMid As Integer                ' ID del fabricant
    wPid As Integer                ' ID del producte
    vDriverVersion As Integer      ' versi del driver
    szPname As String * 32         ' nom del producte (string acabat en NULL)
    wTechnology As Integer         ' tipus de dispositiu
    wVoices As Integer             ' n. de veus (noms sintet. intern)
    wNotes As Integer              ' max n. de notes (noms sintet. intern)
    wChannelMask As Integer        ' canals utilitzables (noms sintet. intern)
    dwSupport As Long              ' controls extres suportats (volum, etc)
End Type


' estructura de les capacitats del dispositiu MIDI input
Type MidiInCaps
    wMid As Integer                ' ID del fabricant
    wPid As Integer                ' ID del producte
    vDriverVersion As Integer      ' versi del driver
    szPname As String * 32         ' nom del producte (string acabat en NULL)
End Type


' flags per dwFlags a MIDIHDR
Global Const MHDR_DONE = &H1                   ' bit que indica operaci completada
Global Const MHDR_PREPARED = &H2               ' bit que indica que el header est preparat
Global Const MHDR_INQUEUE = &H4                ' bit reservat pel driver

' header d'un bloc de data MIDI (SYSEX)
Type MIDIHDR
    lpData As Long                    ' pointer a un bloc de data
    dwBufferLength As Long            ' dimensions del buffer
    dwBytesRecorded As Long           ' n. de Bytes gravats (noms per Input)
    dwUser As Long                    ' utilitzable per l'usuari
    dwFlags As Long                   ' flags (veure les definicions anteriors)
    lpNext As Long                    ' reservat pel driver
    reserved As Long                  ' reservat pel driver
End Type

' tipus de data que utilitza windows per enviar missatges midi
Type MidiShortMsg
    dwTimestamp     As Long   'temps en que s'ha rebut el missatge (ms. desde Start)
    dwMidiMsg       As Long   'missatge
End Type

' Funcions MIDI OUT
'n. de dispositius Midi Output?
Declare Function midiOutGetNumDevs% Lib "MMSYSTEM.DLL" ()
'capacitats d'un dispositiu Midi Output en concret?
Declare Function midiOutGetDevCaps% Lib "MMSYSTEM.DLL" (ByVal uDeviceID%, lpCaps As MidiOutCaps, ByVal uSize%)
'Volum (pregunta)
Declare Function midiOutGetVolume% Lib "MMSYSTEM.DLL" (ByVal uDeviceID%, lpdwVolume&)
'Volum (assigna)
Declare Function midiOutSetVolume% Lib "MMSYSTEM.DLL" (ByVal uDeviceID%, ByVal dwVolume&)
'Texte d'un error MidiOut
Declare Function midiOutGetErrorText% Lib "MMSYSTEM.DLL" (ByVal uError%, ByVal lpText$, ByVal uSize%)
'Obre un dispositiu MIDI
Declare Function midiOutOpen% Lib "MMSYSTEM.DLL" (lphMidiOut As Integer, ByVal uDeviceID%, ByVal dwCallback&, ByVal dwInstance&, ByVal dwFlags&)
'Tanca un dispositiu MIDI
Declare Function midiOutClose% Lib "MMSYSTEM.DLL" (ByVal hMidiOut%)
'Prepara un header per rebre SYSEX
Declare Function midiOutPrepareHeader% Lib "MMSYSTEM.DLL" (ByVal hMidiOut%, lpMidiOutHdr As MIDIHDR, ByVal uSize%)
'Desprepara un header
Declare Function midiOutUnprepareHeader% Lib "MMSYSTEM.DLL" (ByVal hMidiOut%, lpMidiOutHdr As MIDIHDR, ByVal uSize%)
'Envia un missatge Midi normal pel Midi Out (3 Bytes)
Declare Function midiOutShortMsg% Lib "MMSYSTEM.DLL" (ByVal hMidiOut%, ByVal dwMsg&)
'Envia un missatge llarg (SYSEX) pel Midi Out
Declare Function midiOutLongMsg% Lib "MMSYSTEM.DLL" (ByVal hMidiOut%, lpMidiOutHdr As MIDIHDR, ByVal uSize%)
'Reset al dispositiu Midi Out
Declare Function midiOutReset% Lib "MMSYSTEM.DLL" (ByVal hMidiOut%)
'Cache els patches de sons
Declare Function midiOutCachePatches% Lib "MMSYSTEM.DLL" (ByVal hMidiOut%, ByVal uBank%, lpwPatchArray%, ByVal uFlags%)
'Cache els patches de drums
Declare Function midiOutCacheDrumPatches% Lib "MMSYSTEM.DLL" (ByVal hMidiOut%, ByVal uPatch%, lpwKeyArray%, ByVal uFlags%)
'Pregunta ID d'un dispositiu
Declare Function midiOutGetID% Lib "MMSYSTEM.DLL" (ByVal hMidiOut%, lpuDeviceID%)
'Envia un Byte pel Midi Out
Declare Function midiOutMessage& Lib "MMSYSTEM.DLL" (ByVal hMidiOut%, ByVal uMessage%, ByVal dw1&, ByVal dw2&)

'Funcions MIDI IN
Declare Function midiInGetNumDevs% Lib "MMSYSTEM.DLL" ()
Declare Function midiInGetDevCaps% Lib "MMSYSTEM.DLL" (ByVal uDeviceID%, lpCaps As MidiInCaps, ByVal uSize%)
Declare Function midiInGetErrorText% Lib "MMSYSTEM.DLL" (ByVal uError%, ByVal lpText$, ByVal uSize%)
Declare Function midiInOpen% Lib "MMSYSTEM.DLL" (lphMidiIn As Integer, ByVal uDeviceID%, ByVal dwCallback&, ByVal dwInstance&, ByVal dwFlags&)
Declare Function midiInClose% Lib "MMSYSTEM.DLL" (ByVal hMidiIn%)
Declare Function midiInPrepareHeader% Lib "MMSYSTEM.DLL" (ByVal hMidiIn%, lpMidiInHdr As MIDIHDR, ByVal uSize%)
Declare Function midiInUnprepareHeader% Lib "MMSYSTEM.DLL" (ByVal hMidiIn%, lpMidiInHdr As MIDIHDR, ByVal uSize%)
Declare Function midiInAddBuffer% Lib "MMSYSTEM.DLL" (ByVal hMidiIn%, lpMidiInHdr As MIDIHDR, ByVal uSize%)
Declare Function midiInStart% Lib "MMSYSTEM.DLL" (ByVal hMidiIn%)
Declare Function midiInStop% Lib "MMSYSTEM.DLL" (ByVal hMidiIn%)
Declare Function midiInReset% Lib "MMSYSTEM.DLL" (ByVal hMidiIn%)
Declare Function midiInGetID% Lib "MMSYSTEM.DLL" (ByVal hMidiIn%, lpuDeviceID%)
Declare Function midiInMessage& Lib "MMSYSTEM.DLL" (ByVal hMidiIn%, ByVal uMessage%, ByVal dw1&, ByVal dw2&)

' Temps del sistema en alta resoluci (Multimedia)
Declare Function timeGetTime& Lib "mmsystem" ()

Sub Display_Adjust ()
    Dim st As String

    While disp_fff >= Frame_Mode
        disp_fff = disp_fff - Frame_Mode
        disp_sss = disp_sss + 1
    Wend

    While disp_sss >= 60
        disp_sss = disp_sss - 60
        disp_mmm = disp_mmm + 1
    Wend

    While disp_mmm >= 60
        disp_mmm = disp_mmm - 60
        disp_hhh = disp_hhh + 1
    Wend

    While disp_hhh >= 24
        disp_hhh = disp_hhh - 24
    Wend

    While disp_fff < 0
        disp_fff = disp_fff + Frame_Mode
        disp_sss = disp_sss - 1
    Wend

    While disp_sss < 0
        disp_sss = disp_sss + 60
        disp_mmm = disp_mmm - 1
    Wend

    While disp_mmm < 0
        disp_mmm = disp_mmm + 60
        disp_hhh = disp_hhh - 1
    Wend

    While disp_hhh < 0
        disp_hhh = disp_hhh + 24
    Wend

    st = Format$(disp_hhh, "00")
    If MTCForm.txtHours.Caption <> st Then MTCForm.txtHours.Caption = st
    st = Format$(disp_mmm, "00")
    If MTCForm.txtMinutes.Caption <> st Then MTCForm.txtMinutes.Caption = st
    st = Format$(disp_sss, "00")
    If MTCForm.txtSeconds.Caption <> st Then MTCForm.txtSeconds.Caption = st
    MTCForm.txtFrames.Caption = Format$(disp_fff, "00")
End Sub

Sub Dlg_Alert (m$)
     Beep
     MsgBox m$, MB_OK + MB_ICONEXCLAMATION, "ALERT"
End Sub

Sub Erase_Display ()
    MTCForm.txtHours = "--"
    MTCForm.txtMinutes = "--"
    MTCForm.txtSeconds = "--"
    MTCForm.txtFrames = "--"
End Sub

Function IsNumber (kk As Integer)
    Select Case kk
        Case Asc("0") To Asc("9")
            IsNumber = True
        Case KEY_NUMPAD0 To KEY_NUMPAD9
            IsNumber = True
        Case Else
            IsNumber = False
    End Select
End Function

Function KeyToNumber (KeyCode) As Integer
    If KeyCode >= Asc("0") And KeyCode <= Asc("9") Then
        KeyToNumber = KeyCode - Asc("0")
    ElseIf KeyCode >= KEY_NUMPAD0 And KeyCode <= KEY_NUMPAD9 Then
        KeyToNumber = KeyCode - KEY_NUMPAD0
    Else
        KeyToNumber = -1
    End If
End Function

'Tanca el port Midi In
Sub MidiIn_Close ()
    If hMidiIn <> NO_HANDLE Then
        MTCForm.MidiHook.Message(MIM_DATA) = False

        ret = midiInStop(hMidiIn)
        If ret <> 0 Then
            Alerta_MidiError (ret)
            Exit Sub
        End If

        ret = midiInClose(hMidiIn)
        hMidiIn = NO_HANDLE
        If ret <> 0 Then
            Alerta_MidiError (ret)
            Exit Sub
        End If
    End If
End Sub

'Obre un port Midi In
Sub MidiIn_Open (nDevice)
    MTCForm.MidiHook.HwndHook = MTCForm.hWnd
    MTCForm.MidiHook.Message(MIM_DATA) = True

    MidiIn_Close

    ret = midiInOpen(hMidiIn, nDevice, MTCForm.hWnd, 0, CALLBACK_WINDOW)
    If ret <> 0 Then
        Alerta_MidiError (ret)
        hMidiIn = NO_HANDLE
        Exit Sub
    End If

    ret = midiInStart(hMidiIn)
        If ret <> 0 Then
            Alerta_MidiError (ret)
            ret = midiInClose(hMidiIn)
        Exit Sub
    End If
End Sub

'Llegeix un missatge guardat a InBuffer
'Si no hi ha cap missatge torna 0
Function MidiIn_Read () As Long
    Dim Msg As Long

    If BuffCounter = 0 Then
        MidiIn_Read = 0&
        Exit Function
    End If

    Do                           'Wait que flgChangeIt sigui True
        If flgChangeIt = True Then
            flgChangeIt = False
            Exit Do              'surt del bucle
        End If
        DoEvents
    Loop

    MidiIn_Read = InBuffer(ReadIndex)
    ReadIndex = ReadIndex + 1
    If ReadIndex = BUFFSIZE Then ReadIndex = 0     'Dna la volta
    BuffCounter = BuffCounter - 1
    flgChangeIt = True
End Function

'Tanca Midi Out
Sub MidiOut_Close ()

    If hMidiOut <> NO_HANDLE Then
        ret = midiOutClose(hMidiOut)
        If ret <> 0 Then
            Alerta_MidiError (ret)
            Exit Sub
        End If
        hMidiOut = NO_HANDLE
    End If
End Sub

'Obre un dispositiu Midi Out
Sub MidiOut_Open (nDevice)
    MidiOut_Close
    ret = midiOutOpen(hMidiOut, nDevice, 0, 0, 0)
    If ret <> 0 Then
        Alerta_MidiError (ret)
        Exit Sub
    End If
End Sub

'Envia un codi pel Midi Out
Function MidiOut_Write (Msg As Long) As Integer

    MidiOut_Write = True

    ret = midiOutShortMsg(hMidiOut, Msg)
    If ret <> 0 Then
        Alerta_MidiError (ret)
        MidiOut_Write = False
        Exit Function
    End If
    MTCForm.OutShow.Caption = "u"
End Function

Sub MTC_Read ()
    Dim Msg As Long, dd As Integer, oldt As Long, newt As Long
    Dim ln As Integer, Expected As Integer
    Dim flgCatching As Integer, tt As Integer, st As String
    Dim h As Integer, m As Integer, s As Integer, f As Integer

    Erase_Display
    flgCatching = True
    Expected = &H0
    flgReadStop = False

    oldt = timeGetTime()
    While flgReadStop = False
        newt = timeGetTime()

        If newt - oldt > 3000 Then   '3 segons
            Erase_Display
            flgCatching = True
            Expected = &H0
        End If

        Msg = MidiIn_Read()
        If Msg = 0& Then GoTo ReadLoop_End
        If (Msg And &HFF) <> &HF1 Then GoTo ReadLoop_End
        oldt = newt
        dd = (Msg And &HFF00) / 256
        Select Case (dd And &HF0)
            Case &H0:
                If Expected <> &H0 Then
                    Erase_Display
                    flgCatching = True
                    Expected = &H0
                Else
                    ln = (dd And &HF)
                    Expected = &H10
                End If

            Case &H10:
                If Expected <> &H10 Then
                    Erase_Display
                    flgCatching = True
                    Expected = &H0
                Else
                    f = (dd And &HF) * 16 + ln
                    Expected = &H20
                End If

            Case &H20:
                If Expected <> &H20 Then
                    Erase_Display
                    flgCatching = True
                    Expected = &H0
                Else
                    ln = (dd And &HF)
                    Expected = &H30
                End If

            Case &H30:
                If Expected <> &H30 Then
                    Erase_Display
                    flgCatching = True
                    Expected = &H0
                Else
                    s = (dd And &HF) * 16 + ln
                    Expected = &H40
                End If

            Case &H40:
                If Expected <> &H40 Then
                    Erase_Display
                    flgCatching = True
                    Expected = &H0
                Else
                    If flgCatching = False Then
                        fff = fff + 1
                        SMPTE_Adjust
                        disp_fff = disp_fff + 1
                        Display_Adjust
                    End If
                    ln = (dd And &HF)
                    Expected = &H50
                End If

            Case &H50:
                If Expected <> &H50 Then
                    Erase_Display
                    flgCatching = True
                    Expected = &H0
                Else
                    m = (dd And &HF) * 16 + ln
                    Expected = &H60
                End If

            Case &H60:
                If Expected <> &H60 Then
                    Erase_Display
                    flgCatching = True
                    Expected = &H0
                Else
                    ln = (dd And &HF)
                    Expected = &H70
                End If

            Case &H70:
                If Expected <> &H70 Then
                    Erase_Display
                    flgCatching = True
                    Expected = &H0
                Else
                    h = (dd And &H1) * 16 + ln
                    tt = (dd And &H6) / 2

                    If flgCatching = False Then
                        If SMPTE_to_Frames(h, m, s, f) - SMPTE_to_Frames(hhh, mmm, sss, fff) <> 1& Then
                            Erase_Display
                            flgCatching = True
                            Expected = &H0
                        Else
                            fff = fff + 1
                            disp_fff = disp_fff + 1
                        End If
                    Else
                        flgCatching = False
                        hhh = h
                        disp_hhh = h
                        mmm = m
                        disp_mmm = m
                        sss = s
                        disp_sss = s
                        fff = f + 2
                        disp_fff = f + 2
                        TC_Type = tt
                        Select Case tt
                            Case 0:
                                Ms_per_QF = 250 / 24
                                Frame_Mode = 24
                                st = "SMPTE : 24 Fr/s"
                            Case 1:
                                Ms_per_QF = 250 / 25
                                Frame_Mode = 25
                                st = "SMPTE : 25 Fr/s"
                            Case 2:
                                Ms_per_QF = 250 / 29
                                Frame_Mode = 29
                                st = "SMPTE : 30 (Drop-Frame)"
                            Case 3:
                                Ms_per_QF = 250 / 30
                                Frame_Mode = 30
                                st = "SMPTE : 30 (Non-Drop)"
                        End Select
                        If MTCForm.Caption <> st Then MTCForm.Caption = st
                    End If
                    SMPTE_Adjust
                    Display_Adjust
                    Expected = &H0
                End If

        End Select

ReadLoop_End:
        DoEvents
    Wend
End Sub

Sub MTC_Write ()
    Dim CurrentTime As Long, OldTime As Long
    Dim Msg As Long

    OldTime = timeGetTime()
    QF_Counter = 0
    flgStop = False
    While flgStop = False
        CurrentTime = timeGetTime()
        If CurrentTime - OldTime > Ms_per_QF Then
            If QF_Send() = False Then Exit Sub
            OldTime = OldTime + Ms_per_QF
            QF_Counter = QF_Counter + 1
            If QF_Counter = 4 Then
                disp_fff = disp_fff + 1  'Change display every frame
                Display_Adjust
            ElseIf QF_Counter = 8 Then
                disp_fff = disp_fff + 1  'Change display every frame
                Display_Adjust
                fff = fff + 2            'Change MTC every two frames
                SMPTE_Adjust
                QF_Counter = 0
            End If
            DoEvents
        End If
    Wend
End Sub

Sub Panic ()
    ret = midiInClose(966)    'Usual Device Handles
    ret = midiInClose(986)
    ret = midiOutClose(966)
    ret = midiOutClose(986)
End Sub

Function QF_Send () As Integer
    Dim tt As Long, nbl As Integer

    tt = &HF1&
    Select Case QF_Counter
        Case 0:
            nbl = &H0 + (fff And &HF)           'f [ffff]
            tt = tt + nbl * 256
        Case 1:
            nbl = &H10 + (fff And &H10) / 16   '[f] ffff
            tt = tt + nbl * 256
        Case 2:
            nbl = &H20 + (sss And &HF)          'ss [ssss]
            tt = tt + nbl * 256
        Case 3:
            nbl = &H30 + (sss And &H30) / 16    '[ss] ssss
            tt = tt + nbl * 256
        Case 4:
            nbl = &H40 + (mmm And &HF)          'mm [mmmm]
            tt = tt + nbl * 256
        Case 5:
            nbl = &H50 + (mmm And &H30) / 16    '[mm] mmmm
            tt = tt + nbl * 256
        Case 6:
            nbl = &H60 + (hhh And &HF)          'h [hhhh]
            tt = tt + nbl * 256
        Case 7:
            nbl = &H70 + (hhh And &H10) / 16    '[h] hhhh
            nbl = nbl + TC_Type * 2             '[tth]
            tt = tt + nbl * 256
    End Select
    QF_Send = MidiOut_Write(tt)
End Function

'Inicialitza el buffer de Midi In
Sub Reset_BufferIn ()
    flgChangeIt = False
    WriteIndex = 0
    ReadIndex = 0
    BuffCounter = 0
    flgChangeIt = True
End Sub

Sub SMPTE_Adjust ()
    Dim st As String

    While fff >= Frame_Mode
        fff = fff - Frame_Mode
        sss = sss + 1
    Wend

    While sss >= 60
        sss = sss - 60
        mmm = mmm + 1
    Wend

    While mmm >= 60
        mmm = mmm - 60
        hhh = hhh + 1
    Wend

    While hhh >= 24
        hhh = hhh - 24
    Wend

    While fff < 0
        fff = fff + Frame_Mode
        sss = sss - 1
    Wend

    While sss < 0
        sss = sss + 60
        mmm = mmm - 1
    Wend

    While mmm < 0
        mmm = mmm + 60
        hhh = hhh - 1
    Wend

    While hhh < 0
        hhh = hhh + 24
    Wend

End Sub

Function SMPTE_to_Frames (h, m, s, f) As Long
    Dim rr As Long

    rr = (h * 3600& + m * 60 + s) * Frame_Mode + f
    SMPTE_to_Frames = rr
End Function

Function SMPTE_to_Ms (hh As Integer, mm As Integer, ss As Integer, ff As Integer) As Long
    Dim rr As Long

    rr = hh * 3600000 + mm * 60000 + ss * 1000 + ff * (1000 / Frame_Mode)
    SMPTE_to_Ms = rr
End Function

'Translates a Midi Error into a Message Box.
Sub Alerta_MidiError (er As Integer)
    Dim Msg As String

    Select Case er
        Case MMSYSERR_BADDEVICEID
            Msg = "Bad Device ID! "
        Case MMSYSERR_NOTENABLED
            Msg = "Device not Enabled!"
        Case MMSYSERR_ALLOCATED
            Msg = "Device allready allocated!"
        Case MMSYSERR_INVALHANDLE
            Msg = "Invalid Device Handle!"
        Case MMSYSERR_NODRIVER
            Msg = "No Driver!"
        Case MMSYSERR_NOMEM = (MMSYSERR_BASE + 7)
            Msg = "Out of Memory!"
        Case MMSYSERR_NOTSUPPORTED
            Msg = "Function not supported!"
        Case MMSYSERR_BADERRNUM
            Msg = "Bad Error Number!"
        Case MMSYSERR_INVALFLAG
            Msg = "Invalid Flag!"
        Case MMSYSERR_INVALPARAM
            Msg = "Invalid Parameter!"
        Case MMSYSERR_LASTERROR
            Msg = "System last Error!"
        Case MIDIERR_UNPREPARED
            Msg = "Header unprepared!"
        Case MIDIERR_STILLPLAYING
            Msg = "Still Playing!"
        Case MIDIERR_NOMAP
            Msg = "No MIDI Mapper!"
        Case MIDIERR_NOTREADY
            Msg = "Hardware not ready! "
        Case MIDIERR_NODEVICE
            Msg = "No Device!"
        Case MIDIERR_INVALIDSETUP
            Msg = "Invalid Setup!"
        Case MIDIERR_LASTERROR
            Msg = "MIDI Last Error!"
        Case Else
            Msg = "Unexpected Error!"
    End Select

    Dlg_Alert (Msg)
End Sub

Sub Wait (tt As Long)
    Dim t1 As Long, t2 As Long

    t1 = timeGetTime()
    Do
        t2 = timeGetTime()
    Loop Until t2 - t1 >= tt
End Sub

