/*
	Mnythdll.h -- 7-31-94, Bruce McLean

	header for manythings screen saver, includes routines:

		1) ManyDibLoad -- reads DIB files into memory
		2) ManyGifLoad -- reads GIF files into memory and converting to
		                     DIB format
		3) ManyDibWrite -- writes DIB file in memory out to a file
		4) ManyDibModPalette -- adds offsets to colors in palette
		5) ManyDibCyclePalette -- shifts palette entries
		6) ManyLoadLogPal -- retrieves DIB palette into a LOGPALETTE
														structure
		7) ManyDibGet -- returns pointer to DIB in memory
		8) ManyDibGetData -- returns pointer to bitmap data area of DIB in memory
		9) ManyDibFree -- frees memory used by DIB in memory

	Warnings --
		C++ by default modifies the names of functions to add parameter type
			information, to make the functions callable by Visual Basic they need
			to be declared as 'extern "C"' and 'pascal _export'.  See Mnythdll.h
      for example.
*/


#ifndef __MANY_THINGS_H
#define __MANY_THINGS_H

#include <windows.h>

extern "C" long FAR pascal _export ManyDibGetData( void );
extern "C" long FAR pascal _export ManyDibGet( void );
extern "C" int FAR pascal _export ManyDibFree( void );
extern "C" long FAR pascal _export ManyDibInit();
extern "C" long FAR pascal _export ManyDibAlloc( int width,int height );
extern "C" long FAR pascal _export ManyDibLoad (const FAR char * szFileName,int FAR * width,int FAR * height);
extern "C" long FAR pascal _export ManyGifLoad (const FAR char * szFileName,int FAR * width,int FAR * height);
extern "C" void FAR pascal _export ManyDibModPalette(int red,int green,int blue);
extern "C" void FAR pascal _export ManyDibCyclePalette(int StepSize,int LowValue,int HighValue);
extern "C" void pascal _export ManyLoadLogPal (LOGPALETTE & Pal,int Start,int MaxSize,int Flags);
extern "C" int FAR pascal _export ManyDibWrite (const FAR char * szFileName);

#endif // __MANY_THINGS_H