Option Explicit

Global gDatabaseName As String

Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, lpKeyName As Any, lpString As Any, ByVal lplFileName As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer

Function CheckWindow (F1 As Form) As Integer
Dim x As Integer

' this routine makes sure than a form object actually points
' to a form that is currently loaded

CheckWindow = False

If Not (F1 Is Nothing) Then
    For x = 0 To Forms.Count - 1
	If F1 Is Forms(x) Then
	    CheckWindow = True
	    Exit For
	End If
    Next x
End If

End Function

Function CurrentRecord (Data1 As Data) As Integer

If Data1.EditMode = Data_EditAdd Then
    CurrentRecord = False
ElseIf Data1.Recordset.EOF Or Data1.Recordset.BOF Then
    CurrentRecord = False
Else
    CurrentRecord = True
End If

End Function

Sub DataError (ErrNo, ErrorMsg)

Select Case ErrNo
    Case 3197
	MsgBox "This record has been edited by another user. Save record again to overwrite their changes, or choose Edit, Refresh to discard your changes.", MB_IconExclamation
    Case 3200
	MsgBox ErrorMsg, MB_IconStop
    Case Else
	MsgBox "Unable to save record. Error #" & ErrNo & " has occured: " & ErrorMsg, MB_IconStop
End Select

End Sub

Sub Main ()
Dim RealTitle As String

If App.PrevInstance Then
    ' Activate, then restore the previous instance
    RealTitle = App.Title
    App.Title = "Duplicate App"
    AppActivate RealTitle
    SendKeys "%( R)", True
    DoEvents
    End
End If

gDatabaseName = ReadIniString("Options", "Database")

MainMdi.Show

End Sub

Function MakeDate (d As Double) As String

If d < DateSerial(2000, 1, 1) Then
    MakeDate = Format$(d, "mm/dd/yy")
Else
    MakeDate = Format$(d, "mm/dd/yyyy")
End If

End Function

Sub NewForm (File As String, Cmd As String)
Dim F1 As Form

Select Case File
    Case "Titles"
	Set F1 = New Titles
	' can't use show because modal form may be visible
	F1.Visible = True
    Case "Authors"
	Set F1 = New Authors
	F1.Visible = True
    Case "Publishers"
	Set F1 = New Publish
	F1.Visible = True
    Case Else
	MsgBox File & " not implemented yet." '*
End Select

If Not (F1 Is Nothing) And Cmd <> "" Then
    F1.FormCommand = Cmd
End If

End Sub

Function QuotesAround (inside As String) As String
Dim x As Integer, temp As String

If InStr(inside, "'") = 0 Then
    QuotesAround = "'" & inside & "'"
ElseIf InStr(inside, Chr$(34)) = 0 Then
    QuotesAround = Chr$(34) & inside & Chr$(34)
Else
    temp = ""
    For x = 1 To Len(inside)
	If Mid$(inside, x, 1) = Chr$(34) Then
	    temp = temp & Chr$(34) & Chr$(34)
	Else
	    temp = temp & Mid$(inside, x, 1)
	End If
    Next x
    QuotesAround = temp
End If

End Function

Function ReadIniInt (Section As String, Entry As String, default As Integer) As Integer
Dim INIFile As String

INIFile = App.EXEName & ".ini"
ReadIniInt = GetPrivateProfileInt(Section, Entry, default, INIFile)

End Function

Function ReadIniString (Section As String, Entry As String) As String
Dim INIFile  As String
Dim DefaultString As String, ReturnString As String
Dim StringLength As Integer, ReturnLength As Integer

INIFile = App.EXEName & ".INI"
DefaultString = ""
ReturnString = Space$(255)
StringLength = Len(ReturnString)
ReturnLength = GetPrivateProfileString(Section, ByVal Entry, DefaultString, ReturnString, StringLength, INIFile)

ReadIniString = Left$(ReturnString, ReturnLength)

End Function

Sub SendAll (message As String)
Dim x As Integer

On Error Resume Next

For x = 0 To Forms.Count - 1
    Forms(x).FormCommand = message
Next x

End Sub

Sub WriteIni (Section As String, Entry As String, Value As String)
Dim dummy As Integer
Dim INIFile As String

INIFile = App.EXEName & ".INI"
If Value = "" Then
    dummy = WritePrivateProfileString(Section, ByVal Entry, 0&, INIFile)
Else
    dummy = WritePrivateProfileString(Section, ByVal Entry, ByVal Value, INIFile)
End If

End Sub

