'
' LCL4B.INC
'

 DEFINT A-Z

REM PCL4B functions

 DECLARE FUNCTION SioBaud CDECL (BYVAL Port,BYVAL BaudCode)
 DECLARE FUNCTION SioBrkKey CDECL()
 DECLARE FUNCTION SioBrkSig CDECL(BYVAL Port,BYVAL Char)
 DECLARE FUNCTION SioCrtWrite CDECL(BYVAL Char)
 DECLARE FUNCTION SioCTS CDECL(BYVAL Port)
 DECLARE FUNCTION SioDCD CDECL(BYVAL Port)
 DECLARE FUNCTION SioDSR CDECL(BYVAL Port)
 DECLARE FUNCTION SioDTR CDECL(BYVAL Port,BYVAL Char)
 DECLARE FUNCTION SioDelay CDECL (BYVAL Tics)
 DECLARE FUNCTION SioDone  CDECL (BYVAL Port)
 DECLARE FUNCTION SioError CDECL(BYVAL Code)
 DECLARE FUNCTION SioGetDiv CDECL (BYVAL Port)
 DECLARE FUNCTION SioGetc  CDECL (BYVAL Port,BYVAL Tics)
 DECLARE FUNCTION SioInfo CDECL(BYVAL Char)
 DECLARE FUNCTION SioKeyPress CDECL()
 DECLARE FUNCTION SioKeyRead CDECL()
 DECLARE FUNCTION SioLine CDECL(BYVAL Port)
 DECLARE FUNCTION SioModem CDECL(BYVAL Port,BYVAL Char)
 DECLARE FUNCTION SioParms CDECL(BYVAL Port,BYVAL Code1,BYVAL Code2,BYVAL Code3)
 DECLARE FUNCTION SioPutc  CDECL (BYVAL Port,BYVAL Char)
 DECLARE FUNCTION SioRead CDECL(BYVAL Port,BYVAL Code)
 DECLARE FUNCTION SioReset CDECL (BYVAL Port,BYVAL BaudCode)
 DECLARE FUNCTION SioRI CDECL(BYVAL Port)
 DECLARE FUNCTION SioRTS CDECL(BYVAL Port,BYVAL Char)
 DECLARE FUNCTION SioRxBuf CDECL (BYVAL Port,BYVAL PtrSeg,BYVAL Size)
 DECLARE FUNCTION SioRxFlush CDECL(BYVAL Port)
 DECLARE FUNCTION SioRxQue CDECL(BYVAL Port)
 DECLARE FUNCTION SioTimer& CDECL()
 DECLARE FUNCTION SioUnGetc CDECL(BYVAL Port,BYVAL Char)

REM COM port codes

 CONST COM1 = 0
 CONST COM2 = 1
 CONST COM3 = 2
 CONST COM4 = 3

REM Baud codes

 CONST Baud300 = 0
 CONST Baud600 = 1
 CONST Baud1200 = 2
 CONST Baud2400 = 3
 CONST Baud4800 = 4
 CONST Baud9600 = 5
 CONST Baud19200 = 6
 CONST Baud38400 = 7
 CONST Baud57600 = 8
 CONST Baud115200 = 9
 CONST NORESET = -1

REM Parity Codes

CONST NoParity  = 0
CONST OddParity  = 1
CONST EvenParity = 3
CONST MarkParity = 5
CONST SpaceParity = 7

REM Stop Bit Codes

CONST OneStopBit  = 0
CONST TwoStopBits = 1

REM Word Length Codes

CONST WordLength5  = 0
CONST WordLength6  = 1
CONST WordLength7  = 2
CONST WordLength8  = 3

REM Buffer Size Codes

CONST Size128  = 4
CONST Size256  = 5
CONST Size512  = 6
CONST Size1024 = 7
CONST Size2048 = 8
CONST Size4096 = 9
CONST Size8192 = 10
CONST Size16384 = 11
CONST Size32768 = 12
CONST Size1K   = 7
CONST Size2K   = 8
CONST Size4K   = 9
CONST Size8K   = 10
CONST Size16K  = 11
CONST Size32K  = 12

REM Line Status Masks

CONST TransBufferEmpty = 32
CONST BreakDetect  = 16
CONST FramingError = 8
CONST ParityError  = 4
CONST OverrunError = 2
CONST DataReady    = 1

REM Modem Status Masks

CONST DCD = 128
CONST RI  =  64
CONST DSR =  32
CONST CTS =  16
CONST DeltaDCD = 8
CONST DeltaRI  = 4
CONST DeltaDSR = 2
CONST DeltaCTS = 1

REM Break Signal Commands

CONST ASSERT_BREAK = 65
CONST CANCEL_BREAK = 67
CONST DETECT_BREAK = 68

REM SioDTR & SioRTS Commands

CONST SET_LINE   = 83
CONST CLEAR_LINE = 67
CONST READ_LINE  = 82

REM SioInfo Commands

CONST VERSION = 86
