VERSION 2.00
Begin Form Form1 
   Caption         =   "List Controls: Columns and Selections"
   ClientHeight    =   4335
   ClientLeft      =   2280
   ClientTop       =   1650
   ClientWidth     =   5760
   Height          =   4740
   Left            =   2220
   LinkTopic       =   "Form1"
   ScaleHeight     =   4335
   ScaleWidth      =   5760
   Top             =   1305
   Width           =   5880
   Begin TextBox Text2 
      Height          =   285
      Left            =   240
      TabIndex        =   3
      Top             =   2400
      Width           =   5295
   End
   Begin CommandButton Command2 
      Caption         =   "E&xit"
      Height          =   495
      Left            =   3000
      TabIndex        =   6
      Top             =   3600
      Width           =   2535
   End
   Begin ListBox List2 
      Height          =   1200
      Left            =   240
      Sorted          =   -1  'True
      TabIndex        =   4
      Top             =   2880
      Width           =   2535
   End
   Begin TextBox Text1 
      BorderStyle     =   0  'None
      Enabled         =   0   'False
      ForeColor       =   &H00C00000&
      Height          =   255
      Left            =   240
      MultiLine       =   -1  'True
      TabIndex        =   0
      Text            =   "Text1"
      Top             =   120
      Width           =   855
   End
   Begin CommandButton Command1 
      Caption         =   "Command1"
      Height          =   495
      Left            =   3000
      TabIndex        =   5
      Top             =   3000
      Width           =   2535
   End
   Begin ListBox List1 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1230
      Left            =   240
      Sorted          =   -1  'True
      TabIndex        =   1
      Top             =   480
      Width           =   5295
   End
   Begin ComboBox Combo1 
      Height          =   300
      Left            =   240
      Sorted          =   -1  'True
      Style           =   2  'Dropdown List
      TabIndex        =   2
      Top             =   1920
      Width           =   5295
   End
End
'Although multi-column listboxes are a common
'requirement, they are difficult to accomplish
'in VB.

'A simple solution is to select a mono-spaced
'font for the listbox and align the data manually,
'but this is not always visually appealing.  However,
'with a little more work you can set dynamic tabstops
'that will work with proportional fonts.

'This sample shows how to set tabstops in a listbox,
'using a borderless, disabled text box for the column
'headings.  It also shows how to "pre-select" a listbox
'or combobox item, using Windows API functions.

Option Explicit

Dim Fruit(10) As String, MyFruit As String
Dim TabStopsSet As Integer

Sub Combo1_Click ()

MyFruit = Combo1.Text
Text2.Text = MyFruit

Call SelectFruit  'synchronize the listbox

End Sub

Sub Command1_Click ()

Call SetTabStops

End Sub

Sub Command2_Click ()

Unload Form1

End Sub

Sub Form_Load ()

Dim F As Integer

'load up some multi-column data

Text1.Text = "Fruit" + Chr$(9) + "Opinion" + Chr$(9) + "Color"

Fruit(1) = "Oranges" + Chr$(9) + "Good" + Chr$(9) + "Orange, of course"
Fruit(2) = "Bananas" + Chr$(9) + "Munchy" + Chr$(9) + "Yellow"
Fruit(3) = "Apples" + Chr$(9) + "Delicious" + Chr$(9) + "Red"
Fruit(4) = "Blueberries" + Chr$(9) + "Nah" + Chr$(9) + "Blue"
Fruit(5) = "Plums" + Chr$(9) + "Better than prunes" + Chr$(9) + "Purple"
Fruit(6) = "Watermelons" + Chr$(9) + "Marvelous" + Chr$(9) + "Red and Green"
Fruit(7) = "Cherries" + Chr$(9) + "Ummm..." + Chr$(9) + "Bright Red"
Fruit(8) = "Mangos" + Chr$(9) + "Juicy" + Chr$(9) + "No idea"
Fruit(9) = "Kiwis" + Chr$(9) + "Kinda weird" + Chr$(9) + "Fuzzy Green"
Fruit(10) = "Peaches" + Chr$(9) + "OK" + Chr$(9) + "Peach, I guess(?)"

For F = 1 To UBound(Fruit)
   List1.AddItem Fruit(F)
   
   'comboboxes don't support columns, so only use first string

   Combo1.AddItem Left$(Fruit(F), InStr(Fruit(F), Chr$(9)) - 1)
Next

For F = 0 To Screen.FontCount - 1
   List2.AddItem Screen.Fonts(F)
Next

TabStopsSet = True
Command1.Value = True  'trigger tab stops

End Sub

Sub List1_Click ()

MyFruit = List1.Text

If Len(MyFruit) > 0 Then
   MyFruit = Left$(MyFruit, InStr(MyFruit, Chr$(9)) - 1)
   Text2.Text = MyFruit

   Call SelectFruit  'synchronize the combobox
End If

End Sub

Sub List2_Click ()

List1.FontName = List2.List(List2.ListIndex)
List1.Height = (Combo1.Top - List1.Top) - 10

TabStopsSet = Not TabStopsSet
Command1.Value = True  'trigger tab stops

End Sub

Sub SelectFruit ()

If SelectListItem(List1, MyFruit) Then
   If SelectListItem(Combo1, MyFruit) Then
   End If
End If

End Sub

Sub SetTabStops ()

If TabStopsSet Then
   If SetListCols(List1, Text1, False, True) Then
      Command1.Caption = "Set &Custom Tab Stops"
      TabStopsSet = Not TabStopsSet
   End If
Else
   If SetListCols(List1, Text1, False, False) Then
      Command1.Caption = "Reset &Default Tab Stops"
      TabStopsSet = Not TabStopsSet
   End If
End If

End Sub

Sub Text2_Change ()

MyFruit = Text2.Text
Call SelectFruit  'synchronize the listbox and combobox

End Sub

