DefInt A-Z
 
' --------------------------------------------------------
' Get any errors during execution of common OpenSave
' --------------------------------------------------------
Declare Function CommDlgExtendedError Lib "COMMDLG.DLL" () As Long
' --------------------------------------------------------
 
' --------------------------------------------------------
' File Open/Save structures and declarations
' --------------------------------------------------------
Type DLGFILENAME
     lStructSize As Long
     hwndOwner As Integer
     hInstance As Integer
     lpstrFilter As Long
     lpstrCustomFilter As Long
     nMaxCustFilter As Long
     nFilterIndex As Long
     lpstrFile As Long
     nMaxFile As Long
     lpstrFileTitle As Long
     nMaxFileTitle As Long
     lpstrInitialDir As Long
     lpstrTitle As Long
     Flags As Long
     nFileOffset As Integer
     nFileExtension As Integer
     lpstrDefExt As Long
     lCustData As Long
     lpfnHook As Long
     lpTemplateName As Long
End Type

Declare Function GetOpenFileName Lib "COMMDLG.DLL" (pDLGFILENAME As DLGFILENAME) As Integer
Declare Function GetSaveFileName Lib "COMMDLG.DLL" (pDLGFILENAME As DLGFILENAME) As Integer
Declare Function GetFileTitle Lib "COMMDLG.DLL" (ByVal FName As String, ByVal Title As String, Size As Integer)

Global Const OFN_READONLY = &H1
Global Const OFN_OVERWRITEPROMPT = &H2
Global Const OFN_HIDEREADONLY = &H4
Global Const OFN_NOCHANGEDIR = &H8
Global Const OFN_SHOWHELP = &H10
Global Const OFN_ENABLEHOOK = &H20
Global Const OFN_ENABLETEMPLATE = &H40
Global Const OFN_ENABLETEMPLATEHANDLE = &H80
Global Const OFN_NOVALIDATE = &H100
Global Const OFN_ALLOWMULTISELECT = &H200
Global Const OFN_EXTENSIONDIFFERENT = &H400
Global Const OFN_PATHMUSTEXIST = &H800
Global Const OFN_FILEMUSTEXIST = &H1000
Global Const OFN_CREATEPROMPT = &H2000
Global Const OFN_SHAREAWARE = &H4000
Global Const OFN_NOREADONLYRETURN = &H8000
Global Const OFN_NOTESTFILECREATE = &H10000
Global Const OFN_SHAREFALLTHROUGH = 2
Global Const OFN_SHARENOWARN = 1
Global Const OFN_SHAREWARN = 0

' --------------------------------------------------------
' GLOBAL MEMORY Stuff
' --------------------------------------------------------
Declare Function GlobalAlloc Lib "Kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
Declare Function GlobalFree Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hMem As Integer) As Integer

Global Const GMEM_MOVEABLE = &H2
Global Const GMEM_ZEROINIT = &H40
Global Const GHND = (GMEM_MOVEABLE Or GMEM_ZEROINIT)

Declare Sub hmemcpy Lib "Kernel" (lpDest As Any, lpSource As Any, ByVal dwBytes As Long)
' --------------------------------------------------------

Function CmdError$ (x&)
    If x& = 32765 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "Common dialog function failed during initialization (not enough memory?)."
    ElseIf x& = 32761 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "Common dialog function failed to load a specified string."
    ElseIf x& = 32760 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "Common dialog function failed to load a specified resource."
    ElseIf x& = 32759 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "Common dialog function failed to lock a specified resource."
    ElseIf x& = 32758 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "Common dialog function unable to allocate memory for internal data structures."
    ElseIf x& = 32757 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "Common dialog function unable to lock memory associated with a handle."
    ElseIf x& = 32755 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "Cancel was selected."
    ElseIf x& = 32752 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "Couldn't allocate memory for FileName or Filter."
    ElseIf x& = 32751 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The call to WinHelp failed.  Check the Help property values."
    ElseIf x& = 28671 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The PD_RETURNDEFAULT flag was set in the Flags member of PRINTDLG data structure, but either hDevMode or hDevNames field were nonzero."
    ElseIf x& = 28670 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "Load of the required resources failed."
    ElseIf x& = 28669 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The common dialog function failed to parse the strings in the [devices] section of the WIN.INI file."
    ElseIf x& = 28668 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The PD_RETURNDEFAULT flag was set in the Flags member of PRINTDLG data structure, but either hDevMode or hDevNames field were nonzero."
    ElseIf x& = 28667 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The PRINTDLG function failed to load the specified printer's device driver."
    ElseIf x& = 28666 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The printer device-driver failed to initialize a DEVMODE data structure (print driver written for WIN 3.0 or later)."
    ElseIf x& = 28665 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The PRINTDLG function failed during initialization."
    ElseIf x& = 28664 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "No printer device-drivers were found."
    ElseIf x& = 28663 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "A default printer does not exist."
    ElseIf x& = 28662 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The data in the DEVMODE and DEVNAMES data structrues describes two different printers."
    ElseIf x& = 28661 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The PRINTDLG function failed when it attempted to create an information context."
    ElseIf x& = 28660 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The [devices] section of the WIN.INI file does not contain an entry for requested printer."
    ElseIf x& = 24574 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "No fonts exist.  Must set internally to CF_BOTH, CF_PRINTERFONTS or CF_SCREENFONTS."
    ElseIf x& = 20478 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "An attempt to subclass a listbox failed due to insufficient memory."
    ElseIf x& = 20477 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "File name is invalid."
    ElseIf x& = 20476 Then
        PError$ = "#" + LTrim$(Str$(x&)) + ",  " + "The buffer at which the member lpstrFile points to is too small."
    Else
        PError$ = "Unknow Printer Error:  #" + Str$(x&)
    End If
End Function

'
  ' ----------------------------------------------------
  ' Status% = 0 means everything OK
  ' Status% = 1 means couldn't allocate global memory
  ' Status% = 2 means couldn't lock global memory
  ' Status% = 3 means had error returned from common dialog
  ' FError& tells you WHAT error if Status% = 3
  ' ----------------------------------------------------
'
Function OpenFile$ (MyForm As Form, Status%, FError&, Filter$, IDir$, Title$, Index%, Flags&)
    
  MyForm.Cls
  OpenFile$ = "": Status% = 0: SaveError% = 0

  Dim O As DLGFILENAME
  Dim Address As Long

  ' ----------------------------------------------------
  ' First Copy the strings to the Global Memory Block
  ' Use a sub-allocation scheme to avoid overloading
  '   the LDT
  ' ----------------------------------------------------
  szFile$ = String$(256, 0)
  szFilter$ = Filter$
  szInitialDir$ = IDir$
  szTitle$ = Title$
  wSize = Len(szFile$) + Len(szFilter$) + Len(szInitialDir$) + Len(szTitle$)
  MemHandle = GlobalAlloc(GHND, wSize)
  If MemHandle = 0 Then
    Status% = 1
    Exit Function
  End If
    
  Address = GlobalLock(MemHandle) ' Lock global memory, then copy it to local memory
  If Address = 0 Then
    Status% = 2
    Exit Function
  Else
    Call hmemcpy(ByVal Address, ByVal (szFile$ + szFilter$ + szInitialDir$ + szTitle$), wSize)
  End If
    
  O.lStructSize = Len(O)
  O.hwndOwner = MyForm.hWnd
  O.Flags = Flags&
  O.nFilterIndex = Index%
  O.lpstrFile = Address
  O.nMaxFile = Len(szFile$)
  O.lpstrFilter = Address + Len(szFile$)
  O.lpstrInitialDir = O.lpstrFilter + Len(szFilter$)
  O.lpstrTitle = O.lpstrInitialDir + Len(szInitialDir$)

  Result = GetOpenFileName(O)
  FError& = CommDlgExtendedError()
    
  If Result = 0 Then
    Status% = 3
  Else
    Call hmemcpy(ByVal szFile$, ByVal Address, Len(szFile$))
  End If
    
  OK = GlobalUnlock(MemHandle)    'Free The Memory
  OK = GlobalFree(MemHandle)

  If Result = 0 Then Exit Function
  OpenFile$ = Left$(szFile$, InStr(szFile$, Chr$(0)) - 1)

End Function

'
  ' ----------------------------------------------------
  ' Status% = 0 means everything OK
  ' Status% = 1 means couldn't allocate global memory
  ' Status% = 2 means couldn't lock global memory
  ' Status% = 3 means had error returned from common dialog
  ' FError& tells you WHAT error if Status% = 3
  ' ----------------------------------------------------
'
Function SaveFile$ (MyForm As Form, Status%, FError&, Filter$, IDir$, FileMask$, Index%, Title$, Flags&)
    
  MyForm.Cls
  SaveFile$ = "": Status% = 0: FError& = 0

  ' This is similar to GetOpenFileName
  Dim S As DLGFILENAME
  Dim Address As Long
  ' ----------------------------------------------------
  ' First Copy the strings to the Global Memory Block
  ' Use a sub-allocation scheme to avoid wearing down
  '   the LDT
  ' ----------------------------------------------------
  NoTitle$ = FileMask$
  szFile$ = NoTitle$ + String$(256 - Len(NoTitle$), 0)
  szFilter$ = Filter$
  szInitialDir$ = IDir$
  szTitle$ = Title$
  wSize = Len(szFile$) + Len(szFilter$) + Len(szInitialDir$) + Len(szTitle$)
  MemHandle = GlobalAlloc(GHND, wSize)
  If MemHandle = 0 Then
    Status% = 1
    Exit Function
  End If

  Address = GlobalLock(MemHandle)
  If Address = 0 Then
    Status% = 2
    Exit Function
  Else
    Call hmemcpy(ByVal Address, ByVal (szFile$ + szFilter$ + szInitialDir$ + szTitle$), wSize)
  End If

  S.lStructSize = Len(S)
  S.hwndOwner = MyForm.hWnd
  S.Flags = Flags&
  S.nFilterIndex = Index%
  S.lpstrFile = Address
  S.nMaxFile = Len(szFile$)
  S.lpstrFilter = Address + Len(szFile$)
  S.lpstrInitialDir = S.lpstrFilter + Len(szFilter$)
  S.lpstrTitle = S.lpstrInitialDir + Len(szInitialDir$)

  Result = GetSaveFileName(S)
  FError& = CommDlgExtendedError()

  If Result = 0 Then
    Status% = 3
    Exit Function
  Else
    Call hmemcpy(ByVal szFile$, ByVal Address, Len(szFile$))
  End If

  OK = GlobalUnlock(MemHandle)    'Free The Memory
  OK = GlobalFree(MemHandle)

  SaveFile$ = Left$(szFile$, InStr(szFile$, Chr$(0)) - 1)

End Function

