Option Explicit
Type DateInfo
    theDate As Long
    theString As String
End Type

Dim DateInfoList() As DateInfo

Type DateRange
    StartDate As Long
    EndDate As Long
    Description As String
    color As Long
End Type

Dim DateRangeList() As DateRange

Global CR  As String

'==========
' Some Windows API Declarations
Type RECT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

Type POINTAPI
    X As Integer
    Y As Integer
End Type

Global Const PS_SOLID = 0
Global Const DT_LEFT = &H0
Global Const DT_SINGLELINE = &H20
Global Const DT_VCENTER = &H4
Global Const DT_CENTER = &H1
Global Const LTGRAY_BRUSH = 1
Global Const WHITE_BRUSH = 0
Global Const FW_NORMAL = 400
Global Const FW_BOLD = 700
Global Const LOGPIXELSX = 88    '  Logical pixels/inch in X
Global Const LOGPIXELSY = 90    '  Logical pixels/inch in Y
Global Const DEFAULT_PITCH = 0
Global Const FF_DONTCARE = 0    '  Don't care or don't know.
Global Const NULL_PEN = 8
Global Const SRCAND = &H8800C6  ' (DWORD) dest = source AND dest
Global Const TRANSPARENT = 1
Global Const DT_WORDBREAK = &H10
Global Const BLACK_PEN = 7

Declare Function CreatePen Lib "GDI" (ByVal nPenStyle As Integer, ByVal nWidth As Integer, ByVal crColor As Long) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function SetBkColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function setBkMode Lib "GDI" (ByVal hDC As Integer, ByVal nBkMode As Integer) As Integer
Declare Function SetTextColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function Rectangle Lib "GDI" (ByVal hDC As Integer, ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer) As Integer
Declare Function DrawText Lib "User" (ByVal hDC As Integer, ByVal lpStr As String, ByVal nCount As Integer, lpRect As RECT, ByVal wFormat As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function GetStockObject Lib "GDI" (ByVal nIndex As Integer) As Integer
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer
Declare Function CreateFont% Lib "GDI" (ByVal H%, ByVal W%, ByVal E%, ByVal O%, ByVal W%, ByVal I%, ByVal U%, ByVal S%, ByVal C%, ByVal OP%, ByVal CP%, ByVal Q%, ByVal PAF%, ByVal F$)
Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Function MoveTo Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer) As Long
Declare Function LineTo Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer) As Integer
Declare Function Ellipse Lib "GDI" (ByVal hDC As Integer, ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer) As Integer
Declare Sub InflateRect Lib "User" (lpRect As RECT, ByVal X As Integer, ByVal Y As Integer)

Sub DateInfoAdd (aDate As Long, aString As String)
Dim num As Integer
Dim I As Integer
Dim found As Integer

    found = False
    On Error Resume Next
    num = UBound(DateInfoList)
    If Err <> 0 Then
	num = 0
    End If

    For I = 0 To num - 1
	If DateInfoList(I).theDate = aDate Then
	    found = True
	    Exit For
	End If
    Next
    
    If Not found Then
	On Error Resume Next
	num = num + 1
    
	ReDim Preserve DateInfoList(num) As DateInfo
    
	DateInfoList(num - 1).theDate = aDate
	DateInfoList(num - 1).theString = aString
    Else
	DateInfoList(I).theString = DateInfoList(I).theString + CR + aString
    End If
End Sub

Sub DateInfoMove (oldDate As Long, newDate As Long)
Dim I As Integer
    For I = 0 To UBound(DateInfoList) - 1
	If DateInfoList(I).theDate = oldDate Then
	    DateInfoList(I).theDate = newDate
	    Exit Sub
	End If
    Next
End Sub

Sub DateRangeAdd (FromDate As Long, ToDate As Long, Desc As String, color As Long)
Dim num As Integer
Dim I As Integer
Dim found As Integer

    found = False
    On Error Resume Next
    num = UBound(DateRangeList)
    If Err <> 0 Then
	num = 0
    End If

    On Error Resume Next
    num = num + 1
    
    ReDim Preserve DateRangeList(num) As DateRange
    
    DateRangeList(num - 1).StartDate = FromDate
    DateRangeList(num - 1).EndDate = ToDate
    DateRangeList(num - 1).Description = Desc
    DateRangeList(num - 1).color = color


End Sub

Function GetDateInfo (aDate As Long) As String
Dim I As Integer

    For I = 0 To UBound(DateInfoList) - 1
	If DateInfoList(I).theDate = aDate Then
	    GetDateInfo = DateInfoList(I).theString
	    Exit Function
	End If
    Next

    GetDateInfo = ""
End Function

Function GetDateRangeInfo (aDate As Long, Info As DateRange)
Dim I As Integer

    On Error Resume Next
    For I = 0 To UBound(DateRangeList) - 1
	If DateRangeList(I).StartDate <= aDate And DateRangeList(I).EndDate >= aDate Then
	    Info = DateRangeList(I)
	    GetDateRangeInfo = True
	    Exit Function
	End If
    Next

    GetDateRangeInfo = False

End Function

Sub SetDescription (S As String)
    Form6.txtSampleDescription.Text = S
End Sub

