DefInt A-Z

Declare Function GetSystemMenu Lib "User" (ByVal Hwnd, ByVal bRevert)
Declare Function RemoveMenu Lib "User" (ByVal hMenu, ByVal nPosition, ByVal wFlags)

Const MF_BYPOSITION = &H400


' Modal dialog boxes usually do not have a System menu or if
' they do, they consist of only MOVE and CLOSE options.  This
' routine is called when a Modal dialog box is about to be
' displayed, to remove all but the MOVE and CLOSE options
' from the forms system menu.  IconWorks has only two Modal
' dialog boxes: About and SaveFileDlg
'
Sub Remove_Items_From_Sysmenu (A_Form As Form)

    ' Obtain the handle to the forms System menu
    '
    HSysMenu = GetSystemMenu(A_Form.Hwnd, 0)
  
    ' Remove all but the MOVE and CLOSE options.  The menu items
    ' must be removed starting with the last menu item to prevent
    ' the menu items from taking on new position values as other
    ' menu items are being removed.
    '
    R = RemoveMenu(HSysMenu, 8, MF_BYPOSITION) 'Switch to
    R = RemoveMenu(HSysMenu, 7, MF_BYPOSITION) 'Separator
    R = RemoveMenu(HSysMenu, 5, MF_BYPOSITION) 'Separator
    R = RemoveMenu(HSysMenu, 4, MF_BYPOSITION) 'Maximize
    R = RemoveMenu(HSysMenu, 3, MF_BYPOSITION) 'Minimize
    R = RemoveMenu(HSysMenu, 2, MF_BYPOSITION) 'Size
    R = RemoveMenu(HSysMenu, 0, MF_BYPOSITION) 'Restore

End Sub

