//---------------------------------------------------------------------------
// ini.h
//---------------------------------------------------------------------------
// Written 8/93, Walter F. Dexter.
// Based to a large extend on Microsoft's Generic Control sample.
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Resource Information
//---------------------------------------------------------------------------
// Toolbox bitmap resource IDs numbers.
//---------------------------------------------------------------------------
#define IDBMP_INI_UP    8000
#define IDBMP_INI_DOWN  8001
#define IDBMP_INI_MONO  8003
#define IDBMP_INI_EGA   8006

//---------------------------------------------------------------------------
// Change these for each new VBX file
//---------------------------------------------------------------------------
#define VBX_COMPANYNAME 	   "Walter F. Dexter\0"
#define VBX_FILEDESCRIPTION	   "Visual Basic INI File VBX\0"
#define VBX_INTERNALNAME	   "INI\0"
#define VBX_LEGALCOPYRIGHT	   "Copyright \251 Walter F. Dexter 1993\0"
#define VBX_LEGALTRADEMARKS	   "Microsoft\256 is a registered trademark of Microsoft Corporation. Visual Basic\231 is a trademark of Microsoft Corporation. Windows\231 is a trademark of Microsoft Corporation.\0"
#define VBX_ORIGINALFILENAME	   "INI.VBX\0"
#define VBX_PRODUCTNAME 	   "Microsoft\256 Visual Basic\231 for Windows\231\0"


//---------------------------------------------------------------------------
// Update these fields for each build.
//---------------------------------------------------------------------------
#define VBX_VERSION		    1,00,0,00
#define VBX_VERSION_STR 	   "1.00.000\0"

#define OFFSETIN(struc, field)	((USHORT)&( ((struc *)0)->field ))

typedef struct tagINI {
	   HSZ	hszText;
	   HSZ	hszFilename;
	   HSZ	hszSection;
	   HSZ	hszEntry;
	   HSZ	hszDefault;
	  ENUM  enAction;
} INI, FAR *PINI;

LONG FAR PASCAL _export IniCtlProc(HCTL, HWND, USHORT, USHORT, LONG);

PROPINFO Property_Entry =
{
    "Entry",
    DT_HSZ | PF_fGetData | PF_fSetData | PF_fSaveData,
    OFFSETIN(INI, hszEntry),
	0, 0, NULL, 0
};
PROPINFO Property_FileName =
{
    "FileName",
    DT_HSZ | PF_fGetData | PF_fSetData | PF_fSaveData,
    OFFSETIN(INI, hszFilename),
	0, 0, NULL, 0
};

PROPINFO Property_Section =
{
    "Section",
    DT_HSZ | PF_fGetData | PF_fSetData | PF_fSaveData,
    OFFSETIN(INI, hszSection),
	0, 0, NULL, 0
};

PROPINFO Property_Default =
{
    "Default",
    DT_HSZ | PF_fGetData | PF_fSetData | PF_fSaveData,
    OFFSETIN(INI, hszDefault),
	0, 0, NULL, 0
};

CHAR szActions[] = 	"0 - No Action\0"
					"1 - Write\0"
					"2 - Read\0"
					"3 - Delete Entry\0"
					"4 - Delete Section\0";

#define ACTION_NONE 0
#define ACTION_WRITE 1
#define ACTION_READ 2
#define ACTION_DEL_ENTRY 3
#define ACTION_DEL_SECTION 4
					
PROPINFO Property_Action =
{
    "Action",
    DT_ENUM | PF_fGetData | PF_fSetMsg | PF_fNoShow,
    OFFSETIN(INI, enAction),
	0, 0, szActions, 4
};

enum IniProperties	{
					IPROP_INI_CTLNAME,
					IPROP_INI_INDEX,
					IPROP_INI_LEFT,
					IPROP_INI_TOP,
					IPROP_INI_TEXT,
					IPROP_INI_ENTRY,
					IPROP_INI_FILENAME,
					IPROP_INI_SECTION,
					IPROP_INI_DEFAULT,
					IPROP_INI_ACTION
					};


PPROPINFO Ini_Properties[] =
{
    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_LEFTNORUN,
    PPROPINFO_STD_TOPNORUN,
    PPROPINFO_STD_TEXT,
    &Property_Entry,
    &Property_FileName,
    &Property_Section,
	&Property_Default,
	&Property_Action,
    NULL
};

MODEL modelIni =
{
    VB_VERSION, 				// VB version being used
    MODEL_fInvisAtRun,			// MODEL flags
    (PCTLPROC)IniCtlProc,		// Control procedures
    CS_VREDRAW | CS_HREDRAW,	// Class style
    WS_CHILD | WS_BORDER,		// Default Windows style
    sizeof(INI),				// Size of PIX structure
    IDBMP_INI_UP,           	// Palette bitmap ID
    "IniFile",					// Default control name
    "IniFile",					// Visual Basic class name
    NULL,						// Parent class name
    Ini_Properties,				// Property information table
    NULL,        				// Event information table
	NULL,						// Default Property- Property Box
	NULL,						// Default Event- Code Window
	IPROP_INI_TEXT				// Default Property- Runtime
	
};
