//---------------------------------------------------------------------------
// ini.c
// 
// Written and Copyright 8/93 Walter F. Dexter
// Distribute freely per "ini.wri".
//---------------------------------------------------------------------------
//
// Compiled using BCC 3.1.
//

#include <windows.h>
#include <vbapi.h>
#include <string.h>
#include <dos.h>
#include "ini.h"

//---------------------------------------------------------------------------
// Global Variables
//---------------------------------------------------------------------------
#define MAX_READLEN 	256

BOOL bDevTimeInit = FALSE;
HANDLE hModDLL;
HBITMAP HBitmap;
WORD cVBXusers = 0;
USHORT bmWidth;
USHORT bmHeight;
static char scratch[MAX_READLEN];

/***  Function prototypes  ***/
VOID PASCAL PaintControl(HWND hwnd);


/****************************************************************************
 *
 *  FUNCTION:  IniCtlProc(HCTL, HWND, USHORT, USHORT, LONG)
 *
 *  PURPOSE:   This routine is the subclassed window procedure.  Visual Basic
 *             passes VBM_, VBN_, and WM_ messages to this routine.
 *             The custom control determines which messages to process.
 *             Any messages that are not processed need to passed on to the
 *             default message processing routine VBDefControlProc().
 *
 *  Unlike most of this, which was essentially written by Microsoft, I actually
 *  wrote (or at least put together from multiple examples) most of the code 
 *  in this function.
 *
 *  Walt Dexter, 8/93.
 *
 ******************************************************************************/

LONG FAR PASCAL _export IniCtlProc(HCTL hctl, HWND hwnd, USHORT msg,
			USHORT wp, LONG lp)
{
	PINI			pIni;
	//LPSTR			lpStr;

    switch (msg) 
	{
        case WM_SIZE:
			/*
			 *	Set the sizing border of the control to the exact size
			 *	of the bitmap.
			 */
			SetWindowPos(hwnd, NULL, 0, 0, bmWidth, bmHeight,
				SWP_NOMOVE | SWP_NOZORDER);
			break;

        case VBM_CREATED:
			/*
			 *	The Generic custom control is an invisible control.  If we
			 *	are in design mode, display it; if we are not in design mode,
			 *	don't allow the control to be displayed.
			 */
			if (VBGetMode() == MODE_RUN)
				return 0L;
	
			break;

        case VBM_SETPROPERTY:
			/*
			 *	When the Action property is set to a valid value, execute the
			 *	the specified action based on other property values.  The
			 *	Action property acts as a pseudo-method.
			 */
			pIni = (PINI)VBDerefControl(hctl);
		
			if (wp != IPROP_INI_ACTION)
			{
				break;
			}

			pIni->enAction = lp;

			switch ((short)lp) 
			{
				case ACTION_NONE:
					break;

				case ACTION_WRITE:
					{
						if ((pIni->hszSection) &&
							(pIni->hszEntry) &&
							(pIni->hszText) &&
							(pIni->hszFilename))
						{
							if (WritePrivateProfileString(
									VBLockHsz(pIni->hszSection),
									VBLockHsz(pIni->hszEntry),
									VBLockHsz(pIni->hszText),
									VBLockHsz(pIni->hszFilename)))
							{
								pIni->enAction = 0;
							}

							VBUnlockHsz(pIni->hszSection);
							VBUnlockHsz(pIni->hszEntry);
							VBUnlockHsz(pIni->hszText);
							VBUnlockHsz(pIni->hszFilename);

						}
					}
					break;

				case ACTION_READ:
					{
						if ((pIni->hszSection) &&
							(pIni->hszEntry) &&
							(pIni->hszDefault) &&
							(pIni->hszFilename))
						{
							if (GetPrivateProfileString(
									VBLockHsz(pIni->hszSection),
									VBLockHsz(pIni->hszEntry),
									VBLockHsz(pIni->hszDefault),
									(LPSTR)scratch,
									MAX_READLEN,
									VBLockHsz(pIni->hszFilename)))
							{
								pIni->enAction = 0;
							}

							VBUnlockHsz(pIni->hszSection);
							VBUnlockHsz(pIni->hszEntry);
							VBUnlockHsz(pIni->hszDefault);
							VBUnlockHsz(pIni->hszFilename);

							if (pIni->hszText)
							{
								VBDestroyHsz(pIni->hszText);
								pIni->hszText = VBCreateHsz(
													FP_SEG((void far *)hctl),
													(LPSTR)scratch);
							}
						}
					}
					break;
				case ACTION_DEL_ENTRY:
					{
						if ((pIni->hszSection) &&
							(pIni->hszEntry) &&
							(pIni->hszFilename))
						{
							if (WritePrivateProfileString(
									VBLockHsz(pIni->hszSection),
									VBLockHsz(pIni->hszEntry),
									(LPSTR)0L,
									VBLockHsz(pIni->hszFilename)))
							{
								pIni->enAction = 0;
							}

							VBUnlockHsz(pIni->hszSection);
							VBUnlockHsz(pIni->hszEntry);
							VBUnlockHsz(pIni->hszFilename);

						}
					}
					break;
				case ACTION_DEL_SECTION:
					{
						if ((pIni->hszSection) &&
							(pIni->hszFilename))
						{
							if (WritePrivateProfileString(
									VBLockHsz(pIni->hszSection),
									(LPSTR)0L,
									(LPSTR)0L,
									VBLockHsz(pIni->hszFilename)))
							{
								pIni->enAction = 0;
							}

							VBUnlockHsz(pIni->hszSection);
							VBUnlockHsz(pIni->hszEntry);
							VBUnlockHsz(pIni->hszFilename);

						}
					}break;
			}
			return 0L;

        case WM_SETTEXT:
			{
				HSZ hsz;
				PINI pIni = (PINI)VBDerefControl(hctl);

				if (pIni->hszText)
				{
					VBDestroyHsz(pIni->hszText);
				}
				hsz = VBCreateHsz(FP_SEG((void far *)hctl),(LPSTR)lp);
				pIni = (PINI)VBDerefControl(hctl);
				pIni->hszText = hsz;
			}
			return 0L;

        case WM_GETTEXT:
			{
				LPSTR  lpstr;
				USHORT cch;
				PINI pIni = (PINI)VBDerefControl(hctl);

				if (pIni->hszText == NULL)
				{
					*(LPSTR)lp = 0L;
					wp = 1;
				}
				else
				{
					lpstr = VBDerefHsz(pIni->hszText);
					cch = (USHORT)(lstrlen(lpstr) + 1);
					if (wp > cch)
						wp = cch;
					_fstrncpy((LPSTR)lp, lpstr, wp);
					((LPSTR)lp)[wp - 1] = '\0';
				}
			}
			return (LONG)(wp - 1);

        case WM_GETTEXTLENGTH:
			{
				PINI pIni = (PINI)VBDerefControl(hctl);

				if (pIni->hszText == NULL)
					return 0L;
				else
					return lstrlen(VBDerefHsz(pIni->hszText));
			}

        case WM_PAINT:
			/*
			 *	The Generic custom control must do it's own painting.
			 *	Since the control is never created in run mode, painting
			 *	only occurs in design mode.
			 */
			PaintControl(hwnd);
            break;
    }

    return VBDefControlProc(hctl, hwnd, msg, wp, lp);
}


/****************************************************************************
 *
 *  FUNCTION:  PaintControl(HWND)
 *
 *  PURPOSE:   This routine handles the painting of the control by creating
 *             a memory image of the bitmap and BitBlt'ing it to the screen.
 *
 *  Pure Microsoft.
 *
 ******************************************************************************/

VOID PASCAL PaintControl(HWND hwnd)
{
    HDC		hdcMem;
	PAINTSTRUCT ps;
	
	/*
	 *	Set up the display space for the bitmap.
	 */
	BeginPaint(hwnd, &ps);
    hdcMem = CreateCompatibleDC(ps.hdc);
	if (!hdcMem)
		return;

   	SelectObject(hdcMem, HBitmap);

	/*
	 *	Display the bitmap in the sizing rectangle.
	 */
    BitBlt(ps.hdc, 0, 0, bmWidth, bmHeight, hdcMem, 0, 0, SRCCOPY);

   	DeleteDC(hdcMem);
	EndPaint(hwnd, &ps);
}


/****************************************************************************
 *
 *  FUNCTION:  LibMain(HANDLE, WORD, WORD, LPSTR)
 *
 *  PURPOSE:   Initialize library. This routine is called when the
 *             first client loads the DLL.
 *
 *  Pure Microsoft.
 *
 ******************************************************************************/

int FAR PASCAL LibMain(HANDLE hModule, WORD wDataSeg, WORD cbHeapSize,
						LPSTR  lpszCmdLine)
{
    // Avoid warnings on unused (but required) formal parameters
    wDataSeg	= wDataSeg;
    cbHeapSize	= cbHeapSize;
    lpszCmdLine = lpszCmdLine;

    hModDLL = hModule;

    return 1;
}


/****************************************************************************
 *
 *  FUNCTION:  VBINITCC(USHORT, BOOL)
 *
 *  PURPOSE:   Register custom control.  This routine is called by Visual Basic
 *             or the Visual Basic emulation layer when the custom control DLL
 *             is loaded for use.
 *
 *  Pure Microsoft.
 *
 ******************************************************************************/

BOOL FAR PASCAL _export VBINITCC(USHORT usVersion, BOOL fRuntime)
{
	BITMAP bmp;

    usVersion = usVersion;
	
	/*
	 *	Count the number of hosts using this VBX.  A host can be VB.EXE,
	 *	any .EXE compiled from Visual Basic which uses this custom control,
	 *	or any other program which loads and uses VBX files.
	 */
    ++cVBXusers;

    /*
	 *	Load the bitmap resource so that it can be used by WM_PAINT.
	 */
    if (!fRuntime && !bDevTimeInit) {
		HBitmap = LoadBitmap(hModDLL, MAKEINTRESOURCE(IDBMP_INI_UP));
		if (HBitmap == (HANDLE)NULL)
		{
			return 0L;
		}

	    GetObject(HBitmap, sizeof(BITMAP), (LPSTR)&bmp);
		bmWidth = (USHORT)bmp.bmWidth;
		bmHeight = (USHORT)bmp.bmHeight;

		// We successfully initialized the stuff we need at dev time
		bDevTimeInit = TRUE;
	}

    // Register control(s)
    return VBRegisterModel(hModDLL, &modelIni);
}

//---------------------------------------------------------------------------
// Unregister custom control.  This routine is called by Visual Basic when
// the custom control DLL (VBX) is being unloaded.
//
// Pure Microsoft.
// 
//---------------------------------------------------------------------------
VOID FAR PASCAL _export VBTERMCC(VOID)
{
    --cVBXusers;

    if (cVBXusers == 0 && bDevTimeInit) {
		// Free any resources created for Dev environment
		DeleteObject(HBitmap);
	}
}
