/* HLPKEY.C - Author: Jeff Simms - CIS 72200,3173 - Sept. 21, 1992 */

#include <windows.h>

int __export FAR PASCAL SetHook(HWND);
void  __export FAR PASCAL RemoveHook(void);
DWORD __export FAR PASCAL F1Check(int, WORD, LONG);

HWND ghAppWnd;
HHOOK ghhookKB;

int FAR PASCAL WEP (int nParameter)
{
   return (1);
}                  

int __export FAR PASCAL SetHook (HWND hCallingWnd)
{
   HANDLE handle;
   HOOKPROC lpfnHookProc = NULL;

   ghAppWnd = hCallingWnd;
   handle = GetModuleHandle("HLPKEY.DLL");

   lpfnHookProc = GetProcAddress(handle, "F1Check");
   ghhookKB = SetWindowsHookEx(WH_KEYBOARD, lpfnHookProc, handle, GetWindowTask(hCallingWnd));
   return (int) ghhookKB;
}

void __export FAR PASCAL RemoveHook (void)
{
   UnhookWindowsHookEx(ghhookKB);
}                 

DWORD __export FAR PASCAL F1Check (int nCode, WORD wParam, LONG lParam)
{
   if ((nCode >= 0) && nCode != HC_NOREMOVE && wParam == 112){

      if (lParam & 0x80000000 || lParam & 0x40000000)
	return CallNextHookEx(ghhookKB, nCode, wParam, lParam);

	    PostMessage(ghAppWnd, WM_CHAR, wParam, 0L);
	}

   return CallNextHookEx(ghhookKB, nCode, wParam, lParam);
}                  

/*   HLPKEY.DEF

LIBRARY     HLPKEY
EXETYPE     WINDOWS
STUB        'WINSTUB.EXE'
DESCRIPTION 'DLL for F1 Hook'
CODE        PRELOAD FIXED
DATA        PRELOAD MOVEABLE SINGLE
HEAPSIZE    4096
EXPORTS
            WEP                 @1  RESIDENTNAME
            SetHook             @2
            RemoveHook          @3
	    F1Check		@4
*/
