'Global Module

'3D CyberSpace viewer from...

'Ivory Tower Software
'Richard Wagner, vice president, development
'CIS 76427,2611

'Copyright 1992, all rights reserved.

'You may use this VB source code in your programs if you include attribution in your
'startup and "about" screens in the form: "Portions of this program copyright by
'Ivory Tower Software, used with permission."

'If you do use this code in your application, please let us know. We would like to
'take a look at it. Your comments and suggestions for improving this software are
'welcome.

Type PointAPI
  X As Integer
  Y As Integer
End Type

'Declare Windows API function:
Declare Function Polygon Lib "GDI" (ByVal hDC As Integer, lpPoints As PointAPI, ByVal nCount As Integer) As Integer

'Declare GEO.DLL subroutine:
Declare Sub SolidRotate Lib "Geo.dll" (ByVal o1#, ByVal o2#, ByVal o3#, ByVal p1#, ByVal p2#, ByVal p3#, r1#, r2#, r3#, ByVal theta#)
Declare Sub ThreeDXForm Lib "Geo.dll" (ByVal W%, ByVal D%, ByVal X!, ByVal Y!, ByVal Z!, ByVal VPX!, ByVal VPY!, ByVal VPZ!, ByVal WPX!, ByVal WPY!, ByVal WPZ!, ByVal RPX!, ByVal RPY!, ByVal RPZ!, ByVal SPX!, ByVal SPY!, ByVal SPZ!, PXr!, PYr!, PZr!)

Global Const sfPi = 3.1415927               'Single float Pi is the ratio of a circle's circumference to its diameter

Global sfViewPointX As Single               'View point coordinates in World Space
Global sfViewPointY As Single
Global sfViewPointZ As Single

Global sfWinPointX As Single                'Center of view window in World Space
Global sfWinPointY As Single
Global sfWinPointZ As Single

Global sfRpointX As Single                  'Right edge of view widow in World Space
Global sfRpointY As Single
Global sfRpointZ As Single

Global sfSpointX As Single                  'Top edge of view widow in World Space
Global sfSpointY As Single
Global sfSpointZ As Single

Global iObjectX(326, 1 To 100) As Integer   'Object X coordinate array, 326 types of objects with up to 100 points each
Global iObjectY(326, 1 To 100) As Integer   'Object Y coordinate array, 326 types of objects with up to 100 points each
Global iObjectZ(326, 1 To 100) As Integer   'Object Z coordinate array, 326 types of objects with up to 100 points each
Global iNumPoints(326) As Integer           'Index array of number of points in object types


Global iObjectType(160) As Integer          'Object type (1 = cube, 2 = point, etc.)
Global iLocationX(160) As Integer           'Object center
Global iLocationY(160) As Integer
Global iLocationZ(160) As Integer
Global iColor(160) As Integer               'Object iColor
Global sfSize(160) As Single                'sfSize Factor

Global iNumObjects As Integer               'Number of objects in world space (up to 160 (memory limit))

Global iPx(100) As Integer                  'Integer mapped-to-window object point for PlaceObject
Global iPy(100) As Integer
Global iPz(100) As Integer

Global PxOld(200, 100)  As Integer          'Old point for PlaceObject erase
Global PyOld(200, 100)  As Integer
Global PzOld(200, 100)  As Integer

Global sfDSquared(160) As Single           'Square of object center distance from viewpoint, single floating
Global iObjOrder(160) As Integer           'Object index order by distance from ViewPoint (farthest first)

Global iInView(160) As Integer             'Object is in view
Global iInViewPrev(160) As Integer         'Object was in view

Global iSCNum As Integer                   'Spinning cube object number for Timer1 event


'This demo represents a collaboration by

'   Ivory Tower Software

'           and

'    Software Sculptors

'We hope you like it, and we hope that you will consider licensing GEO.DLL for
'royalty-free use with your applications.

