VERSION 2.00
Begin Form Fontshow 
   BackColor       =   &H00C0C000&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "FontShow 1.3"
   ClientHeight    =   6396
   ClientLeft      =   1848
   ClientTop       =   468
   ClientWidth     =   6960
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   7.8
   FontStrikethru  =   0   'False
   FontUnderline   =   -1  'True
   ForeColor       =   &H00800000&
   Height          =   6816
   Left            =   1800
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6396
   ScaleWidth      =   6960
   Top             =   96
   Width           =   7056
   Begin SSCheck ChkPara 
      Caption         =   "&Text Paragraphs"
      ForeColor       =   &H00C00000&
      Height          =   252
      Left            =   3720
      TabIndex        =   12
      Top             =   4080
      Width           =   1692
   End
   Begin SSCheck ChkItalic 
      Caption         =   "&Italic"
      ForeColor       =   &H00800080&
      Height          =   252
      Left            =   5760
      TabIndex        =   14
      Top             =   3840
      Width           =   732
   End
   Begin SSCheck ChkBold 
      Caption         =   "&Bold"
      ForeColor       =   &H00800080&
      Height          =   252
      Left            =   5760
      TabIndex        =   13
      Top             =   3600
      Width           =   732
   End
   Begin SSCheck ChkFull 
      Caption         =   "&Full Page Sample"
      ForeColor       =   &H00C00000&
      Height          =   252
      Left            =   3720
      TabIndex        =   11
      Top             =   3840
      Width           =   1692
   End
   Begin SSCheck ChkChart 
      Caption         =   "&Character Chart"
      ForeColor       =   &H00C00000&
      Height          =   252
      Left            =   3720
      TabIndex        =   10
      Top             =   3600
      Width           =   1692
   End
   Begin SSCheck ChkSample 
      Caption         =   "&Sample Text"
      ForeColor       =   &H00C00000&
      Height          =   252
      Left            =   3720
      TabIndex        =   9
      Top             =   3360
      Value           =   -1  'True
      Width           =   1452
   End
   Begin SSPanel Panel3D3 
      AutoSize        =   3  'AutoSize Child To Panel
      BevelInner      =   1  'Inset
      BorderWidth     =   1
      Height          =   1212
      Left            =   3600
      Outline         =   -1  'True
      TabIndex        =   22
      Top             =   3240
      Width           =   3012
   End
   Begin SSCommand CmdGrid 
      Caption         =   "Display Font &Map"
      ForeColor       =   &H00000080&
      Height          =   372
      Left            =   4920
      TabIndex        =   7
      Top             =   2280
      Width           =   1692
   End
   Begin SSCommand CmdHeadFont 
      Caption         =   "&Heading Font"
      ForeColor       =   &H00000080&
      Height          =   372
      Left            =   4920
      TabIndex        =   4
      Top             =   840
      Width           =   1692
   End
   Begin SSCommand CmdEdit 
      Caption         =   "&Edit Sample Text"
      ForeColor       =   &H00000080&
      Height          =   372
      Left            =   4920
      TabIndex        =   5
      Top             =   1320
      Width           =   1692
   End
   Begin SpinButton SpinSampleSize 
      BackColor       =   &H00FFFF80&
      Delay           =   125
      ForeColor       =   &H00000000&
      Height          =   312
      Left            =   6360
      LightColor      =   &H00FFFF80&
      ShadowBackColor =   &H00FFFF80&
      SpinBackColor   =   &H00FFFF80&
      Top             =   4800
      Width           =   252
   End
   Begin SSPanel Panel3D2 
      AutoSize        =   3  'AutoSize Child To Panel
      BevelInner      =   1  'Inset
      Caption         =   "Panel3D2"
      Height          =   3984
      Left            =   360
      TabIndex        =   19
      Top             =   480
      Width           =   3012
      Begin ListBox LstFonts 
         Height          =   3864
         Left            =   60
         MultiSelect     =   2  'Extended
         Sorted          =   -1  'True
         TabIndex        =   1
         Top             =   60
         Width           =   2892
      End
   End
   Begin SSPanel Panel3D1 
      AutoSize        =   3  'AutoSize Child To Panel
      BevelInner      =   1  'Inset
      Caption         =   "Panel3D1"
      Height          =   1092
      Left            =   360
      TabIndex        =   18
      Top             =   5160
      Width           =   6252
      Begin TextBox TxtDispFont 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   12
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   972
         Left            =   60
         MultiLine       =   -1  'True
         TabIndex        =   15
         Top             =   60
         Width           =   6132
      End
   End
   Begin TextBox TxtPointSize 
      BackColor       =   &H00C0C000&
      Height          =   288
      Left            =   5760
      TabIndex        =   3
      Text            =   "12"
      Top             =   360
      Width           =   612
   End
   Begin SpinButton SpinPointSize 
      BackColor       =   &H00FFFF80&
      Delay           =   125
      ForeColor       =   &H00000000&
      Height          =   288
      Left            =   6360
      LightColor      =   &H00FFFF80&
      ShadowBackColor =   &H00FFFF80&
      SpinBackColor   =   &H00FFFF80&
      Top             =   360
      Width           =   252
   End
   Begin SSCommand CmdExit 
      Caption         =   "E&xit"
      ForeColor       =   &H000000C0&
      Height          =   612
      Left            =   3600
      TabIndex        =   2
      Top             =   840
      Width           =   972
   End
   Begin SSCommand CmdPrint 
      Caption         =   "&Print"
      ForeColor       =   &H00000080&
      Height          =   372
      Left            =   4920
      TabIndex        =   8
      Top             =   2760
      Width           =   1692
   End
   Begin SSCommand CmdSelAll 
      Caption         =   "Select &All"
      ForeColor       =   &H00000080&
      Height          =   372
      Left            =   4920
      TabIndex        =   6
      Top             =   1800
      Width           =   1692
   End
   Begin Label LabelFontsSel 
      BackColor       =   &H00C0C000&
      Caption         =   "Selected"
      ForeColor       =   &H00000000&
      Height          =   252
      Left            =   2160
      TabIndex        =   23
      Top             =   240
      Width           =   1332
   End
   Begin Label LblHeadingFont 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C000&
      Caption         =   "Heading Font:"
      Height          =   192
      Left            =   360
      TabIndex        =   21
      Top             =   4560
      Width           =   1176
   End
   Begin Label LblSampleSize 
      BackColor       =   &H00C0C000&
      Caption         =   "Sample size"
      Height          =   252
      Left            =   5160
      TabIndex        =   20
      Top             =   4920
      Width           =   1128
   End
   Begin Label LblSample 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C000&
      Caption         =   "Sample"
      ForeColor       =   &H00000000&
      Height          =   300
      Left            =   360
      TabIndex        =   17
      Top             =   4920
      Width           =   648
   End
   Begin Label LblFonts 
      BackColor       =   &H00C0C000&
      Caption         =   "Fonts"
      ForeColor       =   &H00000000&
      Height          =   252
      Left            =   360
      TabIndex        =   16
      Top             =   240
      Width           =   972
   End
   Begin Label LblPointSize 
      BackColor       =   &H00C0C000&
      Caption         =   "Sample Text Point Si&ze"
      ForeColor       =   &H00000000&
      Height          =   420
      Left            =   4560
      TabIndex        =   0
      Top             =   240
      Width           =   1212
      WordWrap        =   -1  'True
   End
End

Sub ChkBold_Click (Value As Integer)
    TxtDispFont.FontBold = ChkBold
End Sub

Sub ChkItalic_Click (Value As Integer)
    TxtDispFont.FontItalic = ChkItalic
End Sub

Sub CmdEdit_Click ()
	FS_Edtxt.Show
End Sub

Sub CmdExit_Click ()
	End
End Sub

Sub CmdGrid_Click ()
	Screen.MousePointer = 11   ' hourglass
	FS_Grid.Caption = CurrFont$
	FS_Grid.Grid1.Width = 8470
	FS_Grid.Grid1.Height = 2540
	FS_Grid.Grid1.FontName = CurrFont$
	FS_Grid.Grid1.FontBold = False
	FS_Grid.Grid1.FontItalic = False
	FS_Grid.ChkBold = False
	FS_Grid.ChkItalic = False
	FS_Grid.Grid1.FontSize = 11
	For x% = 0 To 31
		FS_Grid.Grid1.ColWidth(x%) = 250
		FS_Grid.Grid1.ColAlignment(x%) = 2 'center
	Next
	For r% = 0 To 6
	    FS_Grid.Grid1.RowHeight(r%) = 350
	    FS_Grid.Grid1.Row = r%
		For c% = 0 To 31
			FS_Grid.Grid1.Col = c%
			FS_Grid.Grid1 = Chr$(c% + ((r% + 1) * 32))
		Next
	Next
	FS_Grid.Grid1.Row = 1
	FS_Grid.Grid1.Col = 1
	FS_Grid.TxtCurrChar.FontSize = 24
	FS_Grid.TxtCurrChar.FontName = CurrFont$
	FS_Grid.TxtCurrChar.FontBold = False
	FS_Grid.TxtCurrChar.FontItalic = False
	FS_Grid.TxtCurrChar = "A"
	FS_Grid.Show
	Screen.MousePointer = 0  ' normal
End Sub

Sub CmdHeadFont_Click ()
	' Code 4 is a Yes/No message box; result of 6 is a Yes response
	mb = MsgBox("Change heading font to " + LstFonts.List(LstFonts.ListIndex) + "?", 4, "Heading Font")
	If mb = 6 Then
		HeadingFont$ = LstFonts.List(LstFonts.ListIndex)
		x% = WritePrivateProfileString("Fontshow", "HeadingFont", HeadingFont$, IniFile)
		LblHeadingFont.Caption = "Heading Font: " + HeadingFont$
	End If
End Sub

Sub CmdPrint_Click ()
	On Error GoTo PRINT_ERR
	Dim i, j, P, n, m, mb, PerPage, printed As Integer
	Dim PointSize As Single, ParaSize As Single, px As Single, py As Single
	Static SampleText(3) As String
	SampleText$(1) = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	SampleText$(2) = "abcdefghijklmnopqrstuvwxyz1234567890!@#$%^&*()-+=[]{}/':;" + Chr$(34) + ",.?"
	SampleText$(3) = FS_Edtxt.TxtSample
	ContPrint = True
	PointSize! = Val(TxtPointSize)
	If PointSize! > 72 Then PointSize! = 72
	' 660 points is total available space (about 9.15 inches)
	' 24 points in between is 10 for blank line, 10 for heading, 4 to spare
	PerPage = Int(660 / ((PointSize! * 3) + 24))
	If PerPage > 14 Then PerPage = 14   ' avoid overflow
	If ChkSample = False And ChkChart = False And ChkFull = False And ChkPara = False Then
		mb = MsgBox("You have not selected any printing options", 48, "FontShow Error")
		ChkSample.SetFocus
		Exit Sub
	End If
	' Display the paragraph size window before any printing is done;
	' in case they choose more than one printout we don't want it
	' interrupting the printing.
	If ChkPara = True Then
	    DoPara = True
	    Fs_Psize.Show 1  ' 1 indicates modal
	End If
	FS_Prmsg.TxtPrintMsg = ""   ' clear out message box
	If ChkSample = True Then
		PageHead (PointSize!)
		FS_Prmsg.Show
		printed = 0
		P = 1
		For i = 0 To NumFonts - 1
			DoEvents
			If ContPrint = False Then Exit For
			If LstFonts.Selected(i) = True Then
				printed = printed + 1
				CurrFont$ = LstFonts.List(i)
				FS_Prmsg.TxtPrintMsg = "Fonts Selected: " + Str$(FontsSel) + CRLF + "Samples printed: " + Str$(printed)
				Printer.FontName = HeadingFont$
				Printer.FontSize = 10
				Printer.FontBold = False
				Printer.FontItalic = False
				Printer.CurrentX = .5
				Printer.Print CurrFont$
				Printer.FontName = CurrFont$
				Printer.FontSize = PointSize!
				Printer.FontBold = ChkBold
				Printer.FontItalic = ChkItalic
				For j = 1 To 3
					Printer.CurrentX = .5
					Printer.Print SampleText$(j)
				Next
				Printer.FontSize = 10
				P = P + 1
				If P = PerPage Then
					P = 1
					Printer.NewPage
					Printer.EndDoc
					PageHead (PointSize!)
				Else
					Printer.Print  ' blank line between fonts
				End If
			End If
		Next
	Printer.EndDoc
	End If
	If ChkChart = True Then
		FS_Prmsg.Show
		printed = 0
		P = 1
		For i = 0 To NumFonts - 1
			DoEvents
			If ContPrint = False Then Exit For
			If LstFonts.Selected(i) = True Then
				Printer.ScaleMode = 5
				printed = printed + 1
				CurrFont$ = LstFonts.List(i)
				FS_Prmsg.TxtPrintMsg = "Fonts Selected: " + Str$(FontsSel) + CRLF + "Charts printed: " + Str$(printed)
				Printer.FontBold = False
				Printer.FontItalic = False
				Printer.FontName = HeadingFont$
				Printer.FontSize = 12
				BI$ = IIf(ChkBold = True And ChkItalic = True, " - Bold Italic", IIf(ChkBold = True And ChkItalic = False, " - Bold", IIf(ChkBold = False And ChkItalic = True, " - Italic", "")))
				Printer.CurrentX = 4 - (Printer.TextWidth(CurrFont$ + BI$) / 2)
				Printer.CurrentY = .5
				Printer.Print CurrFont$ + BI$;
				py! = .7
				For n = 33 To 243 Step 14
					px! = .25
					py! = py! + .4
					Printer.CurrentY = py!
					Printer.FontName = HeadingFont$
					Printer.FontBold = False
					Printer.FontItalic = False
					Printer.FontSize = 7
					For m = n To n + 13
						px! = px! + .5
						Printer.CurrentX = px!
						If m >= 33 And m <= 126 Then
							Printer.Print LTrim$(Str$(m)) + " " + Chr$(m);
						End If
						If m >= 127 And m <= 255 Then
							Printer.Print LTrim$(Str$(m));
						End If
					Next
					Printer.FontName = CurrFont$
					Printer.FontSize = 16
					Printer.FontBold = ChkBold
					Printer.FontItalic = ChkItalic
					px! = .28
					py! = py! + .15
					Printer.CurrentY = py!
					For m = n To n + 13
						px! = px! + .5
						Printer.CurrentX = px!
						If m < 256 Then Printer.Print Chr$(m);   ' chr$(256) doesn't exist
					Next
				Next
				Printer.NewPage
				Printer.EndDoc
			End If
		Next
	End If
	If ChkFull = True Then
		FS_Prmsg.Show
		printed = 0
		P = 1
		For i = 0 To NumFonts - 1
			DoEvents
			If ContPrint = False Then Exit For
			If LstFonts.Selected(i) = True Then
				Printer.ScaleMode = 5
				printed = printed + 1
				CurrFont$ = LstFonts.List(i)
				FS_Prmsg.TxtPrintMsg = "Fonts Selected: " + Str$(FontsSel) + CRLF + "Full pages printed: " + Str$(printed)
				Printer.FontBold = False
				Printer.FontItalic = False
				Printer.FontName = HeadingFont$
				Printer.FontSize = 12
				Printer.CurrentX = .5
				Printer.CurrentY = .3
				Printer.Print CurrFont$;
				Printer.FontName = CurrFont$
				' Samples from 8 to 60 points
				Printer.CurrentY = .7
				Printer.CurrentX = .5
				Printer.FontSize = 8
				Printer.Print FS_Edtxt.Txt8Pt
				Printer.CurrentX = .5
				Printer.FontSize = 9
				Printer.Print FS_Edtxt.Txt9Pt
				Printer.CurrentX = .5
				Printer.FontSize = 10
				Printer.Print FS_Edtxt.Txt10Pt
				Printer.CurrentX = .5
				Printer.FontSize = 11
				Printer.Print FS_Edtxt.Txt11Pt
				Printer.CurrentX = .5
				Printer.FontSize = 12
				Printer.Print FS_Edtxt.Txt12Pt
				Printer.CurrentX = .5
				Printer.FontSize = 14
				Printer.Print FS_Edtxt.Txt14Pt
				Printer.CurrentX = .5
				Printer.FontSize = 16
				Printer.Print FS_Edtxt.Txt16Pt
				Printer.CurrentX = .5
				Printer.CurrentX = .5
				Printer.FontSize = 18
				Printer.Print FS_Edtxt.Txt18Pt
				Printer.CurrentX = .5
				Printer.FontSize = 24
				Printer.Print FS_Edtxt.Txt24Pt
				Printer.CurrentX = .5
				Printer.FontSize = 36
				Printer.Print FS_Edtxt.Txt36Pt
				Printer.CurrentX = .5
				Printer.FontSize = 48
				Printer.Print FS_Edtxt.Txt48Pt
				Printer.CurrentX = .5
				Printer.FontSize = 60
				Printer.Print FS_Edtxt.Txt60Pt

				' Normal text sample
				Printer.FontName = HeadingFont$
				Printer.FontSize = 10
				Printer.Print
				Printer.CurrentX = .5
				Printer.Print "Normal"
				Printer.FontName = CurrFont$
				Printer.FontSize = 12
				For j = 1 To 3
					Printer.CurrentX = .5
					Printer.Print SampleText$(j)
				Next

				' Bold sample
				Printer.FontName = HeadingFont$
				Printer.FontSize = 10
				Printer.Print
				Printer.CurrentX = .5
				Printer.Print "Bold"
				Printer.FontName = CurrFont$
				Printer.FontBold = True
				Printer.FontSize = 12
				For j = 1 To 3
					Printer.CurrentX = .5
					Printer.Print SampleText$(j)
				Next

				' Italic sample
				Printer.FontName = HeadingFont$
				Printer.FontSize = 10
				Printer.FontBold = False    ' turn it off for the heading
				Printer.Print
				Printer.CurrentX = .5
				Printer.Print "Italic"
				Printer.FontName = CurrFont$
				Printer.FontItalic = True
				Printer.FontSize = 12
				Printer.CurrentX = .5
				For j = 1 To 3
					Printer.CurrentX = .5
					Printer.Print SampleText$(j)
				Next

				' Bold italic sample
				Printer.FontName = HeadingFont$
				Printer.FontSize = 10
				Printer.FontItalic = False  ' turn it off for the heading
				Printer.Print
				Printer.CurrentX = .5
				Printer.Print "Bold Italic"
				Printer.FontName = CurrFont$
				Printer.FontBold = True
				Printer.FontItalic = True
				Printer.FontSize = 12
				For j = 1 To 3
					Printer.CurrentX = .5
					Printer.Print SampleText$(j)
				Next

				' Extended characters
				Printer.FontName = HeadingFont$
				Printer.FontSize = 10
				Printer.Print
				Printer.CurrentX = .5
				Printer.FontBold = False
				Printer.FontItalic = False
				Printer.Print "Extended Characters"
				Printer.FontName = CurrFont$
				Printer.FontSize = 12
				Printer.CurrentX = .5
				For j = 127 To 158
					Printer.Print Chr$(j) + " ";
				Next
				Printer.Print
				Printer.CurrentX = .5
				For j = 159 To 190
					Printer.Print Chr$(j) + " ";
				Next
				Printer.Print
				Printer.CurrentX = .5
				For j = 191 To 222
					Printer.Print Chr$(j) + " ";
				Next
				Printer.Print
				Printer.CurrentX = .5
				For j = 223 To 255
					Printer.Print Chr$(j) + " ";
				Next
				Printer.Print

				Printer.NewPage
				Printer.EndDoc
			End If
		Next
	End If
	If ChkPara = True Then
		Static TextLine(6) As String
		If DoPara = False Then
		    FS_Prmsg.Hide  ' in case it was displayed for another printout
		    Exit Sub
		End If
		FS_Prmsg.Show
		TextLine$(1) = "When Gutenberg printed his 42-line Bible in 1456, he had only one typeface to choose"
		TextLine$(2) = "from: the formal, square-text Gothic letter that mimicked the lettering of scribes."
		TextLine$(3) = "Today, designers and desktop publishers have tens of thousands of typefaces to choose"
		TextLine$(4) = "from, and new designs are added almost daily. Typefaces can be organized according to"
		TextLine$(5) = "a simplified classification system which is based on the internationally recognized"
		TextLine$(6) = "scheme that has been adopted by the Association Typeographique International."
		printed = 0
		P = 1
		For i = 0 To NumFonts - 1
			DoEvents
			If ContPrint = False Then Exit For
			If LstFonts.Selected(i) = True Then
				Printer.ScaleMode = 5
				printed = printed + 1
				CurrFont$ = LstFonts.List(i)
				FS_Prmsg.TxtPrintMsg = "Fonts Selected: " + Str$(FontsSel) + CRLF + "Paragraph pages printed: " + Str$(printed)
				Printer.FontBold = False
				Printer.FontItalic = False
				Printer.FontName = HeadingFont$
				Printer.FontSize = 12
				BI$ = IIf(ChkBold = True And ChkItalic = True, " - Bold Italic", IIf(ChkBold = True And ChkItalic = False, " - Bold", IIf(ChkBold = False And ChkItalic = True, " - Italic", "")))
				Printer.CurrentX = 4 - (Printer.TextWidth(CurrFont$ + BI$) / 2)
				Printer.CurrentY = .3
				Printer.Print CurrFont$ + BI$;
				Printer.Print
				For j = 0 To 12
				    If Fs_Psize.ChkParaSize(j) = True Then
					ParaSize = Val(Fs_Psize.ChkParaSize(j).Caption)
					Printer.FontName = HeadingFont$
					Printer.FontSize = 11
					Printer.Print
					Printer.FontBold = False
					Printer.FontItalic = False
					Printer.CurrentX = .5
					Printer.Print ParaSize; "point"
					Printer.FontName = CurrFont$
					Printer.FontBold = ChkBold
					Printer.FontItalic = ChkItalic
					Printer.FontSize = ParaSize
					For m = 1 To 6
					    Printer.CurrentX = .5
					    Printer.Print TextLine$(m)
					Next
				    End If
				Next
				Printer.NewPage
				Printer.EndDoc
			End If
		Next
	End If

PRINT_RESUME:
	Printer.EndDoc
	FS_Prmsg.Hide
	Exit Sub
PRINT_ERR:
	If Err = 6 Then  ' overflow
		mb = MsgBox("Overflow error while printing - point size too large" + CRLF + "Printing will be aborted", 48, "FontShow Error")
	Else
		mb = MsgBox("Error while printing -" + CRLF + Error$(Err), 48, "FontShow Error")
	End If
	Resume PRINT_RESUME
End Sub

Sub CmdSelAll_Click ()
	RefreshSample = False
	LstFonts.Visible = False
	For i% = 0 To NumFonts - 1
		LstFonts.Selected(i%) = True
	Next
	FontsSel = NumFonts
	LabelFontsSel.Caption = "Selected: " + LTrim$(Str$(FontsSel))
	RefreshSample = True
	LstFonts.Visible = True
End Sub

Sub Form_Load ()
	Dim TempFont As String
	Dim i, HfontOK As Integer
	Top = 350
	Left = (Screen.Width - Width) / 2
	IniFile$ = App.Path + "\FONTSHOW.INI"
	If Len(Dir$(IniFile$)) = 0 Then
		Open IniFile$ For Output As #1
		Print #1, "[Fontshow]"
		Print #1, "Def8=This is 8-point type - not easy to read!"
		Print #1, "Def9=9-point type is about the smallest readable size."
		Print #1, "Def10=Now, with 10-point type, we have a normal text size."
		Print #1, "Def11=11-point type is usually ideal for body text."
		Print #1, "Def12=With some fonts, 12-point type is easier to read."
		Print #1, "Def14=14-point type is good for subheadings."
		Print #1, "Def16=For larger subheadings, try 16-point type."
		Print #1, "Def18=18-point type makes nice small headlines."
		Print #1, "Def24=24-point type is for medium headlines."
		Print #1, "Def36=36-point is for larger ones."
		Print #1, "Def48=48-point almost shouts!"
		Print #1, "Def60=60-point is huge!"
		Print #1, "DefSample=The quick brown fox jumps over the lazy dog."
		Print #1, "HeadingFont=Arial"
		Close #1
	End If

	Def8$ = Space$(50)
	Def9$ = Space$(50)
	Def10$ = Space$(50)
	Def11$ = Space$(50)
	Def12$ = Space$(50)
	Def14$ = Space$(50)
	Def16$ = Space$(50)
	Def18$ = Space$(50)
	Def24$ = Space$(50)
	Def36$ = Space$(50)
	Def48$ = Space$(50)
	Def60$ = Space$(50)
	DefSample$ = Space$(50)
	HeadingFont$ = Space$(50)
	x% = GetPrivateProfileString("Fontshow", "Def8", "", Def8$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def9", "", Def9$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def10", "", Def10$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def11", "", Def11$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def12", "", Def12$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def14", "", Def14$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def16", "", Def16$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def18", "", Def18$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def24", "", Def24$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def36", "", Def36$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def48", "", Def48$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "Def60", "", Def60$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "DefSample", "", DefSample$, 50, IniFile)
	x% = GetPrivateProfileString("Fontshow", "HeadingFont", "Arial", HeadingFont$, 50, IniFile)

	HfontOK = False
	CRLF = Chr$(13) + Chr$(10)
	NumFonts = Printer.FontCount
	' Determine number of fonts and make sure heading font in INI file exists
	For i = 0 To NumFonts - 1
		TempFont$ = Printer.Fonts(i)
		LstFonts.AddItem TempFont$ ' Put each font into list box.
		If HfontOK = False Then  ' don't bother with this if already found
			If InStr(1, TempFont$, Left$(HeadingFont$, Len(TempFont$)), 1) > 0 Then HfontOK = True
		End If
	Next i
	If HfontOK = False Then
		For i = 0 To NumFonts - 1
			TempFont$ = Printer.Fonts(i)
			If InStr(1, TempFont$, "courier", 1) = 0 And InStr(1, TempFont$, "line", 1) = 0 Then
				HeadingFont$ = TempFont$
				x% = WritePrivateProfileString("Fontshow", "HeadingFont", HeadingFont$, IniFile)
				Exit For
			End If
		Next
	End If
	LblHeadingFont.Caption = "Heading Font: " + HeadingFont$
	TxtPointSize = "12.0"
	RefreshSample = True
	RefreshDefault = True
	SampleChanged = False
	TxtDispFont.FontSize = 12

	FS_Edtxt.Txt8Pt = Def8$
	FS_Edtxt.Txt9Pt = Def9$
	FS_Edtxt.Txt10Pt = Def10$
	FS_Edtxt.Txt11Pt = Def11$
	FS_Edtxt.Txt12Pt = Def12$
	FS_Edtxt.Txt14Pt = Def14$
	FS_Edtxt.Txt16Pt = Def16$
	FS_Edtxt.Txt18Pt = Def18$
	FS_Edtxt.Txt24Pt = Def24$
	FS_Edtxt.Txt36Pt = Def36$
	FS_Edtxt.Txt48Pt = Def48$
	FS_Edtxt.Txt60Pt = Def60$
	FS_Edtxt.TxtSample = DefSample$
	LblFonts.Caption = "Fonts: " + LTrim$(Str$(NumFonts))
	' Select first font and display sample text
	LstFonts.Selected(0) = True
	LstFonts_Click
End Sub

Sub LstFonts_Click ()
' An error will occur if the user clicks on a
' resident printer font such as Line Printer.
	If RefreshSample = True Then
		On Error GoTo LSTFONTS_ERR
		CurrFont$ = LstFonts.List(LstFonts.ListIndex)
		TxtDispFont.FontName = CurrFont$
		'It's necessary to reset the bold and italic to match the check box
		'because fonts whose regular version is bold or italic (true of some
		'display and script fonts) will change it.
		TxtDispFont.FontBold = ChkBold
		TxtDispFont.FontItalic = ChkItalic
		LblSample.Caption = "Sample: " + CurrFont$ + " (" + Format$(TxtDispFont.FontSize, "##") + " pt)"
		FontsSel = SendMessage(LstFonts.hWnd, LB_GETSELCOUNT, 0, 0)
		LabelFontsSel.Caption = "Selected: " + LTrim$(Str$(FontsSel))
		If SampleChanged = False Then
		    TxtDispFont = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + CRLF + FS_Edtxt.TxtSample
		End If
LSTFONTS_RESUME:
		Exit Sub
LSTFONTS_ERR:
	    LblSample.Caption = "Sample: " + CurrFont$
	    TxtDispFont.FontName = "System"
	    TxtDispFont = CurrFont$ + " does not have an equivalent" + CRLF + "screen font and cannot be displayed."
	    GoTo LSTFONTS_RESUME
	End If
End Sub

Sub PageHead (PointSize As Single)
    ' ScaleMode must be reset every time a new page is printed, otherwise it may go back
    ' to the default.  The reason for this is not clear.
    Printer.ScaleMode = 5   'set to inches
    Printer.FontName = HeadingFont$
    Printer.FontSize = 10
    Printer.Print
    Printer.Print
    Printer.CurrentX = .5
    Printer.Print FS_Edtxt.TxtTitle;
    SizeStyleText$ = IIf(ChkBold = True, "Bold ", "") + IIf(ChkItalic = True, "Italic", "") + "    Size: " + Format$(PointSize!, "##.0") + " points"
    Printer.CurrentX = 7.5 - Printer.TextWidth(SizeStyleText$)
    Printer.Print SizeStyleText$
    Printer.Print
    Printer.Print
End Sub

Sub SpinPointSize_SpinDown ()
    TxtPointSize = LTrim$(Str$(Val(TxtPointSize) - 1))
    If Val(TxtPointSize) < 6 Then TxtPointSize = "6"
End Sub

Sub SpinPointSize_SpinUp ()
    TxtPointSize = LTrim$(Str$(Val(TxtPointSize) + 1))
End Sub

Sub SpinSampleSize_SpinDown ()
    TxtDispFont.FontSize = TxtDispFont.FontSize - 1
    If TxtDispFont.FontSize < 8 Then TxtDispFont.FontSize = 8
    LstFonts_Click
End Sub

Sub SpinSampleSize_SpinUp ()
    TxtDispFont.FontSize = TxtDispFont.FontSize + 1
    If TxtDispFont.FontSize > 20 Then TxtDispFont.FontSize = 20
    LstFonts_Click
End Sub

Sub TxtDispFont_LostFocus ()
    SampleChanged = True
End Sub

Sub TxtPointSize_KeyPress (Keyascii As Integer)
    ' Allow only digits, decimal point and backspace.
    ' This works better than the masked edit control,
    ' which handles decimal points very badly.
    If (Keyascii < 48 And Keyascii <> 46 And Keyascii <> 8) Or Keyascii > 57 Then Keyascii = 0
End Sub

Sub TxtPointSize_LostFocus ()
    If Val(TxtPointSize) > 72 Then TxtPointSize = "72"
    If Val(TxtPointSize) <= 0 Then TxtPointSize = "12"
    If Val(TxtPointSize) <= 4 Then TxtPointSize = "4"
End Sub

