//---------------------------------------------------------------------------
// FileList.h
//---------------------------------------------------------------------------
#define LINE_SIZE				40
#define NUMBER_LINES			80
#define BUFFER_SIZE 			(LINE_SIZE * NUMBER_LINES)

//---------------------------------------------------------------------------
// Helpful Macros
//---------------------------------------------------------------------------
#define OFFSETIN( struc, field )  ( (USHORT)&( ((struc *)0)->field ) )

//---------------------------------------------------------------------------
// Resource ID's
//---------------------------------------------------------------------------
// Toolbox bitmap resource IDs numbers must be consecutive from N to N+5
//---------------------------------------------------------------------------
#define IDBMP_FILELIST              8000
#define IDBMP_FILELISTDOWN          8001
#define IDBMP_FILELISTMONO          8003
#define IDBMP_FILELISTMONODOWN      8004
#define IDBMP_FILELISTEGA           8006
#define IDBMP_FILELISTEGADOWN       8007

//---------------------------------------------------------------------------
// Other constants
//---------------------------------------------------------------------------
#define ARRMAX                  	100
#define COLMAX						 80
#define FILENAME_LEN				255

//---------------------------------------------------------------------------
// FILELIST control data and structs
//---------------------------------------------------------------------------
typedef struct tagList {

	// PROPERTIES
    LONG        lBackColorGray;
    LONG        lForeColorGray;
    SHORT       nMaxSelect;
    HWND        hWnd;
    HSZ         hFileName;
    SHORT		nLineSize;
	HSZ			hVerifyText;
	HSZ			hLocateText;
    HSZ         hListArray  [1];
    int         nListGray   [ARRMAX];
    int         nListSelect [ARRMAX];
    int			nDisplayCol [COLMAX];
    int			nOutputCol	[COLMAX];
    int			nInputCol	[COLMAX];

    // NO PROPERTIES
    HFONT       hFont;
	int 		nStartLine;
	int 		nEndLine;
	HANDLE		hListBuffer;
	LPSTR       lpListBuffer;
	int			nCurrPos;
	char 		szSearchString [LINE_SIZE + 1];
    int  		nSearchStringLen;


} FILELIST;
typedef FILELIST FAR * PFILELIST;

#define FILELISTDEREF(hctl)   ((PFILELIST) VBDerefControl (hctl))

//---------------------------------------------------------------------------
// Control Procedure
//---------------------------------------------------------------------------
LONG _export FileListCtlProc( HCTL, HWND, USHORT, USHORT, LONG );


#ifndef RC_INVOKED
//---------------------------------------------------------------------------
// Property filelist
//---------------------------------------------------------------------------
// Define the consecutive indicies for the properties
//---------------------------------------------------------------------------
#define IPROP_FILELIST_NAME           	0x0000
#define IPROP_FILELIST_INDEX          	0x0001
#define IPROP_FILELIST_PARENT         	0x0002
#define IPROP_FILELIST_BACKCOLOR      	0x0003
#define IPROP_FILELIST_FORECOLOR      	0x0004
#define IPROP_FILELIST_LEFT           	0x0005
#define IPROP_FILELIST_TOP            	0x0006
#define IPROP_FILELIST_WIDTH          	0x0007

#define IPROP_FILELIST_HEIGHT         	0x0008
#define IPROP_FILELIST_FONTNAME       	0x0009
#define IPROP_FILELIST_FONTSIZE       	0x000A
#define IPROP_FILELIST_FONTBOLD       	0x000B
#define IPROP_FILELIST_FONTITALIC     	0x000C
#define IPROP_FILELIST_FONTSTRIKE     	0x000D
#define IPROP_FILELIST_FONTUNDER      	0x000E
#define IPROP_FILELIST_TABINDEX       	0x000F

#define IPROP_FILELIST_TABSTOP        	0x0010
#define IPROP_FILELIST_DRAGMODE       	0x0011
#define IPROP_FILELIST_DRAGICON       	0x0012
#define IPROP_FILELIST_ENABLED        	0x0013
#define IPROP_FILELIST_VISIBLE        	0x0014
#define IPROP_FILELIST_TAG            	0x0015
#define IPROP_FILELIST_MOUSEPOINTER   	0x0016
#define IPROP_FILELIST_BACKCOLORGRAY    0x0017

#define IPROP_FILELIST_FORECOLORGRAY    0x0018
#define IPROP_FILELIST_LISTARRAY        0x0019
#define IPROP_FILELIST_LISTGRAY         0x001A
#define IPROP_FILELIST_LISTSELECT       0x001B
#define IPROP_FILELIST_MAXSELECT        0x001C
#define IPROP_FILELIST_HWND             0x001D
#define IPROP_FILELIST_FILENAME         0x001E
#define IPROP_FILELIST_LINESIZE         0x001F
#define IPROP_FILELIST_DISPLAYCOL       0x0020
#define IPROP_FILELIST_OUTPUTCOL        0x0021
#define IPROP_FILELIST_INPUTCOL         0x0022
#define IPROP_FILELIST_VERIFYTEXT       0x0023
#define IPROP_FILELIST_LOCATETEXT       0x0024

#ifdef CTL_DATA

PROPINFO CTL_DATA propBackColorGray =
{
   "BackColorGray",
   DT_COLOR | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (FILELIST, lBackColorGray), 0
};

PROPINFO CTL_DATA propForeColorGray =
{
   "ForeColorGray",
   DT_COLOR | PF_fGetData  | PF_fSetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (FILELIST, lForeColorGray), 0
};

PROPINFO CTL_DATA propListArray =
{
   "ListArray",
   DT_HSZ 			| PF_fGetMsg  | PF_fSetMsg    |
   PF_fNoRuntimeW	| PF_fNoShow  | PF_fPropArray,
   OFFSETIN (FILELIST, hListArray), 0
};

PROPINFO CTL_DATA propListGray =
{
   "ListGray",
   DT_SHORT |  PF_fGetMsg  | PF_fSetMsg    |
               PF_fNoShow  | PF_fPropArray,
   OFFSETIN (FILELIST, nListGray), 0
};

PROPINFO CTL_DATA propListSelect =
{
   "ListSelect",
   DT_SHORT |  PF_fGetMsg  | PF_fSetMsg    |
               PF_fNoShow  | PF_fPropArray,
   OFFSETIN (FILELIST, nListSelect), 0
};

PROPINFO CTL_DATA propListDisplayCol =
{
   "DisplayCol",
   DT_SHORT |  PF_fGetMsg  | PF_fSetMsg    |
               PF_fNoShow  | PF_fPropArray,
   OFFSETIN (FILELIST, nDisplayCol), 0
};

PROPINFO CTL_DATA propListOutputCol =
{
   "OutputCol",
   DT_SHORT |  PF_fGetMsg  | PF_fSetMsg    |
               PF_fNoShow  | PF_fPropArray,
   OFFSETIN (FILELIST, nOutputCol), 0
};

PROPINFO CTL_DATA propListInputCol =
{
   "InputCol",
   DT_SHORT |  PF_fGetMsg  | PF_fSetMsg    |
               PF_fNoShow  | PF_fPropArray,
   OFFSETIN (FILELIST, nInputCol), 0
};

PROPINFO CTL_DATA propMaxSelect =
{
   "MaxSelect",
   DT_SHORT | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (FILELIST, nMaxSelect), 0
};

PROPINFO CTL_DATA prophWnd =
{
   "hWnd",
   DT_SHORT   | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData | PF_fNoShow,
   OFFSETIN (FILELIST, hWnd), 0
};

PROPINFO CTL_DATA propFileName =
{
   "FileName",
   DT_HSZ  | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (FILELIST, hFileName), 0
};

PROPINFO CTL_DATA propVerifyText =
{
   "VerifyText",
   DT_HSZ  | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (FILELIST, hVerifyText), 0
};

PROPINFO CTL_DATA propLocateText =
{
   "LocateText",
   DT_HSZ  | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (FILELIST, hLocateText), 0
};


PROPINFO CTL_DATA propLineSize =
{
   "LineSize",
   DT_SHORT   | PF_fGetData | PF_fSetData | PF_fSetMsg | PF_fSaveData,
   OFFSETIN (FILELIST, nLineSize), 0
};

PPROPINFO CTL_DATA propfilelistList[] = {

    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_BACKCOLOR,
    PPROPINFO_STD_FORECOLOR,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_FONTNAME,
    PPROPINFO_STD_FONTSIZE,
    PPROPINFO_STD_FONTBOLD,
    PPROPINFO_STD_FONTITALIC,
    PPROPINFO_STD_FONTSTRIKE,
    PPROPINFO_STD_FONTUNDER,
    PPROPINFO_STD_TABINDEX,
    PPROPINFO_STD_TABSTOP,
    PPROPINFO_STD_DRAGMODE,
    PPROPINFO_STD_DRAGICON,
    PPROPINFO_STD_ENABLED,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_TAG,
    PPROPINFO_STD_MOUSEPOINTER,
    &propBackColorGray,
    &propForeColorGray,
    &propListArray,
    &propListGray,
    &propListSelect,
    &propMaxSelect,
    &prophWnd,
    &propFileName,
    &propLineSize,
    &propListDisplayCol,
    &propListOutputCol,
    &propListInputCol,
    &propVerifyText,
    &propLocateText,
    NULL

};
#endif	// CTL_DATA

#ifdef CTL_DATA
//---------------------------------------------------------------------------
// Event filelist
//---------------------------------------------------------------------------
#endif	// CTL_DATA

//---------------------------------------------------------------------------
// Define the consecutive indicies for the events
//---------------------------------------------------------------------------
#define EVENT_FILELIST_CLICK        0
#define EVENT_FILELIST_DRAGDROP     1
#define EVENT_FILELIST_DRAGOVER     2
#define EVENT_FILELIST_GOTFOCUS     3
#define EVENT_FILELIST_KEYDOWN      4
#define EVENT_FILELIST_KEYPRESS     5
#define EVENT_FILELIST_KEYUP        6
#define EVENT_FILELIST_LOSTFOCUS    7

#ifdef CTL_DATA
PEVENTINFO CTL_DATA eventfilelistList[] =
{
    PEVENTINFO_STD_CLICK,
    PEVENTINFO_STD_DRAGDROP,
    PEVENTINFO_STD_DRAGOVER,
    PEVENTINFO_STD_GOTFOCUS,
    PEVENTINFO_STD_KEYDOWN,
    PEVENTINFO_STD_KEYPRESS,
    PEVENTINFO_STD_KEYUP,
    PEVENTINFO_STD_LOSTFOCUS,
    NULL
};
#endif	// CTL_DATA

//---------------------------------------------------------------------------
// Model struct
//---------------------------------------------------------------------------
// Define the control model (using the event and property structures).
//---------------------------------------------------------------------------
#ifdef CTL_DATA

MODEL CTL_DATA modelList = {
    VB_VERSION, 						// VB version being used
    MODEL_fFocusOk | MODEL_fArrows |
    MODEL_fInitMsg | MODEL_fLoadMsg,    // MODEL flags
    (PCTLPROC)FileListCtlProc,          // Control procedure
    CS_VREDRAW 					|
    CS_HREDRAW,            				// Class style
    WS_BORDER                   |
    LBS_MULTIPLESEL             |
    LBS_OWNERDRAWVARIABLE       |
    LBS_NOINTEGRALHEIGHT		|
    LBS_WANTKEYBOARDINPUT       |
    LBS_NOTIFY,
    sizeof(FILELIST),                   // cbCtlExtra for FILELIST structure
    IDBMP_FILELIST,                     // Palette bitmap ID
    "FileList",                         // Default control name
    "FileListButton",                   // Visual Basic class name
    "listbox",                          // Parent class name
    propfilelistList,                   // Properties filelist
    eventfilelistList                   // Events filelist
};

#endif	// CTL_DATA

#endif  // RC_INVOKED

//---------------------------------------------------------------------------
