$FREEFORM

" TESTMSG.DLL - short subroutine to send text string from running DLL to
" a VB list box and text box. The DLL is called by a Visual Basic program   
" with a text box and a list box.  The text box is used to display 'current'
" status messages from the DLL while it is running, while the list box
" is used as a 'log' of status messages received, that can be easily
" reviewed after the DLL is done.  
" This subroutine demonstates how to use the Windows API
" to create a message box [MessageBox], place a string in the calling
" VB's text box [SendMessage with WM_SETTEXT] and place a string in
" the VB's list box [SendMessage with LB_ADDSTRING].  It also demonstrates
" use of the UpdateWindow API call to allow Visual Basic to update its
" form after Fortran has added strings to the list and text boxes.
" Also changes the cursor to an hourglass while calculating (and then
" back to the original form).

" Windows API call SendMessage to send string to text and list boxes

      interface to integer*4 FUNCTION SendMessage[PASCAL]-
       (hWnd, WinMsg,wparam,lparam)
	    character*1 lparam[reference]   ! string to be passed
	    integer*2 hWnd[value]           ! handle of object 
	    integer*2 WinMsg[value]         ! API message to be sent
	    integer*2 wparam[value]         ! not used for this example, = 0
      end

" generate message box via API calls

      interface to integer*2 FUNCTION MessageBox[pascal]-
       (hWndMB,boxtext,caption,boxtype)
	    integer*2 hWndMB[value]         ! handle of message box
	    integer*2 boxtype[value]        ! type of message box
	    character*1 boxtext[reference]  ! string to be in message box
	    character*1 caption[reference]  ! caption of message box
      end

" UpdateWindow function to redraw VB form

      interface to SUBROUTINE UpdateWindow[pascal]-
       (hWndVBF)
	    integer*2 hWndVBF[value]        ! handle of VB form
      end

" LoadCursor function to change cursor form

      interface to integer*2 FUNCTION LoadCursor[pascal]-
       (hinst,pCursor)
	    integer*2 hinst[value]	    ! set to zero for this example
	    integer*4 pCursor[value]        ! cursor form
      end

" SetCursor subroutine to implement change
      
      interface to integer*2 FUNCTION SetCursor[pascal](hcur)
	    integer*2 hcur[value]           ! handle of cursor
      end

" main part of program
      subroutine testmsg(LBhandle,TBhandle, VBFhandle)	! name of subroutine
	    character buffer1*80,buffer2*12 ! message box strings
	    character text1*25              ! text & list box strings
	    integer*2 LB_ADDSTRING          ! Win API message to list box
	    integer*2 WM_SETTEXT            ! Win API message to text box
	    integer*2 MessageBox	    ! used for messagebox
	    integer*2 LoadCursor	    ! used for loadcursor
	    integer*2 SetCursor 	    ! used for setcursor
	    integer*2 LBhandle              ! list box hWnd from VB
	    integer*2 TBhandle              ! text box hWnd from VB
	    integer*2 VBFhandle             ! VB form hWnd
	    integer*4 SendMessage           ! used for sending text
	    integer*2 MBVal                 ! return value from messagebox
	    integer*4 SendListVal           ! return value from SendMessage - list box
	    integer*4 SendTextVal           ! return value from SendMessage - text box
	    integer*2 wparam                ! wparameter value for SendMessage
	    integer*2 oldCursor             ! old cursor form value
	    integer*4 IDC_WAIT		    ! hourglass cursor shape value
	    integer*2 ValCursor 	    ! dummy for loadcursor
	  
      LB_ADDSTRING = #0401                  ! define hex value of API message
      WM_SETTEXT = #C                       ! define hex value of API message
      IDC_WAIT = 32514                      ! define value of hourglass form

" Message Box before calling the SendMessage API
      buffer1='Starting Fortran DLL...'c    ! use C string format
      buffer2='FORTRAN DLL'c
      MBVal=MessageBox(0,buffer1,buffer2,0) ! first message box
      wparam = 0                            ! set to zero for string functions

" Save old cursor value, and load hourglass shape
      ValCursor = LoadCursor(0,IDC_WAIT)    ! load new cursor form
      oldCursor = SetCursor(ValCursor)	    ! set new form; save value of old cursor

" DO loop to demo multiple status messages during execution
      Do 100 i=1,9,1                                     ! send 9 messages to VB
	  text1 = 'status message #'//CHAR(i+48)//'...'c ! status message string
	  If (i.EQ.9) text1 = 'DLL is finished!'c        !last message is different

" call the list box API here
	  SendListVal=SendMessage(LBhandle,LB_ADDSTRING,wparam,-
	   text1)

" call the text box API here
	  SendTextVal=SendMessage(TBhandle,WM_SETTEXT,wparam,-
	   text1)

" call for update of VB form	
      Call UpdateWindow(VBFhandle)          ! updates display of text & list boxes
	
" kill time here to slow things down a bit for the demo
      Call GetTim(ihr,imin,isec,i100th)     ! current time
      OldTime=(imin*60)+isec                ! base time in seconds
      dT=0.0                                ! reset difference
      Do While (dT.LE.4)                    ! loop for 4 seconds
	Call GetTim(ihr,imin,isec,i100th)
	NewTime=(imin*60)+isec
	dT=NewTime-OldTime
      End Do

  100 Continue

" Restore the cursor shape
      oldCursor=SetCursor(oldCursor)

" Message Box after calling the SendMessage API
      buffer1='DLL complete, return to VB'c
      MBVal=MessageBox(0,buffer1,buffer2,0) ! second message box

      return
      end
