' Copyright  1993 by John Murdoch. All Rights Reserved.
' This module may be incorporated into your code, but may
' not be resold or redistributed without my prior written
' permission. Subscribers to Data Based Advisor Magazine
' and/or members of the CompuServe DBADVISOR forum may
' distribute this function within their organizations without
' prior permission.

Type ErrorType
    ErrNum As Integer
    Headline As String
    ProblemMsg As String
    ResponseMsg As String
    MoreInfoVisible As Integer
    Button1Caption As String
    Button2Caption As String
    Label01 As String
    Label02 As String
    Label03 As String
    Label04 As String
    Label05 As String
    Label06 As String
    Label07 As String
    Label08 As String
    Label09 As String
    Label10 As String
    Data01 As Variant
    Data02 As Variant
    Data03 As Variant
    Data04 As Variant
    Data05 As Variant
    Data06 As Variant
    Data07 As Variant
    Data08 As Variant
    Data09 As Variant
    Data10 As Variant
    Bitmap As Integer
End Type

Function ErrorHandler (ErrorStruct As ErrorType) As Integer
' Maintenance Header
' Version   Date        Coder       Action
'   1       9/21/93     Murdoch     Initial keyin

' Calls:
'   FillErrorStruct

' Is Called By:

' Purpose:
'   Passed a structure, this reads the information,
' and displays it on the Errors form.

If Len(ErrorStruct.Headline) < 1 Then
    Answer% = FillErrorStruct(ErrorStruct)
End If

' Assign the right picture from the storage array....
If ErrorStruct.Bitmap > 3 Then
    Errors!imgPicture.Picture = Errors!imgStorage(0).Picture
Else
    Errors!imgPicture.Picture = Errors!imgStorage(ErrorStruct.Bitmap).Picture
End If

Errors!lblHeadline.Caption = ErrorStruct.Headline
Errors!lblProblem.Caption = ErrorStruct.ProblemMsg
Errors!lblResponse.Caption = ErrorStruct.ResponseMsg
Errors!cmdAction(2).Visible = ErrorStruct.MoreInfoVisible

If Not IsNull(ErrorStruct.Label01) Then
    Errors!lblLabel(0).Caption = ErrorStruct.Label01
    Errors!lblData(0).Caption = ErrorStruct.Data01
Else
    Errors!lblLabel(0).Visible = False
    Errors!lblData(0).Visible = False
End If

If Not IsNull(ErrorStruct.Label02) Then
    Errors!lblLabel(1).Caption = ErrorStruct.Label02
    Errors!lblData(1).Caption = ErrorStruct.Data02
Else
    Errors!lblLabel(1).Visible = False
    Errors!lblData(1).Visible = False
End If

If Not IsNull(ErrorStruct.Label03) Then
    Errors!lblLabel(2).Caption = ErrorStruct.Label03
    Errors!lblData(2).Caption = ErrorStruct.Data03
Else
    Errors!lblLabel(2).Visible = False
    Errors!lblData(2).Visible = False
End If

If Not IsNull(ErrorStruct.Label04) Then
    Errors!lblLabel(3).Caption = ErrorStruct.Label04
    Errors!lblData(3).Caption = ErrorStruct.Data04
Else
    Errors!lblLabel(3).Visible = False
    Errors!lblData(3).Visible = False
End If

If Not IsNull(ErrorStruct.Label05) Then
    Errors!lblLabel(4).Caption = ErrorStruct.Label05
    Errors!lblData(4).Caption = ErrorStruct.Data05
Else
    Errors!lblLabel(4).Visible = False
    Errors!lblData(4).Visible = False
End If

If Not IsNull(ErrorStruct.Label06) Then
    Errors!lblLabel(5).Caption = ErrorStruct.Label06
    Errors!lblData(5).Caption = ErrorStruct.Data06
Else
    Errors!lblLabel(5).Visible = False
    Errors!lblData(5).Visible = False
End If

If Not IsNull(ErrorStruct.Label07) Then
    Errors!lblLabel(6).Caption = ErrorStruct.Label07
    Errors!lblData(6).Caption = ErrorStruct.Data07
Else
    Errors!lblLabel(6).Visible = False
    Errors!lblData(6).Visible = False
End If

If Not IsNull(ErrorStruct.Label08) Then
    Errors!lblLabel(7).Caption = ErrorStruct.Label08
    Errors!lblData(7).Caption = ErrorStruct.Data08
Else
    Errors!lblLabel(7).Visible = False
    Errors!lblData(7).Visible = False
End If

If Not IsNull(ErrorStruct.Label09) Then
    Errors!lblLabel(8).Caption = ErrorStruct.Label09
    Errors!lblData(8).Caption = ErrorStruct.Data09
Else
    Errors!lblLabel(8).Visible = False
    Errors!lblData(8).Visible = False
End If

If Not IsNull(ErrorStruct.Label10) Then
    Errors!lblLabel(9).Caption = ErrorStruct.Label10
    Errors!lblData(9).Caption = ErrorStruct.Data10
Else
    Errors!lblLabel(9).Visible = False
    Errors!lblData(9).Visible = False
End If

LeftPos% = (Screen.Width - Errors.Width) \ 2
TopPos% = (Screen.Height - Errors.Height) \ 2
Errors.Move LeftPos%, TopPos%
Errors.Show MODAL

End Function

Function FillErrorStruct (ErrorStruct As ErrorType)
' Copyright  1993 by John Murdoch. All Rights Reserved.
' This function may be incorporated into your code, but may
' not be resold or redistributed without my prior written
' permission. Subscribers to Data Based Advisor Magazine
' and/or members of the CompuServe DBADVISOR forum may
' distribute this function within their organizations without
' prior permission.

' Maintenance Header
' Version   Date        Coder       Action
'   1       9/21/93     Murdoch     Initial keyin
'   1a      10/23/93    Murdoch     More typing...
'   1b      10/25/93    Murdoch     Still typing...
'   1c      10/28/93    Murdoch     Done! (I got blisters on ma
'                                   fingers....)

' Is Called By:
'   Utility routine. Called by local error handlers.

' Purpose:
'   If the headline passed is null, we're asking for
' the library to fill in the Headline, Problem, and
' Response fields with stock material.
    
Select Case ErrorStruct.ErrNum
    Case 607        ' Access attempted on unopened database
        ErrorStruct.Headline = "Error: Database Not Open"
        ErrorStruct.ProblemMsg = "The application could not open a database file. This can happen if the application or database has not been installed properly, or if a configuration option is not set correctly."
        ErrorStruct.ResponseMsg = "If the application has just been installed, make sure that the installation was done properly. If you have been using the application for some time, check the network connection, file access permissions for the current user, and if the database file still exists."
    
    Case 616        ' Table exists, no append allowed
        ErrorStruct.Headline = "Error: Cannot Append to Table "
        ErrorStruct.ProblemMsg = "The application could not append data to the database table. "
        ErrorStruct.ResponseMsg = "Contact tech support and tell them that you encountered error number 616. "
    
    Case 617        ' No fields defined - cannot append table
        ErrorStruct.Headline = "Error: Cannot Append to Table "
        ErrorStruct.ProblemMsg = "The application attempted to append records to a table in the database. It was unable to do so. "
        ErrorStruct.ResponseMsg = "Contact tech support, and tell them you encountered error number 617.  "
    
    Case 622        ' CommitTrans/Rollback illegal - Transactions not supported
        ErrorStruct.Headline = "Error: Transaction Processing Not Supported "
        ErrorStruct.ProblemMsg = "Most databases support " & Chr$(34) & "transaction processing," & Chr$(34) & "but the database you are connected to does not."
        ErrorStruct.ResponseMsg = "Contact tech support. You may need an updated piece of software, or you may be connected to the wrong file.  "

    Case 623        ' Name not found in this collection
        ErrorStruct.Headline = "Error: Name Not Found in Collection "
        ErrorStruct.ProblemMsg = "The application has referred to an object that is not part of the data collection (where the application thinks it should be). "
        ErrorStruct.ResponseMsg = "Contact tech support. You may need an updated piece of software, or you may be connected to the wrong file."

    Case 625        ' Data type of field "item" not supported by target database
        ErrorStruct.Headline = "Error: Unsupported Data Type"
        ErrorStruct.ProblemMsg = "The database does not support the data type that the application tried to store."
        ErrorStruct.ResponseMsg = "Contact tech support. You may need a new piece of software, a new database file, or you may be connected to the wrong file."

    Case 626        ' Attempt to move past EOF
        ErrorStruct.Headline = "Error: Can't Move Past EOF"
        ErrorStruct.ProblemMsg = "The application referred to a record that is past the end of the file."
        ErrorStruct.ResponseMsg = "Contact tech support RIGHT NOW. This error message can be an indication of a damaged database file--a serious problem. Write down what record you were working on, and what anybody else using the system was doing. Do not continue working with the application."

    Case 627        ' Dynaset is not updateable or Edit method has not been invoked
        ErrorStruct.Headline = "Error: Dynaset Is Not Updateable"
        ErrorStruct.ProblemMsg = "A program error has happened--the application tried to update a record in a database that could not be edited."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 627."

    Case 630        ' Property is read only
        ErrorStruct.Headline = "Error: Read Only Property"
        ErrorStruct.ProblemMsg = "The application tried to change the value of a program property that is set to read-only."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 630."

    Case 632        ' Update illegal without previous Edit or AddNew
        ErrorStruct.Headline = "Error: Update Without Edit or AddNew"
        ErrorStruct.ProblemMsg = "The application has tried to update a record--but has not yet created the record or opened it for editing."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 632."

    Case 633        ' Append illegal - Field is part of a TableDefs collection
        ErrorStruct.Headline = "Error: Tried to Append to TableDefs Collection"
        ErrorStruct.ProblemMsg = "The application tried to append (add) a record to a table structure--rather than the table itself."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 633."

    Case 634        ' Property value only valid when Field is part of a dynaset
        ErrorStruct.Headline = "Error: Incorrect Use of Field Property"
        ErrorStruct.ProblemMsg = "The application has attempted to use a database value incorrectly."
        ErrorStruct.ResponseMsg = "Contact tech support, and tell them you have encountered error number 634. You may need new program files or an updated database."

    Case 635        ' Cannot set the property of an object which is part of a database object
        ErrorStruct.Headline = "Error: Cannot Set Object Property "
        ErrorStruct.ProblemMsg = "The application attempted to set a database property--but the database table is currently in use."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 635. You may need updated program files."

    Case 638        ' Access attempted on an unopened dynaset
        ErrorStruct.Headline = "Error: Data Not Opened Yet"
        ErrorStruct.ProblemMsg = "The application attempted to read data from a table (actually a dynaset) that has not been opened."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 638. You may been updated program files."

    Case 639        ' Field size illegal for specified field type
        ErrorStruct.Headline = "Error: Incorrect Field Size"
        ErrorStruct.ProblemMsg = "The application has attempted to write data to the database--and the field size in the database won't support the size of the variable being written."
        ErrorStruct.ResponseMsg = "Check the data value--you may have accidentally entered a number that is too big. If you continue to get an error message, contact tech support and tell them you have encountered error number 639."

    Case 643        ' Property not found
        ErrorStruct.Headline = "Error: Property Not Found"
        ErrorStruct.ProblemMsg = "The application has tried to read or change a program property--but the property is not there."
        ErrorStruct.ResponseMsg = "Contact tech support--you may need updated program files. Tell them you encountered error number 643."

    Case 646        ' GetChunk: Offset/size argument combination illegal
        ErrorStruct.Headline = "Error: GetChunk Failed "
        ErrorStruct.ProblemMsg = "The application tried to read a portion of a file--but the size of the portion, or where it began, (or both) was incorrect."
        ErrorStruct.ResponseMsg = "Contact tech support RIGHT NOW. This is usually an indication of a problem with a file. Tell them that you have encountered error number 646."

    Case 648        ' Data access objects require VBDB300.DLL
        ErrorStruct.Headline = "Error: VBDB300.DLL Not Found"
        ErrorStruct.ProblemMsg = "The application requires a file named VBDB300.DLL. The file could not be located on your system."
        ErrorStruct.ResponseMsg = "Check to be sure that VBDB300.DLL is installed in your file PATH, your \WINDOWS\SYSTEM directory, or in the same directory as the application EXE file."

    Case 2420 To 2422   ' Syntax error in number, date, or string
        ErrorStruct.Headline = "Error: Syntax Error"
        ErrorStruct.ProblemMsg = "The application has referred to a number, date, or string incorrectly."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number " & Format$(ErrorStruct.ErrNum) & "."

    Case 2431 To 2434   ' syntax error
        ErrorStruct.Headline = "Error: Syntax Error"
        ErrorStruct.ProblemMsg = "The application contains an error in the program code that has halted the program."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number " & Format$(ErrorStruct.ErrNum) & "."

    Case 3005       ' "Item" isn't a valid database name
        ErrorStruct.Headline = "Error: Invalid Database Name "
        ErrorStruct.ProblemMsg = "The application has attempted to access a database--but cannot find a database with that name."
        ErrorStruct.ResponseMsg = "Contact tech support--you will probably need updated program files."

    Case 3006       ' Database is exclusively locked
        ErrorStruct.Headline = "Problem: The Database Is Exclusively Locked"
        ErrorStruct.ProblemMsg = "The application cannot open the database--it is presently locked by another user or application."
        ErrorStruct.ResponseMsg = "Someone may be editing the database file directly, or there may be a problem in the program code. Check to see if anyone else is using the database (whether with an application or with a database editor). If no one is, contact tech support."

    Case 3007       ' Couldn't open database
        ErrorStruct.Headline = "Error: Could Not Open Database"
        ErrorStruct.ProblemMsg = "The application was unable to open a database file."
        ErrorStruct.ResponseMsg = "Check to see if someone else is using the database. If no one is, contact tech support and tell them you have encountered error number 3007."

    Case 3008, 3189 ' Table is exclusively locked
        ErrorStruct.Headline = "Error: Table Exclusively Locked "
        ErrorStruct.ProblemMsg = "The application has been prevented from opening a database table. Someone else is using it. "
        ErrorStruct.ResponseMsg = "Wait a moment or two and try again. Chances are that the table is only locked momentarily."

    Case 3009       ' Table in use--could not lock
        ErrorStruct.Headline = "Error: Table Could Not Be Locked"
        ErrorStruct.ProblemMsg = "The application tried to lock a table in the database, and could not."
        ErrorStruct.ResponseMsg = "Someone else is presently using the same table. Wait a moment and try again. If you still get this message, contact tech support."

    Case 3011       ' Couldn't find object "item"
        ErrorStruct.Headline = "Error: Cannot Find Object"
        ErrorStruct.ProblemMsg = "The application has tried to find a particular database object, and cannot."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 3011. You may need an updated database file."

    ' A mere 56 to go....
    Case 3014       ' Couldn't open any more tables
        ErrorStruct.Headline = "Error: Couldn't Open Any More Tables "
        ErrorStruct.ProblemMsg = "The application has attempted to open a database table, but cannot."
        ErrorStruct.ResponseMsg = "Contact tech support. You may have to adjust entries in your CONFIG.SYS file (not likely) or there is a program flaw. Tell them you encountered error number 3014."

    Case 3015       ' "Item" isn't an index in this table
        ErrorStruct.Headline = "Error: Use of Invalid Index"
        ErrorStruct.ProblemMsg = "The application tried to use a database index that doesn't exist."
        ErrorStruct.ResponseMsg = "Contact tech support--this is most likely a case of having a program file that is more current that the database file you're using. Tell them you have encountered error number 3015."

    Case 3016       ' Field won't fit in this record
        ErrorStruct.Headline = "Error: Field Won't Fit in Record"
        ErrorStruct.ProblemMsg = "The application has tried to copy the contents of a database record, and the record won't fit."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 3016. You may need new programs files or an updated database."

    Case 3017       ' Field length is too long
        ErrorStruct.Headline = "Error: Field Length Too Long "
        ErrorStruct.ProblemMsg = "The application has tried to define a text field that is longer than 255 characters."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 3017."

    Case 3018       ' Couldn't find field "item"
        ErrorStruct.Headline = "Error: Cannot Find Field "
        ErrorStruct.ProblemMsg = "The application has tried to access a field--but cannot find it."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 3018."

    Case 3019       ' Operation invalid without a current index
        ErrorStruct.Headline = "Error: Must Have a Current Index "
        ErrorStruct.ProblemMsg = "The application requires a current index."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 3019."

    Case 3020       ' Update without Add or Edit
        ErrorStruct.Headline = "Error: Update Without Add or Edit"
        ErrorStruct.ProblemMsg = "The application has encountered an error updating a database table."
        ErrorStruct.ResponseMsg = "Contact tech support. You will probably need to get updated program files."

    Case 3021       ' No current record
        ErrorStruct.Headline = "Error: No Current Record"
        ErrorStruct.ProblemMsg = "The application is looking for a record, and has encountered difficulty."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 3021."
    
    Case 3022       ' Duplicate key
        ErrorStruct.Headline = "Error: Duplicate Key"
        ErrorStruct.ProblemMsg = "The application has attempted to write data to a field--but an identical record exists."
        ErrorStruct.ResponseMsg = "Are you entering a duplicate record? Check your work to be sure that you're not trying to add records that already exist. If necessary, contact tech support and tell them you have encountered error number 3022."
        
    Case 3023       ' Add or Edit already used
        ErrorStruct.Headline = "Error: Add or Edit Already Used "
        ErrorStruct.ProblemMsg = "The application has attempted to open a database record--but the record is already open."
        ErrorStruct.ResponseMsg = "Contact tech support. Do NOT continue entering records. "

    Case 3024       ' Couldn't find field "item"
        ErrorStruct.Headline = "Error: Could Not Find a Field "
        ErrorStruct.ProblemMsg = "The application is looking for a field in the database that is not there. "
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error 3024. Do not continue entering data. "

    Case 3025       ' Can't open any more files
        ErrorStruct.Headline = "Error: Cannot Open Files "
        ErrorStruct.ProblemMsg = "The application cannot open any more files--as a result, it has stopped. "
        ErrorStruct.ResponseMsg = "Contact tech support and tell them you have encountered error 3025. You will probably need to increase the " & Chr$(34) & "FILES=" & Chr$(34) & " statement in your CONFIG.SYS file, but check with tech support first. "

    Case 3026       ' Not enough space on disk
        ErrorStruct.Headline = "Error: Not Enough Space Free on Disk "
        ErrorStruct.ProblemMsg = "The application cannot write data to the disk drive, because it is full.  "
        ErrorStruct.ResponseMsg = "Use File Manager to remove unused files from your disk drive. If you do not know which files are safe to remove, check with your LAN administrator or contact tech support."

    Case 3027       ' Couldn't update, database is read only
        ErrorStruct.Headline = "Error: Cannot Update Read Only Database"
        ErrorStruct.ProblemMsg = "The application is trying to write data to a read-only database."
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 3027."

    Case 3028       ' Couldn't initialize data access, because System.MDA couldn't be opened
        ErrorStruct.Headline = "Error: Cannot Open SYSTEM.MDA"
        ErrorStruct.ProblemMsg = "Your application requires the presence of a file named SYSTEM.MDA. The application cannot open it, probably because it cannot find it."
        ErrorStruct.ResponseMsg = "Check to be sure that any network connections are still valid, and that the SYSTEM.MDA file is visible on your system. If the problem reoccurs, contact tech support and tell them you have error number 3028."

    Case 3029       ' Not a valid account name or password
        ErrorStruct.Headline = "Error: Not a Valid Account Name or Password"
        ErrorStruct.ProblemMsg = "Your application has attempted to attach to the network, but the account name or password was not accepted."
        ErrorStruct.ResponseMsg = "Contact your LAN administrator to be sure that you are using the correct name and password. Then try again. "

    Case 3030       ' "Item" isn't a valid account name
        ErrorStruct.Headline = "Error: Invalid Account Name "
        ErrorStruct.ProblemMsg = "Your application has attempted to attach to the network, but the account name given is not valid. "
        ErrorStruct.ResponseMsg = "Contact your LAN administrator to get the correct name to use."

    Case 3031       ' Not a valid password
        ErrorStruct.Headline = "Error: Invalid Password"
        ErrorStruct.ProblemMsg = "Your application has attempted to attach to the network, but the password given is not valid. "
        ErrorStruct.ResponseMsg = "Try re-entering the password. If it still doesn't work, contact your LAN administrator."

    Case 3032       ' Can't delete account
        ErrorStruct.Headline = "Error: Can't Delete Account"
        ErrorStruct.ProblemMsg = "Your application has attempted to delete a network account. It cannot do so. "
        ErrorStruct.ResponseMsg = "In all likelihood the account could not be deleted because somebody is presently using it. Contact your LAN administrator. "

    Case 3033       ' No permission for "item"
        ErrorStruct.Headline = "Error: Permission Error "
        ErrorStruct.ProblemMsg = "Your application tried to read or write data from a directory or file to which you do not have appropriate rights. "
        ErrorStruct.ResponseMsg = "Contact your LAN administrator for permission to use the file, or contact tech support. "

    Case 3034       ' Commit or Rollback without BeginTrans
        ErrorStruct.Headline = "Error: Transaction Ended--But Not Begun "
        ErrorStruct.ProblemMsg = "Your application attempted to save a database entry--but never began one. "
        ErrorStruct.ResponseMsg = "Contact tech support--do NOT continue data entry. "

    Case 3036       ' Database has reached maximum size
        ErrorStruct.Headline = "Error: Database Has Reached Maximum Size "
        ErrorStruct.ProblemMsg = "One of your database files has reached the maximum possible size for that type of file. You cannot add any more information to the file. "
        ErrorStruct.ResponseMsg = "Depending on the database format, you may be able to compact the file to gain more space. You should, however, contact tech support. "

    Case 3037       ' Can't open any more tables or queries
        ErrorStruct.Headline = "Error: Can't Open Any More Tables or Queries "
        ErrorStruct.ProblemMsg = "Your application has tried to open more tables or queries than is permitted. "
        ErrorStruct.ResponseMsg = "Contact tech support, and tell them you have encountered error number 3037. Do NOT continue data entry. "

    Case 3040       ' Disk I/O error during read
        ErrorStruct.Headline = "Error: Disk I/O Error "
        ErrorStruct.ProblemMsg = "An error was encountered while attempting to access your hard disk drive. "
        ErrorStruct.ResponseMsg = "Contact tech support immediately. Do NOT continue data entry. Tell them you have encountered error number 3040. "

    Case 3041       ' Incompatible database version
        ErrorStruct.Headline = "Error: Incompatible Database Version "
        ErrorStruct.ProblemMsg = "Your application cannot open a database file--the file is the wrong version. "
        ErrorStruct.ResponseMsg = "Check your startup information--the application may be opening the wrong file. Check to be sure that your data files are correctly installed. If this error persists, contact tech support. "

    Case 3042       ' Out of MS-DOS file handles
        ErrorStruct.Headline = "Error: Out of DOS File Handles "
        ErrorStruct.ProblemMsg = "Your computer system needs to have a change made to your CONFIG.SYS file. "
        ErrorStruct.ResponseMsg = "Change the " & Chr$(34) & "FILES=" & Chr$(34) & " line in your CONFIG.SYS file to 40 or more. If you have never edited CONFIG.SYS, contact your LAN administrator or call tech support. "

    Case 3043       ' Disk or network error
        ErrorStruct.Headline = "Error: Disk or Network Error "
        ErrorStruct.ProblemMsg = "Your application has attempted to access files on your hard drive, or on the network, and could not. "
        ErrorStruct.ResponseMsg = "If you are using a Local Area Network, attempt to re-connect to the LAN. Contact your LAN Adminstrator for help and more instructions. "

    Case 3045       ' File already in use
        ErrorStruct.Headline = "Error: File in Use "
        ErrorStruct.ProblemMsg = "Your application cannot open a file--another user or application is using it. "
        ErrorStruct.ResponseMsg = "Contact tech support and tell them you have encountered error number 3045.  "

    Case 3046, 3158, 3186, 3202, 3218, 3260 ' Couldn't save--record locked by another user
        ErrorStruct.Headline = "Error: Record Locked "
        ErrorStruct.ProblemMsg = "Your application is trying to read or write information--but another user has that part of the database locked. "
        ErrorStruct.ResponseMsg = "Try continuing--the problem may not happen again. If this error continues, contact tech support and tell them you have encountered error number " & Format$(ErrorStruct.ErrNum) & "."
    
    Case 3051       ' Couldn't open file "item"
        ErrorStruct.Headline = "Error: Could Not Open File "
        ErrorStruct.ProblemMsg = "Your application tried to open a file, and could not. "
        ErrorStruct.ResponseMsg = "Contact tech support--tell them you have encountered error number 3051. Do NOT continue data entry. "
    
    Case 3052       ' MS-DOS file sharing lock count exceeded (increase SHARE.EXE locks)
        ErrorStruct.Headline = "Error: DOS File Sharing Locks "
        ErrorStruct.ProblemMsg = "Your computer system doesn't have the SHARE lock count set high enough. "
        ErrorStruct.ResponseMsg = "Change the SHARE line in your AUTOEXEC.BAT file. It should be set to 500 locks or higher. "
    
    Case 3054       ' Too many Memo or Long Binary fields
        ErrorStruct.Headline = "Error: Too Many Memo or Long Binary Fields "
        ErrorStruct.ProblemMsg = "Your database file format does not support all the fields defined by your application. "
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them you have encountered error number 3054. They will need to revise the application or change your database file format. "

    Case 3056       ' Couldn't repair this database
        ErrorStruct.Headline = "Error: Cannot Repair Database "
        ErrorStruct.ProblemMsg = "The application attempted to repair the database, and could not. "
        ErrorStruct.ResponseMsg = "Contact tech support--stop ALL data entry immediately! "

    Case 3058       ' Can't have null value in index
        ErrorStruct.Headline = "Error: Null Value in Index "
        ErrorStruct.ProblemMsg = "The application has tried to save a value that has not been entered. "
        ErrorStruct.ResponseMsg = "Check to be sure that you have all the fields filled in. Contact tech support, and tell them you have encountered error number 3058. "

    Case 3059       ' Operation cancelled by user
        ErrorStruct.Headline = "Error: Operation Cancelled "
        ErrorStruct.ProblemMsg = "You cancelled an operation that was in progress. "
        ErrorStruct.ResponseMsg = "Cancelling the action may have undesireable results. Contact tech support, and tell them what happened. Do not continue data entry until you have talked with them. "

    Case 3071       ' Can't evaluate expression
        ErrorStruct.Headline = "Error: Can't Evaluate Expression "
        ErrorStruct.ProblemMsg = "The application could not correctly express the search you described. "
        ErrorStruct.ResponseMsg = "Try the search again. If you still need help, check the program documentation, and contact tech support. "

    Case 3160       ' Table isn't open
        ErrorStruct.Headline = "Error: Table Not Open "
        ErrorStruct.ProblemMsg = "The application has tried to access a data table that has not been opened. "
        ErrorStruct.ResponseMsg = "Contact tech support--tell them you have encountered error number 3160. "
        
    Case 3161       ' Couldn't decrypt file
        ErrorStruct.Headline = "Error: Cannot Decrypt File "
        ErrorStruct.ProblemMsg = "Your application stores data in encrypted form--the application could not decrypt the data it needs. "
        ErrorStruct.ResponseMsg = "Check to be sure that you have the correct version of the database file installed. If you do, contact tech support immediately."

    Case 3167       ' Record is deleted
        ErrorStruct.Headline = "Error: Record Deleted "
        ErrorStruct.ProblemMsg = "Your application attempted to access a database record, but the record has already been deleted. "
        ErrorStruct.ResponseMsg = "If possible, use another means to determine that the record is not there. If it is (so this message is mistaken) contact tech support. "

    Case 3183       ' Not enough space on temporary disk
        ErrorStruct.Headline = "Error: Not Enough Space on Temporary Disk "
        ErrorStruct.ProblemMsg = "The program needs to use your temporary disk--but there is not enough space free. "
        ErrorStruct.ResponseMsg = "Check to see if you have other programs using the temporary disk (such as print caching software). Remove those programs, or check with tech support. "

    Case 3187       ' Couldn't read, record is currently locked by another user
        ErrorStruct.Headline = "Error: Record Locked "
        ErrorStruct.ProblemMsg = "The record you need (or one nearby in the database) is currently locked. "
        ErrorStruct.ResponseMsg = "Try repeating the action once or twice. If the problem persists, contact tech support. "

    Case 3188       ' Couldn't update--record is locked by another session on *this* machine
        ErrorStruct.Headline = "Error: Record Locked "
        ErrorStruct.ProblemMsg = "The record you need (or one nearby in the database) is currently locked. "
        ErrorStruct.ResponseMsg = "Try repeating the action once or twice. If the problem persists, contact tech support. "

    Case 3197       ' Data has changed--operation stopped
        ErrorStruct.Headline = "Data Has Changed "
        ErrorStruct.ProblemMsg = "The data record you are trying to change has been changed since you read it. "
        ErrorStruct.ResponseMsg = "Contact tech support--do not continue, or you will overwrite data that has been saved by another user. "

    Case 3198       ' Couldn't start session, too many sessions already active
        ErrorStruct.Headline = "Error: Not Enough Sessions "
        ErrorStruct.ProblemMsg = "The program uses a database that limits the number of sessions available. All sessions are in use. "
        ErrorStruct.ResponseMsg = "Check with your LAN administrator or tech support. All check with your co-workers--somebody may have a record open that could be closed. "

    Case 3200       ' Can't delete or change record--referential integrity violation
        ErrorStruct.Headline = " "
        ErrorStruct.ProblemMsg = " "
        ErrorStruct.ResponseMsg = " "

    Case 3201       ' Can't add or change--referential integrity violation
        ErrorStruct.Headline = "Error: Referential Integrity Violation "
        ErrorStruct.ProblemMsg = "Your application has tried to add data to a detail table--but hasn't added a record header first. "
        ErrorStruct.ResponseMsg = "Do NOT continue. Contact tech support. "

    Case 3211, 3212 ' Couldn't lock table--currently in use
        ErrorStruct.Headline = "Error: Could Not Lock Table "
        ErrorStruct.ProblemMsg = "Your application needs to lock a table in the database--but someone else is using it. "
        ErrorStruct.ResponseMsg = "Wait a second or two, and try again. If the problem persists, check with your co-workers to see if somebody has a record from the table in use--but might close it. "

    Case 3224       ' Btrieve data dictionary is corrupted
        ErrorStruct.Headline = "Error: Btrieve Data Dictionary Problem "
        ErrorStruct.ProblemMsg = "Your database has a damaged data dictionary.  "
        ErrorStruct.ResponseMsg = "Stop what you are doing. Write down what you are presently doing, and what the other people in your workgroup are doing. Call tech support immediately. "

    Case 3225       ' Record locking deadlock in Btrieve
        ErrorStruct.Headline = "Error: Deadlock in Btrieve Database "
        ErrorStruct.ProblemMsg = "You have a record open that another user needs--and that user has a record open that you need.  "
        ErrorStruct.ResponseMsg = "Both of you are pretty well stuck. Write down what you're doing, and contact tech support. "
        
    Case 3226, 3240 ' Btrieve DLL error
        ErrorStruct.Headline = "Error: Btrieve DLL Error "
        ErrorStruct.ProblemMsg = "The application couldn't find the right Btrieve database DLL file.  "
        ErrorStruct.ResponseMsg = "Chances are you have recently installed another application that has installed a new DLL file. Check with tech support to see if you need an updated program file. "

    Case 3229 To 3238   ' ODBC Error
        ErrorStruct.Headline = "Error: ODBC Error "
        ErrorStruct.ProblemMsg = "Your application has encountered an error working with an ODBC database. "
        ErrorStruct.ResponseMsg = "Check your network connections, particularly connections to your database server. If they're OK, check with your LAN administrator or with tech support. "

    Case 3239       ' Too many active users
        ErrorStruct.Headline = "Error: Too Many Active Users "
        ErrorStruct.ProblemMsg = "Your application (probably the database) limits the number of users who can be logged on at a time. You're over the limit. "
        ErrorStruct.ResponseMsg = "Check with your LAN adminstrator--and with your co-workers. There may be somebody who's still logged in that doesn't need to be. "
    
    Case 3270       ' Property not found
        ErrorStruct.Headline = "Error: Property Not Found "
        ErrorStruct.ProblemMsg = "Your application tried to access a database feature that your database doesn't support. "
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them what you were doing in the program, and ask for an updated program file. "

    Case 3271       ' Invalid property value
        ErrorStruct.Headline = "Error: Invalid Property Value "
        ErrorStruct.ProblemMsg = "Your application tried to change a value (probably in the database) that isn't the right type for the change that was attempted. "
        ErrorStruct.ResponseMsg = "Contact tech support. Tell them what you were doing in the program, and ask for an updated program file. "

    Case Else       ' A truly unique problem...
        ErrorStruct.Headline = "Error " & Format$(ErrorStruct.ErrNum) & ": Contact Tech Support"
        ErrorStruct.ProblemMsg = Error
        ErrorStruct.ResponseMsg = "Contact tech support and tell them you have encountered Error Number " & Str$(ErrorStruct.ErrNum) & ". You should write down what you were doing when the error occured--the program function you were using, the record you were working with, and what you were doing. You should also write down what other users were doing at the same time."
End Select



End Function

Sub Main ()
Errors.Show
End Sub

