VERSION 2.00
Begin Form frmEOF_BOF 
   BackColor       =   &H00C0C0FF&
   Caption         =   "EOF / BOF"
   ClientHeight    =   4440
   ClientLeft      =   1200
   ClientTop       =   1500
   ClientWidth     =   6345
   Height          =   4845
   Icon            =   EOFBOF.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   1140
   LinkTopic       =   "Form1"
   ScaleHeight     =   4440
   ScaleWidth      =   6345
   Top             =   1155
   Width           =   6465
   Begin CommandButton cmdPrint 
      Caption         =   "P&rint List"
      Height          =   396
      Left            =   4800
      TabIndex        =   4
      Top             =   960
      Width           =   1260
   End
   Begin ListBox lstActions 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier New"
      FontSize        =   7.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2175
      Left            =   240
      TabIndex        =   11
      Top             =   2040
      Width           =   5865
   End
   Begin CommandButton cmdMove 
      Caption         =   "Move&Last"
      Height          =   396
      Index           =   3
      Left            =   4800
      TabIndex        =   8
      Top             =   1440
      Width           =   1260
   End
   Begin CommandButton cmdMove 
      Caption         =   "Move&Next"
      Height          =   396
      Index           =   2
      Left            =   3240
      TabIndex        =   7
      Top             =   1440
      Width           =   1260
   End
   Begin CommandButton cmdMove 
      Caption         =   "Move&Prev"
      Height          =   396
      Index           =   1
      Left            =   1725
      TabIndex        =   6
      Top             =   1440
      Width           =   1260
   End
   Begin CommandButton cmdMove 
      Caption         =   "Move&First"
      Height          =   396
      Index           =   0
      Left            =   240
      TabIndex        =   5
      Top             =   1440
      Width           =   1260
   End
   Begin CommandButton cmdRefresh 
      Caption         =   "&Refresh"
      Height          =   396
      Left            =   3270
      TabIndex        =   3
      Top             =   960
      Width           =   1260
   End
   Begin CommandButton cmdDelete 
      Caption         =   "&Del Rec"
      Height          =   396
      Left            =   1725
      TabIndex        =   2
      Top             =   960
      Width           =   1260
   End
   Begin CommandButton cmdAdd 
      Caption         =   "&Add Rec"
      Height          =   396
      Left            =   240
      TabIndex        =   1
      Top             =   960
      Width           =   1260
   End
   Begin TextBox Text1 
      DataField       =   "KeyFld"
      DataSource      =   "Data1"
      Height          =   300
      Left            =   195
      TabIndex        =   0
      Top             =   600
      Width           =   1260
   End
   Begin Data Data1 
      Caption         =   "Data1"
      Connect         =   ""
      DatabaseName    =   "C:\CODE\IRA\VB\TESTBED\EOF_BOF.MDB"
      Exclusive       =   0   'False
      Height          =   300
      Left            =   192
      Options         =   0
      ReadOnly        =   0   'False
      RecordSource    =   "eof_bof"
      Top             =   192
      Width           =   5868
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "EOF State"
      Height          =   195
      Index           =   1
      Left            =   3240
      TabIndex        =   10
      Top             =   600
      Width           =   855
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "BOF State"
      Height          =   195
      Index           =   0
      Left            =   1800
      TabIndex        =   9
      Top             =   600
      Width           =   855
   End
End
Option Explicit

Sub cmdAdd_Click ()
    '---------------------------------------------
    ' Notice that the MoveLast is artificial, not
    ' a true part of the "Add" process.  Neither is
    ' the Find performed after added -- these are
    ' simply "bells and whistles" I included.
    '---------------------------------------------
    lstActions.AddItem "Add Record:"

    Dim i%
    
    If ((data1.Recordset.EOF = False) Or (data1.Recordset.BOF = False)) Then
        data1.Recordset.MoveLast
        i% = data1.Recordset.Fields(0)
        i% = i% + 1
    End If
    data1.Recordset.AddNew
    text1 = i%
    data1.Recordset.Update

    ' Why do this?  To restore position to the latest added record...(!)
    data1.Recordset.FindFirst "[KeyFld] = " & i%
    
End Sub

Sub cmdDelete_Click ()
    '---------------------------------------------
    ' Delete Record (if it exists)
    '---------------------------------------------
    lstActions.AddItem "Del Record:"

    If data1.Recordset.BOF = False And data1.Recordset.EOF = False Then
        data1.Recordset.Delete
        cmdMove(2).Value = True  ' i.e. MoveNext
    End If

End Sub

Sub cmdMove_Click (Index As Integer)
    '---------------------------------------------
    ' MoveFirst/Next/Previous/Last code.
    ' Code to prevent "No Current Record" when
    ' Move Methods are invoked.
    '---------------------------------------------

    ' Okay, is this an empty table...?
    If data1.Recordset.EOF = False And data1.Recordset.BOF = False Then

        ' No...  So let's do a move!
        Select Case Index

            Case 0      ' MoveFirst
                lstActions.AddItem "MoveFirst:"
                data1.Recordset.MoveFirst

            Case 1      ' MovePrevious
                lstActions.AddItem "MovePrevious:"
                data1.Recordset.MovePrevious

                ' Ah, but is there a record there?
                If data1.Recordset.BOF = True Then
                    data1.Refresh
                    If data1.Recordset.EOF = False Then
                        data1.Recordset.MoveFirst
                    End If
                End If

            Case 2      ' MoveNext
                lstActions.AddItem "MoveNext:"
                data1.Recordset.MoveNext

                ' Ah, but is there a record there?
                If data1.Recordset.EOF = True Then
                    data1.Refresh
                    If data1.Recordset.BOF = False Then
                        data1.Recordset.MoveLast
                    End If
                End If

            Case 3      ' MovePrevious
                lstActions.AddItem "MoveLast:"
                data1.Recordset.MoveLast

        End Select

    End If


    ' Wanna see something irritating?  Put the code below in the
    ' reposition event(!)
    If ((data1.Recordset.EOF = True) And (data1.Recordset.BOF = True)) Then
        MsgBox "You will probably want to add a record or exit.", 0, "Empty Table!"
    End If

End Sub

Sub cmdPrint_Click ()
    '------------
    ' Print List
    '------------
    Screen.MousePointer = 11

    Dim i%
    For i% = 0 To lstActions.ListCount - 1
        printer.Print lstActions.List(i%)
    Next i%

    Screen.MousePointer = 0
    
End Sub

Sub cmdRefresh_Click ()
    '---------------------------------------------
    ' Refresh - Refreshes database
    '---------------------------------------------
    lstActions.AddItem "Refresh:"
    data1.Refresh

End Sub

Sub Data1_Reposition ()
    '---------------------------------------------
    ' Reposition - Just updates the EOF/BOF flags
    '              and adds to the list.
    ' Reposition events triggered by the data
    ' control are rarely a problem (unless the
    ' table is empty).  The Data Control automatically
    ' prevents moving off the end of a table.  It's the
    ' actual MoveNext/MovePrevious methods which are
    ' dangerous/require extra action (see cmdMove_Click)
    '---------------------------------------------
    Static i%
    If data1.Recordset.BOF = True Then
        label1(0) = "BOF(" & i% & ") =  TRUE"
    Else
        label1(0) = "BOF(" & i% & ") = FALSE"
    End If

    If data1.Recordset.EOF = True Then
        label1(1) = "EOF(" & i% & ") =  TRUE"
    Else
        label1(1) = "EOF(" & i% & ") = FALSE"
    End If

    ' Add current state to the list, and keep list on the last item
    lstActions.AddItem "        " & label1(0) & ";  " & label1(1)
    i% = i% + 1
    lstActions.ListIndex = lstActions.ListCount - 1

End Sub

Sub Data1_Validate (Action As Integer, Save As Integer)
    '---------------------------------------------
    '  This just makes sure the list knows what the
    '  latest action to take place is.
    '---------------------------------------------

    Select Case Action
        Case 0
            lstActions.AddItem "    ACTIONCANCEL"
        Case 1
            lstActions.AddItem "    ACTIONMOVEFIRST"
        Case 2
            lstActions.AddItem "    ACTIONMOVEPREVIOUS"
        Case 3
            lstActions.AddItem "    ACTIONMOVENEXT"
        Case 4
            lstActions.AddItem "    ACTIONMOVELAST"
        Case 5
            lstActions.AddItem "    ACTIONADDNEW"
        Case 6
            lstActions.AddItem "    ACTIONUPDATE"
        Case 7
            lstActions.AddItem "    ACTIONDELETE"
        Case 8
            lstActions.AddItem "    ACTIONFIND"
        Case 9
            lstActions.AddItem "    ACTIONBOOKMARK"
        Case 10
            lstActions.AddItem "    ACTIONCLOSE"
        Case 11
            lstActions.AddItem "    ACTIONUNLOAD"
    End Select

End Sub

Sub Form_Load ()
    '---------------------------------------------
    ' Load - Set Data control to read EOFBOF.MDB
    '        and delete all records in it.
    '---------------------------------------------
    Dim TmpStr$
    TmpStr$ = App.Path & "\EOFBOF.MDB"
    data1.DatabaseName = TmpStr$
    lstActions.AddItem "Form Load:"

    Dim Db As Database
    Set Db = OpenDatabase(TmpStr$)
    Db.Execute ("DELETE * FROM eof_bof")
    Db.Close
    Set Db = Nothing
    
End Sub

