'********************************************************
'*
'* First attempt of a dispatcher to invoke 'general'
'* procedures of a form from other modules/forms.
'*
'* Oliver Mangold   CIS 100277,511
'* Aug. 1993
'*
'********************************************************


Option Explicit

    ' return value of dispatched function / sub
Global dispatchReturnValue

    ' true if a dispatched sub is running
    ' false otherwise
Global dispatchIsRunning As Integer

' dispatch a sub with no arguments
'
'
Sub dispatch (frm As Form, fn$)

    dispatchIsRunning = True

    frm.dispatcher(0) = fn$     ' set the function / sub name

End Sub

' dispatch a sub with one argument
'
Sub dispatch1 (frm As Form, fn$, arg1)

    dispatchIsRunning = True

    ' setting the dispatcher must have this order
    ' 1. set dispatcher(1) - dispatcher(n) with the
    '    arguments
    ' 2. set dispatcher(0) with the name of the sub you
    '    want to call

    frm.dispatcher(1) = arg1
    frm.dispatcher(0) = fn$
    
End Sub

' dispatch a sub with two arguments
'
'
Sub dispatch2 (frm As Form, fn$, arg1, arg2)

    dispatchIsRunning = True

    ' setting the dispatcher must have this order
    ' 1. set dispatcher(1) - dispatcher(n) with the
    '    arguments
    ' 2. set dispatcher(0) with the name of the sub you
    '    want to call

    frm.dispatcher(2) = arg2
    frm.dispatcher(1) = arg1
    frm.dispatcher(0) = fn$
    
End Sub

' Get the value the dispatched sub returned
'
'
Function dispatchGetVal ()

    dispatchGetVal = dispatchReturnValue
    
End Function

' Set the return value of the dispatched sub.
' Inform the calling procedure that the sub has finished
'
'
Sub dispatchReturn (ByVal val1)

    dispatchReturnValue = val1
    dispatchIsRunning = False

End Sub

' Wait for the dispatched sub to finish
'
'
Sub dispatchWait ()

    While dispatchIsRunning
        DoEvents
    Wend

End Sub

