#include <Windows.h>
#include <dos.h>

// Calls _dos_getdiskfree and returns data in diskspace
// In VisualBASIC:
//   Type DiskFree
//     total_clusters As Long
//     avail_clusters As Long
//     sectors_per_cluster As Long
//     bytes_per_sector As Long
//   End Type
// Declare Function GetDiskSpaces Lib "diskfree.dll" (ByVal wDrive As Integer, DiskSpace As DiskFree) As Integer

struct diskspaces
{
	long total_clusters;
	long avail_clusters;
	long sectors_per_cluster;
	long bytes_per_sector;
};

int far pascal _export GetDiskSpaces (unsigned int drive, struct diskspaces far *diskspace)
{
	int ret;
	static struct diskfree_t diskspace1;
	ret = _dos_getdiskfree (drive, &diskspace1);
	diskspace->total_clusters = diskspace1.total_clusters;
	diskspace->avail_clusters = diskspace1.avail_clusters;
	diskspace->sectors_per_cluster = diskspace1.sectors_per_cluster;
	diskspace->bytes_per_sector = diskspace1.bytes_per_sector;
	return ret;
}
