Const PIXELS = 3
Const RED = &HFF&
Const GCW_HCURSOR = -12
Const GWW_HINSTANCE = -6
Const BITS_OFFSET = 12

Type CursorInfo
     hWnd       As Integer
     hOldCursor As Integer
     hNewCursor As Integer
End Type

Declare Function GlobalLock Lib "Kernel" (ByVal hMem%) As Long
Declare Function GlobalUnLock Lib "Kernel" (ByVal hMem%) As Integer
Declare Function CreateCursor Lib "User" (ByVal hinst%, ByVal xHotSpot%, ByVal yHotSpot%, ByVal nWidth%, ByVal nHeight%, ByVal lpvANDPlane As Any, ByVal lpvXORPlane As Any) As Integer
Declare Function DestroyCursor Lib "User" (ByVal hcur%) As Integer
Declare Function GetWindowWord Lib "User" (ByVal hWnd%, ByVal nIndex%) As Integer
Declare Function SetClassWord Lib "User" (ByVal hWnd%, ByVal nIndex%, ByVal wNewWord%) As Integer
Declare Function GetPixel Lib "GDI" (ByVal hDC%, ByVal nXPos%, ByVal nYPos%) As Long

Function ChangeCursor (ByVal hWnd As Integer, hCursor As Integer)
    ChangeCursor = SetClassWord(hWnd, GCW_HCURSOR, hCursor)
End Function

Sub FindHotSpot (CursorPic As Control, x As Integer, y As Integer)
    
    For x = 0 To (CursorPic.ScaleWidth - 1)
	For y = 0 To (CursorPic.ScaleHeight - 1)
	    If GetPixel(CursorPic.hDC, x, y) = RED Then Exit Sub
	Next y
    Next x

    x = 0: y = 0
End Sub

Sub MakeCursor (ByVal hWnd As Integer, picCursor As Control, picMask As Control, ciCursor As CursorInfo)
Dim x As Integer, y As Integer

    picCursor.AutoRedraw = True
    picCursor.ScaleMode = PIXELS
    
    FindHotSpot picCursor, x, y
    
    ciCursor.hWnd = hWnd
    ciCursor.hNewCursor = CreateCursor(GetWindowWord(hWnd, GWW_HINSTANCE), x, y, picCursor.ScaleWidth, picCursor.ScaleHeight, GlobalLock(picCursor.Picture) + BITS_OFFSET, GlobalLock(picMask.Picture) + BITS_OFFSET)
    ciCursor.hOldCursor = ChangeCursor(hWnd, ciCursor.hNewCursor)
    
    z% = GlobalUnLock(picCursor.Picture)
    z% = GlobalUnLock(picMask.Picture)
End Sub

Sub RestoreCursor (ciCursor As CursorInfo)
    z% = ChangeCursor(ciCursor.hWnd, ciCursor.hOldCursor)
    z% = DestroyCursor(ciCursor.hNewCursor)
End Sub

