
' Booleans
Global Const TRUE = -1
Global Const FALSE = 0

' ====================
' BTRIEVE DECLARATIONS
' ====================

    Rem ------------- BTRIEVE error codes
Global Const BE_OK = 0
Global Const BE_INVALID_OP = 1
Global Const BE_IO_ERROR = 2
Global Const BE_FILENOTOPEN = 3
Global Const BE_KEYNOTFOUND = 4
Global Const BE_DUPKEY = 5
Global Const BE_INVALID_KEYNUM = 6
Global Const BE_DIFF_KEYNUM = 7
Global Const BE_INVALID_POS = 8
Global Const BE_EOF = 9
Global Const BE_KEYMODIF = 10
Global Const BE_INVALID_FILE = 11
Global Const BE_FILENOTFOUND = 12
Global Const BE_EXTENSIONFILE = 13
Global Const BE_PREIMAGE_OPEN = 14
Global Const BE_PREIMAGE_IO = 15
Global Const BE_EXPANSION = 16
Global Const BE_CLOSE = 17
Global Const BE_DISKFULL = 18
Global Const BE_UNRECOVERABLE = 19
Global Const BE_INACTIVE = 20
Global Const BE_KEYBUFF_SIZE = 21
Global Const BE_DATABUFF_SIZE = 22
Global Const BE_POSBLK_SIZE = 23
Global Const BE_PAGE_SIZE = 24
Global Const BE_CREATE = 25
Global Const BE_NUM_KEYS = 26
Global Const BE_INVALID_KEYPOS = 27
Global Const BE_INVALID_RECLEN = 28
Global Const BE_INVALID_KEYLEN = 29
Global Const BE_NOT_BTRVFILE = 30
Global Const BE_FILE_EXTENDED = 31
Global Const BE_EXTEND_IO = 32
Global Const BE_INVALID_EXTNAME = 34
Global Const BE_DIRECTORY = 35
Global Const BE_TRANSACTION = 36
Global Const BE_TANS_ACTIVE = 37
Global Const BE_TRANS_IO = 38
Global Const BE_TRANS_END = 39
Global Const BE_TRANS_MAXFILES = 40
Global Const BE_OP_NOTALLOWED = 41
Global Const BE_ACC_ACCESS = 42
Global Const BE_INVALID_RECADDR = 43
Global Const BE_NULL_KEY = 44
Global Const BE_KEY_FLAG = 45
Global Const BE_ACCESS_DENIED = 46
Global Const BE_MAX_OPENFILES = 47
Global Const BE_INVALID_ALTSEQ = 48
Global Const BE_KEY_TYPE = 49
Global Const BE_OWNER_SET = 50
Global Const BE_INVALID_OWNER = 51
Global Const BE_CACHE = 52
Global Const BE_INVALID_INTF = 53
Global Const BE_VAR_PAGE = 54
Global Const BE_AUTOINCREMENT = 55
Global Const BE_INCOMPLETE_INDEX = 56
Global Const BE_EMS_ERROR = 57
Global Const BE_COMPRBUFF_SIZE = 58
Global Const BE_FILE_EXIST = 59
Global Const BE_CONFLICT = 80
Global Const BE_LOCK_ERROR = 81
Global Const BE_LOST_POSITION = 82
Global Const BE_READ_OUT_TRANS = 83
Global Const BE_RECORD_LOCKED = 84
Global Const BE_FILE_LOCKED = 85
Global Const BE_FILE_TABLE_FULL = 86
Global Const BE_OPEN_MODE = 88
Global Const BE_LOCK_TYPE = 93
Global Const BE_PERMISSION = 94
Global Const BE_INVALID_OPCOD = 100

    ''''File attibute flag.''''
    ' these are used when creating the file
Global Const FF_VAR_LENGTH = 1
Global Const FF_STRIP_BLANK = 2
Global Const FF_PREALLOCATE = 4
Global Const FF_COMPRESS = 8
Global Const FF_KEYONLY = 16
Global Const FF_10_FREE = 64
Global Const FF_20_FREE = 128
Global Const FF_30_FREE = 192

    ''''Key attribute flag.''''
    ' these are used when creating the file
Global Const KF_STRING = 0
Global Const KF_DUPLICATE = 1
Global Const KF_MODIFIABLE = 2
Global Const KF_INTEGER = 4
Global Const KF_NULLVALUE = 8
Global Const KF_SEGMENT = 16
Global Const KF_ALT_SORT = 32
Global Const KF_DESCENDING = 64
Global Const KF_EXTENDED = &H100
Global Const KF_MANUAL = &H200

    ''''Extended key types.''''
Global Const EKT_STRING = 0
Global Const EKT_INTEGER = 1
Global Const EKT_FLOAT = 2
Global Const EKT_DATE = 3
Global Const EKT_TIME = 4
Global Const EKT_DECIMAL = 5
Global Const EKT_MONEY = 6
Global Const EKT_LOGICAL = 7
Global Const EKT_NUMERIC = 8
Global Const EKT_BFLOAT = 9
Global Const EKT_LSTRING = 10
Global Const EKT_ZSTRING = 11
Global Const EKT_UINTEGER = 14
Global Const EKT_AUTOINCREMENT = 15

''------------- BTRIEVE record type definitions.-----------------------------''
' Btrieve's optional key buffer
' this is not used in this demo program
' the program can be modified to use this for Btrieve's key buffer
' instead of KeyVal
Type BTRV_Key_Buffer
    Kstr As String * 128
End Type
Global BtrvKeyBuf As BTRV_Key_Buffer

' filespec used in creating files
Type BTRV_FILESPEC
	Length      As Integer
	PageSize    As Integer
	nbIndex     As Integer
	FileFlags   As Integer
	Alloc       As Integer
End Type

    '''' BTRIEVE Open file modes ''''
    Global Const OM_NORMAL = 0
    Global Const OM_ACCELERATED = 1
    Global Const OM_READONLY = 2
    Global Const OM_VERIFY = 3
    Global Const OM_EXCLUSIVE = 4

    '''' BTRIEVE Lock types ''''
    ' note that no wait locks are not allowed in the Windows dll
    Global Const LCK_NONE = 0          '' No lock.
    Global Const LCK_SINGLE = 200      '' Single record lock (nowait).
    Global Const LCK_MULTIPLE = 400    '' Multiple record lock (nowait).

    '''' Btrieve's Operation Codes '''
    Global Const GET_FIRST = 12
    Global Const GET_LAST = 13
    Global Const GET_NEXT = 6
    Global Const GET_PREV = 7
    Global Const GET_EQ = 5
    Global Const GET_GT = 8
    Global Const GET_GE = 9
    Global Const GET_LT = 10
    Global Const GET_LE = 11

    Global Const B_OPEN = 0
    Global Const B_CLOSE = 1
    Global Const B_INSERT = 2
    Global Const B_UPDATE = 3
    Global Const B_DELETE = 4
    Global Const B_CREATE = 14
    Global Const B_STAT = 15
    Global Const B_SETDIR = 17
    Global Const B_GETDIR = 18
    Global Const B_BEGTRAN = 19
    Global Const B_ENDTRAN = 20
    Global Const B_ABORTTRAN = 21
    Global Const B_GETPOS = 22
    Global Const B_GETDIRECT = 23
    Global Const B_STEPNEXT = 24
    Global Const B_STOP = 25
    Global Const B_UNLOCK = 27
    Global Const B_RESET = 28
    Global Const B_STEPFIRST = 33
    Global Const B_STEPLAST = 34
    Global Const B_STEPPREV = 35
    Global Const B_USE = 48
    Global Const B_DUPS = 49
    Global Const B_KEYONLY = 40

    '''' BTRIEVE Change password ''''
    Global Const CP_RW_NOENCRYPT = 0     'Owner name required for Read/Write. No encryption.
    Global Const CP_W_NOENCRYPT = 1      'Owner name required for Write. No encryption.
    Global Const CP_RW_ENCRYPT = 2       'Owner name required for Read/Write. With encryption.
    Global Const CP_W_ENCRYPT = 3        'Owner name required for Write. With encryption.
    Global Const CP_CLEAR = 4            'Clear any password.


' WBTRCALL.DLL declarations
Declare Function WBtrvInit Lib "wbtrcall.dll" (ByVal Options As String) As Integer
Declare Function WBtrvStop Lib "wbtrcall.dll" () As Integer
Declare Function BtrCall Lib "wbtrcall.dll" (ByVal op%, ByVal Pb$, DB As Any, Dl As Integer, ByVal Kb$, ByVal Kl%, ByVal Kn%) As Integer

Global Const MaxFile = 0                    ' the number of files we will open (0 based)
Global BStatus As Integer                   ' Btrieve's return status code
Global PosBlk(MaxFile) As String * 128      ' Btrieve's position blocks
Global KeyVal As String                     ' key value passed to and from CallBtrv()
Global FileName(MaxFile) As String          ' filenames
Global Path As String                       ' path for files
Global KeyLen(MaxFile, 3) As Integer        ' key length (fileno,keyno)
Global FileNo As Integer                    ' our file number
Global KeyNo As Integer                     ' the key number

' Btrieve's data buffer
' it must be set to the page size or at least to the
' largest record size for your files
Type BTRV_BUF
    buffer  As String * 1024
End Type
Global BtrvBuf As BTRV_BUF

' specifications for the sample data file
Type GL_ACCT
	GlId            As String * 8
	GlAcct          As String * 12
	GlName          As String * 30
	GlType          As String * 2
	GlParen         As Integer
	GlMaster        As Integer
	GlBalance       As Currency
	GlSort          As String * 12
	GlNoOfHist      As Long
End Type
Global ChartRec As GL_ACCT
Global Const GlAcctLen = 80     ' length of the record

' key specification used for creating files
' this is for 1 segment
' this sample program uses a file with 6 segments so
' this is not used here
Type KEY_1SEG
	KeyPos      As Integer
	KeyLength   As Integer
	KeyFlags    As Integer
	ExtKeyType  As Integer
	KeyNull     As Integer
End Type

' key specification used for creating files
' this is for 6 segments
' create additional key specifications depending on how many
' segments your files have
Type KEY_6SEG
    RecLen      As Integer
    PgSize      As Integer
    NoOfIndex   As Integer
    NotUsed     As Long
    FileFlags   As Integer
    ResWrd      As Integer
    Alloc       As Integer
    KeyPos1     As Integer
    KeyLen1     As Integer
    KeyFlags1   As Integer
    NotUsed1    As Long
    Ext_Nul1    As Integer
    ResWrd1     As Long
    KeyPos2     As Integer
    KeyLen2     As Integer
    KeyFlags2   As Integer
    NotUsed2    As Long
    Ext_Nul2    As Integer
    ResWrd2     As Long
    KeyPos3     As Integer
    KeyLen3     As Integer
    KeyFlags3   As Integer
    NotUsed3    As Long
    Ext_Nul3    As Integer
    ResWrd3     As Long
    KeyPos4     As Integer
    KeyLen4     As Integer
    KeyFlags4   As Integer
    NotUsed4    As Long
    Ext_Nul4    As Integer
    ResWrd4     As Long
    KeyPos5     As Integer
    KeyLen5     As Integer
    KeyFlags5   As Integer
    NotUsed5    As Long
    Ext_Nul5    As Integer
    ResWrd5     As Long
    KeyPos6     As Integer
    KeyLen6     As Integer
    KeyFlags6   As Integer
    NotUsed6    As Long
    Ext_Nul6    As Integer
    ResWrd6     As Long
End Type

