VERSION 2.00
Begin Form TextView 
   Caption         =   "Big Text File Viewer"
   ClientHeight    =   4695
   ClientLeft      =   1380
   ClientTop       =   1605
   ClientWidth     =   7500
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "Courier New"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   5130
   Left            =   1305
   LinkTopic       =   "Form1"
   ScaleHeight     =   4695
   ScaleWidth      =   7500
   Top             =   1245
   Width           =   7650
   Begin CommandButton Command2 
      Caption         =   "Quit"
      Height          =   330
      Left            =   1785
      TabIndex        =   0
      Top             =   210
      Width           =   1065
   End
   Begin CommandButton Command1 
      Caption         =   "Open File"
      Height          =   330
      Left            =   525
      TabIndex        =   1
      Top             =   210
      Width           =   1065
   End
   Begin CommonDialog CMDialog1 
      Left            =   6090
      Top             =   1680
   End
   Begin PictureBox Picture2 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Fixedsys"
      FontSize        =   9
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1170
      Left            =   6090
      ScaleHeight     =   1140
      ScaleWidth      =   405
      TabIndex        =   4
      Top             =   2415
      Width           =   435
   End
   Begin PictureBox Picture1 
      Height          =   2850
      Left            =   210
      ScaleHeight     =   2820
      ScaleWidth      =   5655
      TabIndex        =   3
      Top             =   735
      Width           =   5685
   End
   Begin VScrollBar VScroll1 
      Height          =   750
      LargeChange     =   10
      Left            =   6195
      TabIndex        =   2
      Top             =   735
      Width           =   225
   End
   Begin Label Label2 
      Height          =   330
      Left            =   5775
      TabIndex        =   6
      Top             =   270
      Width           =   1695
   End
   Begin Label Label1 
      Height          =   330
      Left            =   3465
      TabIndex        =   5
      Top             =   270
      Width           =   2115
   End
End
DefInt A-Z

Dim FileArray(10000) As String * 80
Dim LineCount, NLinesToShow

Sub Command1_Click ()
  
  On Error GoTo ErrHandler
  CMDialog1.Filter = "All Files (*.*)|*.*"

  CMDialog1.Action = 1            ' File Open Dialogue Box
  file$ = CMDialog1.Filename      ' File Name

  LineCount = 0
  Open file$ For Input As #1
    Filesize& = LOF(1)
    Do Until EOF(1) Or LineCount = 10000
      Line Input #1, lin$
      FileArray(LineCount) = lin$
      LineCount = LineCount + 1
    Loop
  Close
  
  Label1.Caption = Str$(LineCount) + " lines available."
  
  VScroll1.Max = LineCount - NLinesToShow   ' max value for scroll bar

  VScroll1.Value = 0    ' reset for new file
  PrintLines            ' print the lines Subroutine

ErrHandler:
  Exit Sub

End Sub

Sub Command2_Click ()
  End

End Sub

Sub Form_Load ()
  
  ' n lines to show in the "list box"
  NLinesToShow = 15
 
  TextView.Width = Screen.Width   ' form is maximum width
  TextView.Left = 0               ' centre Picture1 on form
  Picture1.Width = TextView.Width * .9
  Picture1.Left = (TextView.Width - Picture1.Width - VScroll1.Width) \ 2

  ScaleMode = 3    ' pixels
  ' -1 to overlap the rt side of the picture box with the left side of the scroll
  VScroll1.Left = Picture1.Left + Picture1.Width - 1
  ScaleMode = 1    ' back to twips
  
  ' determine the height of a line of text in Picture 2
  ' make room for 15 lines of text + a bit of space at the bottom
  Picture1.Height = (NLinesToShow + .2) * Picture2.TextHeight("A")
  
  VScroll1.Height = Picture1.Height
  VScroll1.Top = Picture1.Top
  
  Picture2.AutoRedraw = True
  Picture2.Left = -13000   ' move picture2 off the screen
  Picture2.Height = Picture1.Height
  Picture2.Width = Picture1.Width

  VScroll1.LargeChange = NLinesToShow

End Sub

Sub PrintLines ()
  FirstLine = VScroll1.Value
  If FirstLine > LineCount - NLinesToShow Then
    ' so we don't scroll past the end of the file
    FirstLine = LineCount - NLinesToShow
  End If
  If FirstLine < 0 Then FirstLine = 0
  
  ' if fewer lines in file than n lines height of list box
  If NLinesToShow > LineCount Then NLinesToShow = LineCount - 1
  
  Label2.Caption = "Top Line:" + Str$(FirstLine)
  
  For I = FirstLine To FirstLine + NLinesToShow
    Picture2.Print FileArray(I)  ' print lines to Picture2
  Next I
  
  ' copy lines in Picture2 over to Picture1
  Picture1.Picture = Picture2.Image
  Picture2.Cls    ' clear Picture2 for next lines

End Sub

Sub VScroll1_Change ()
  PrintLines

End Sub

